/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.multitenant.service.AbstractFpzsPluginService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.collector.InvoiceCollectEditPlugin;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FpzsEditAttachPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(InvoiceCollectEditPlugin.class);
    private static String submitButton = "submitbutton";
    private static String downloadButton = "download";
    private static String downloadButton2 = "download_file";

    public void afterCreateNewData(EventObject e) {
        this.showEditView();
    }

    public void registerListener(EventObject e) {
        Button submit = (Button)this.getControl(submitButton);
        Button download = (Button)this.getControl(downloadButton);
        Button download2 = (Button)this.getControl(downloadButton2);
        submit.addClickListener((ClickListener)this);
        download.addClickListener((ClickListener)this);
        download2.addClickListener((ClickListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("attach_category");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("editFlag", "1");
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("imageIndex".equals(eventName) && !StringUtils.isEmpty((CharSequence)eventArgs)) {
            int index = 0;
            if (eventArgs.indexOf("index") > 0) {
                JSONObject json = JSONObject.parseObject((String)eventArgs);
                index = json.getIntValue("index");
            } else {
                index = Integer.parseInt(eventArgs);
            }
            this.updateAttachView(index, Boolean.FALSE);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (downloadButton.equals(key) || downloadButton2.equals(key)) {
            Object attachId = this.getView().getFormShowParameter().getCustomParams().get("attachid");
            if (attachId == null || "".equals(attachId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u5165\u9644\u4ef6\u7684id", (String)"FpzsEditAttachPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            String attach_url = (String)this.getModel().getValue("attach_url");
            if (StringUtils.isEmpty((CharSequence)attach_url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9644\u4ef6\u7684\u5730\u5740", (String)"FpzsEditAttachPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String fullUrl = UrlServiceUtils.getAttachmentFullUrl((String)attach_url);
            this.getView().download(fullUrl);
        } else {
            String editFlag = this.getPageCache().get("editFlag");
            if (StringUtils.isEmpty((CharSequence)editFlag) || "0".equals(editFlag)) {
                this.getView().close();
            } else {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                HashMap<String, Object> returnData = new HashMap<String, Object>(8);
                Object attachName = this.getModel().getValue("attach_name");
                Object attachType = this.getModel().getValue("attach_type");
                Object remark = this.getModel().getValue("attach_remark");
                Long attachCategoryId = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("attach_category2")).longValue();
                DynamicObject attachCategory = BusinessDataServiceHelper.loadSingle((Object)attachCategoryId, (String)"bdm_attach_type");
                returnData.put("serialNo", customParams.get("serialNo"));
                returnData.put("attach_name", attachName);
                returnData.put("attach_type", attachType);
                returnData.put("attach_remark", remark);
                String attachIdStr = this.getModel().getValue("attachid").toString();
                if (StringUtils.isNotBlank((CharSequence)attachIdStr)) {
                    Long attachId = Long.valueOf(attachIdStr);
                    QFilter idFilter = new QFilter("id", "=", (Object)attachId);
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"rim_attach", (String)"id,attach_category,attach_name,attach_type,remark,update_time", (QFilter[])new QFilter[]{idFilter});
                    obj.set("attach_name", attachName);
                    obj.set("attach_type", attachType);
                    obj.set("attach_category", (Object)attachCategory);
                    obj.set("remark", remark);
                    obj.set("update_time", (Object)new Date());
                    ImcSaveServiceHelper.update((DynamicObject)obj);
                    returnData.put("attach_category", attachCategory.get("id"));
                    returnData.put("attach_category_simplify", attachCategory.get("simplify_name"));
                }
                returnData.put("attach_category", attachCategory.get("id"));
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.setCancel(true);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setFormId("rim_attachtype_select");
        FpzsAnonymousUserService.addEventCode((FormShowParameter)showParameter, (String)this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdm_attach_type");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Long id;
        if ("bdm_attach_type".equals(closedCallBackEvent.getActionId()) && (id = (Long)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("attach_category", (Object)id);
        }
    }

    private void showEditView() {
        HashMap<String, Object> urlMap;
        this.getView().setVisible(Boolean.FALSE, new String[]{"attach_sum"});
        ComboEdit targCombo = (ComboEdit)this.getView().getControl("attach_category2");
        targCombo.setComboItems(FpzsMainService.loadAttachType());
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String url = "";
        Object attachId = customParams.get("attachid");
        String editFlag = (String)customParams.get("editFlag");
        List<Object> urlList = new ArrayList();
        if ("viewAttach".equals(customParams.get("viewAttach"))) {
            urlList = this.updateAttachView(0, Boolean.TRUE);
        } else if (attachId != null) {
            if (attachId == null || "".equals(attachId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f20\u5165\u9644\u4ef6\u7684id", (String)"FpzsEditAttachPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            Pair<String, String> pair = this.loadAttachById(attachId, editFlag);
            url = (String)pair.getLeft();
            urlMap = new HashMap<String, Object>();
            Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url, (String)"", (String)"");
            urlMap.putAll(previewMap);
            Object attachType = customParams.get("attach_type");
            if (ObjectUtils.isEmpty(attachType)) {
                attachType = pair.getRight();
            }
            FpzsAttachService.setImgMap(urlMap, String.valueOf(attachType));
            urlList.add(urlMap);
        } else {
            Object attach_category = customParams.get("attach_category");
            if (attach_category == null) {
                attach_category = AttachConstant.ATTACH_OTHER_CATEGORY_ID;
            }
            this.getModel().setValue("attach_category2", (Object)attach_category.toString());
            this.getModel().setValue("attach_category", attach_category);
            this.getModel().setValue("attach_name", customParams.get("attach_name"));
            this.getModel().setValue("file_extension", customParams.get("file_extension"));
            this.getModel().setValue("attach_type", customParams.get("attach_type"));
            this.getModel().setValue("attach_remark", customParams.get("attach_remark"));
            this.getModel().setValue("upload_date", customParams.get("upload_date"));
            this.getModel().setValue("create_time", customParams.get("upload_date"));
            this.getModel().setValue("attachid", customParams.get("attachid"));
            url = (String)customParams.get("attach_url");
            urlMap = new HashMap();
            Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)url);
            urlMap.putAll(previewMap);
            String attachType = String.valueOf(customParams.get("attach_type"));
            FpzsAttachService.setImgMap(urlMap, attachType);
            urlList.add(urlMap);
        }
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#image_flex");
        map.put("showBtn", (Object)(urlList.size() > 1 ? 1 : 0));
        map.put("time", (Object)System.currentTimeMillis());
        ScannerService.addCustomParam((Map)map, (String)"viewinvoice");
        customcontrol.setData((Object)map);
    }

    private List<Map<String, Object>> updateAttachView(int index, Boolean isFirstLoad) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray attachList = (JSONArray)customParams.get("attachInfoList");
        ArrayList<Map<String, Object>> urlList = new ArrayList<Map<String, Object>>();
        if (attachList != null && attachList.size() > 0) {
            JSONObject attachInfo = attachList.getJSONObject(index);
            this.getModel().setValue("attach_category", attachInfo.get((Object)"attach_category"));
            this.getModel().setValue("attach_category2", (Object)attachInfo.getString("attach_category"));
            this.getModel().setValue("attach_name", attachInfo.get((Object)"attach_name"));
            this.getModel().setValue("attach_type", attachInfo.get((Object)"attach_type"));
            this.getModel().setValue("attach_remark", attachInfo.get((Object)"remark"));
            Object update_time = attachInfo.get((Object)"update_time");
            if (update_time instanceof Long) {
                Date updateTime = new Date((Long)update_time);
                update_time = DateUtils.format((Date)updateTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            this.getModel().setValue("upload_date", update_time);
            this.getModel().setValue("attachid", attachInfo.get((Object)"id"));
            this.getModel().setValue("attach_sum", (Object)(attachList.size() == 0 ? 1 : attachList.size()));
            String attachUrl = attachInfo.getString("attach_url");
            this.getModel().setValue("attach_url", (Object)attachUrl);
            Object create_time = attachInfo.get((Object)"create_time");
            if (create_time instanceof Long) {
                Date createTime = new Date((Long)create_time);
                create_time = DateUtils.format((Date)createTime, (String)"yyyy-MM-dd HH:mm:ss");
            }
            String fileExtension = attachInfo.getString("file_extension");
            this.getModel().setValue("create_time", create_time);
            this.getModel().setValue("file_extension", (Object)fileExtension);
            if ("xls".equalsIgnoreCase(fileExtension) || "xlsx".equalsIgnoreCase(fileExtension)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"download_flex"});
            }
            if (isFirstLoad.booleanValue()) {
                for (int i = 0; i < attachList.size(); ++i) {
                    HashMap<String, Object> urlMap = new HashMap<String, Object>(2);
                    attachInfo = attachList.getJSONObject(i);
                    Map previewMap = UrlServiceUtils.getAttachmentPreviewUrlAndType((String)attachUrl);
                    urlMap.putAll(previewMap);
                    FpzsAttachService.setImgMap(urlMap, attachInfo.getString("attach_type"));
                    urlList.add(urlMap);
                }
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"attach_category", "attach_category2", "attach_sum", "create_time", "attach_name", "attach_type", "attach_remark"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"submitbutton"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"attach_sum"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"attach_name", "file_extension", "attach_remark"});
        return urlList;
    }

    private Pair<String, String> loadAttachById(Object attachId, String editFlag) {
        JSONObject dynamicObject = AbstractFpzsPluginService.newInstance().loadAttachById(Long.valueOf(Long.parseLong(attachId.toString())));
        if (dynamicObject == null || StringUtils.isEmpty((CharSequence)dynamicObject.getString("id"))) {
            return Pair.of((Object)"", (Object)"");
        }
        if (dynamicObject.get((Object)"attach_category") != null) {
            this.getModel().setValue("attach_category2", (Object)dynamicObject.get((Object)"attach_category").toString());
        }
        this.getModel().setValue("attach_category", dynamicObject.get((Object)"attach_category"));
        this.getModel().setValue("attach_name", dynamicObject.get((Object)"attach_name"));
        this.getModel().setValue("attach_type", dynamicObject.get((Object)"attach_type"));
        this.getModel().setValue("attach_remark", dynamicObject.get((Object)"remark"));
        this.getModel().setValue("create_time", (Object)DateUtils.format((Date)dynamicObject.getDate("create_time"), (String)"yyyy-MM-dd HH:mm:ss"));
        this.getModel().setValue("attachid", dynamicObject.get((Object)"id"));
        String fileExtension = dynamicObject.getString("file_extension");
        this.getModel().setValue("file_extension", (Object)fileExtension);
        String url = dynamicObject.getString("attach_url");
        this.getModel().setValue("attach_url", (Object)url);
        this.getModel().setValue("attach_sum", (Object)dynamicObject.getInteger("attach_sum"));
        Long attach_category = dynamicObject.getLong("attach_category");
        if (AttachConstant.ATTACH_LIST_CATEGORY_ID.equals(attach_category)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attach_category", "attach_category2", "attach_sum", "create_time", "attach_name", "attach_type", "attach_remark"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitbutton"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attach_sum"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"attach_name", "file_extension", "attach_remark"});
        }
        if ("0".equals(editFlag)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitbutton"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"attach_category", "attach_category2", "attach_sum", "create_time", "attach_name", "attach_type", "attach_remark"});
        }
        return Pair.of((Object)url, (Object)dynamicObject.getString("attach_type"));
    }
}

