/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.imc.rim.common.invoice.query.AttachSaveService;
import kd.imc.rim.common.multitenant.helper.RimAttachListHelper;
import kd.imc.rim.common.multitenant.service.MultiTenantService;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ViewUtil;

public class FpzsMultiTenantAttachListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String BILL_LIST_AP = "entryentity";
    private static final String DELETE_BUTTON = "delete";
    private static final String[] FIELDS = new String[]{"id", "attach_category", "attach_name", "create_time", "file_extension", "remark"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid billList = (EntryGrid)this.getControl(BILL_LIST_AP);
        billList.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().beginInit();
        this.getModel().setValue("start_date", (Object)DateUtils.addYear((Date)new Date(), (int)-1));
        this.getModel().setValue("end_date", (Object)new Date());
        this.getModel().endInit();
        this.loadData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("search_category".equals(name) || "search_name".equals(name) || "end_date".equals(name) || "start_date".equals(name)) {
            this.loadData();
        }
    }

    private void loadData() {
        Date start = (Date)this.getModel().getValue("start_date");
        Date end = (Date)this.getModel().getValue("end_date");
        DynamicObject searchCategory = (DynamicObject)this.getModel().getValue("search_category");
        String searchName = (String)this.getModel().getValue("search_name");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("entity", "rim_attach");
        customParams.put("start_date", start);
        customParams.put("end_date", end);
        if (searchCategory != null) {
            customParams.put("attach_category_id", searchCategory.getPkValue());
        }
        customParams.put("attach_name", searchName);
        Object[] dynamicObjectCollection = null;
        MultiTenantService service = new MultiTenantService();
        if (service.isMultiTenant()) {
            String result = (String)service.doPost("RimAttachListServiceOpenApiImpl", "queryFpzsAttachList", (Object)customParams);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"rim_attach");
            dynamicObjectCollection = DynamicObjectSerializeUtil.deserialize((String)result, (DynamicObjectType)type);
        } else {
            dynamicObjectCollection = RimAttachListHelper.getRimAttachList((String)"rim_attach", (Map)customParams);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(BILL_LIST_AP);
        model.beginInit();
        if (dynamicObjectCollection != null && dynamicObjectCollection.length > 0) {
            TableValueSetter vs = new TableValueSetter(FIELDS);
            for (int i = 0; i < dynamicObjectCollection.length; ++i) {
                DynamicObject rimInfo = dynamicObjectCollection[i];
                Object[] value = new Object[FIELDS.length];
                value[0] = rimInfo.getString("id");
                if (rimInfo.get("attach_category") != null) {
                    DynamicObject dynamicObject = (DynamicObject)rimInfo.get("attach_category");
                    value[1] = dynamicObject.getPkValue();
                }
                value[2] = rimInfo.getString("attach_name");
                value[3] = rimInfo.getDate("create_time");
                value[4] = rimInfo.getString("file_extension");
                value[5] = rimInfo.getString("remark");
                vs.addRow(value);
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.batchCreateNewEntryRow(BILL_LIST_AP, vs);
        }
        model.endInit();
        model.setDataChanged(false);
        this.getView().updateView(BILL_LIST_AP);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
        this.viewDetail(((DynamicObject)entity.get(row)).getPkValue());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (DELETE_BUTTON.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9644\u4ef6", (String)"FpzsMultiTenantAttachListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"FpzsMultiTenantAttachListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"FpzsMultiTenantAttachListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u65e0\u6cd5\u67e5\u770b\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"FpzsMultiTenantAttachListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(DELETE_BUTTON, (IFormPlugin)this), btnNameMaps);
        } else if ("import".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u518d\u6267\u884c\u5bfc\u5165\u64cd\u4f5c", (String)"FpzsMultiTenantAttachListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object[]> returnData = new HashMap<String, Object[]>(8);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
            Object[] ids = new Object[selectRows.length];
            for (int i = 0; i < selectRows.length; ++i) {
                ids[i] = ((DynamicObject)entity.get(selectRows[i])).getPkValue();
            }
            returnData.put("attachIds", ids);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("view_detail".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
            this.viewDetail(((DynamicObject)entity.get(selectRows[0])).getPkValue());
        }
    }

    private void viewDetail(Object attachId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("attachid", attachId);
        customParams.put("editFlag", "0");
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"rim_fpzs_attach_edit", (String)"rim_fpzs_attach_edit");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (DELETE_BUTTON.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(BILL_LIST_AP);
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection entity = this.getModel().getEntryEntity(BILL_LIST_AP);
            Long primaryKeyValue = (Long)((DynamicObject)entity.get(selectRows[0])).getPkValue();
            MultiTenantService service = new MultiTenantService();
            if (service.isMultiTenant()) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put("primaryKeyValue", primaryKeyValue);
                service.doPost("RimAttachListServiceOpenApiImpl", "deleteAttach", (Object)customParams);
            } else {
                AttachSaveService.deleteAttach((Long)primaryKeyValue);
            }
            this.loadData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"FpzsMultiTenantAttachListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }
}

