/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.fpzs.operate;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.fpzs.operate.AttachListOperateService;
import kd.imc.rim.formplugin.fpzs.operate.AttachUploadOperateService;
import kd.imc.rim.formplugin.fpzs.operate.InvoiceEnterOperateService;
import kd.imc.rim.formplugin.fpzs.operate.InvoiceListOperateService;
import kd.imc.rim.formplugin.fpzs.operate.InvoiceUploadOperateService;
import kd.imc.rim.formplugin.fpzs.operate.OverseaInvoiceEnterOperateService;
import kd.imc.rim.formplugin.fpzs.operate.QrCodeOperateService;
import kd.imc.rim.formplugin.fpzs.operate.ScanGunOperateService;
import kd.imc.rim.formplugin.fpzs.operate.ScannerOperateService;

public class FpzsOperateService {
    protected AbstractFormPlugin plugin;
    private static final String LQCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.LqCheckService";
    private static Log logger = LogFactory.getLog(FpzsOperateService.class);

    public static FpzsOperateService newInstance(AbstractFormPlugin plugin, String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        switch (type) {
            case "operate_upload": 
            case "pc_oversea_file_upload": {
                return new InvoiceUploadOperateService(plugin, "upload_file");
            }
            case "operate_multi_upload": {
                return null;
            }
            case "operate_attach_upload": {
                return new AttachUploadOperateService(plugin);
            }
            case "operate_qrcode": 
            case "operate_attach_qrcode": 
            case "pc_oversea_phone_upload": {
                return new QrCodeOperateService(plugin);
            }
            case "operate_enter": {
                return new InvoiceEnterOperateService(plugin);
            }
            case "pc_oversea_enter": {
                return new OverseaInvoiceEnterOperateService(plugin);
            }
            case "operate_scanner": 
            case "pc_oversea_scanner": {
                return new ScannerOperateService(plugin);
            }
            case "operate_san_gun": {
                return new ScanGunOperateService(plugin);
            }
            case "operate_company_invoice": 
            case "pc_oversea_company": {
                return new InvoiceListOperateService(plugin, "operate_company_invoice");
            }
            case "operate_person_invoice": 
            case "pc_oversea_person": {
                return new InvoiceListOperateService(plugin, "operate_person_invoice");
            }
            case "operate_attach_scanner": {
                return new ScannerOperateService(plugin);
            }
            case "operate_attach_person": {
                return new AttachListOperateService(plugin);
            }
        }
        return null;
    }

    public void operate() {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
    }

    public boolean getCheckType() {
        Map customParams = this.plugin.getView().getFormShowParameter().getCustomParams();
        logger.info("PC\u7aefcustomParams\uff1a{}", (Object)customParams);
        String checkType = "1";
        if (customParams != null) {
            String taxNo = (String)customParams.get("taxNo");
            if (StringUtils.isEmpty((CharSequence)taxNo)) {
                long orgId = BigDecimalUtil.transDecimal(customParams.get("orgId")).longValue();
                if (orgId == 0L) {
                    orgId = RequestContext.get().getOrgId();
                }
                taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
            }
            checkType = TenantUtils.getCheckTypeByTaxNo((String)taxNo);
        }
        String checkImplStr = RimConfigUtils.getConfig((String)"rim_recog_check", (String)"cimpl");
        return "2".equals(checkType) || LQCHECKSERIVCESTR.equals(checkImplStr);
    }
}

