/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.imc.rim.common.constant.AttachConstant;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.invoice.query.AttachSaveService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.codec.digest.DigestUtils;

public class H5AttachDetailPlugin
extends AbstractMobFormPlugin {
    private static Log logger = LogFactory.getLog(H5AttachDetailPlugin.class);
    private static final String EDIT_BUTTON = "edit_button";
    private static final String DELETE_BUTTON = "delete";
    private static final String CONFIRM_BUTTON = "confirm";
    private static final String CANCEL_BUTTON = "cancel";
    private static final String viewRaw_BUTTON = "view_raw";

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void registerListener(EventObject e) {
        Button editButton = (Button)this.getControl(EDIT_BUTTON);
        editButton.addClickListener((ClickListener)this);
        Button deleteButton = (Button)this.getControl(DELETE_BUTTON);
        deleteButton.addClickListener((ClickListener)this);
        Button confirmButton = (Button)this.getControl(CONFIRM_BUTTON);
        confirmButton.addClickListener((ClickListener)this);
        Button cancelButton = (Button)this.getControl(CANCEL_BUTTON);
        cancelButton.addClickListener((ClickListener)this);
        Button viewRawButton = (Button)this.getControl(viewRaw_BUTTON);
        viewRawButton.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("editFlag", "1");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (EDIT_BUTTON.equals(control.getKey())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attach_name"});
            this.showEdit();
        }
        if (DELETE_BUTTON.equals(control.getKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"H5AttachDetailPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"H5AttachDetailPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"H5AttachDetailPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delCallBack"), btnNameMaps);
        }
        if (CONFIRM_BUTTON.equals(control.getKey())) {
            this.submitAttach();
            this.getView().close();
        }
        if (CANCEL_BUTTON.equals(control.getKey())) {
            this.getModel().setValue("attach_name", this.getModel().getValue("original_attach_name"));
            this.getModel().setValue("remark", this.getModel().getValue("original_remark"));
            this.showDetail();
        }
        if (viewRaw_BUTTON.equals(control.getKey())) {
            try {
                this.viewRaw();
            }
            catch (IOException e) {
                logger.info(e.getMessage(), (Object)e);
                throw new MsgException("0001", ResManager.loadKDString((String)"md5\u751f\u6210\u5931\u8d25", (String)"H5InvoiceUpdatePlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void viewRaw() throws IOException {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        long id = Long.parseLong(parentCustomParams.get("id").toString());
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id, create_time, attach_name, remark, attach_url, attach_type, snapshot_url, icon_url, file_extension", (QFilter[])idFilter.toArray());
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u9644\u4ef6\u8be5\u9644\u4ef6\u4fe1\u606f", (String)"H5AttachDetailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String domainContextUrl = UrlService.getDomainContextUrl();
        String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        String attachUrl = dynamicObject.getString("attach_url");
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(attachUrl);
        String md5 = DigestUtils.md5Hex((InputStream)in);
        String downloadUrl = this.urlEncode(attachUrl);
        String encodeDownUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/download.do?path=" + downloadUrl));
        String encodePreviewUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/preview.do?path=" + downloadUrl)) + "&kd_cs_ticket=" + csrfTokenValue;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dynamicObject.getString("attach_type").equals("2")) {
            encodePreviewUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/preview.do?path=" + downloadUrl));
            String[] urlList = new String[]{encodePreviewUrl};
            map.put("urlList", urlList);
        }
        map.put("downloadUrl", encodeDownUrl);
        map.put("fileExt", dynamicObject.getString("file_extension"));
        map.put("fileId", dynamicObject.get("id"));
        map.put("fileName", dynamicObject.getString("attach_name"));
        map.put("filesource", "1");
        map.put("md5", md5);
        map.put("supportOnlinePreview", true);
        map.put("previewType", UrlServiceUtils.getPreviewType());
        map.put("previewUrl", encodePreviewUrl);
        logger.info("\u79fb\u52a8\u7aef\u9644\u4ef6\u9884\u89c8\u539f\u6587\u4ef6\u7684map\uff1a{}", map);
        this.getView().previewAttachment(map);
    }

    private String urlEncode(String url) {
        try {
            String encodeUrl = URLEncoder.encode(url, "UTF-8");
            return encodeUrl;
        }
        catch (UnsupportedEncodingException e) {
            logger.info(e.getMessage(), (Object)e);
            throw new MsgException("0001", ResManager.loadKDString((String)"url\u8f6c\u4e49\u5931\u8d25", (String)"H5InvoiceUpdatePlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "delCallBack".equals(callBackId)) {
            this.deleteAttach();
            this.buildReturnData(DELETE_BUTTON);
            this.getView().close();
        }
    }

    private void submitAttach() {
        String editFlag = this.getPageCache().get("editFlag");
        if (StringUtils.isEmpty((CharSequence)editFlag) || "0".equals(editFlag)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4f5c\u6539\u52a8", (String)"H5AttachDetailPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.showDetail();
        } else {
            String attachIdStr = this.getModel().getValue("attachid").toString();
            Long attachId = Long.parseLong(attachIdStr);
            QFilter idFilter = new QFilter("id", "=", (Object)attachId);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"rim_attach", (String)"id, attach_name, remark, update_time", (QFilter[])new QFilter[]{idFilter});
            Object attachNameObj = this.getModel().getValue("attach_name");
            Object remarkObj = this.getModel().getValue("remark");
            String attachName = "";
            String remark = "";
            if (ObjectUtils.isEmpty((Object)attachNameObj)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"H5AttachDetailPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            attachName = attachNameObj.toString();
            if (!ObjectUtils.isEmpty((Object)remarkObj)) {
                remark = remarkObj.toString();
            }
            obj.set("attach_name", (Object)attachName);
            obj.set("remark", (Object)remark);
            obj.set("update_time", (Object)new Date());
            ImcSaveServiceHelper.update((DynamicObject)obj);
            this.buildDetailData(attachName, remark);
            this.showDetail();
            this.buildReturnData("edit");
            this.refreshParentViewAttachCnt("update", attachId, attachName, remark);
        }
    }

    private void deleteAttach() {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        Long attachId = Long.parseLong(this.getModel().getValue("attachid").toString());
        String serialNo = (String)parentCustomParams.get("serialNo");
        AttachSaveService.deleteAttach((Long)attachId, (String)serialNo);
        this.refreshParentViewAttachCnt(DELETE_BUTTON, attachId, null, null);
    }

    private void buildReturnData(String returnType) {
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        Object rowIndex = parentCustomParams.get("rowIndex");
        JSONObject returnData = new JSONObject();
        returnData.put("type", (Object)returnType);
        returnData.put("rowIndex", rowIndex);
        returnData.put("attach_name", this.getModel().getValue("attach_name"));
        returnData.put("remark", this.getModel().getValue("remark"));
        this.getView().returnDataToParent((Object)returnData);
    }

    private void showDetail() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"attach_name"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"remark"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit_pannel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"detail_pannel"});
    }

    private void showEdit() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"attach_name"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"remark"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"edit_pannel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"detail_pannel"});
    }

    private void initData() {
        QFilter idFilter;
        DynamicObject dynamicObject;
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        long id = Long.parseLong(parentCustomParams.get("id").toString());
        Boolean allowEdit = (Boolean)parentCustomParams.get("allowEdit");
        if (allowEdit != null && !allowEdit.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"detail_pannel"});
        }
        if (ObjectUtils.isEmpty((Object)(dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"create_time, attach_name, remark, attach_url, attach_type, snapshot_url, icon_url,file_extension", (QFilter[])(idFilter = new QFilter("id", "=", (Object)id)).toArray())))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u9644\u4ef6\u8be5\u9644\u4ef6\u4fe1\u606f", (String)"H5AttachDetailPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String attachName = dynamicObject.getString("attach_name");
        Date createTime = dynamicObject.getDate("create_time");
        AttachQueryService attachSaveService = new AttachQueryService();
        String attachUrl = attachSaveService.getAttachUrl(dynamicObject);
        String remark = dynamicObject.getString("remark");
        this.showInvoiceImage(attachUrl, dynamicObject.getString("attach_type"));
        this.getModel().setValue("create_time", (Object)createTime);
        this.getModel().setValue("attachid", (Object)id);
        this.getModel().setValue("file_extension", dynamicObject.get("file_extension"));
        this.buildDetailData(attachName, remark);
        this.getView().setEnable(Boolean.FALSE, new String[]{"attach_name"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"remark"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit_pannel"});
    }

    private void showInvoiceImage(String url, String attachType) {
        ArrayList urlList = new ArrayList();
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        String previewUrl = UrlServiceUtils.getDownloadUrl((String)url, (String)baseUrl);
        if (previewUrl.startsWith("http")) {
            urlMap.put("localUrl", previewUrl);
            urlMap.put("snapshotUrl", previewUrl);
        } else {
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                url = "attachment/download.do?path=" + url;
            }
            urlMap.put("snapshotUrl", url);
            urlMap.put("localUrl", url);
        }
        String iconUrl = AttachConstant.getAttachIconUrl((String)attachType);
        if (!"1".equalsIgnoreCase(attachType) && StringUtils.isEmpty((CharSequence)url) && StringUtils.isNotEmpty((CharSequence)iconUrl)) {
            url = UrlServiceUtils.getLoaclIconFullUrl((String)iconUrl, (String)baseUrl);
            urlMap.put("snapshotUrl", url);
            urlMap.put("localUrl", url);
            Label label = (Label)this.getControl("labelap");
            label.setText(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u9884\u89c8", (String)"H5AttachDetailPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            HashMap<String, LocaleString> ctrl = new HashMap<String, LocaleString>(2);
            ctrl.put("text", new LocaleString(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6", (String)"H5AttachDetailPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0])));
            this.getView().updateControlMetadata(viewRaw_BUTTON, ctrl);
            return;
        }
        urlMap.put("rotationAngle", 0);
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("viewinvoice_custom");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#invoice_attach_show");
        map.put("displayFlag", (Object)"cuteImage");
        map.put("time", (Object)System.currentTimeMillis());
        ScannerService.addCustomParam((Map)map, (String)"viewinvoice");
        customcontrol.setData((Object)map);
    }

    private void buildDetailData(String attachName, String remark) {
        this.getModel().setValue("attach_name", (Object)attachName);
        this.getModel().setValue("original_attach_name", (Object)attachName);
        this.getModel().setValue("remark", (Object)remark);
        this.getModel().setValue("original_remark", (Object)remark);
        this.getView().setEnable(Boolean.FALSE, new String[]{"attach_name"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"remark"});
    }

    private void refreshParentViewAttachCnt(String action, Long attachId, String attachName, String remark) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isEmpty(customParams.get("freshAttachNum")) || !((Boolean)customParams.get("freshAttachNum")).booleanValue() || attachId == null) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        String entryEntityFiled = (String)customParams.get("entryentity");
        int row = (Integer)customParams.get("row");
        if (StringUtils.equals((CharSequence)"update", (CharSequence)action)) {
            String attachNameFiled = (String)customParams.get("attach_name");
            String remarkFiled = (String)customParams.get("attach_remark");
            parentView.getModel().setValue(attachNameFiled, (Object)attachName, row);
            parentView.getModel().setValue(remarkFiled, (Object)remark, row);
        } else if (StringUtils.equals((CharSequence)DELETE_BUTTON, (CharSequence)action)) {
            List ids = Lists.newArrayList();
            String cacheValue = parentView.getPageCache().get("attachIds");
            if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                ids = (List)JSON.parseObject((String)cacheValue, List.class);
            }
            List[] idsfinal = new List[]{ids};
            LinkedList attachIds = Lists.newLinkedList();
            attachIds.add(attachId);
            idsfinal[0] = idsfinal[0].stream().filter(b -> attachId.longValue() != b.longValue()).collect(Collectors.toList());
            String indexPageId = (String)customParams.get("indexPageId");
            AbstractOperateService.deleteSelected(indexPageId, null, attachIds);
            parentView.getPageCache().remove("attachIds");
            parentView.getPageCache().put("attachIds", JSON.toJSONString((Object)idsfinal[0]));
            parentView.getModel().deleteEntryRows(entryEntityFiled, new int[]{row});
            parentView.updateView();
        }
        this.getView().sendFormAction(parentView);
    }
}

