/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;

public class H5InvoiceEditPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(H5InvoiceEditPlugin.class);
    private static final String LQCHECKSERIVCESTR = "kd.imc.rim.common.invoice.checknew.impl.LqCheckService";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save_invoice"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initView();
    }

    private JSONObject getBusinessParam() {
        JSONObject businessParam = new JSONObject();
        if (this.getPageCache().get("fpzs_param_cache") != null) {
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
        } else {
            FpzsMainService.cacheCustomParam((AbstractFormPlugin)this);
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
        }
        logger.info("businessParam:" + businessParam);
        return businessParam;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "save_invoice": {
                boolean isLqcheck;
                JSONObject invoiceInit = JSONObject.parseObject((String)this.getPageCache().get("invoiceInit"));
                JSONObject invoice = JSONObject.parseObject((String)this.getPageCache().get("invoice"));
                String taxNo = this.getTargetTaxNo(invoice);
                String checkType = TenantUtils.getCheckTypeByTaxNo((String)taxNo);
                Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
                String buyerTaxNo = invoice.getString("buyerTaxNo");
                String checkImplStr = RimConfigUtils.getConfig((String)"rim_recog_check", (String)"cimpl");
                boolean bl = isLqcheck = "2".equals(checkType) || LQCHECKSERIVCESTR.equals(checkImplStr);
                if (isLqcheck && InputInvoiceTypeEnum.needCheck((Long)invoiceType).booleanValue() && StringUtils.isEmpty((CharSequence)buyerTaxNo)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u586b\u5199\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"InvoiceCollectEditPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (InvoiceConvertUtils.checkRoadBridgeMustInput((JSONObject)invoice)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u8def\u8fc7\u6865\u8d39\u53d1\u7968\u4ee3\u7801\u3001\u51fa\u53e3\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"H5InvoiceEditPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long type = invoice.getLong("invoiceType");
                boolean unChangedFlag = invoiceInit.toJSONString().equals(invoice.toJSONString());
                if (invoiceInit.toJSONString().equals(invoice.toJSONString()) && !InvoiceConvertUtils.isVatInvoiceType((Long)invoice.getLong("invoiceType"))) {
                    this.getView().close();
                    return;
                }
                String verifySaveFlag = RimConfigUtils.getConfig((String)"verify_save");
                if ("0".equals(verifySaveFlag)) {
                    invoice.put("delete", (Object)"2");
                }
                logger.info("\u4fee\u6539\u4fdd\u5b58\u524d\u7684\u53d1\u7968\u6570\u636e\uff1a" + invoice);
                JSONObject businessParam = this.getBusinessParam();
                invoice.putAll((Map)businessParam);
                if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(type)) {
                    invoice.put("purchaserUnifiedSocialCreditCode", (Object)invoice.getString("buyerTaxNo"));
                }
                if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(type)) {
                    invoice.put("purchaserName", (Object)invoice.getString("buyerName"));
                    invoice.put("purchaserUnifiedSocialCreditCode", (Object)invoice.getString("buyerTaxNo"));
                    invoice.put("totalTaxAmount", (Object)invoice.getBigDecimal("taxAmount"));
                    invoice.put("invoiceDate", (Object)invoice.getString("issueDate"));
                }
                JSONObject saveResult = this.invoiceCollectService.checkAndSaveInvoice(invoice, unChangedFlag);
                logger.info("\u4fee\u6539\u4fdd\u5b58\u7ed3\u679c\uff1a" + saveResult);
                if (!saveResult.getBoolean("saveFlag").booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff01", (String)"H5InvoiceEditPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                JSONObject invoiceData = saveResult.getJSONObject("data");
                Long uploadSeq = invoice.getLong("uploadSeq");
                invoiceData.put("invoiceType", (Object)invoiceType);
                invoiceData.put("uploadSeq", (Object)uploadSeq);
                HashMap<String, JSONObject> customParams = new HashMap<String, JSONObject>(8);
                customParams.put("invoice", invoiceData);
                this.getView().returnDataToParent(customParams);
                this.getView().close();
                return;
            }
        }
    }

    private String getTargetTaxNo(JSONObject invoice) {
        String taxNo = invoice.getString("tax_no");
        if (StringUtils.isEmpty((CharSequence)taxNo)) {
            Long org_id = invoice.getLong("org_id");
            if (org_id == null || org_id == 0L) {
                org_id = StringUtils.isNotEmpty((CharSequence)invoice.getString("orgNumber")) ? TenantUtils.getOrgByNumberOrTaxNo((String)invoice.getString("orgNumber"), null) : Long.valueOf(RequestContext.get().getOrgId());
            }
            taxNo = TenantUtils.getTaxNoByOrgId((Long)org_id);
        }
        return taxNo;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"invoicetype", (CharSequence)fieldKey)) {
            JSONObject invoice;
            String newInvoiceType = "";
            ChangeData[] changeDatas = e.getChangeSet();
            if (changeDatas.length == 1 && (invoice = JSONObject.parseObject((String)this.getPageCache().get("invoice"))) != null && !invoice.isEmpty()) {
                logger.info("\u79fb\u52a8\u7aef\u53d1\u7968\u7f16\u8f91\u7684\u53d1\u7968\u6570\u636e\uff1a", (Object)invoice.toJSONString());
                String oldAwsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoice.getLong("invoiceType"));
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_" + oldAwsInvoiceType});
                newInvoiceType = changeDatas[0].getNewValue().toString();
                invoice.put("serialNo", (Object)"");
                invoice.put("invoiceType", (Object)newInvoiceType);
                String newAwsInvoiceTyep = InputInvoiceTypeEnum.getAwsType((Object)BigDecimalUtil.transDecimal((Object)newInvoiceType).longValue());
                this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_" + newAwsInvoiceTyep});
                this.getPageCache().put("invoice", invoice.toJSONString());
                Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoice.getLong("invoiceType"));
                for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                    if (null == this.getControl((String)invoiceField.getValue())) continue;
                    this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                    if (((String)invoiceField.getKey()).contains(",")) {
                        String[] valueKeys;
                        for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                            if (!StringUtils.isNotEmpty((CharSequence)invoice.getString(valueKey))) continue;
                            this.getModel().setValue((String)invoiceField.getValue(), (Object)invoice.getString(valueKey));
                        }
                        continue;
                    }
                    this.getModel().setValue((String)invoiceField.getValue(), (Object)invoice.getString((String)invoiceField.getKey()));
                }
            }
        } else {
            Object newValue = null;
            ChangeData[] changeDatas = e.getChangeSet();
            if (changeDatas.length == 1) {
                JSONObject invoice;
                Map invoiceFieldMap;
                newValue = changeDatas[0].getNewValue();
                if (newValue instanceof Date) {
                    newValue = DateUtils.format((Date)((Date)newValue), (String)"yyyy-MM-dd");
                }
                if ((invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)(invoice = JSONObject.parseObject((String)this.getPageCache().get("invoice"))).getLong("invoiceType"))).containsValue(fieldKey)) {
                    for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                        if (!StringUtils.equals((CharSequence)((CharSequence)invoiceField.getValue()), (CharSequence)fieldKey)) continue;
                        if (((String)invoiceField.getKey()).contains(",")) {
                            String[] valueKeys;
                            for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                                invoice.put(valueKey, newValue);
                            }
                            continue;
                        }
                        if (newValue instanceof DynamicObject) {
                            invoice.put((String)invoiceField.getKey(), (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)newValue));
                            continue;
                        }
                        invoice.put((String)invoiceField.getKey(), newValue);
                    }
                }
                this.getPageCache().put("invoice", invoice.toJSONString());
            }
        }
    }

    private void initView() {
        String uncheckId;
        this.invisibleInvoiceFlex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u7f16\u8f91\u9884\u89c8\u754c\u9762\u53d1\u7968\u6570\u636e\u521d\u59cb\u5316\uff1a" + customParams);
        Object invoiceJson = customParams.get("invoice");
        Object serialNo = customParams.get("serialNo");
        Object mainId = customParams.get("mainId");
        String string = uncheckId = customParams.get("uncheckId") == null ? "" : customParams.get("uncheckId").toString();
        if (customParams.get("businessParam") != null) {
            JSONObject businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            logger.info("parentBusinessParam:" + businessParam);
            this.getView().getPageCache().put("fpzs_param_cache", businessParam.toJSONString());
        }
        JSONArray invoiceArray = null;
        JSONObject invoice = null;
        if (invoiceJson != null) {
            invoice = JSONObject.parseObject((String)invoiceJson.toString());
        } else if (serialNo != null) {
            invoiceArray = VerifyUtil.verifyBySerialNos(new HashMap(), Stream.of(serialNo.toString()).collect(Collectors.toList()), (boolean)true);
        } else if (mainId != null) {
            invoiceArray = VerifyUtil.verifyByMainIds(new HashMap(), Collections.singletonList(mainId.toString()).stream().filter(StringUtils::isNotEmpty).map(v -> Long.parseLong(v.trim())).collect(Collectors.toList()), Collections.singletonList(uncheckId).stream().filter(StringUtils::isNotEmpty).map(v -> Long.parseLong(v.trim())).collect(Collectors.toList()), (boolean)true);
        }
        if (null != invoiceArray && invoiceArray.size() > 0) {
            invoice = invoiceArray.getJSONObject(0);
        }
        if (null != invoice) {
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
            this.setMust(invoiceType);
            String awsInvoiceTyep = InputInvoiceTypeEnum.getAwsType((Object)invoiceType);
            this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_" + awsInvoiceTyep});
            invoice.put("invoiceType", (Object)invoiceType);
            this.getPageCache().put("invoice", invoice.toJSONString());
            this.getPageCache().put("invoiceInit", invoice.toJSONString());
            Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
            if (invoiceFieldMap != null) {
                this.getModel().setValue("invoicetype", (Object)invoiceType);
                List amountField = InvoiceCollectField.getAmountField();
                for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                    if (null == this.getControl((String)invoiceField.getValue())) continue;
                    this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                    if (((String)invoiceField.getKey()).contains(",")) {
                        String[] valueKeys;
                        for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                            String fieldValue = invoice.getString(valueKey);
                            if (!StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                            if (amountField.contains(valueKey)) {
                                fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                            }
                            this.getModel().setValue((String)invoiceField.getValue(), (Object)fieldValue);
                        }
                        continue;
                    }
                    String fieldValue = invoice.getString((String)invoiceField.getKey());
                    if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) && ((String)invoiceField.getKey()).equals("businessType")) {
                        fieldValue = MetadataUtil.getComboItemName((String)"rim_inv_train_ele", (String)"business_type", (String)invoice.getString("businessType"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)fieldValue) && amountField.contains(invoiceField.getKey())) {
                        fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                    }
                    this.getModel().setValue((String)invoiceField.getValue(), (Object)fieldValue);
                }
            }
        }
    }

    private void setMust(Long invoiceType) {
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            Map configMap = ImcConfigUtil.getValue((String)"rim_recog_check");
            String otherMust = ImcConfigUtil.getValue((Map)configMap, (String)"other_must", (String)"0");
            if ("1".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
            } else if ("2".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
                TextEdit invoiceCode = (TextEdit)this.getControl("invoicecode_11");
                invoiceCode.setMustInput(true);
            }
        }
    }

    private void invisibleInvoiceFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_3"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_4"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_6"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_15"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_12"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_13"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_7"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_23"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_9"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_10"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_16"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_20"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_8"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_14"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_17"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_18"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_22"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_23"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_28"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_29"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_11"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_19"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_21"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_24"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_25"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_26"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_27"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_30"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_29"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_28"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_83"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_84"});
    }
}

