/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.h5;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.helper.ImcSaveServiceHelper;
import kd.imc.rim.common.invoice.collector.InvoiceCollectField;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.collector.ScannerService;
import kd.imc.rim.common.invoice.file.InvoiceAttachCaremaService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.invoice.verify.dto.VerifyResultDto;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CurrencyUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.itextpdf.UrlServiceUtils;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class H5InvoiceUpdatePlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static Log logger = LogFactory.getLog(H5InvoiceUpdatePlugin.class);
    private static final String ATTACH_ENTITY = "attach_entity";
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"edit_invoice", "del_invoice", "pre_page_flex", "next_page_flex", "show_more", "flex_invoice_class", "check_invoice", "relay_invoice", "view_raw"});
        this.addItemClickListeners(new String[]{"flexpanelap4"});
        this.addItemClickListeners(new String[]{"show_more"});
        CardEntry cardEntry = (CardEntry)this.getControl(ATTACH_ENTITY);
        cardEntry.addCellClickListener((CellClickListener)this);
        Button moreButton = (Button)this.getControl("more");
        moreButton.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        InvoiceAttachCaremaService attachService = new InvoiceAttachCaremaService();
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        attachService.initH5AttachUpload(Boolean.FALSE, customcontrol, "add_attach");
        this.getView().setVisible(Boolean.FALSE, new String[]{"check_invoice"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"relay_invoice"});
        this.initView();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        Long id = Long.parseLong(this.getModel().getValue("attachid").toString());
        this.showAttachDetail(id);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "pre_page_flex": {
                this.prePage();
                return;
            }
            case "next_page_flex": {
                this.nextPage();
                return;
            }
            case "edit_invoice": {
                this.showEditView();
                return;
            }
            case "del_invoice": {
                this.delInvoice();
                return;
            }
            case "more": {
                this.dealAttachMore();
                return;
            }
            case "show_more": {
                this.showMore();
                return;
            }
            case "flex_invoice_class": {
                InvoiceClassService.getInstance().openSelect((AbstractFormPlugin)this);
                return;
            }
            case "check_invoice": {
                this.checkInvoice();
                return;
            }
            case "relay_invoice": {
                this.relayInvoice();
                return;
            }
            case "view_raw": {
                this.viewRaw();
                return;
            }
        }
    }

    private void viewRaw() {
        String invoiceStr = this.getView().getPageCache().get("invoice");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoiceStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"H5InvoiceUpdatePlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject invoice = JSONObject.parseObject((String)invoiceStr);
        String fileType = invoice.getString("fileType");
        String originalFileUrl = "";
        if ("2".equals(fileType)) {
            originalFileUrl = invoice.getString("imageUrl");
            String suffix = FileUtils.getFileTypeByPath((String)originalFileUrl);
            if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)suffix)) {
                if (!this.qualify(suffix)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u683c\u5f0f\u6682\u4e0d\u652f\u6301\u9884\u89c8", (String)"H5InvoiceUpdatePlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return;
                }
                try {
                    this.previewImg(invoice);
                }
                catch (IOException e) {
                    logger.info(e.getMessage(), (Object)e);
                    throw new MsgException("0001", ResManager.loadKDString((String)"md5\u751f\u6210\u5931\u8d25", (String)"H5InvoiceUpdatePlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u683c\u5f0f\u6682\u4e0d\u652f\u6301\u9884\u89c8", (String)"H5InvoiceUpdatePlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            this.previewPdf(invoice);
        }
        catch (IOException e) {
            logger.info(e.getMessage(), (Object)e);
            throw new MsgException("0001", ResManager.loadKDString((String)"md5\u751f\u6210\u5931\u8d25", (String)"H5InvoiceUpdatePlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private void previewImg(JSONObject invoice) throws IOException {
        String domainContextUrl = UrlService.getDomainContextUrl();
        String imageUrl = invoice.getString("imageUrl");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)imageUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"H5InvoiceUpdatePlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileType = FileUtils.getFileTypeByPath((String)imageUrl);
        String fileName = MD5.md5Hex((String)imageUrl) + "." + fileType;
        QFilter billIdsFilter = new QFilter("ffileid", "=", (Object)imageUrl);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)"bos_attachment", (String)"id", (QFilter[])billIdsFilter.toArray());
        if (ObjectUtils.isEmpty((Object)idObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"H5InvoiceUpdatePlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Long id = (Long)idObject.get("id");
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(imageUrl);
        String md5 = DigestUtils.md5Hex((InputStream)in);
        String downloadUrl = this.urlEncode(imageUrl);
        String encodeDownUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/download.do?path=" + downloadUrl));
        String encodePreviewUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/preview.do?path=" + downloadUrl));
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] urlList = new String[]{encodePreviewUrl};
        map.put("urlList", urlList);
        map.put("downloadUrl", encodeDownUrl);
        map.put("fileExt", fileType);
        map.put("fileId", id);
        map.put("fileName", fileName);
        map.put("filesource", "1");
        map.put("previewType", UrlServiceUtils.getPreviewType());
        map.put("md5", md5);
        map.put("supportOnlinePreview", true);
        map.put("previewUrl", encodePreviewUrl);
        logger.info("\u53d1\u7968\u9884\u89c8\u539f\u56fe\u7247\u6587\u4ef6\u7684map\uff1a{}", map);
        this.getView().previewAttachment(map);
    }

    private void previewPdf(JSONObject invoice) throws IOException {
        String domainContextUrl = UrlService.getDomainContextUrl();
        String pdfUrl = invoice.getString("pdfurl");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)pdfUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"H5InvoiceUpdatePlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String fileType = FileUtils.getFileTypeByPath((String)pdfUrl);
        String fileName = MD5.md5Hex((String)pdfUrl) + "." + fileType;
        QFilter billIdsFilter = new QFilter("ffileid", "=", (Object)pdfUrl);
        DynamicObject idObject = QueryServiceHelper.queryOne((String)"bos_attachment", (String)"id", (QFilter[])billIdsFilter.toArray());
        if (ObjectUtils.isEmpty((Object)idObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"H5InvoiceUpdatePlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(pdfUrl);
        Long id = (Long)idObject.get("id");
        String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        String downloadUrl = this.urlEncode(pdfUrl);
        String encodePreviewUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/preview.do?path=" + downloadUrl)) + "&kd_cs_ticket=" + csrfTokenValue;
        String encodeDownUrl = EncreptSessionUtils.encryptSession((String)(domainContextUrl + "/attachment/download.do?path=" + downloadUrl));
        String md5 = DigestUtils.md5Hex((InputStream)in);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("downloadUrl", encodeDownUrl);
        map.put("fileExt", fileType);
        map.put("fileId", id);
        map.put("fileName", fileName);
        map.put("filesource", "1");
        map.put("md5", md5);
        map.put("supportOnlinePreview", true);
        map.put("previewType", UrlServiceUtils.getPreviewType());
        map.put("previewUrl", encodePreviewUrl);
        logger.info("\u53d1\u7968\u9884\u89c8\u539fPDF\u6587\u4ef6\u7684map\uff1a{}", map);
        this.getView().previewAttachment(map);
    }

    private boolean qualify(String str) {
        HashSet<String> stringSet = new HashSet<String>();
        stringSet.add("jpg");
        stringSet.add("jpeg");
        stringSet.add("png");
        stringSet.add("pdf");
        stringSet.add("bmp");
        String lowerCaseString = str.toLowerCase();
        return stringSet.contains(lowerCaseString);
    }

    private String urlEncode(String url) {
        try {
            String encodeUrl = URLEncoder.encode(url, "UTF-8");
            return encodeUrl;
        }
        catch (UnsupportedEncodingException e) {
            logger.info(e.getMessage(), (Object)e);
            throw new MsgException("0001", ResManager.loadKDString((String)"url\u8f6c\u4e49\u5931\u8d25", (String)"H5InvoiceUpdatePlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private void relayInvoice() {
        String invoiceStr = this.getView().getPageCache().get("invoice");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoiceStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"H5InvoiceUpdatePlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject invoice = JSONObject.parseObject((String)invoiceStr);
        ArrayList ids = Lists.newArrayList();
        ids.add(invoice.getLong("mainId"));
        MobileFormShowParameter mfsp = new MobileFormShowParameter();
        mfsp.setShowTitle(false);
        mfsp.setShowClose(false);
        mfsp.setFormId("rim_inv_relay_mb");
        mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invoiceRelay"));
        mfsp.getOpenStyle().setShowType(ShowType.Floating);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)2);
        customParams.put("ids", ids);
        Map customParamsPage = this.getView().getFormShowParameter().getCustomParams();
        customParams.put(InvoiceSaveConstant.OPERATE_USER_ID, customParamsPage.get(InvoiceSaveConstant.OPERATE_USER_ID));
        customParams.put("rim_user", customParamsPage.get("rim_user"));
        FpzsAnonymousUserService.addEventCode((Map)customParams, (String)this.getView().getPageId());
        mfsp.setCustomParams((Map)customParams);
        this.getView().showForm((FormShowParameter)mfsp);
    }

    private void checkInvoice() {
        String checkAmount;
        String invoiceStr = this.getView().getPageCache().get("invoice");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoiceStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"H5InvoiceUpdatePlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject invoice = JSONObject.parseObject((String)invoiceStr);
        String totalAmount = invoice.getString("totalAmount");
        String invoiceAmount = invoice.getString("invoiceAmount");
        Long invoiceType = invoice.getLong("invoiceType");
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.needReplaceAmountType((Long)invoiceType)) {
            checkAmount = totalAmount;
        } else {
            checkAmount = invoiceAmount;
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoiceAmount)) {
                checkAmount = totalAmount;
            }
        }
        InvoiceCollectService invoiceCollectService = new InvoiceCollectService();
        JSONObject businessParam = new JSONObject();
        businessParam.put("isSetUser", (Object)"1");
        JSONObject checkResult = invoiceCollectService.checkInvoice(invoice.getString("invoiceCode"), invoice.getString("invoiceNo"), invoiceType, invoice.getString("invoiceDate"), BigDecimalUtil.transDecimal((Object)checkAmount), invoice.getString("checkCode"), businessParam);
        if (!"0000".equals(checkResult.getString("errcode"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)checkResult.getString("description"), (String)"H5InvoiceUpdatePlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u9a8c\u6210\u529f", (String)"H5InvoiceUpdatePlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        if ("h5_eidtInvoice".equals(closedCallBackEvent.getActionId())) {
            Map callBackData = (Map)closedCallBackEvent.getReturnData();
            if (null == callBackData || null == callBackData.get("invoice")) {
                return;
            }
            JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
            JSONObject editInvoice = (JSONObject)callBackData.get("invoice");
            Long mainId = editInvoice.getLong("mainId");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            logger.info("customParams\uff1a" + customParams);
            JSONObject businessParam = new JSONObject();
            if (customParams.get("businessParam") != null) {
                businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            }
            editInvoice = VerifyUtil.verifyByMainIds((Map)businessParam, Stream.of(mainId).collect(Collectors.toList()), (boolean)true).getJSONObject(0);
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)editInvoice.getString("invoiceType"));
            editInvoice.put("invoiceType", (Object)invoiceType);
            JSONArray invoiceArray = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArray"));
            int index = Integer.parseInt(this.getView().getPageCache().get("index"));
            invoiceArray.set(index, (Object)editInvoice);
            if (!editInvoice.getString("serialNo").equals(invoice.getString("serialNo"))) {
                String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoice.get((Object)"invoiceType"));
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_" + awsInvoiceType});
                for (int invoiceIndex = invoiceArray.size() - 1; invoiceIndex >= 0; --invoiceIndex) {
                    JSONObject invoiceTemp = invoiceArray.getJSONObject(invoiceIndex);
                    if (index == invoiceIndex || !editInvoice.getString("serialNo").equals(invoiceTemp.getString("serialNo"))) continue;
                    invoiceArray.remove(invoiceIndex);
                    if (invoiceIndex >= index) continue;
                    --index;
                }
            }
            editInvoice.put("uploadSeq", (Object)invoice.getLong("uploadSeq"));
            this.getView().getPageCache().put("invoiceArray", invoiceArray.toJSONString());
            this.getView().getPageCache().put("size", invoiceArray.size() + "");
            this.getView().getPageCache().put("invoice", editInvoice.toJSONString());
            this.getView().getPageCache().put("index", index + "");
            if (invoiceArray.size() == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pre_page_flex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"next_page_flex"});
            }
            this.showInvoiceFlex(editInvoice);
            this.notifyParentPage();
            Label pageLabelap = (Label)this.getControl("page_labelap");
            pageLabelap.setText(index + 1 + "/" + invoiceArray.size());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"H5InvoiceUpdatePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        } else if ("rim_h5_attach_operate".equals(closedCallBackEvent.getActionId()) || "rim_h5_attach_detail".equals(closedCallBackEvent.getActionId())) {
            JSONObject returnData2 = (JSONObject)closedCallBackEvent.getReturnData();
            this.dealAttachCallback(returnData2);
            this.notifyParentPage();
        } else if ("select_class".equals(closedCallBackEvent.getActionId())) {
            JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
            InvoiceClassService.getInstance().selectCloseCallBack((AbstractFormPlugin)this, closedCallBackEvent, invoice.getLong("mainId"));
            InvoiceClassService.getInstance().callBackProBar((AbstractFormPlugin)this);
        } else if ("invoiceRelay".equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.getView().close();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        if ("cameraUploadStart".equals(e.getEventName())) {
            logger.info("\u53d1\u7968\u4e0a\u4f20\u9644\u4ef6\u4fe1\u606f-cameraUploadStart\uff1a" + eventArgs);
            this.setLoading(true);
        } else if ("cameraUpload".equals(e.getEventName())) {
            logger.info("\u53d1\u7968\u4e0a\u4f20\u9644\u4ef6\u4fe1\u606f-cameraUpload\uff1a" + eventArgs);
            JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoice.getString("serialNo"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5173\u952e\u5b57\u6bb5\u7f3a\u5931\uff0c\u4e0d\u652f\u6301\u7ed1\u5b9a\u9644\u4ef6\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"H5InvoiceUpdatePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            } else {
                String serialNo = invoice.getString("serialNo");
                JSONObject uploadData = JSON.parseObject((String)eventArgs);
                JSONArray fileArray = uploadData.getJSONArray("fileArray");
                for (int i = 0; i < fileArray.size(); ++i) {
                    JSONObject fileJson = fileArray.getJSONObject(i);
                    if (!"success".equals(fileJson.getString("status"))) continue;
                    String urlPath = fileJson.getString("url");
                    String originalFileName = fileJson.getString("name");
                    DynamicObject dynamicObject = FpzsAttachService.saveAttach(originalFileName, urlPath, this);
                    if (dynamicObject == null || ObjectUtils.isEmpty((Object)dynamicObject)) continue;
                    String attachid = dynamicObject.getString("id");
                    QFilter relationFilter = new QFilter("attach_id", "=", (Object)attachid).and("relation_id", "=", (Object)serialNo).and("relation_type", "=", (Object)"3");
                    DynamicObject relationObject = QueryServiceHelper.queryOne((String)"rim_attach_relation", (String)"attach_id, relation_type", (QFilter[])relationFilter.toArray());
                    if (ObjectUtils.isEmpty((Object)relationObject)) {
                        relationObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_attach_relation");
                        relationObject.set("attach_id", (Object)attachid);
                        relationObject.set("relation_type", (Object)"3");
                        relationObject.set("relation_id", (Object)serialNo);
                        ImcSaveServiceHelper.save((DynamicObject)relationObject);
                    }
                    this.refreshParentViewAttachCnt(Long.parseLong(attachid));
                }
                this.initAttachList(serialNo);
                this.notifyParentPage();
                this.setLoading(false);
            }
        }
    }

    private void initView() {
        String uncheckIds;
        this.getView().setEnable(Boolean.FALSE, new String[]{"inv_message"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flex_invoice_verify"});
        this.invisibleInvoiceFlex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        logger.info("\u7f16\u8f91\u9884\u89c8\u754c\u9762\u53d1\u7968\u6570\u636e\u521d\u59cb\u5316\uff1a" + customParams);
        Object parentPageId = customParams.get("parentPageId");
        Object invoices = customParams.get("invoices");
        Object serialNos = customParams.get("serialNos");
        Object mainIds = customParams.get("mainIds");
        String string = uncheckIds = customParams.get("uncheckIds") == null ? "" : customParams.get("uncheckIds").toString();
        if (customParams.get("businessParam") != null) {
            JSONObject businessParam = JSON.parseObject((String)customParams.get("businessParam").toString());
            logger.info("parentBusinessParam:" + businessParam);
            this.getView().getPageCache().put("fpzs_param_cache", businessParam.toJSONString());
        }
        if (parentPageId != null) {
            this.getView().getPageCache().put("parentPageId", parentPageId.toString());
        }
        JSONArray invoiceArray = null;
        if (!ObjectUtils.isEmpty(invoices)) {
            invoiceArray = JSONObject.parseArray((String)invoices.toString());
        } else if (serialNos != null) {
            invoiceArray = VerifyUtil.verifyBySerialNos(new HashMap(), Stream.of(serialNos.toString()).collect(Collectors.toList()), (boolean)true);
        } else if (mainIds != null) {
            invoiceArray = VerifyUtil.verifyByMainIds(new HashMap(), Arrays.asList(mainIds.toString().split(",")).stream().filter(kd.bos.dataentity.utils.StringUtils::isNotEmpty).map(mainId -> Long.parseLong(mainId.trim())).collect(Collectors.toList()), Arrays.asList(uncheckIds.split(",")).stream().filter(kd.bos.dataentity.utils.StringUtils::isNotEmpty).map(uncheckId -> Long.parseLong(uncheckId.trim())).collect(Collectors.toList()), (boolean)true);
        }
        if (invoiceArray != null && invoiceArray.size() > 0) {
            if (invoiceArray.size() > 1) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"pre_page_flex"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"next_page_flex"});
                if (!ObjectUtils.isEmpty(invoices) && invoiceArray.getJSONObject(0).getLong("uploadSeq") != null) {
                    invoiceArray.sort((o1, o2) -> ((JSONObject)o1).getLong("uploadSeq").compareTo(((JSONObject)o2).getLong("uploadSeq")));
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pre_page_flex"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"next_page_flex"});
            }
            JSONObject invoice = invoiceArray.getJSONObject(0);
            Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
            invoice.put("invoiceType", (Object)invoiceType);
            this.showInvoiceFlex(invoice);
            String checkStatus = invoice.getString("checkStatus");
            if ("2".equals(checkStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"check_invoice"});
            }
            if ("1".equals(invoice.getString("expenseStatus"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"relay_invoice"});
            }
            this.getView().getPageCache().put("invoiceArray", invoiceArray.toJSONString());
            this.getView().getPageCache().put("index", "0");
            this.getView().getPageCache().put("size", invoiceArray.size() + "");
            this.getView().getPageCache().put("invoice", invoice.toJSONString());
            Label pageLabelap = (Label)this.getControl("page_labelap");
            pageLabelap.setText("1/" + invoiceArray.size());
        } else {
            this.showInitFlex();
        }
    }

    private void showMore() {
        String showMore = this.getView().getPageCache().get("show_more");
        Label labelap = (Label)this.getView().getControl("show_more_text");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) {
            this.getView().getPageCache().put("show_more", "1");
            labelap.setText(ResManager.loadKDString((String)"\u6536\u8d77", (String)"H5InvoiceUpdatePlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_down"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_up"});
        } else {
            this.getView().getPageCache().put("show_more", "0");
            labelap.setText(ResManager.loadKDString((String)"\u5c55\u793a\u66f4\u591a", (String)"H5InvoiceUpdatePlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"vector_down"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"vector_up"});
        }
        this.showInvoiceInfo();
    }

    private JSONObject getBusinessParam() {
        JSONObject businessParam = new JSONObject();
        if (this.getPageCache().get("fpzs_param_cache") != null) {
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
        } else {
            FpzsMainService.cacheCustomParam((AbstractFormPlugin)this);
            businessParam = JSON.parseObject((String)this.getPageCache().get("fpzs_param_cache"));
        }
        logger.info("businessParam:" + businessParam);
        return businessParam;
    }

    private void showToastMessage(String toast, String verifyLevel) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)toast)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inv_toast_flex"});
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)verifyLevel) && "2".equals(verifyLevel)) {
                HashMap<String, String> flexFieldMap = new HashMap<String, String>();
                flexFieldMap.put("bc", "#fffbf2");
                this.getView().updateControlMetadata("inv_toast_flex", flexFieldMap);
                HashMap<String, String> labelapFieldMap = new HashMap<String, String>();
                labelapFieldMap.put("fc", "#ff991c");
                this.getView().updateControlMetadata("inv_toast_labelap", labelapFieldMap);
                Label invToastLabelap = (Label)this.getControl("inv_toast_labelap");
                invToastLabelap.setText(toast);
            } else {
                HashMap<String, String> flexFieldMap = new HashMap<String, String>();
                flexFieldMap.put("bc", "#fff2f4");
                this.getView().updateControlMetadata("inv_toast_flex", flexFieldMap);
                HashMap<String, String> labelapFieldMap = new HashMap<String, String>();
                labelapFieldMap.put("fc", "#fb2623");
                this.getView().updateControlMetadata("inv_toast_labelap", labelapFieldMap);
                Label invToastLabelap = (Label)this.getControl("inv_toast_labelap");
                invToastLabelap.setText(toast);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inv_toast_flex"});
        }
    }

    private void prePage() {
        int size = Integer.parseInt(this.getView().getPageCache().get("size"));
        if (size == 1) {
            return;
        }
        JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
        String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoice.get((Object)"invoiceType"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_" + awsInvoiceType});
        int index = Integer.parseInt(this.getView().getPageCache().get("index"));
        JSONArray invoiceArray = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArray"));
        int showIndex = index == 0 ? size - 1 : index - 1;
        invoice = invoiceArray.getJSONObject(showIndex);
        this.getView().getPageCache().put("invoice", invoice.toJSONString());
        this.getView().getPageCache().put("index", showIndex + "");
        this.showInvoiceFlex(invoice);
        Label pageLabelap = (Label)this.getControl("page_labelap");
        pageLabelap.setText(showIndex + 1 + "/" + invoiceArray.size());
    }

    private void nextPage() {
        int size = Integer.parseInt(this.getView().getPageCache().get("size"));
        if (size == 1) {
            return;
        }
        JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
        String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoice.get((Object)"invoiceType"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_" + awsInvoiceType});
        int index = Integer.parseInt(this.getView().getPageCache().get("index"));
        JSONArray invoiceArray = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArray"));
        int showIndex = index == size - 1 ? 0 : index + 1;
        invoice = invoiceArray.getJSONObject(showIndex);
        this.getView().getPageCache().put("invoice", invoice.toJSONString());
        this.getView().getPageCache().put("index", showIndex + "");
        this.showInvoiceFlex(invoice);
        Label pageLabelap = (Label)this.getControl("page_labelap");
        pageLabelap.setText(showIndex + 1 + "/" + invoiceArray.size());
    }

    private void showInvoiceFlex(JSONObject invoice) {
        String showAttach;
        Object flag;
        InvoiceClassService.getInstance().initInvoiceClass((Map)invoice);
        InvoiceClassService.getInstance().setValueInvoiceClass((AbstractFormPlugin)this, invoice);
        this.showToastMessage(null, null);
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoice.getString("invoiceType"));
        String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoiceType);
        this.getView().setVisible(Boolean.TRUE, new String[]{"invoice_" + awsInvoiceType});
        String localUrl = "";
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("localUrl"))) {
            localUrl = invoice.getString("localUrl");
        } else if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("downloadUrl"))) {
            localUrl = invoice.getString("downloadUrl");
        }
        this.showInvoiceImage(localUrl, invoice.getString("snapshotUrl"), invoice.getString("rotationAngle"), invoice.getString("pixel"), invoice.getString("region"), invoice.getString("fileType"));
        logger.info("\u53d1\u7968\u8be6\u60c5, {}", (Object)invoice.toJSONString());
        List resultList = new ArrayList(8);
        if (invoice.getJSONArray("verifyResult") != null) {
            resultList = JSON.parseArray((String)invoice.getJSONArray("verifyResult").toJSONString(), VerifyResultDto.class);
            if (resultList.size() > 0) {
                StringBuilder filter0 = new StringBuilder();
                filter0.append(System.lineSeparator());
                boolean isFilter = false;
                for (int resultIndex = 0; resultIndex < resultList.size(); ++resultIndex) {
                    VerifyResultDto verifyResultDto = (VerifyResultDto)resultList.get(resultIndex);
                    if ("check_status".equals(verifyResultDto.getConfigType())) {
                        this.showToastMessage(verifyResultDto.getMsg(), verifyResultDto.getConfig());
                    }
                    if (!"0".equals(verifyResultDto.getConfig())) continue;
                    isFilter = true;
                    filter0.append(verifyResultDto.getMsg()).append(System.lineSeparator());
                }
                if (isFilter) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flex_invoice_verify"});
                    this.getModel().setValue("invoice_verify_result", (Object)filter0.toString());
                }
            }
        } else if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)invoice.getString("serialNo"))) {
            this.showToastMessage(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u5fc5\u586b\u5b57\u6bb5\u7f3a\u5931", (String)"H5InvoiceUpdatePlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), null);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"vector_up"});
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        Boolean editFlag = this.getEditAllowFlag(invoice);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (flag = customParams.get("allowEdit")) != null && !((Boolean)flag).booleanValue()) {
            editFlag = Boolean.FALSE;
        }
        if (invoiceFieldMap != null) {
            this.getModel().setValue("invoicetype", (Object)invoiceType);
            List amountField = InvoiceCollectField.getAmountField();
            for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)invoiceField.getValue())) continue;
                Boolean encrypt = InvoiceCollectField.encryptField((String)((String)invoiceField.getValue()), (Boolean)Boolean.FALSE);
                if (((String)invoiceField.getKey()).contains(",")) {
                    String[] valueKeys;
                    boolean nullFlag = true;
                    for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                        String fieldValue = invoice.getString(valueKey);
                        if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fieldValue)) continue;
                        nullFlag = false;
                        if (amountField.contains(valueKey)) {
                            fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                        }
                        this.getModel().setValue((String)invoiceField.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
                    }
                    if (!nullFlag) continue;
                    this.getModel().setValue((String)invoiceField.getValue(), (Object)"");
                    continue;
                }
                String fieldValue = invoice.getString((String)invoiceField.getKey());
                if ("issueDate".equals(invoiceField.getKey()) && invoice.get(invoiceField.getKey()) instanceof Long) {
                    Date dateVal = new Date(invoice.getLong((String)invoiceField.getKey()));
                    fieldValue = DateUtils.format((Date)dateVal, (String)"yyyy-MM-dd");
                }
                if (InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getCode().equals(invoiceType) && ((String)invoiceField.getKey()).equals("businessType")) {
                    fieldValue = MetadataUtil.getComboItemName((String)"rim_inv_train_ele", (String)"business_type", (String)invoice.getString("businessType"));
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fieldValue) && amountField.contains(invoiceField.getKey())) {
                    if (InputInvoiceTypeEnum.OVERSEA_INVOICE.getCode().equals(invoiceType)) {
                        Long currencyId = invoice.getLong("currencyId");
                        int precision = CurrencyUtils.getAmtPrecision((Long)currencyId);
                        CurrencyUtils.modifyScaleDynamically((AbstractFormPlugin)this, (String)((String)invoiceField.getValue()), (int)precision);
                    } else {
                        fieldValue = BigDecimalUtil.transToPoint((String)fieldValue, (int)2);
                    }
                }
                this.getModel().setValue((String)invoiceField.getValue(), encrypt != false ? InvoiceConvertService.encrypt((Object)fieldValue) : fieldValue);
            }
        }
        this.showInvoiceInfo();
        this.getView().setVisible(Boolean.TRUE, new String[]{"del_flexpanelap"});
        logger.info("editFlag1111, {}", (Object)editFlag);
        this.getView().setVisible(editFlag, new String[]{"edit_invoice"});
        this.getPageCache().put("allowInvoiceEdit", editFlag.toString());
        if (customParams != null && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(showAttach = (String)customParams.get("showAttach"))) && "0".equals(showAttach)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attach_flex"});
            return;
        }
        List<Object> attachIds = new ArrayList(16);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("serialNo"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexpanelap11"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"inv_attach"});
            attachIds = this.initAttachList(invoice.getString("serialNo"));
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap11"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"inv_attach"});
        }
        if (customParams != null) {
            if (customParams.get("addAttach") != null && !((Boolean)customParams.get("addAttach")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap11"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1"});
                HashMap<String, Boolean> showMore = new HashMap<String, Boolean>(1);
                showMore.put("vi", Boolean.FALSE);
                this.getView().updateControlMetadata("cardentryflexpanelap1", showMore);
                if (CollectionUtils.isEmpty(attachIds)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"attach_flex"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"add_attach"});
                }
            }
            if (customParams.get("allowDel") != null && !((Boolean)customParams.get("allowDel")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"del_flexpanelap"});
            }
        }
    }

    private void setMust(Long invoiceType) {
        if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(invoiceType)) {
            Map configMap = ImcConfigUtil.getValue((String)"rim_recog_check");
            String otherMust = ImcConfigUtil.getValue((Map)configMap, (String)"other_must", (String)"0");
            if ("1".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
            } else if ("2".equals(otherMust)) {
                TextEdit invoiceNo = (TextEdit)this.getControl("invoiceno_11");
                invoiceNo.setMustInput(true);
                TextEdit invoiceCode = (TextEdit)this.getControl("invoicecode_11");
                invoiceCode.setMustInput(true);
            }
        }
    }

    private void showInvoiceInfo() {
        Object invoiceTypeObj = this.getModel().getValue("invoicetype");
        if (ObjectUtils.isEmpty((Object)invoiceTypeObj)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u53d1\u7968\u7c7b\u578b", (String)"H5InvoiceUpdatePlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Long invoiceType = Long.parseLong(invoiceTypeObj.toString());
        Map invoiceFieldMap = InvoiceCollectField.getInvoiceField((Long)invoiceType);
        if (invoiceFieldMap != null) {
            String showMore = this.getView().getPageCache().get("show_more");
            int showMoreCount = 0;
            if (invoiceFieldMap.size() <= 4) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"show_more"});
                return;
            }
            for (Map.Entry invoiceField : invoiceFieldMap.entrySet()) {
                if (null == this.getControl((String)invoiceField.getValue())) continue;
                if (((String)invoiceField.getKey()).contains(",")) {
                    String[] valueKeys;
                    for (String valueKey : valueKeys = ((String)invoiceField.getKey()).split(",")) {
                        if ((kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) && ++showMoreCount >= 4) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                            continue;
                        }
                        this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
                    }
                    continue;
                }
                if ((kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)showMore) || "0".equals(showMore)) && ++showMoreCount >= 4) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{(String)invoiceField.getValue()});
                    continue;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{(String)invoiceField.getValue()});
            }
        }
    }

    private void showEditView() {
        String allowInvoiceEdit = this.getPageCache().get("allowInvoiceEdit");
        if ("false".equals(allowInvoiceEdit)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u4e0d\u5141\u8bb8\u8fdb\u884c\u7f16\u8f91", (String)"H5InvoiceUpdatePlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String invoice = this.getView().getPageCache().get("invoice");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("invoice", invoice);
        customParams.put("businessParam", (String)this.getBusinessParam());
        FpzsAnonymousUserService.addEventCode(customParams, (String)this.getView().getPageId());
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_h5_inv_edit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "h5_eidtInvoice");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void delInvoice() {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"H5InvoiceUpdatePlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"H5InvoiceUpdatePlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"H5InvoiceUpdatePlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("delCallBack"), btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            if ("delCallBack".equals(callBackId)) {
                JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("serialNo"))) {
                    Long userId = FpzsMainService.getUserId((Map)parentCustomParams);
                    Long rimUser = FpzsMainService.getRimUser((Map)parentCustomParams);
                    this.extracted(invoice.getString("serialNo"), userId, rimUser);
                }
                String awsInvoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoice.get((Object)"invoiceType"));
                this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_" + awsInvoiceType});
                JSONArray invoiceArray = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArray"));
                int index = Integer.parseInt(this.getView().getPageCache().get("index"));
                invoiceArray.remove(index);
                this.getView().getPageCache().put("invoiceArray", invoiceArray.toJSONString());
                this.getView().getPageCache().put("size", invoiceArray.size() + "");
                if (invoiceArray.size() == 0) {
                    HashMap<String, String> customParams = new HashMap<String, String>(8);
                    customParams.put("invoices", invoiceArray.toJSONString());
                    customParams.put("row", (String)parentCustomParams.get("row"));
                    customParams.put("isFilter", (String)parentCustomParams.get("isFilter"));
                    this.getView().returnDataToParent(customParams);
                    this.getView().close();
                } else {
                    this.notifyParentPage();
                    invoice = invoiceArray.getJSONObject(0);
                    if (invoiceArray.size() == 1) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"pre_page_flex"});
                        this.getView().setVisible(Boolean.FALSE, new String[]{"next_page_flex"});
                    }
                    this.getView().getPageCache().put("index", "0");
                    this.getView().getPageCache().put("invoice", invoice.toJSONString());
                    this.showInvoiceFlex(invoice);
                    Label pageLabelap = (Label)this.getControl("page_labelap");
                    pageLabelap.setText("1/" + invoiceArray.size());
                }
            }
        }
    }

    private void invisibleInvoiceFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_2"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_3"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_4"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_5"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_6"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_15"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_12"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_13"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_7"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_23"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_9"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_10"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_16"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_20"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_8"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_14"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_17"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_18"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_22"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_23"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_28"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_29"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_11"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_19"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_21"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_24"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_25"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_26"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_27"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_30"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_29"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_28"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_83"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"invoice_84"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap11"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"inv_attach"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"init_flex"});
    }

    private void extracted(String serialNo, Long userId, Long rimUser) {
        boolean delResult = this.invoiceCollectService.delInvoice(serialNo, userId, rimUser);
        if (!delResult) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25!", (String)"H5InvoiceUpdatePlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void showInitFlex() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_image_flex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_toast_flex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_message"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"inv_attach"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"init_flex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"del_flexpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"show_more"});
    }

    private List<Long> initAttachList(String serialNo) {
        QFilter relationFilter;
        DynamicObjectCollection relationObjects;
        this.getModel().deleteEntryData(ATTACH_ENTITY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String relationType = null;
        if (!CollectionUtils.isEmpty((Map)customParams)) {
            relationType = (String)customParams.get("relationType");
        }
        if ((relationObjects = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id", (QFilter[])(relationFilter = kd.bos.dataentity.utils.StringUtils.isEmpty(relationType) ? new QFilter("relation_id", "=", (Object)serialNo).and("relation_type", "=", (Object)"3") : new QFilter("relation_id", "=", (Object)serialNo).and("relation_type", "=", (Object)relationType)).toArray())).isEmpty()) {
            return null;
        }
        ArrayList<Long> attachIds = new ArrayList<Long>(relationObjects.size());
        for (DynamicObject relationObject : relationObjects) {
            QFilter attachFilter;
            DynamicObject dynamicObject;
            Long attachId;
            if (ObjectUtils.isEmpty((Object)relationObject) || ObjectUtils.isEmpty((Object)(attachId = Long.valueOf(relationObject.getLong("attach_id")))) || ObjectUtils.isEmpty((Object)(dynamicObject = QueryServiceHelper.queryOne((String)"rim_attach", (String)"id, attach_url, attach_name, attach_type, snapshot_url, icon_url, create_time, remark", (QFilter[])(attachFilter = new QFilter("id", "=", (Object)attachId)).toArray())))) continue;
            attachIds.add(attachId);
            int rowIndex = this.getModel().createNewEntryRow(ATTACH_ENTITY);
            this.getModel().setValue("attachid", (Object)attachId, rowIndex);
            this.getModel().setValue("attach_url", (Object)dynamicObject.getString("attach_url"), rowIndex);
            this.getModel().setValue("attach_name", (Object)dynamicObject.getString("attach_name"), rowIndex);
            this.getModel().setValue("create_time", (Object)dynamicObject.getDate("create_time"), rowIndex);
            this.getModel().setValue("remark", (Object)dynamicObject.getString("remark"), rowIndex);
            String url = FpzsAttachService.getPreviewIconFullUrl(dynamicObject);
            this.getModel().setValue("attach_image", (Object)url, rowIndex);
        }
        return attachIds;
    }

    private void dealAttachMore() {
        MobileFormShowParameter moreForm = new MobileFormShowParameter();
        moreForm.setFormId("rim_h5_attach_operate");
        moreForm.getOpenStyle().setShowType(ShowType.Modal);
        JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
        Long id = Long.parseLong(this.getModel().getValue("attachid").toString());
        HashMap<String, Object> customerParam = new HashMap<String, Object>(3);
        customerParam.put("attachId", id);
        customerParam.put("serialNo", invoice.getString("serialNo"));
        customerParam.put("rowIndex", this.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
        H5PluginService.setCommonParam(customerParam, (Map)this.getBusinessParam());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_operate");
        moreForm.setCloseCallBack(closeCallBack);
        FpzsAnonymousUserService.addEventCode(customerParam, (String)this.getView().getPageId());
        moreForm.setCustomParams(customerParam);
        this.getView().showForm((FormShowParameter)moreForm);
    }

    private void dealAttachCallback(JSONObject returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String operateType = returnData.getString("type");
        if (StringUtils.isEmpty((String)operateType)) {
            return;
        }
        int rowIndex = returnData.getInteger("rowIndex");
        switch (operateType) {
            case "delete": {
                Long attachId = Long.parseLong(this.getView().getModel().getValue("attachid", rowIndex).toString());
                this.getView().getModel().deleteEntryRow(ATTACH_ENTITY, rowIndex);
                this.refreshParentViewAttachCnt(attachId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u5220\u9664\u6210\u529f", (String)"H5InvoiceUpdatePlugin_13", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                break;
            }
            case "edit": {
                String attachName = returnData.getString("attach_name");
                String remark = returnData.getString("remark");
                this.getView().getModel().setValue("attach_name", (Object)attachName, rowIndex);
                this.getView().getModel().setValue("remark", (Object)remark, rowIndex);
                break;
            }
            case "cancel": {
                break;
            }
            default: {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u9644\u4ef6\u64cd\u4f5c\u7c7b\u578b", (String)"H5InvoiceUpdatePlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showAttachDetail(Long id) {
        MobileFormShowParameter showAttachEditForm = new MobileFormShowParameter();
        showAttachEditForm.setFormId("rim_h5_attach_detail");
        JSONObject invoice = JSON.parseObject((String)this.getView().getPageCache().get("invoice"));
        showAttachEditForm.getOpenStyle().setShowType(ShowType.Floating);
        JSONObject customerParam = new JSONObject();
        customerParam.put("id", (Object)id);
        customerParam.put("serialNo", (Object)invoice.getString("serialNo"));
        customerParam.put("rowIndex", (Object)this.getModel().getEntryCurrentRowIndex(ATTACH_ENTITY));
        Map ParentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        H5PluginService.setCommonParam((Map)customerParam, (Map)this.getBusinessParam());
        if (!CollectionUtils.isEmpty((Map)ParentCustomParams) && !ObjectUtils.isEmpty(ParentCustomParams.get("allowEditAttach"))) {
            customerParam.put("allowEdit", ParentCustomParams.get("allowEditAttach"));
        }
        FpzsAnonymousUserService.addEventCode((Map)customerParam, (String)this.getView().getPageId());
        showAttachEditForm.setCustomParams((Map)customerParam);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rim_h5_attach_detail");
        showAttachEditForm.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showAttachEditForm);
    }

    private void notifyParentPage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (this.getView().getPageCache().get("parentPageId") != null && customParams != null && customParams.get("row") != null) {
            Object invoices = customParams.get("invoices");
            PageCache cache = new PageCache(this.getView().getPageCache().get("parentPageId"));
            JSONArray invoiceArray = JSON.parseArray((String)this.getView().getPageCache().get("invoiceArray"));
            JSONObject notifyData = new JSONObject();
            if (invoices != null) {
                JSONArray parentInvoices = (JSONArray)invoices;
                JSONObject parentInvoice = parentInvoices.getJSONObject(0);
                JSONObject invoice = invoiceArray.getJSONObject(0);
                if (!"0".equals(invoice.getString("errorLevel"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flex_invoice_verify"});
                }
                if ("0".equals(parentInvoice.getString("errorLevel")) && !"0".equals(invoice.getString("errorLevel"))) {
                    notifyData.put("needRemove", (Object)"1");
                } else if (!"0".equals(parentInvoice.getString("errorLevel")) && "0".equals(invoice.getString("errorLevel"))) {
                    notifyData.put("needRemove", (Object)"0");
                }
            }
            int row = Integer.parseInt(customParams.get("row").toString());
            notifyData.put("row", (Object)row);
            notifyData.put("invoiceArray", (Object)invoiceArray);
            cache.put("notifyData", notifyData.toJSONString());
        }
    }

    private Boolean getEditAllowFlag(JSONObject invoice) {
        Boolean editAllowFlag = Boolean.FALSE;
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("expenseStatus")) && !"1".equals(invoice.getString("expenseStatus"))) {
            editAllowFlag = Boolean.FALSE;
        } else if (!InvoiceConvertUtils.isVatInvoiceType((Long)invoice.getLong("invoiceType"))) {
            editAllowFlag = Boolean.TRUE;
        } else if (InvoiceConvertUtils.isVatInvoiceType((Long)invoice.getLong("invoiceType")) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)invoice.getString("checkStatus")) && !"1".equals(invoice.getString("checkStatus"))) {
            editAllowFlag = Boolean.TRUE;
        }
        return editAllowFlag;
    }

    private void showInvoiceImage(String localUrl, String snapshotUrl, String rotateDeg, String pixel, String region, String fileType) {
        ArrayList urlList = new ArrayList();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        String attachmentType = "attachment/download.do?path=";
        Map fpzsConfig = ImcConfigUtil.getValue((String)"rim_fpzs");
        String invoiceViewType = (String)kd.bos.dataentity.utils.StringUtils.defaultIfEmpty((CharSequence)((CharSequence)fpzsConfig.get("invoice_view_type")), (CharSequence)"0");
        String baseUrl = H5PluginService.getBaseUrl((IFormView)this.getView());
        if ("1".equals(invoiceViewType)) {
            attachmentType = "attachment/preview.do?path=";
            localUrl = UrlServiceUtils.getPreviewUrl((String)localUrl, (String)baseUrl);
            snapshotUrl = UrlServiceUtils.getPreviewUrl((String)snapshotUrl, (String)baseUrl);
        } else {
            localUrl = UrlServiceUtils.getDownloadUrl((String)localUrl, (String)baseUrl);
            snapshotUrl = UrlServiceUtils.getDownloadUrl((String)snapshotUrl, (String)baseUrl);
        }
        if (snapshotUrl.contains("http")) {
            urlMap.put("snapshotUrl", snapshotUrl);
        } else {
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)snapshotUrl)) {
                snapshotUrl = UrlServiceUtils.getCsPath((String)(attachmentType + snapshotUrl));
            }
            urlMap.put("snapshotUrl", snapshotUrl);
        }
        if (localUrl.contains("http")) {
            urlMap.put("localUrl", localUrl);
        } else {
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)localUrl)) {
                localUrl = UrlServiceUtils.getCsPath((String)(attachmentType + localUrl));
            }
            urlMap.put("localUrl", localUrl);
        }
        urlMap.put("rotateDeg", rotateDeg);
        urlMap.put("pixel", pixel);
        urlMap.put("region", region);
        urlMap.put("fileType", fileType);
        urlList.add(urlMap);
        CustomControl customcontrol = (CustomControl)this.getControl("viewinvoice_custom");
        JSONObject map = new JSONObject();
        map.put("pageId", (Object)this.getView().getPageId());
        map.put("list", urlList);
        map.put("flexKey", (Object)"#invoice_file_show");
        map.put("displayFlag", (Object)"cuteImage");
        map.put("time", (Object)System.currentTimeMillis());
        ScannerService.addCustomParam((Map)map, (String)"viewinvoice");
        customcontrol.setData((Object)map);
    }

    private void setLoading(boolean visible) {
        CustomControl customControlAp = (CustomControl)this.getControl("dialog_customcontrolap");
        InvoiceAttachCaremaService.loadDialogPlugin((CustomControl)customControlAp, (String)"flexpanelap6", (boolean)visible, null);
    }

    private void refreshParentViewAttachCnt(Long attachId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isEmpty(customParams.get("freshAttachNum")) || !((Boolean)customParams.get("freshAttachNum")).booleanValue()) {
            return;
        }
        List<Object> invAttachIdsTemp = Lists.newArrayList((Object[])new Long[]{attachId});
        int row = (Integer)customParams.get("row");
        String attachIdFiled = (String)customParams.get("attach_ids");
        IFormView parentView = this.getView().getParentView();
        DynamicObject dynamicObject = parentView.getModel().getEntryRowEntity("entryentity", row);
        String attachIds1 = dynamicObject.getString(attachIdFiled);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)attachIds1)) {
            invAttachIdsTemp = Arrays.stream(kd.bos.dataentity.utils.StringUtils.split((String)attachIds1, (String)",")).map(invAttachId -> Long.parseLong(invAttachId)).collect(Collectors.toList());
            if (invAttachIdsTemp.contains(attachId)) {
                invAttachIdsTemp.remove(attachId);
            } else {
                invAttachIdsTemp.add(attachId);
            }
        }
        String attachCntFiled = (String)customParams.get("inv_attach_cnt");
        parentView.getModel().setValue(attachIdFiled, (Object)kd.bos.dataentity.utils.StringUtils.join((Object[])invAttachIdsTemp.toArray(), (String)","), row);
        parentView.getModel().setValue(attachCntFiled, (Object)invAttachIdsTemp.size(), row);
        CardEntry cardEntry = (CardEntry)parentView.getControl("entryentity");
        if (invAttachIdsTemp.size() > 0) {
            cardEntry.setChildVisible(true, row, new String[]{"inv_attach_label"});
        } else {
            cardEntry.setChildVisible(false, row, new String[]{"inv_attach_label"});
        }
        if (!ArrayUtils.contains((int[])cardEntry.getSelectRows(), (int)row)) {
            this.getView().sendFormAction(parentView);
            return;
        }
        String cacheValue1 = parentView.getPageCache().get("attachIds");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)cacheValue1)) {
            String indexPageId = (String)customParams.get("indexPageId");
            List attachIds = (List)customParams.get("attachIds");
            if (attachIds.contains(attachId)) {
                AbstractOperateService.deleteSelected(indexPageId, null, Collections.singletonList(attachId));
            } else {
                AbstractOperateService.addSelected(indexPageId, null, Collections.singletonList(attachId));
            }
            this.getView().sendFormAction(parentView);
            return;
        }
        List attachIds = (List)JSON.parseObject((String)cacheValue1, List.class);
        if (attachIds.contains(attachId)) {
            attachIds.remove(attachId);
        } else {
            attachIds.add(attachId);
        }
        parentView.getPageCache().remove("attachIds");
        parentView.getPageCache().put("attachIds", JSON.toJSONString((Object)attachIds));
        Label labelap = (Label)parentView.getControl("labelap2");
        Label labelap4 = (Label)parentView.getControl("labelap5");
        if (labelap != null) {
            labelap.setText(String.format(ResManager.loadKDString((String)"\u5143\uff0c%s\u5f20\u9644\u4ef6", (String)"H5InvoiceUpdatePlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), attachIds.size()));
        }
        if (labelap4 != null) {
            labelap4.setText(String.format(ResManager.loadKDString((String)"\u5143\uff0c%s\u5f20\u9644\u4ef6", (String)"H5InvoiceUpdatePlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), attachIds.size()));
        }
        if (parentView.getModel().getDataEntity(true).getDynamicObjectType().getProperty("attach_selected_cnt") != null) {
            parentView.getModel().setValue("attach_selected_cnt", (Object)attachIds.size());
        }
        this.getView().sendFormAction(parentView);
    }
}

