/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.home;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DateUtils;

public class InvoiceHomePlugin
extends AbstractFormPlugin {
    private static final String RIM_INVOICE_SUM = "rim_invoice_sum";

    public void afterCreateNewData(EventObject e) {
        this.setModelData("0");
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"allinvoice", "commoninvoice", "majorinvoice", "labelap4"});
    }

    public void setModelData(String statisticstype) {
        this.getView().setStatus(OperationStatus.VIEW);
        QFilter filter = new QFilter("create_date", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date())).and("org", "=", (Object)RequestContext.get().getOrgId());
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)RIM_INVOICE_SUM, (String)"id", (QFilter[])filter.toArray());
        int receivedEInvoice = 0;
        int unreceivedEInvoice = 0;
        int receivedPaperInvoice = 0;
        int unreceivedPaperInvoice = 0;
        int authedInvoice = 0;
        int unauthedInvoice = 0;
        for (DynamicObject obj : objs) {
            if (ObjectUtils.isEmpty((Object)obj)) continue;
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)RIM_INVOICE_SUM);
            Long inputType = obj.getLong("input_invoice_type_id");
            int receivedCount = obj.getInt("received_count");
            int unreceivedCount = obj.getInt("unreceive_count");
            int certifiedCount = obj.getInt("certified_count");
            int uncertifiedCount = obj.getInt("uncertified_count");
            Boolean isEInvoice = InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(inputType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(inputType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(inputType);
            Boolean isSpecialInvoice = InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(inputType);
            Boolean isVATInvoice = InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(inputType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(inputType) || InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(inputType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(inputType);
            if (isEInvoice.booleanValue()) {
                receivedEInvoice += receivedCount;
                unreceivedEInvoice += unreceivedCount;
            }
            if (isSpecialInvoice.booleanValue()) {
                receivedPaperInvoice += receivedCount;
                unreceivedPaperInvoice += unreceivedCount;
            }
            if (!isVATInvoice.booleanValue()) continue;
            authedInvoice += certifiedCount;
            unauthedInvoice += uncertifiedCount;
        }
        this.getModel().setValue("received_einvoice", (Object)receivedEInvoice);
        this.getModel().setValue("unreceived_einvoice", (Object)unreceivedEInvoice);
        this.getModel().setValue("received_paper_invoice", (Object)receivedPaperInvoice);
        this.getModel().setValue("unreceived_paper_invoice", (Object)unreceivedPaperInvoice);
        this.getModel().setValue("authed_invoice", (Object)authedInvoice);
        this.getModel().setValue("unauthed_invoice", (Object)unauthedInvoice);
    }
}

