/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;

public class MessageReceivePlugin
implements IBillWebApiPlugin {
    private static Log LOGGER = LogFactory.getLog(MessageReceivePlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        Boolean success = Boolean.TRUE;
        result.setSuccess(success.booleanValue());
        result.setErrorCode("0000");
        String msgType = params.get("messageType") + "";
        String msgId = params.get("messageId") + "";
        Object reqData = params.get("data");
        LOGGER.info("msgType:{}-{}", (Object)msgType, (Object)msgId);
        AbstractMessageServie service = AbstractMessageServie.newInstance(msgType);
        if (service != null) {
            try {
                ApiResult busiResult = service.doBusiness(reqData);
                this.setSuccess(busiResult);
                return busiResult;
            }
            catch (MsgException e) {
                LOGGER.info("msgType:{}-{},", new Object[]{msgType, msgId, e});
                result.setErrorCode(e.getErrorCode());
                result.setMessage(e.getMessage());
                result.setData(e.getData());
            }
            catch (Exception e) {
                LOGGER.error(msgId + "-error", (Throwable)e);
                result.setErrorCode(ErrorType.FAIL.getCode());
                result.setData((Object)e);
            }
        } else {
            result.setErrorCode(ErrorType.PARAM_ERROR.getCode());
            result.setMessage(ResManager.loadKDString((String)"msgType\u53c2\u6570\u9519\u8bef", (String)"MessageReceivePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        this.setSuccess(result);
        return result;
    }

    private void setSuccess(ApiResult result) {
        result.setSuccess("0000".equals(result.getErrorCode()));
        if ("0000".equals(result.getErrorCode())) {
            result.setMessage(MessageReceivePlugin.getSuccessMsg());
        } else if (StringUtils.isEmpty((CharSequence)result.getMessage())) {
            result.setMessage(MessageReceivePlugin.getErrorMsg());
        }
    }

    public static String getSuccessMsg() {
        return ResManager.loadKDString((String)"\u6210\u529f", (String)"MessageReceivePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]);
    }

    public static String getErrorMsg() {
        return String.format(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25,\u8bf7\u6c42id:%1$s", (String)"MessageReceivePlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), RequestContext.get().getTraceId());
    }
}

