/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.model.openapi.MessageApiV2Request;
import kd.imc.rim.formplugin.message.MessageReceivePlugin;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;

@ApiController(value="imc", desc="\u6536\u7968\u7ba1\u7406")
@ApiMapping(value="message")
public class MessageReceiveV2Plugin
implements Serializable {
    private static final Log logger = LogFactory.getLog(MessageReceiveV2Plugin.class);
    private static final long serialVersionUID = 1L;

    @ApiPostMapping(value="/service", desc="\u6536\u7968\u7ba1\u7406\u4e1a\u52a1\u63a5\u53e3V2.0")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u53c2\u6570") Object> service(@ApiRequestBody(value="\u5165\u53c2") MessageApiV2Request request) {
        long start = System.currentTimeMillis();
        try {
            logger.info("\u6536\u7968\u7ba1\u7406\u4e1a\u52a1\u63a5\u53e3V2.0\u8bf7\u6c42:{},{}", (Object)request.getMessageType(), (Object)request.getMessageId());
            AbstractMessageServie service = AbstractMessageServie.newInstance(request.getMessageType());
            if (service != null) {
                ApiResult busiResult = service.doBusiness(request.getData());
                CustomApiResult<Object> result = this.createResult(busiResult.getErrorCode(), busiResult.getMessage(), busiResult.getData());
                logger.info("\u6536\u7968\u7ba1\u7406\u4e1a\u52a1\u63a5\u53e3V2.0:{}-{},\u8017\u65f6{}", new Object[]{request.getMessageType(), request.getMessageId(), System.currentTimeMillis() - start});
                return result;
            }
            return this.createResult(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"msgType\u53c2\u6570\u9519\u8bef", (String)"MessageReceivePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), null);
        }
        catch (MsgException e) {
            return this.createResult(e.getErrorCode(), e.getMessage(), e.getData());
        }
        catch (KDException e) {
            ErrorCode error = e.getErrorCode();
            if (error != null) {
                return this.createResult(error.getCode(), error.getMessage(), null);
            }
            return this.createResult(ErrorType.FAIL.getCode(), null, null);
        }
        catch (Exception e) {
            logger.error("\u6536\u7968\u7ba1\u7406\u4e1a\u52a1\u63a5\u53e3V2.0\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            return this.createResult(ErrorType.FAIL.getCode(), null, null);
        }
    }

    private CustomApiResult<Object> createResult(String errorCode, String msg, Object data) {
        CustomApiResult result = new CustomApiResult();
        result.setStatus("0000".equals(errorCode));
        result.setErrorCode(errorCode);
        result.setMessage(msg);
        result.setData(data);
        this.setMsg((CustomApiResult<Object>)result);
        return result;
    }

    private void setMsg(CustomApiResult<Object> result) {
        if (StringUtils.isEmpty((CharSequence)result.getMessage())) {
            if ("0000".equals(result.getErrorCode())) {
                result.setMessage(MessageReceivePlugin.getSuccessMsg());
            } else {
                result.setMessage(MessageReceivePlugin.getErrorMsg());
            }
        }
    }
}

