/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.fpdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.helper.ApiLogHelper;
import kd.imc.rim.common.message.BusinessSystemService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;

public class DeductReceivePlugin
implements IBillWebApiPlugin {
    private static Log LOGGER = LogFactory.getLog(DeductReceivePlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        if (ObjectUtils.isEmpty(params)) {
            return ApiResult.fail((String)ErrorType.PARAM_NULL.getName(), (String)ErrorType.PARAM_NULL.getCode());
        }
        LOGGER.info("rim-deductApi\u539f\u59cb\u4f20\u5165\u53c2\u6570{}", (Object)JSON.toJSONString(params));
        RequestVo requestVo = (RequestVo)JSON.parseObject((String)JSON.toJSONString(params), RequestVo.class);
        ApiResult apiResult = RimApiHelper.apiCommonCheckValid(requestVo);
        String interfaceCode = requestVo.getInterfaceCode();
        long startTime = System.currentTimeMillis();
        if (!apiResult.getSuccess()) {
            ApiLogHelper.asyncSaveLog((String)interfaceCode, (String)"/app/rim/deduction", (String)JSON.toJSONString((Object)requestVo), (String)JSON.toJSONString((Object)apiResult), (long)startTime);
            return apiResult;
        }
        DynamicObject businessSys = null;
        ApiResult result = new ApiResult();
        AbstractFpdkService service = AbstractFpdkService.newInstance(interfaceCode);
        boolean isSaveLog = false;
        if (service != null) {
            try {
                isSaveLog = true;
                businessSys = BusinessSystemService.getBusinessSystemByCode((String)requestVo.getBusinessSystemCode());
                RimApiHelper.decryptData(requestVo, businessSys);
                LOGGER.info("rim-deductApi\u4f20\u5165\u53c2\u6570(\u89e3\u5bc6\u540e):{}", (Object)JSON.toJSONString((Object)requestVo));
                JSONObject param = JSON.parseObject((String)requestVo.getData());
                result = service.doBusiness(param);
                ApiLogHelper.asyncSaveLog((String)interfaceCode, (String)"/app/rim/deduction", (String)JSON.toJSONString((Object)requestVo), (String)JSON.toJSONString((Object)result), (long)startTime);
                if (null != result.getData() && StringUtils.isNotBlank((CharSequence)result.getData().toString())) {
                    String dataStr = JSON.toJSONString((Object)result.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                    result.setData((Object)BusinessSystemService.getDecryptData((DynamicObject)businessSys, (int)0, (String)dataStr));
                }
            }
            catch (MsgException e) {
                LOGGER.info("interfaceCode:{}-{},", new Object[]{interfaceCode, requestVo.getRequestId(), e});
                result.setErrorCode(e.getErrorCode());
                result.setMessage(e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error(interfaceCode + "-error", (Throwable)e);
                result.setErrorCode(ErrorType.FAIL.getCode());
                result.setData((Object)e);
            }
        } else {
            result.setErrorCode(ErrorType.PARAM_ERROR.getCode());
            result.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u8bf7\u6c42\u63a5\u53e3[%s]", (String)"DeductReceivePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), requestVo.getInterfaceCode()));
        }
        result.setSuccess("0000".equals(result.getErrorCode()));
        if (!isSaveLog) {
            ApiLogHelper.asyncSaveLog((String)interfaceCode, (String)"/app/rim/deduction", (String)JSON.toJSONString((Object)requestVo), (String)JSON.toJSONString((Object)result), (long)startTime);
        }
        return result;
    }
}

