/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;

public class ChangeOrgService
extends AbstractMessageServie {
    private static Log logger = LogFactory.getLog(ChangeOrgService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        JSONObject data = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reqObject));
        logger.info("\u4fee\u6539\u7ec4\u7ec7\u63a5\u53e3\u53c2\u6570{}", (Object)data.toJSONString());
        String orgNumber = data.getString("orgNumber");
        String taxOrgNumber = data.getString("taxOrgNumber");
        JSONArray serialNos = data.getJSONArray("serialNos");
        if (serialNos == null || serialNos.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChangeOrgService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"2001");
        }
        Map<String, Long> orgInfo = this.getOrg(orgNumber, taxOrgNumber);
        if (orgInfo.isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ChangeOrgService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"2002");
        }
        Long orgId = 0L;
        Long taxOrgId = 0L;
        if (StringUtils.isNotEmpty((CharSequence)orgNumber) && (orgId = orgInfo.get(orgNumber)) == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ChangeOrgService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"2003");
        }
        if (StringUtils.isNotEmpty((CharSequence)taxOrgNumber) && (taxOrgId = orgInfo.get(taxOrgNumber)) == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ChangeOrgService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"2004");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter serialFilter = new QFilter("serial_no", "in", (Object)serialNos);
                DynamicObject[] list = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id,org,serial_no,tax_org,modifytime,invoice_type", (QFilter[])serialFilter.toArray());
                HashMap<String, ArrayList<String>> typeSerialMap = new HashMap<String, ArrayList<String>>(8);
                for (DynamicObject obj : list) {
                    if (orgId > 0L) {
                        obj.set("org", (Object)orgId);
                    }
                    if (taxOrgId > 0L) {
                        obj.set("tax_org", (Object)orgId);
                    }
                    obj.set("modifytime", (Object)new Date());
                    Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)obj.get("invoice_type"));
                    String entity = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
                    ArrayList<String> sublist = (ArrayList<String>)typeSerialMap.get(entity);
                    if (sublist == null) {
                        sublist = new ArrayList<String>(8);
                    }
                    sublist.add(obj.getString("serial_no"));
                    typeSerialMap.put(entity, sublist);
                }
                SaveServiceHelper.update((DynamicObject[])list);
                for (Map.Entry entry : typeSerialMap.entrySet()) {
                    DynamicObject[] entityList;
                    QFilter filter = new QFilter("serial_no", "in", entry.getValue());
                    for (DynamicObject obj : entityList = BusinessDataServiceHelper.load((String)((String)entry.getKey()), (String)"id,org,tax_org,modifytime", (QFilter[])filter.toArray())) {
                        if (orgId > 0L) {
                            obj.set("org", (Object)orgId);
                        }
                        if (taxOrgId > 0L) {
                            obj.set("tax_org", (Object)orgId);
                        }
                        obj.set("modifytime", (Object)new Date());
                    }
                    SaveServiceHelper.save((DynamicObject[])entityList);
                }
            }
            catch (Throwable e) {
                logger.error("\u4fee\u6539\u7ec4\u7ec7\u51fa\u9519", e);
                h.markRollback();
                throw e;
            }
        }
        ApiResult result = ApiResult.success(null);
        result.setErrorCode("0000");
        return result;
    }

    private Map<String, Long> getOrg(String orgNumber, String taxOrgNumber) {
        HashMap<String, Long> list = new HashMap<String, Long>(2);
        ArrayList<String> orgList = new ArrayList<String>(2);
        if (StringUtils.isNotEmpty((CharSequence)orgNumber)) {
            orgList.add(orgNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)taxOrgNumber)) {
            orgList.add(taxOrgNumber);
        }
        if (orgList.isEmpty()) {
            return list;
        }
        QFilter filter = new QFilter("number", "in", orgList);
        DynamicObjectCollection orgInfo = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject obj : orgInfo) {
            list.put(obj.getString("number"), obj.getLong("id"));
        }
        return list;
    }
}

