/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectPluginService;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.query.InvoiceQueryService;
import kd.imc.rim.common.invoice.query.convert.InvoiceConvertService;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.invoice.verify.VerifyService;
import kd.imc.rim.common.invoice.verify.VerifyStatisticsService;
import kd.imc.rim.common.invoice.verify.VerifyUtil;
import kd.imc.rim.common.message.constant.ErrorType;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import kd.imc.rim.formplugin.message.service.RimApiHelper;

public class InvoiceEditOpenService
extends AbstractMessageServie {
    private static Log logger = LogFactory.getLog(InvoiceEditOpenService.class);
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    @Override
    public ApiResult doBusiness(Object reqObject) {
        Long type;
        DynamicObject invoiceDynamicObject;
        long start = System.currentTimeMillis();
        JSONObject data = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reqObject));
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u53d1\u7968\u7f16\u8f91\uff0c\u4f20\u8fc7\u6765\u7684\u53d1\u7968\u6570\u636e\uff1a" + data);
        if (data == null) {
            return ApiResult.fail((String)ErrorType.EMPTY_PARAM.getName(), (String)ErrorType.EMPTY_PARAM.getCode());
        }
        ApiResult checkResult = InvoiceCheckUtils.checkMust((JSONObject)data, (boolean)true);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = InvoiceCheckUtils.checkFieldFormat((JSONObject)data);
        if (checkResult != null) {
            return checkResult;
        }
        InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)data.getString("invoiceType"));
        if (invoiceSaveService == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u7c7b\u578b\u6709\u8bef", (String)"InvoiceEditOpenService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"9999");
        }
        JSONObject needEditInvoice = this.getInvoiceInfoOfDB(data);
        String oldSerialNo = data.getString("serialNo");
        if (needEditInvoice == null && (invoiceDynamicObject = invoiceSaveService.getInvoiceDynamicObject(data)) != null) {
            data.put("serialNo", (Object)invoiceDynamicObject.getString("serial_no"));
            needEditInvoice = this.getInvoiceInfoOfDB(data);
        }
        if (needEditInvoice != null && !StringUtils.equals((CharSequence)needEditInvoice.getString("invoiceType"), (CharSequence)data.getString("invoiceType")) && InputInvoiceTypeEnum.needCheck((Long)(type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)needEditInvoice.getString("invoiceType")))).booleanValue() && "1".equals(needEditInvoice.getString("checkStatus"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u65e0\u6cd5\u4fee\u6539", (String)"InvoiceEditOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"9999");
        }
        if (needEditInvoice != null) {
            needEditInvoice.put("checkStatus", (Object)data.getString("checkStatus"));
            needEditInvoice.put("invoiceType", (Object)data.getString("invoiceType"));
        }
        if (!"1".equals(data.getString("forceEdit")) && needEditInvoice != null && !InvoiceCollectPluginService.canEdit((JSONObject)needEditInvoice).booleanValue()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u65e0\u6cd5\u4fee\u6539", (String)"InvoiceEditOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"9999");
        }
        String collectType = CollectTypeEnum.MSG_SERVICE.getCode();
        String resource = "\u7b2c\u4e09\u65b9";
        if (needEditInvoice != null) {
            if (StringUtils.isNotBlank((CharSequence)needEditInvoice.getString("collect_type"))) {
                collectType = needEditInvoice.getString("collect_type");
            }
            if (StringUtils.isNotBlank((CharSequence)needEditInvoice.getString("resource"))) {
                resource = needEditInvoice.getString("resource");
            }
        }
        data.put("collect_type", (Object)collectType);
        data.put("resource", (Object)resource);
        Long orgId = RimApiHelper.getOrgId(data.get((Object)"orgId"), data.getString("orgNumber"), data.getString("taxNo"));
        data.put("org_id", (Object)orgId);
        JSONObject saveResult = this.invoiceCollectService.checkAndSaveInvoice(data, false);
        long end = System.currentTimeMillis();
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u53d1\u7968\u7f16\u8f91\uff0c\u4fee\u6539\u6570\u636e\u6240\u8017\u8d39\u7684\u65f6\u95f4\uff1a" + (end - start) + "ms\uff0c\u4fee\u6539\u5b8c\u6210\u540e\u83b7\u5f97\u7684\u6570\u636e\uff1a" + saveResult);
        if (!saveResult.getBoolean("saveFlag").booleanValue()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25", (String)"InvoiceEditOpenService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)"9999");
        }
        ApiResult result = this.successResult();
        JSONObject invoiceResult = this.getInvoice(saveResult, data);
        result.setData((Object)invoiceResult);
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u53d1\u7968\u7f16\u8f91\uff0c\u8fd4\u56de\u7ed9\u8c03\u7528\u65b9\u7684\u6570\u636e\uff1a" + invoiceResult);
        return result;
    }

    private JSONObject getInvoice(JSONObject saveResult, JSONObject param) {
        JSONObject invoiceResult = saveResult.getJSONObject("data");
        if (!"1".equals(param.getString("verifyFlag"))) {
            JSONArray verifyInvoice;
            if (saveResult.getBoolean("checkStatus").booleanValue() && (verifyInvoice = this.verify(invoiceResult)) != null && !verifyInvoice.isEmpty()) {
                invoiceResult = verifyInvoice.getJSONObject(0);
            }
        } else {
            Long orgId = param.getLong("org_id");
            JSONObject verifyParam = new JSONObject();
            VerifyService.convertBuyerInfo((JSONObject)param, (JSONObject)verifyParam);
            VerifyService.convertSalerInfo((JSONObject)param, (JSONObject)verifyParam);
            verifyParam.put("orgId", (Object)orgId);
            verifyParam.put("billType", (Object)param.getString("billType"));
            verifyParam.put("billId", (Object)param.getString("billId"));
            ArrayList mainIdList = Lists.newArrayListWithExpectedSize((int)1);
            ArrayList uncheckIdList = Lists.newArrayListWithExpectedSize((int)1);
            Long mainId = invoiceResult.getLong("mainId");
            Long uncheckId = invoiceResult.getLong("unCheckId");
            if (uncheckId != null) {
                uncheckIdList.add(uncheckId);
            } else if (mainId != null) {
                mainIdList.add(mainId);
            }
            JSONArray verify = VerifyUtil.verifyByMainIds((Map)verifyParam, (List)mainIdList, (List)uncheckIdList, (boolean)true);
            for (int i = 0; i < verify.size(); ++i) {
                JSONObject invoiceInfo = verify.getJSONObject(i);
                String errorLevel = invoiceInfo.getString("errorLevel");
                String invoiceType = invoiceInfo.getString("invoiceType");
                String serialNo = invoiceInfo.getString("serialNo");
                VerifyUtil.updateDataStatus((String)errorLevel, (String)serialNo, (Long)InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType), (Boolean)Boolean.TRUE, (boolean)true);
            }
            if (!CollectionUtils.isEmpty((Collection)verify)) {
                VerifyStatisticsService.asyncSaveVerifyStatistics((JSONArray)verify, null, null);
                invoiceResult = verify.getJSONObject(0);
            }
        }
        JSONArray resultAddError = new JSONArray();
        resultAddError.add((Object)invoiceResult);
        this.addErrorCode(resultAddError, null);
        String invoiceType = InputInvoiceTypeEnum.getAwsType((Object)invoiceResult.getLong("invoiceType"));
        if (StringUtils.isNotEmpty((CharSequence)invoiceType)) {
            invoiceResult.put("invoiceType", (Object)invoiceType);
        }
        return invoiceResult;
    }

    private JSONObject getInvoiceInfoOfDB(JSONObject data) {
        String serialNo = data.getString("serialNo");
        if (StringUtils.isBlank((CharSequence)serialNo)) {
            return null;
        }
        Map mainDetailMap = VerifyUtil.queryInvoiceDynamicObjectBySerialNo((String)serialNo);
        if (mainDetailMap.isEmpty()) {
            return null;
        }
        DynamicObject mainObj = (DynamicObject)mainDetailMap.get("main");
        Long invoiceType = mainObj.getLong("invoice_type");
        InvoiceConvertService convertService = InvoiceConvertService.newInstance((Long)invoiceType, null);
        Map mainMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)mainObj);
        Map fileMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)((DynamicObject)mainDetailMap.get("file")));
        Map bodyMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)((DynamicObject)mainDetailMap.get("detail")));
        InvoiceConvertService.putAll((Map)mainMap, (Map)fileMap);
        InvoiceConvertService.putAll((Map)mainMap, (Map)bodyMap);
        JSONObject oldInvoiceInfo = convertService.convert(mainMap);
        this.setInvoiceFiled(oldInvoiceInfo);
        return oldInvoiceInfo;
    }

    private void setInvoiceFiled(JSONObject invoiceJson) {
        String serialNo = invoiceJson.getString("serialNo");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serialNo)) {
            return;
        }
        InvoiceQueryService invoiceQueryService = new InvoiceQueryService();
        QFilter qFilter = new QFilter("serial_no", "=", (Object)serialNo);
        DynamicObjectCollection collection = invoiceQueryService.findByFilter("collect_type", qFilter);
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            invoiceJson.put("collect_type", (Object)((DynamicObject)collection.get(0)).getString("collect_type"));
        }
    }

    private JSONArray verify(JSONObject invoice) {
        long start = System.currentTimeMillis();
        JSONArray result = new JSONArray();
        ArrayList mainIdList = Lists.newArrayListWithExpectedSize((int)1);
        ArrayList uncheckIdList = Lists.newArrayListWithExpectedSize((int)1);
        HashMap fileMap = Maps.newHashMap();
        if (fileMap.isEmpty()) {
            fileMap.put("snapshotUrl", invoice.getString("snapshotUrl"));
            fileMap.put("imageUrl", invoice.getString("imageUrl"));
            fileMap.put("ofdUrl", invoice.getString("ofdUrl"));
            fileMap.put("pdfUrl", invoice.getString("pdfUrl"));
            fileMap.put("fileType", invoice.getString("fileType"));
        }
        mainIdList.add(invoice.getLong("mainId"));
        Map map = VerifyUtil.noVerify((List)mainIdList, (List)uncheckIdList, null);
        result.addAll((Collection)((JSONArray)map.get("data")));
        this.addErrorCode(result, fileMap);
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u5408\u89c4\u6027\u6821\u9a8c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private void addErrorCode(JSONArray result, Map<String, String> fileMap) {
        logger.info("openservice addErrorCode fileMap:{}", fileMap);
        List serialNos = result.toJavaList(JSONObject.class).stream().map(v -> v.getString("serialNo")).collect(Collectors.toList());
        QFilter qf = new QFilter("serial_no", "in", serialNos);
        QFilter deleteFilter = new QFilter("delete", "!=", (Object)"3");
        DynamicObject[] checkResultArr = BusinessDataServiceHelper.load((String)"rim_invoice_uncheck", (String)"check_result,serial_no", (QFilter[])new QFilter[]{qf, deleteFilter});
        Map<Object, Object> serialNoMapChechResult = Maps.newHashMap();
        if (checkResultArr != null && checkResultArr.length > 0) {
            serialNoMapChechResult = Arrays.asList(checkResultArr).stream().collect(Collectors.toMap(v -> v.getString("serial_no"), v -> v.getString("check_result")));
        }
        for (int i = 0; i < result.size(); ++i) {
            JSONObject json = result.getJSONObject(i);
            String serialNo = json.getString("serialNo");
            String checkStatus = json.getString("checkStatus");
            json.put("errorCode", (Object)"0000");
            json.put("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"InvoiceEditOpenService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            if (StringUtils.isEmpty((CharSequence)serialNo)) {
                json.put("errorCode", (Object)"3006");
                json.put("description", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u5fc5\u8981\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u7f16\u8f91\u8865\u5168", (String)"InvoiceEditOpenService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                if (fileMap == null || fileMap.isEmpty()) continue;
                String fileType = fileMap.get("fileType");
                json.put("snapshotUrl", (Object)fileMap.get("snapshotUrl"));
                json.put("imageUrl", (Object)fileMap.get("imageUrl"));
                json.put("downloadUrl", (Object)fileMap.get("imageUrl"));
                json.put("fileType", (Object)fileType);
                if ("1".equals(fileType)) {
                    json.put("pdfUrl", (Object)fileMap.get("pdfUrl"));
                    json.put("downloadUrl", (Object)fileMap.get("pdfUrl"));
                    continue;
                }
                if (!"4".equals(fileType)) continue;
                json.put("ofdUrl", (Object)fileMap.get("ofdUrl"));
                json.put("downloadUrl", (Object)fileMap.get("ofdUrl"));
                continue;
            }
            String checkResult = (String)serialNoMapChechResult.get(serialNo);
            if (!StringUtils.isNotBlank((CharSequence)checkResult) || "1".equals(checkStatus)) continue;
            int rightIndex = checkResult.indexOf(93);
            int leftIndex = checkResult.indexOf(91);
            String errorCode = "";
            String description = "";
            errorCode = checkResult.substring(leftIndex + 1, rightIndex);
            description = checkResult.substring(rightIndex + 1);
            json.put("errorCode", (Object)errorCode);
            json.put("description", (Object)description);
        }
    }
}

