/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.domain.ExpenseInvoiceDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.VoucherService;
import kd.imc.rim.common.invoice.save.ExcelInvoiceSaveService;
import kd.imc.rim.common.message.error.OpenAPIErrorContant;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.InvoiceCheckUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.formplugin.message.service.RimApiHelper;

public class InvoiceImportService {
    private static Log logger = LogFactory.getLog(InvoiceImportService.class);
    private static final List<String> FOMATDATEFIELD = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"invoiceDate", "selectTime", "authenticateTime", "taxPeriod"}));
    private static final List<String> FOMATAMOUNTFIELD = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"airportConstructionFee", "fuelSurcharge", "insurancePremium"}));

    public ApiResult invoiceImport(Object reqObject) {
        int invoiceIndex;
        JSONArray fail = new JSONArray();
        JSONArray success = new JSONArray();
        int failCount = 0;
        int invoiceTotal = 0;
        JSONObject param = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reqObject));
        logger.info("param:{}", (Object)param);
        if (param == null) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0c\u4f20\u5165\u53c2\u6570param\u4e3a\u7a7a");
            return this.getErrorResult(ErrorType.PARAM_NULL);
        }
        JSONArray invoices = param.getJSONArray("invoice");
        if (invoices == null) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0c\u4f20\u5165\u53d1\u7968\u4e3a\u7a7a");
            return this.getErrorResult(ErrorType.PARAM_NULL);
        }
        int maxNum = RimConfigUtils.getPageSizeFromConfig((int)100, (String)"import_max_num");
        if (maxNum <= 0) {
            maxNum = 100;
        }
        if (invoices.size() > maxNum) {
            logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0c\u4f20\u5165\u53d1\u7968\u6570\u91cf\u8d85\u8fc7100\u8bf7\u5206\u6279\u5bfc\u5165");
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53d1\u7968\u6570\u91cf\u8d85\u8fc7%s\u4efd\uff0c\u8bf7\u5206\u6279\u5bfc\u5165", (String)"InvoiceImportService_127", (String)"imc-rim-formplugin", (Object[])new Object[0]), maxNum), (String)"2002");
        }
        ArrayList noNeedCheckInvoiceToDB = Lists.newArrayListWithExpectedSize((int)invoices.size());
        invoiceTotal = invoices.size();
        for (int i = 0; i < invoiceTotal; ++i) {
            JSONObject invoice = invoices.getJSONObject(i);
            invoiceIndex = invoice.getIntValue("invoiceIndex");
            try {
                JSONObject convertInvoice = this.verifyInvoice(invoice);
                if (StringUtils.isNotBlank((CharSequence)convertInvoice.getString("msg"))) {
                    logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0cinvoice\uff1a{}\uff0cmsg:{}", (Object)JSONObject.toJSONString((Object)invoice), (Object)convertInvoice.getString("msg"));
                    fail.add((Object)this.getFailInfo(invoiceIndex, convertInvoice.getString("msg"), "1"));
                    ++failCount;
                    continue;
                }
                String msg = this.checkStandardRule(convertInvoice);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0cconvertInvoice\uff1a{}\uff0cmsg:{}", (Object)JSONObject.toJSONString((Object)convertInvoice), (Object)msg);
                    fail.add((Object)this.getFailInfo(invoiceIndex, msg, "1"));
                    ++failCount;
                    continue;
                }
                Long invoiceType = convertInvoice.getLong("invoice_type");
                convertInvoice.put("invoiceType", (Object)invoiceType);
                String warmTips = this.checkDetailRule(convertInvoice);
                if (StringUtils.isNotBlank((CharSequence)warmTips)) {
                    fail.add((Object)this.getFailInfo(invoiceIndex, warmTips, "1"));
                    ++failCount;
                    continue;
                }
                String taxNo = (String)CommonUtils.getJsonValue((Map)invoice, String.class, (String[])new String[]{"taxNo", "buyerTaxNo"});
                Long orgId = RimApiHelper.getOrgId(invoice.get((Object)"orgId"), invoice.getString("orgNumber"), taxNo);
                convertInvoice.put("org_id", (Object)orgId);
                noNeedCheckInvoiceToDB.add(convertInvoice);
                continue;
            }
            catch (Exception e) {
                logger.error("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0c\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                fail.add((Object)this.getFailInfo(invoiceIndex, String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a%1$s", (String)"InvoiceImportService_85", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()), "1"));
                ++failCount;
            }
        }
        for (JSONObject invoice : noNeedCheckInvoiceToDB) {
            invoiceIndex = invoice.getIntValue("invoiceIndex");
            try {
                logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8f6c\u6362\u4e4b\u540e\u7684\u53d1\u7968\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)invoice));
                ExcelInvoiceSaveService ex = new ExcelInvoiceSaveService(invoice.getLong("invoice_type"));
                this.initRequestData(invoice);
                JSONObject saveInvoice = ex.save(invoice);
                String serialNo = saveInvoice.getString("serialNo");
                invoice.put("serial_no", (Object)serialNo);
                this.saveExpense(invoice);
                this.saveVoucher(invoice);
                success.add((Object)this.getSuccessInfo(invoiceIndex, serialNo));
            }
            catch (Exception e) {
                logger.error("\u3010\u53d1\u7968\u4e91API\u3011\u5bfc\u5165\u5168\u7968\u6c60\u5931\u8d25\uff0c\u5165\u5e93\u5931\u8d25\uff1a", (Throwable)e);
                fail.add((Object)this.getFailInfo(invoiceIndex, String.format(ResManager.loadKDString((String)"\u5165\u5e93\u5931\u8d25\uff1a%1$s", (String)"InvoiceImportService_86", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()), "2"));
                ++failCount;
            }
        }
        ApiResult apiResult = this.successResult();
        JSONObject resultData = new JSONObject();
        resultData.put("fail", (Object)fail);
        resultData.put("success", (Object)success);
        resultData.put("failCount", (Object)failCount);
        resultData.put("invoiceCount", (Object)invoiceTotal);
        apiResult.setData((Object)resultData);
        return apiResult;
    }

    private void initRequestData(JSONObject invoice) {
        invoice.put("resoureseAPI", (Object)"1");
        if (StringUtils.isEmpty((CharSequence)invoice.getString("check_status"))) {
            invoice.put("check_status", (Object)"4");
        }
    }

    private JSONObject verifyInvoice(JSONObject invoice) {
        JSONObject result = new JSONObject();
        ApiResult checkResult = InvoiceCheckUtils.checkMust((JSONObject)invoice, (boolean)false);
        if (checkResult != null) {
            result.put("msg", (Object)checkResult.getMessage());
            return result;
        }
        checkResult = InvoiceCheckUtils.checkFieldFormat((JSONObject)invoice);
        if (checkResult != null) {
            result.put("msg", (Object)checkResult.getMessage());
            return result;
        }
        for (Map.Entry entry : invoice.entrySet()) {
            String checkValueResult = this.checkField((String)entry.getKey(), entry.getValue(), invoice);
            if (checkValueResult == null) continue;
            result.clear();
            result.put("msg", (Object)checkValueResult);
            return result;
        }
        this.formatFiled(invoice);
        JSONArray expenseArr = invoice.getJSONArray("expenseInfo");
        if (expenseArr != null) {
            JSONArray vouchInfos;
            StringBuilder allBillNo = new StringBuilder();
            String statusMax = "";
            for (int i = 0; i < expenseArr.size(); ++i) {
                JSONObject expense = expenseArr.getJSONObject(i);
                String status = expense.getString("status");
                String billNo = expense.getString("billNo");
                if (StringUtils.isNotBlank((CharSequence)status) && ("30".equals(status) || "60".equals(status)) && StringUtils.isBlank((CharSequence)billNo)) {
                    result.put("msg", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u4e1a\u52a1\u72b6\u6001\u4e3a'\u5ba1\u6838\u4e2d','\u5df2\u62a5\u9500'\u72b6\u6001\u65f6\u4e1a\u52a1\u5355\u636e\u53f7\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InvoiceImportService_88", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return result;
                }
                if (StringUtils.isNotBlank((CharSequence)billNo) && StringUtils.isBlank((CharSequence)status)) {
                    result.put("msg", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u53f7\u7801\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u62a5\u9500\u72b6\u6001\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InvoiceImportService_89", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    return result;
                }
                if (StringUtils.isNotBlank((CharSequence)status) && (StringUtils.isBlank((CharSequence)statusMax) || Integer.parseInt(status) > Integer.parseInt(statusMax))) {
                    statusMax = status;
                }
                if (!StringUtils.isNotBlank((CharSequence)billNo)) continue;
                if (allBillNo.length() > 0) {
                    allBillNo.append(',');
                }
                allBillNo.append(billNo);
            }
            if (StringUtils.isNotBlank((CharSequence)statusMax)) {
                invoice.put("expense_status", (Object)statusMax);
            } else {
                invoice.put("expense_status", (Object)"1");
            }
            if (allBillNo.length() > 0) {
                invoice.put("expense_num", (Object)allBillNo.toString());
            }
            if ((vouchInfos = invoice.getJSONArray("voucherInfo")) != null) {
                StringBuilder allVouchNo = new StringBuilder();
                String maxDate = "";
                for (int i = 0; i < vouchInfos.size(); ++i) {
                    JSONObject vouchNum = vouchInfos.getJSONObject(i);
                    String vouchNo = vouchNum.getString("vouchNo");
                    String accountDate = vouchNum.getString("accountDate");
                    if (StringUtils.isNotEmpty((CharSequence)statusMax) && "65".equals(statusMax) && (ObjectUtils.isEmpty((Object)accountDate) || ObjectUtils.isEmpty((Object)vouchNo))) {
                        result.put("msg", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u4e1a\u52a1\u72b6\u6001\u4e3a'\u5df2\u5165\u8d26'\u72b6\u6001\u65f6\u4f1a\u8ba1\u5c5e\u671f\u548c\u51ed\u8bc1\u53f7\u5747\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"InvoiceImportService_90", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        return result;
                    }
                    if (ObjectUtils.isEmpty((Object)accountDate) && !ObjectUtils.isEmpty((Object)vouchNo) || !ObjectUtils.isEmpty((Object)accountDate) && ObjectUtils.isEmpty((Object)vouchNo)) {
                        result.put("msg", (Object)ResManager.loadKDString((String)"\u4f1a\u8ba1\u5c5e\u671f\u548c\u51ed\u8bc1\u53f7\u8981\u4e48\u90fd\u586b,\u8981\u4e48\u90fd\u4e0d\u586b\u3002", (String)"InvoiceImportService_91", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        return result;
                    }
                    if (allVouchNo.length() > 0) {
                        allVouchNo.append(',');
                    }
                    allVouchNo.append(vouchNo);
                    if (!StringUtils.isBlank((CharSequence)maxDate)) continue;
                    maxDate = accountDate;
                }
                if (StringUtils.isNotBlank((CharSequence)maxDate)) {
                    invoice.put("account_date", (Object)maxDate);
                }
                if (StringUtils.isNotBlank((CharSequence)allVouchNo.toString())) {
                    invoice.put("vouch_no", (Object)allVouchNo.toString());
                }
            }
        }
        return InvoiceCheckUtils.conver((JSONObject)invoice);
    }

    public ApiResult successResult() {
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setErrorCode(ErrorType.SUCCESS.getCode());
        result.setMessage(ErrorType.SUCCESS.getName());
        return result;
    }

    private ApiResult getErrorResult(ErrorType error) {
        ApiResult result = ApiResult.fail((String)error.getName(), (String)error.getCode());
        return result;
    }

    private JSONObject getFailInfo(int index, String msg, String level) {
        JSONObject result = new JSONObject();
        result.put("invoiceIndex", (Object)index);
        result.put("msg", (Object)msg);
        result.put("level", (Object)level);
        return result;
    }

    private JSONObject getSuccessInfo(int index, String serialNo) {
        JSONObject result = new JSONObject();
        result.put("invoiceIndex", (Object)index);
        result.put("serialNo", (Object)serialNo);
        return result;
    }

    private ApiResult getErrorResult(OpenAPIErrorContant error) {
        ApiResult result = ApiResult.fail((String)error.getName(), (String)error.getCode());
        return result;
    }

    private String checkField(String fieldName, Object value, JSONObject invoiceJson) {
        try {
            String tag;
            if (StringUtils.equals((CharSequence)"checkCode", (CharSequence)fieldName)) {
                String checkCode = StringUtils.trimToEmpty((Object)value);
                if (value != null && checkCode.length() > 6) {
                    value = checkCode.substring(checkCode.length() - 6);
                }
            } else if (StringUtils.equals((CharSequence)"expenseStatus", (CharSequence)fieldName)) {
                String expendStatus = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.EXPENSE_STATUS_CHECK.contains(expendStatus)) {
                    return ResManager.loadKDString((String)"\u62a5\u9500\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_92", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"authenticateFlag", (CharSequence)fieldName)) {
                String authenticateFlag = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ZERO_FOUR_CHECK.contains(authenticateFlag)) {
                    return ResManager.loadKDString((String)"\u52fe\u9009\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_93", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"invoiceStatus", (CharSequence)fieldName)) {
                String invoiceStatus = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.INVOICE_STATS_CHECK.contains(invoiceStatus)) {
                    return ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_94", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"deductionPurpose", (CharSequence)fieldName)) {
                String deductionPurpose = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ONE_TWO_CHECK.contains(deductionPurpose)) {
                    return ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_95", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"notDeductibleType", (CharSequence)fieldName)) {
                String notDeductibleType = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ONE_FIVE_CHECK.contains(notDeductibleType)) {
                    return ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u539f\u56e0\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_96", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"deductionFlag", (CharSequence)fieldName)) {
                String deductionFlag = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ZERO_ONE_CHECK.contains(deductionFlag)) {
                    return ResManager.loadKDString((String)"\u662f\u5426\u53ef\u62b5\u6263\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_97", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"transportDeduction", (CharSequence)fieldName)) {
                String transportDeduction = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ZERO_TWO_CHECK.contains(transportDeduction)) {
                    return ResManager.loadKDString((String)"\u65c5\u5ba2\u8fd0\u8f93\u62b5\u6263\u72b6\u6001\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_98", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"originalState", (CharSequence)fieldName)) {
                String originalState = StringUtils.trimToEmpty((Object)value);
                if (!InvoiceCheckUtils.ZERO_ONE_CHECK.contains(originalState)) {
                    return ResManager.loadKDString((String)"\u662f\u5426\u7b7e\u6536\u672a\u6309\u6307\u5b9a\u683c\u5f0f\u586b\u5165", (String)"InvoiceImportService_99", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
            } else if (StringUtils.equals((CharSequence)"tag", (CharSequence)fieldName) && (tag = StringUtils.trimToEmpty((Object)value)) != null && tag.length() > 50) {
                return ResManager.loadKDString((String)"\u53d1\u7968\u6807\u6ce8\u5b57\u6bb5\u957f\u5ea6\u8d85\u8fc750", (String)"InvoiceImportService_100", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("\u53c2\u6570\u540d\u4e3a\uff1a" + fieldName + "\u7684\u5b57\u6bb5\u51fa\u9519{}", (Throwable)e);
            return String.format(ResManager.loadKDString((String)"\u89e3\u6790\u5b57\u6bb5%1$s\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u8be5\u5b57\u6bb5\u683c\u5f0f\u662f\u5426\u6b63\u786e", (String)"InvoiceImportService_87", (String)"imc-rim-formplugin", (Object[])new Object[0]), fieldName);
        }
        return null;
    }

    private void formatFiled(JSONObject invoice) {
        Object orgId;
        for (String field : FOMATDATEFIELD) {
            String date;
            if (!invoice.containsKey((Object)field) || !StringUtils.isNotBlank((CharSequence)(date = invoice.getString(field))) || Objects.isNull(date = date.replaceAll("-", ""))) continue;
            invoice.put(field, (Object)date);
        }
        if (invoice.getString("orgNumber") != null && !Objects.isNull(orgId = this.getOrgId(invoice.getString("orgNumber")))) {
            invoice.put("org", orgId);
        }
        if (invoice.getString("taxOrgNumber") != null && !Objects.isNull(orgId = this.getOrgId(invoice.getString("taxOrgNumber")))) {
            invoice.put("tax_org", orgId);
        }
        for (String field : FOMATAMOUNTFIELD) {
            Object amount;
            if (!invoice.containsKey((Object)field) || (amount = invoice.get((Object)field)) != null) continue;
            amount = BigDecimal.ZERO;
            invoice.put(field, amount);
        }
    }

    private String checkStandardRule(JSONObject invoice) {
        String invoiceStatus = invoice.getString("invoice_status");
        String deductionFlag = invoice.getString("deduction_flag");
        String deductionPurpose = invoice.getString("deduction_purpose");
        String authenticateFlag = invoice.getString("authenticate_flag");
        Object selectTime = invoice.get((Object)"select_time");
        Object authenticateTime = invoice.get((Object)"authenticate_time");
        Object taxPeriod = invoice.get((Object)"tax_period");
        String notDeductibleType = invoice.getString("not_deductible_type");
        if (!("0".equals(invoiceStatus) || !InputInvoiceTypeEnum.canDeduction((Long)invoice.getLong("invoiceType")).booleanValue() || StringUtils.isEmpty((CharSequence)deductionFlag) && StringUtils.isEmpty((CharSequence)deductionPurpose) && StringUtils.isEmpty((CharSequence)authenticateFlag) && ObjectUtils.isEmpty((Object)selectTime) && ObjectUtils.isEmpty((Object)authenticateTime) && ObjectUtils.isEmpty((Object)taxPeriod))) {
            return ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u4e3a\u975e'\u6b63\u5e38'\u72b6\u6001\u65f6\uff0c\u3010\u662f\u5426\u53ef\u62b5\u6263\u3011\uff0c\u3010\u62b5\u6263\u7528\u9014\u3011\uff0c\u3010\u4e0d\u62b5\u6263\u539f\u56e0\u3011\uff0c\u3010\u52fe\u9009\u72b6\u6001\u3011\uff0c\u3010\u52fe\u9009\u65f6\u95f4\u3011\uff0c\u3010\u8ba4\u8bc1\u65f6\u95f4\u3011\uff0c\u3010\u62b5\u6263\u7a0e\u671f\u3011\u5b57\u6bb5\u4e0d\u5141\u8bb8\u586b\u5165\u4efb\u4f55\u503c", (String)"InvoiceImportService_101", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)deductionPurpose) && "0".equals(deductionFlag)) {
            return ResManager.loadKDString((String)"\u62b5\u6263\u72b6\u6001\u4e3a'\u4e0d\u53ef\u62b5\u6263'\u72b6\u6001'\u65f6,\u6ca1\u6709\u62b5\u6263\u7528\u9014", (String)"InvoiceImportService_102", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)deductionPurpose) && (StringUtils.isEmpty((CharSequence)authenticateFlag) || "0".equals(authenticateFlag) || ResManager.loadKDString((String)"\u672a\u52fe\u9009", (String)"InvoiceImportService_103", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(authenticateFlag))) {
            return ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u52fe\u9009\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a\u2018\u672a\u52fe\u9009\u2019\u72b6\u6001", (String)"InvoiceImportService_104", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if (("1".equals(deductionPurpose) || ResManager.loadKDString((String)"\u62b5\u6263", (String)"InvoiceImportService_105", (String)"imc-rim-formplugin", (Object[])new Object[0]).equals(deductionPurpose)) && !StringUtils.isEmpty((CharSequence)notDeductibleType)) {
            return ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:\u62b5\u6263\u7528\u9014\u4e3a'\u62b5\u6263'\u65f6\uff0c\u4e0d\u62b5\u6263\u539f\u56e0\u5fc5\u987b\u4e3a\u7a7a", (String)"InvoiceImportService_106", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        JSONArray items = invoice.getJSONArray("items");
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject item = items.getJSONObject(i);
                BigDecimal taxRate = item.getBigDecimal("tax_rate");
                if (taxRate == null || BigDecimal.ONE.compareTo(taxRate) >= 0 && BigDecimal.ZERO.compareTo(taxRate) <= 0) continue;
                return ResManager.loadKDString((String)"\u7a0e\u7387\u683c\u5f0f\u6709\u8bef,\u7a0e\u7387\u7684\u503c\u53ea\u80fd\u57280%\u5230100%\u4e4b\u95f4", (String)"InvoiceImportService_107", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        }
        BigDecimal effectiveTaxAmount = invoice.getBigDecimal("effective_tax_amount");
        BigDecimal totalTaxAmount = invoice.getBigDecimal("total_tax_amount");
        if (!ObjectUtils.isEmpty((Object)effectiveTaxAmount) && !ObjectUtils.isEmpty((Object)totalTaxAmount) && totalTaxAmount.compareTo(effectiveTaxAmount) < 0) {
            return ResManager.loadKDString((String)"\u6709\u6548\u7a0e\u989d\u53ea\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u7a0e\u989d", (String)"InvoiceImportService_108", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        BigDecimal invoiceAmount = invoice.getBigDecimal("invoice_amount");
        BigDecimal totalAmount = invoice.getBigDecimal("total_amount");
        String invoiceTypeStr = invoice.getString("invoice_type");
        Long invoiceType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceTypeStr);
        if (InputInvoiceTypeEnum.AIR_ELE_INVOICE.getCode().equals(invoiceType)) {
            invoiceAmount = BigDecimalUtil.transDecimal((Object)invoiceAmount);
            totalAmount = BigDecimalUtil.transDecimal((Object)totalAmount);
            totalTaxAmount = BigDecimalUtil.transDecimal((Object)totalTaxAmount);
            BigDecimal fuel_surcharge = BigDecimalUtil.transDecimal((Object)invoice.get((Object)"fuel_surcharge"));
            BigDecimal other_total_tax_amount = BigDecimalUtil.transDecimal((Object)invoice.get((Object)"other_total_tax_amount"));
            BigDecimal airport_construction_fee = BigDecimalUtil.transDecimal((Object)invoice.get((Object)"airport_construction_fee"));
            BigDecimal total = fuel_surcharge.add(other_total_tax_amount).add(airport_construction_fee).add(invoiceAmount).add(totalTaxAmount);
            if (totalAmount.compareTo(total) != 0) {
                return ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1 = \u7a0e\u989d + \u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceImportService_109", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        } else if (!(InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType) || ObjectUtils.isEmpty((Object)invoiceAmount) || ObjectUtils.isEmpty((Object)totalTaxAmount) || ObjectUtils.isEmpty((Object)totalAmount) || totalAmount.compareTo(invoiceAmount.add(totalTaxAmount)) == 0)) {
            return ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1 = \u7a0e\u989d + \u4e0d\u542b\u7a0e\u91d1\u989d", (String)"InvoiceImportService_109", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return DeductionUtils.checkDeductionFiled((JSONObject)invoice);
    }

    private Object getOrgId(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj != null) {
            return obj.get("id");
        }
        return null;
    }

    private String checkDetailRule(JSONObject invoice) {
        if (ObjectUtils.isEmpty((Object)invoice.get((Object)"total_amount"))) {
            return ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a", (String)"InvoiceImportService_114", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        try {
            BigDecimal maxAmount = CommonUtils.getImportItemBalance();
            JSONArray items = invoice.getJSONArray("items");
            for (int i = 0; items != null && i < items.size(); ++i) {
                BigDecimal offsetPrice;
                BigDecimal offsetDetailAmount;
                JSONObject item = items.getJSONObject(i);
                BigDecimal num = BigDecimal.ZERO;
                try {
                    num = item.getBigDecimal("num");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u6570\u91cf\u3011\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_115", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"num")});
                }
                BigDecimal unitPrice = BigDecimal.ZERO;
                try {
                    unitPrice = item.getBigDecimal("unit_price");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u5355\u4ef7\u3011\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_116", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"unit_price")});
                }
                BigDecimal detailAmount = BigDecimal.ZERO;
                try {
                    detailAmount = item.getBigDecimal("detail_amount");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u91d1\u989d\u3011\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_117", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"detail_amount")});
                }
                BigDecimal taxAmount = BigDecimal.ZERO;
                try {
                    taxAmount = item.getBigDecimal("tax_amount");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u7a0e\u989d\u3011\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_118", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"tax_amount")});
                }
                BigDecimal taxRate = BigDecimal.ZERO;
                try {
                    taxRate = item.getBigDecimal("tax_rate");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u7a0e\u7387\u3011\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_119", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"tax_rate")});
                }
                String goodsCode = "";
                try {
                    goodsCode = item.getString("goods_code");
                }
                catch (Exception e) {
                    return StringUtils.append((Object[])new Object[]{ResManager.loadKDString((String)"\u3010\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3011\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cvalue\uff1a", (String)"InvoiceImportService_120", (String)"imc-rim-formplugin", (Object[])new Object[0]), item.get((Object)"goods_code")});
                }
                if (num == null && unitPrice != null || num != null && unitPrice == null) {
                    return ResManager.loadKDString((String)"\u6570\u91cf\u548c\u5355\u4ef7\u9700\u540c\u65f6\u5fc5\u586b\u6216\u8005\u540c\u65f6\u4e0d\u586b", (String)"InvoiceImportService_121", (String)"imc-rim-formplugin", (Object[])new Object[0]);
                }
                if (num != null && unitPrice != null && maxAmount.compareTo((offsetDetailAmount = detailAmount.subtract(unitPrice.multiply(num).setScale(2, RoundingMode.HALF_UP))).abs()) < 0) {
                    return String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u6570\u91cf*\u5355\u4ef7\u548c\u91d1\u989d\u7684\u8bef\u5dee\u8d85\u8fc7%s", (String)"InvoiceImportService_122", (String)"imc-rim-formplugin", (Object[])new Object[0]), maxAmount.toPlainString());
                }
                if (num != null && unitPrice != null && taxAmount != null && taxRate != null && (offsetPrice = taxAmount.subtract(unitPrice.multiply(num).multiply(taxRate).setScale(2, 4))).abs().compareTo(maxAmount) > 0) {
                    return String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7684\u7a0e\u989d\u4e0e\u5b9e\u9645\u586b\u5165\u7684\u7a0e\u989d\u7684\u504f\u5dee\u503c\u8d85\u8fc7\u4e86%s", (String)"InvoiceImportService_123", (String)"imc-rim-formplugin", (Object[])new Object[0]), maxAmount.toPlainString());
                }
                if (!StringUtils.isNotBlank((CharSequence)goodsCode) || goodsCode.length() == 19) continue;
                return ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5e94\u8be5\u4e3a19\u4f4d\u957f\u5ea6", (String)"InvoiceImportService_124", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            String deductionFlagResult = this.checkDeductionFlag(invoice);
            if (StringUtils.isNotEmpty((CharSequence)deductionFlagResult)) {
                return deductionFlagResult;
            }
        }
        catch (Exception e) {
            logger.error("\u660e\u7ec6\u8f6c\u5316\u6709\u8bef\uff1a", (Throwable)e);
            return ResManager.loadKDString((String)"\u6570\u91cf\uff0c\u5355\u4ef7\uff0c\u91d1\u989d\uff0c\u7a0e\u7387\uff0c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6216\u7a0e\u989d\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"InvoiceImportService_125", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkDeductionFlag(JSONObject invoice) {
        Long invoiceType = invoice.getLong("invoiceType");
        if (InputInvoiceTypeEnum.canDeduction((Long)invoiceType).booleanValue()) {
            String userDeductionFlag = invoice.getString("deduction_flag");
            JSONObject invoiceParam = new JSONObject();
            invoiceParam.put("invoiceStatus", (Object)invoice.getString("invoice_status"));
            if (!ObjectUtils.isEmpty((Object)invoice.getDate("invoice_date"))) {
                invoiceParam.put("invoiceDate", (Object)DateUtils.format((Date)invoice.getDate("invoice_date"), (String)"yyyy-MM-dd"));
            }
            invoiceParam.put("totalTaxAmount", invoice.get((Object)"total_tax_amount"));
            invoiceParam.put("taxAmount", invoice.get((Object)"tax_amount"));
            invoiceParam.put("invoiceType", (Object)invoiceType);
            invoiceParam.put("buyerTaxNo", CommonUtils.getJsonValue((Map)invoice, String.class, (String[])new String[]{"buyerTaxNo", "buyer_tax_no", "purchaserUnifiedSocialCreditCode"}));
            String sysDeductionFlag = DeductionConstant.canBeDeductionForTaxInvoice((JSONObject)invoiceParam);
            if ("1".equals(userDeductionFlag) && "0".equals(sysDeductionFlag)) {
                invoice.put("deduction_purpose", (Object)"");
                invoice.put("not_deductible_type", (Object)"");
                invoice.put("authenticate_flag", (Object)"");
                invoice.put("select_time", null);
                invoice.put("authenticate_time", null);
                invoice.put("tax_period", (Object)"");
                return ResManager.loadKDString((String)"\u7cfb\u7edf\u5224\u65ad\u8be5\u53d1\u7968\u4e0d\u53ef\u62b5\u6263\uff0c\u4e0e\u586b\u5165\u7684\u503c\u4e0d\u7b26\uff0c\u4fdd\u5b58\u8be5\u53d1\u7968\u65f6\u5df2\u81ea\u52a8\u6e05\u9664\u6807\u7eff\u5b57\u6bb5\u7684\u5185\u5bb9", (String)"InvoiceImportService_126", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void saveExpense(JSONObject invoice) {
        JSONArray expenseArr = invoice.getJSONArray("expenseInfo");
        ArrayList dtoList = Lists.newArrayListWithExpectedSize((int)0);
        if (expenseArr != null) {
            dtoList = Lists.newArrayListWithExpectedSize((int)expenseArr.size());
            for (int i = 0; i < expenseArr.size(); ++i) {
                JSONObject expenseInfo = expenseArr.getJSONObject(i);
                ExpenseDTO dto = new ExpenseDTO();
                dto.setExpenseNum(expenseInfo.getString("billNo"));
                dto.setStatus(expenseInfo.getString("status"));
                if (StringUtils.isNotBlank((CharSequence)expenseInfo.getString("billId"))) {
                    dto.setExpenseId(expenseInfo.getString("billId"));
                } else {
                    dto.setExpenseId(expenseInfo.getString("billNo"));
                }
                String resource = expenseInfo.getString("resource");
                if (StringUtils.isEmpty((CharSequence)resource)) {
                    resource = "api";
                }
                dto.setResource(resource);
                if (StringUtils.isNotBlank((CharSequence)expenseInfo.getString("billType"))) {
                    dto.setExpenseType(expenseInfo.getString("billType"));
                }
                if (StringUtils.isNotBlank((CharSequence)expenseInfo.getString("orgNumber"))) {
                    dto.setOrgId((Long)this.getOrgId(expenseInfo.getString("orgNumber")));
                } else if (StringUtils.isNotBlank((CharSequence)invoice.getString("org_id"))) {
                    dto.setOrgId(invoice.getLong("org_id"));
                }
                ArrayList<ExpenseInvoiceDTO> list = new ArrayList<ExpenseInvoiceDTO>(1);
                ExpenseInvoiceDTO invoiceDto = new ExpenseInvoiceDTO();
                invoiceDto.setSerialNo(invoice.getString("serial_no"));
                list.add(invoiceDto);
                dto.setInvoiceList(list);
                dtoList.add(dto);
            }
        }
        ExpenseService service = new ExpenseService();
        service.saveInvoiceAndExpenseOfAPI((List)dtoList, invoice.getString("serial_no"));
    }

    private void saveVoucher(JSONObject invoice) {
        String serialNo = invoice.getString("serial_no");
        JSONArray voucherInfo = invoice.getJSONArray("voucherInfo");
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)0);
        if (voucherInfo != null) {
            paramList = Lists.newArrayListWithExpectedSize((int)voucherInfo.size());
            ArrayList list = Lists.newArrayList((Object[])new String[]{serialNo});
            for (int i = 0; i < voucherInfo.size(); ++i) {
                JSONObject vouch = voucherInfo.getJSONObject(i);
                String vouchNo = vouch.getString("vouchNo");
                String accountDate = vouch.getString("accountDate");
                if ((accountDate = accountDate.replaceAll("-", "")).length() == 6) {
                    accountDate = accountDate + "01";
                }
                String vouchId = StringUtils.isNotBlank((CharSequence)vouch.getString("vouchId")) ? vouch.getString("vouchId") : vouch.getString("vouchNo");
                String businessDate = StringUtils.isNotBlank((CharSequence)vouch.getString("businessDate")) ? vouch.getString("businessDate") : vouch.getString("accountDate");
                businessDate = businessDate.replaceAll("-", "");
                HashMap<String, String> vouchparam = new HashMap<String, String>(8);
                vouchparam.put("vouchNo", vouchNo);
                vouchparam.put("vouchId", vouchId);
                vouchparam.put("accountDate", accountDate.replaceAll("-", ""));
                vouchparam.put("businessDate", businessDate.replaceAll("-", ""));
                vouchparam.put("accountTime", vouch.getString("accountTime"));
                String resource = vouch.getString("resource");
                if (StringUtils.isEmpty((CharSequence)resource)) {
                    resource = "api";
                }
                vouchparam.put("resource", resource);
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("voucherInfo", vouchparam);
                param.put("serialNoArray", list);
                param.put("resoureseAPI", "1");
                paramList.add(param);
            }
        }
        VoucherService service = new VoucherService();
        service.deleteVoucherOfAPI(serialNo);
        for (Map param : paramList) {
            service.saveVoucher(param);
        }
    }
}

