/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;

public class InvoiceUpdateOpenService
extends AbstractMessageServie {
    private static Log LOGGER = LogFactory.getLog(InvoiceUpdateOpenService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        int count = BigDecimalUtil.transDecimal((Object)ImcConfigUtil.getValue((String)"rim_api", (String)"invoice_update")).intValue();
        ApiResult result = new ApiResult();
        if (count > 0) {
            String json = null;
            json = reqObject instanceof String ? reqObject.toString() : SerializationUtils.toJsonString((Object)reqObject);
            JSONArray array = JSONArray.parseArray((String)json);
            if (array.size() > count) {
                result.setMessage(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\uff1a\u6570\u636e\u8d85\u9650", (String)"InvoiceUpdateOpenService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return result;
            }
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>(array.size());
            LOGGER.info("\u6839\u636e\u6d41\u6c34\u53f7\u4fee\u6539\u6570\u636e");
            ArrayList<String> serialList = new ArrayList<String>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                JSONObject invoice = array.getJSONObject(i);
                String serialNo = invoice.getString("serial_no");
                if (StringUtils.isEmpty((CharSequence)serialNo) || invoice.size() <= 1) continue;
                map.put(serialNo, invoice);
                serialList.add(serialNo);
            }
            if (serialList.isEmpty()) {
                result.setMessage(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\uff1a\u53c2\u6570\u9519\u8bef", (String)"InvoiceUpdateOpenService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return result;
            }
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_type.id as invoice_type,serial_no", (QFilter[])new QFilter("serial_no", "in", serialList).toArray());
            List<Long> mainIdList = new ArrayList<Long>(invoiceCollection.size());
            HashMap<String, ArrayList<String>> typeMap = new HashMap<String, ArrayList<String>>(8);
            for (DynamicObject obj : invoiceCollection) {
                mainIdList.add(obj.getLong("id"));
                String entity = InputInvoiceTypeEnum.getEntity((Long)obj.getLong("invoice_type"));
                ArrayList<String> list = (ArrayList<String>)typeMap.get(entity);
                if (list == null) {
                    list = new ArrayList<String>(16);
                }
                list.add(obj.getString("serial_no"));
                typeMap.put(entity, list);
            }
            int count1 = this.extracted("rim_invoice", map, mainIdList);
            for (Map.Entry entry : typeMap.entrySet()) {
                mainIdList = this.getIdList((String)entry.getKey(), (List)entry.getValue());
                this.extracted((String)entry.getKey(), map, mainIdList);
            }
            result.setErrorCode("0000");
            result.setMessage(String.valueOf(count1));
        } else {
            result.setMessage(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\uff1a\u63a5\u53e3\u4e0d\u53ef\u7528", (String)"InvoiceUpdateOpenService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return result;
    }

    public List<Long> getIdList(String entity, List<String> serialList) {
        DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter("serial_no", "in", serialList).toArray());
        ArrayList<Long> mainIdList = new ArrayList<Long>(invoiceCollection.size());
        for (DynamicObject obj : invoiceCollection) {
            mainIdList.add(obj.getLong("id"));
        }
        return mainIdList;
    }

    private int extracted(String entity, Map<String, JSONObject> map, List<Long> mainIdList) {
        if (mainIdList == null || mainIdList.size() < 1) {
            return 0;
        }
        DynamicObject[] updateInvoice = BusinessDataServiceHelper.load((Object[])mainIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(updateInvoice.length);
        for (DynamicObject inv : updateInvoice) {
            String serialNo = inv.getString("serial_no");
            JSONObject val = map.get(serialNo);
            int setConut = 0;
            for (Map.Entry entry : val.entrySet()) {
                String fileId = (String)entry.getKey();
                if ("id".equals(fileId) || "serial_no".equals(fileId)) continue;
                try {
                    DynamicProperty property = inv.getDynamicObjectType().getProperty(fileId);
                    if (property instanceof DateTimeProp) {
                        inv.set(fileId, (Object)val.getDate(fileId));
                    } else if (property instanceof BasedataProp) {
                        inv.set(fileId, (Object)val.getLong(fileId));
                    } else if (property instanceof LongProp) {
                        inv.set(fileId, (Object)val.getLong(fileId));
                    } else if (property instanceof DecimalProp) {
                        inv.set(fileId, (Object)val.getBigDecimal(fileId));
                    } else {
                        inv.set(fileId, (Object)val.getString(fileId));
                    }
                }
                catch (Exception e) {
                    continue;
                }
                ++setConut;
            }
            if (setConut <= 0) continue;
            if ("rim_invoice".equals(entity)) {
                String awsType = InputInvoiceTypeEnum.getAwsType((Object)inv.get("invoice_type.id"));
                InvoiceSaveService.newInstance((String)awsType).setMainInvoiceInfo(inv);
            }
            updateList.add(inv);
        }
        if (updateList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        return updateList.size();
    }
}

