/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.service.RecognitionCheckAPIService;
import kd.imc.rim.common.utils.FileUploadUtils;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;

public class UploadFileService
extends AbstractMessageServie {
    private static Log logger = LogFactory.getLog(UploadFileService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        long start = System.currentTimeMillis();
        JSONObject data = JSONObject.parseObject((String)SerializationUtils.toJsonString((Object)reqObject));
        if (data == null) {
            throw new MsgException("0009", ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"UploadFileService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String base64 = data.getString("base64");
        if (StringUtils.isEmpty((CharSequence)base64)) {
            throw new MsgException("0010", ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a", (String)"UploadFileService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        RecognitionCheckAPIService.RecognitionCheckParam rcParam = (RecognitionCheckAPIService.RecognitionCheckParam)JSONObject.toJavaObject((JSON)data, RecognitionCheckAPIService.RecognitionCheckParam.class);
        String fileName = this.fileName(rcParam.getFileType());
        String fileUrl = this.upFile(rcParam, fileName);
        ApiResult result = this.successResult();
        JSONObject attachData = new JSONObject();
        attachData.put("fileDownUrl", (Object)fileUrl);
        result.setData((Object)attachData);
        logger.info("\u3010\u53d1\u7968\u4e91API\u3011\u8bc6\u522b\u67e5\u9a8c\uff0c\u8bc6\u522b\u67e5\u9a8c\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private String fileName(String fileType) {
        String fileName = String.valueOf(UUID.randomUUID());
        String filePix = "";
        if (StringUtils.equals((CharSequence)fileType, (CharSequence)"1")) {
            filePix = ".pdf";
        } else if (StringUtils.equals((CharSequence)fileType, (CharSequence)"2")) {
            filePix = ".png";
        } else if (StringUtils.equals((CharSequence)fileType, (CharSequence)"4")) {
            filePix = ".ofd";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"pdf")) {
            filePix = ".pdf";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fileType, (CharSequence)"ofd")) {
            filePix = ".ofd";
        } else if (FileUtils.isImage((String)fileType)) {
            filePix = ".jpg";
        }
        if (StringUtils.isEmpty((CharSequence)filePix)) {
            throw new MsgException("0009", ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u9519\u8bef", (String)"UploadFileService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        return fileName + filePix;
    }

    private String upFile(RecognitionCheckAPIService.RecognitionCheckParam rcParam, String fileName) {
        return this.upFileOfBase64(rcParam.getBase64(), rcParam.getFileType(), fileName);
    }

    private String upFileOfBase64(String base64, String fileType, String fileName) {
        String url = FileUploadUtils.getInvoiceDir((String)"invoice") + fileName;
        String fileId = MD5.SHA256Hex((String)(fileType + base64));
        String path = FileUtils.queryFilePath((String)fileId);
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = FileUploadUtils.uploadBase64((String)url, (String)fileName, (String)base64);
            FileUtils.saveFilePath((String)"", (String)path, (String)fileId, (String)fileType);
        }
        logger.info("\u4e0a\u4f20\u670d\u52a1\u5668\uff1afileName\uff1a" + fileName + ", url\uff1a" + url + ", fileId: " + fileId);
        return path;
    }
}

