/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.fpdk;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.ReadyDeductSelectSerive;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.message.service.RimApiHelper;
import kd.imc.rim.formplugin.message.service.fpdk.AbstractFpdkService;
import org.apache.commons.compress.utils.Lists;

public class ReadySelectService
extends AbstractFpdkService {
    public ReadySelectService(String type) {
        this.type = type;
    }

    @Override
    public ApiResult getResult(JSONObject reqJson) {
        this.checkParam(reqJson);
        String taxNo = reqJson.getString("taxNo");
        List<Long> orgIds = this.getAllOrgIdByTaxNo(taxNo);
        String authenticateFlag = reqJson.getString("authenticateFlag");
        JSONArray invoiceArray = reqJson.getJSONArray("invoices");
        Date taxPeriod = reqJson.getDate("taxPeriodDate");
        JSONArray taxDeductInvoiceArray = new JSONArray();
        ArrayList transportDeductSerialNos = Lists.newArrayList();
        JSONArray success = new JSONArray();
        JSONArray fail = new JSONArray();
        JSONObject example = null;
        for (int i = 0; i < invoiceArray.size(); ++i) {
            JSONObject invoice = invoiceArray.getJSONObject(i);
            if (invoice == null) continue;
            invoice.put("selectResult", (Object)"1");
            invoice.put("description", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"ReadySelectService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.queryInvoice(invoice, authenticateFlag, orgIds, taxPeriod);
            if (!"1".equals(invoice.getString("selectResult"))) {
                invoice.remove((Object)"invoiceTypeLong");
                fail.add((Object)invoice);
                continue;
            }
            Long invoiceTypeLong = invoice.getLong("invoiceTypeLong");
            invoice.remove((Object)"invoiceTypeLong");
            if (InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue()) {
                example = new JSONObject();
                example.put("serial_no", (Object)invoice.getString("serialNo"));
                example.put("invoice_type", (Object)invoiceTypeLong);
                example.put("deduction_purpose", (Object)invoice.getString("deductionPurpose"));
                example.put("not_deductible_type", (Object)invoice.getString("notDeductibleType"));
                example.put("effective_tax_amount", invoice.get((Object)"effectiveTaxAmount"));
                example.put("tax_period", taxPeriod != null ? DateUtils.format((Date)taxPeriod, (String)"yyyyMM") : null);
                example.put("authenticate_flag", (Object)("1".equals(authenticateFlag) ? "4" : "0"));
                taxDeductInvoiceArray.add((Object)example);
            } else {
                transportDeductSerialNos.add(invoice.getString("serialNo"));
            }
            success.add((Object)invoice);
        }
        ReadyDeductSelectSerive selectSerive = new ReadyDeductSelectSerive();
        String batchNo = UUID.getBatchNo((String)"READY");
        selectSerive.readyDeductSelect(taxDeductInvoiceArray, "1".equals(authenticateFlag) ? "4" : "0", taxPeriod, batchNo);
        selectSerive.readyDeductTransport((List)transportDeductSerialNos, "1".equals(authenticateFlag) ? "2" : "0", taxPeriod, batchNo);
        JSONObject data = new JSONObject();
        data.put("success", (Object)success);
        data.put("fail", (Object)fail);
        JSONObject result = ResultContant.createSuccessJSONObject((Object)data);
        return RimApiHelper.convertApiResult((Map<String, Object>)result);
    }

    private void queryInvoice(JSONObject invoice, String authenticateFlag, List<Long> orgIds, Date taxPeriod) {
        String serialNo = invoice.getString("serialNo");
        Long invoiceTypeLong = invoice.getLong("invoiceTypeLong");
        QFilter qFilter = new QFilter("org_id", "in", orgIds);
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            String msg;
            qFilter.and("serial_no", "=", (Object)serialNo);
            DynamicObject main = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"serial_no,invoice_code,invoice_no,authenticate_flag,deduction_flag,invoice_type,transport_deduction,effective_tax_amount,total_tax_amount,invoice_date", (QFilter[])qFilter.toArray());
            if (ObjectUtils.isEmpty((Object)main)) {
                invoice.put("selectResult", (Object)"2");
                invoice.put("description", (Object)ResManager.loadKDString((String)"\u65e0\u6b64\u7968", (String)"ReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            invoiceTypeLong = DynamicObjectUtil.getDynamicObjectLongValue((Object)main.get("invoice_type"));
            if (!InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue() && !InputInvoiceTypeEnum.canTransportDeduction((Long)invoiceTypeLong).booleanValue()) {
                invoice.put("selectResult", (Object)"3");
                invoice.put("description", (Object)ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u9519\u8bef\uff0c\u4e0d\u5c5e\u4e8e\u53ef\u62b5\u6263\u7684\u53d1\u7968\u7c7b", (String)"ReadySelectService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue() && StringUtils.isNotEmpty((CharSequence)(msg = this.checkTaxInvoiceParam(authenticateFlag, invoice)))) {
                invoice.put("selectResult", (Object)"4");
                invoice.put("description", (Object)msg);
                return;
            }
            String deductionPurpose = invoice.getString("deductionPurpose");
            if ("3".equals(deductionPurpose) && !InputInvoiceTypeEnum.canVatDrawbackDeduction((Long)invoiceTypeLong).booleanValue()) {
                invoice.put("selectResult", (Object)"10");
                invoice.put("description", (Object)String.format(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u7535\u5b50\u4e13\u7528\u3001\u7eb8\u8d28\u4e13\u7528\u3001\u5168\u7535\u4e13\u7968\u4e09\u79cd\u53d1\u7968\u7c7b\u578b\u8fdb\u884c\u9000\u7a0e\u9884\u52fe\u9009\u64cd\u4f5c\uff0c\u53d1\u7968\u53f7\u7801: %1$s\uff0c\u4e0d\u5c5e\u4e8e\u4ee5\u4e0a\u4e09\u79cd\u7c7b\u578b", (String)"ReadySelectService_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), main.getString("invoice_no")));
                return;
            }
            invoice.put("invoiceTypeLong", (Object)invoiceTypeLong);
            this.checkDeduct(main, invoice, authenticateFlag, taxPeriod);
            return;
        }
        String entity = InputInvoiceTypeEnum.getEntity((Long)invoiceTypeLong);
        String selectFiled = "serial_no,deduction_flag,transport_deduction,total_tax_amount,effective_tax_amount,invoice_date";
        if (InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue()) {
            selectFiled = "serial_no,deduction_flag,authenticate_flag,effective_tax_amount,total_tax_amount,invoice_date";
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceTypeLong)) {
            qFilter.and("invoice_date", "=", (Object)invoice.getDate("invoiceDate")).and("train_num", "=", (Object)invoice.getString("invoiceCode")).and("sequence_no", "=", (Object)invoice.getString("invoiceNo"));
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceTypeLong)) {
            qFilter.and("eticket_no", "=", (Object)invoice.getString("invoiceCode")).and("print_num", "=", (Object)invoice.getString("invoiceNo"));
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceTypeLong)) {
            qFilter.and("custom_declaration_no", "=", (Object)invoice.getString("invoiceNo"));
        } else if (InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceTypeLong) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceTypeLong)) {
            qFilter.and("invoice_no", "=", (Object)invoice.getString("invoiceNo"));
        } else {
            qFilter.and("invoice_code", "=", (Object)invoice.getString("invoiceCode")).and("invoice_no", "=", (Object)invoice.getString("invoiceNo"));
        }
        DynamicObject invoiceObj = QueryServiceHelper.queryOne((String)entity, (String)selectFiled, (QFilter[])qFilter.toArray());
        if (ObjectUtils.isEmpty((Object)invoiceObj)) {
            invoice.put("selectResult", (Object)"2");
            invoice.put("description", (Object)ResManager.loadKDString((String)"\u65e0\u6b64\u7968", (String)"ReadySelectService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        invoice.put("serialNo", (Object)invoiceObj.getString("serial_no"));
        this.checkDeduct(invoiceObj, invoice, authenticateFlag, taxPeriod);
    }

    private void checkDeduct(DynamicObject localInvoice, JSONObject reqInvoice, String authenticateFlag, Date taxPeriod) {
        BigDecimal effectiveTaxAmount;
        BigDecimal totalTaxAmount;
        if (ObjectUtils.isEmpty((Object)localInvoice)) {
            return;
        }
        if (!"1".equals(localInvoice.getString("deduction_flag"))) {
            reqInvoice.put("selectResult", (Object)"5");
            reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u4e0d\u53ef\u62b5\u6263\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u9884\u52fe\u9009", (String)"ReadySelectService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("1".equals(authenticateFlag)) {
            Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)taxPeriod);
            Date invoiceDate = localInvoice.getDate("invoice_date");
            if (invoiceDate == null || invoiceDate.compareTo(lastDateOfMonth) > 0) {
                reqInvoice.put("selectResult", (Object)"9");
                reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u7968\u8d85\u51fa\u53ef\u64cd\u4f5c\u5f00\u7968\u65e5\u671f\u8303\u56f4\u4e0a\u9650", (String)"ReadySelectService_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ((totalTaxAmount = localInvoice.getBigDecimal("total_tax_amount")).compareTo(BigDecimal.ZERO) < 0) {
            reqInvoice.put("selectResult", (Object)"8");
            reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u7a0e\u989d\u4e3a\u8d1f\u6570\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u9884\u52fe\u9009", (String)"ReadySelectService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        Long invoiceTypeLong = reqInvoice.getLong("invoiceTypeLong");
        if (InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue()) {
            if (!"0".equals(localInvoice.getString("authenticate_flag")) && "1".equals(authenticateFlag)) {
                reqInvoice.put("selectResult", (Object)"6");
                reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u672a\u52fe\u9009\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u9884\u52fe\u9009", (String)"ReadySelectService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            if (!"4".equals(localInvoice.getString("authenticate_flag")) && "0".equals(authenticateFlag)) {
                reqInvoice.put("selectResult", (Object)"7");
                reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u9884\u52fe\u9009\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u9884\u52fe\u9009", (String)"ReadySelectService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        } else {
            if (!"0".equals(localInvoice.getString("transport_deduction")) && "1".equals(authenticateFlag)) {
                reqInvoice.put("selectResult", (Object)"6");
                reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u672a\u52fe\u9009\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u9884\u52fe\u9009", (String)"ReadySelectService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            if (!"2".equals(localInvoice.getString("transport_deduction")) && "0".equals(authenticateFlag)) {
                reqInvoice.put("selectResult", (Object)"7");
                reqInvoice.put("description", (Object)ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u975e\u9884\u52fe\u9009\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u9884\u52fe\u9009", (String)"ReadySelectService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
        if ((effectiveTaxAmount = localInvoice.getBigDecimal("effective_tax_amount")).compareTo(BigDecimal.ZERO) == 0) {
            reqInvoice.put("effectiveTaxAmount", (Object)totalTaxAmount);
        } else {
            reqInvoice.put("effectiveTaxAmount", (Object)effectiveTaxAmount);
        }
    }

    private void checkParam(JSONObject reqJson) {
        String authenticateFlag = reqJson.getString("authenticateFlag");
        JSONArray invoiceArray = reqJson.getJSONArray("invoices");
        if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u9884\u52fe\u9009\u6807\u5fd7\u4e0d\u5141\u8bb8\u4e3a\u7a7a", (String)"ReadySelectService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        this.checkValue(authenticateFlag, "authenticateFlag");
        if ("1".equals(authenticateFlag)) {
            Date taxPeriod = DeductionUtils.getParamTaxPeriod((String)reqJson.getString("taxPeriod"));
            reqJson.put("taxPeriodDate", (Object)taxPeriod);
        }
        if (CollectionUtils.isEmpty((Collection)invoiceArray)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReadySelectService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < invoiceArray.size(); ++i) {
            String msg;
            String serialNo;
            JSONObject invoice = invoiceArray.getJSONObject(i);
            if (invoice == null || StringUtils.isNotEmpty((CharSequence)(serialNo = invoice.getString("serialNo")))) continue;
            String invoiceNo = invoice.getString("invoiceNo");
            if (StringUtils.isEmpty((CharSequence)invoiceNo)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReadySelectService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            String invoiceType = invoice.getString("invoiceType");
            if (StringUtils.isEmpty((CharSequence)invoiceType)) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\uff0c\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReadySelectService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            Long invoiceTypeLong = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            if (!InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue() && !InputInvoiceTypeEnum.canTransportDeduction((Long)invoiceTypeLong).booleanValue()) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\uff0c\u53d1\u7968\u7c7b\u578b\u9519\u8bef\uff0c\u4e0d\u5c5e\u4e8e\u53ef\u62b5\u6263\u7684\u53d1\u7968\u7c7b\u578b", (String)"ReadySelectService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            invoice.put("invoiceTypeLong", (Object)invoiceTypeLong);
            String invoiceCode = invoice.getString("invoiceCode");
            if (!(!StringUtils.isEmpty((CharSequence)invoiceCode) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.TRAIN_ELE_INVOICE.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.AIR_ELE_INVOICE.getAwsType().equals(invoiceType) || InputInvoiceTypeEnum.HGJKS.getAwsType().equals(invoiceType))) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReadySelectService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            }
            if (InputInvoiceTypeEnum.TRAIN_INVOICE.getAwsType().equals(invoiceType)) {
                String invoiceDate = invoice.getString("invoiceDate");
                if (StringUtils.isEmpty((CharSequence)invoiceDate)) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%s\uff0c\u706b\u8f66\u7968\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"ReadySelectService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
                }
                try {
                    invoice.getDate("invoiceDate");
                }
                catch (Exception e) {
                    throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968:%1$s,%2$s", (String)"ReadySelectService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo, ResManager.loadKDString((String)"\u53d1\u7968\u65e5\u671f\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"ReadySelectService_15", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                }
            }
            if (InputInvoiceTypeEnum.canDeduction((Long)invoiceTypeLong).booleanValue() && StringUtils.isNotEmpty((CharSequence)(msg = this.checkTaxInvoiceParam(authenticateFlag, invoice)))) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\uff0c,%2$s", (String)"ReadySelectService_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo, msg));
            }
            String deductionPurpose = invoice.getString("deductionPurpose");
            if (!"3".equals(deductionPurpose) || InputInvoiceTypeEnum.canVatDrawbackDeduction((Long)invoiceTypeLong).booleanValue()) continue;
            invoice.put("selectResult", (Object)"10");
            invoice.put("description", (Object)String.format(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u7535\u5b50\u4e13\u7528\u3001\u7eb8\u8d28\u4e13\u7528\u3001\u5168\u7535\u4e13\u7968\u4e09\u79cd\u53d1\u7968\u7c7b\u578b\u8fdb\u884c\u9000\u7a0e\u9884\u52fe\u9009\u64cd\u4f5c\uff0c\u53d1\u7968\u53f7\u7801: %1$s\uff0c\u4e0d\u5c5e\u4e8e\u4ee5\u4e0a\u4e09\u79cd\u7c7b\u578b", (String)"ReadySelectService_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceNo));
            return;
        }
    }

    private String checkTaxInvoiceParam(String authenticateFlag, JSONObject invoice) {
        if (invoice == null) {
            return "";
        }
        String deductionPurpose = invoice.getString("deductionPurpose");
        if (!Arrays.asList("1", "2", "3").contains(deductionPurpose)) {
            return ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"ReadySelectService_17", (String)"imc-rim-formplugin", (Object[])new Object[0]);
        }
        if ("2".equals(deductionPurpose) && "1".equals(authenticateFlag)) {
            String notDeductibleType = invoice.getString("notDeductibleType");
            if (StringUtils.isEmpty((CharSequence)notDeductibleType)) {
                return ResManager.loadKDString((String)"\u62b5\u6263\u7528\u9014\u4e3a\u4e0d\u62b5\u6263\u65f6\uff0c\u5fc5\u987b\u586b\u4e0d\u62b5\u6263\u539f\u56e0", (String)"ReadySelectService_18", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            if (!Arrays.asList("1", "2", "3", "4", "5").contains(notDeductibleType)) {
                return ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u539f\u56e0\u4e0d\u5408\u89c4,\u8bf7\u68c0\u67e5", (String)"ReadySelectService_19", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

