/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.deduction.DeductService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.message.vo.RequestVo;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.formplugin.message.service.OpenApiService;
import kd.imc.rim.formplugin.message.service.fpdk.GxInvoiceService;

public class DeductSelectServiceImpl
implements OpenApiService {
    @Override
    public ApiResult doBusiness(RequestVo requestVo) {
        JSONObject param = JSON.parseObject((String)requestVo.getData());
        this.checkSelectParam(param);
        String taxNo = param.getString("taxNo");
        String authType = this.getAuthType(taxNo);
        param.put("orgId", (Object)RequestContext.get().getOrgId());
        String deductibleMode = DeductionConstant.getDeductibleMode((String)param.getString("deductionPurpose"), (String)param.getString("authenticateFlag"));
        param.put("deductibleMode", (Object)deductibleMode);
        DeductService deductService = DeductServiceFactory.newInstanceForDeduct((String)authType, (Long)RequestContext.get().getOrgId());
        JSONObject resultJson = deductService.gxInvoices(param);
        if (resultJson != null) {
            GxInvoiceService gxInvoiceService = new GxInvoiceService();
            ThreadPools.executeOnceIncludeRequestContext((String)"SelectAuthService.invoiceSelect", () -> gxInvoiceService.asyncUpdateInvoiceStatus(param, resultJson));
        }
        return this.convertApiResult(resultJson, requestVo);
    }

    private void checkSelectParam(JSONObject param) {
        this.checkParam(param);
        String deductionPurpose = param.getString("deductionPurpose");
        if (StringUtils.isEmpty((CharSequence)deductionPurpose)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u62b5\u6263\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductSelectServiceImpl_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!"1".equals(deductionPurpose) && !"2".equals(deductionPurpose)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u62b5\u6263\u7c7b\u578b\u4f20\u5165\u6570\u636e\u6709\u8bef", (String)"DeductSelectServiceImpl_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String authenticateFlag = param.getString("authenticateFlag");
        if (StringUtils.isEmpty((CharSequence)authenticateFlag)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u52fe\u9009\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductSelectServiceImpl_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (!"0".equals(authenticateFlag) && !"1".equals(authenticateFlag)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u52fe\u9009\u6807\u5fd7\u4f20\u5165\u6570\u636e\u6709\u8bef", (String)"DeductSelectServiceImpl_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        JSONArray invoices = param.getJSONArray("invoices");
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53d1\u7968\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (String)"DeductSelectServiceImpl_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }
}

