/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.message.service.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.BussinSysBillStatusEnum;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.expense.domain.ExpenseCoverDTO;
import kd.imc.rim.common.expense.domain.ExpenseDTO;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.expense.service.InvoiceImageNotifyService;
import kd.imc.rim.common.invoice.fpzs.FpzsCommonService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.message.service.AbstractMessageServie;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillCreateService
extends AbstractMessageServie {
    private static Log LOGGER = LogFactory.getLog(BillCreateService.class);

    @Override
    public ApiResult doBusiness(Object reqObject) {
        String json = SerializationUtils.toJsonString((Object)reqObject);
        LOGGER.info("\u521b\u5efa\u62a5\u9500\u5355\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        JSONObject jsonObj = JSONObject.parseObject((String)json);
        jsonObj.put("rim_operate_method", (Object)"billCreate");
        this.checkParam(jsonObj);
        ExpenseDTO dto = FpzsCommonService.getApiExpenseDTO((Map)jsonObj);
        ExpenseService service = new ExpenseService();
        service.billCreate(dto);
        ApiResult results = this.pushImage(jsonObj, dto);
        if (results != null) {
            return results;
        }
        return this.successResult();
    }

    protected void checkParam(JSONObject param) {
        String country;
        String currencyCode;
        String userId;
        String bussinSysBillStatus = param.getString("bussinSysBillStatus");
        if (!BussinSysBillStatusEnum.isBillCreateStatus((String)bussinSysBillStatus)) {
            throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u7cfb\u7edf\u5355\u636e\u72b6\u6001\u6570\u636e\u9519\u8bef\u3002", (String)"BillCreateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String orgNumber = param.getString("orgNumber");
        String billTaxNo = param.getString("billTaxNo");
        if (StringUtils.isNotEmpty((CharSequence)orgNumber) || StringUtils.isNotEmpty((CharSequence)billTaxNo)) {
            Long orgId = TenantUtils.getOrgByNumberOrTaxNo((String)orgNumber, (String)billTaxNo);
            if (orgId == null || orgId == 0L) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u91d1\u8776\u7ec4\u7ec7\u7f16\u7801\u6216\u5355\u636e\u6240\u5c5e\u4f01\u4e1a\u7a0e\u53f7\u53c2\u6570\u9519\u8bef\u3002", (String)"BillCreateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            param.put("orgId", (Object)orgId);
        }
        String applyOrgCode = param.getString("applyOrgCode");
        String applyTaxNo = param.getString("applyTaxNo");
        if (StringUtils.isNotEmpty((CharSequence)applyOrgCode) || StringUtils.isNotEmpty((CharSequence)applyTaxNo)) {
            Long applyOrgId = TenantUtils.getOrgByNumberOrTaxNo((String)applyOrgCode, (String)applyTaxNo);
            if (applyOrgId == null || applyOrgId == 0L) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), ResManager.loadKDString((String)"\u63d0\u5355\u91d1\u8776\u7ec4\u7ec7\u7f16\u7801\u6216\u63d0\u5355\u7ec4\u7ec7\u4f01\u4e1a\u7a0e\u53f7\u53c2\u6570\u9519\u8bef\u3002", (String)"BillCreateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            param.put("applyOrgId", (Object)applyOrgId);
        }
        if (StringUtils.isNotEmpty((CharSequence)(userId = param.getString("userId")))) {
            Pair user = FpzsMainService.getUser((String)userId, (String)"1");
            if (user == null) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u4e0d\u5b58\u5728\u3002", (String)"BillCreateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), userId));
            }
            param.put("billUser", user.getLeft());
            if (StringUtils.isEmpty((CharSequence)param.getString("userName"))) {
                param.put("userName", user.getRight());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(currencyCode = param.getString("currencyCode")))) {
            QFilter filter = new QFilter("number", "=", (Object)currencyCode);
            DynamicObject currencyObj = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id,name", (QFilter[])new QFilter[]{filter});
            if (currencyObj == null) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u5e01\u522b%1$s\u4e0d\u5b58\u5728\u3002", (String)"BillCreateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), currencyCode));
            }
            param.put("currencyId", (Object)currencyObj.getLong("id"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(country = param.getString("country")))) {
            QFilter filter = new QFilter("threecountrycode", "=", (Object)country).or("simplespell", "=", (Object)country);
            DynamicObject currencyObj = BusinessDataServiceHelper.loadSingle((String)"bd_country", (String)"id,name", (QFilter[])new QFilter[]{filter});
            if (currencyObj == null) {
                throw new MsgException(ErrorType.PARAM_ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u56fd\u522b%1$s\u4e0d\u5b58\u5728\u3002", (String)"BillCreateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), country));
            }
            param.put("countryId", (Object)currencyObj.getLong("id"));
        }
    }

    protected ApiResult pushImage(JSONObject jsonObj, ExpenseDTO dto) {
        if (StringUtils.equals((CharSequence)"1", (CharSequence)jsonObj.getString("needCoverNo")) || "Y".equalsIgnoreCase(jsonObj.getString("needCoverNo"))) {
            String imageNumber = InvoiceImageNotifyService.getImageNumber((String)dto.getExpenseType(), (String)dto.getExpenseId());
            if (StringUtils.isBlank((CharSequence)imageNumber)) {
                imageNumber = InvoiceImageNotifyService.createImageNumber((String)dto.getExpenseId(), (String)dto.getExpenseNum(), (String)RequestContext.get().getUserId(), (String)(RequestContext.get().getOrgId() + ""), (String)dto.getExpenseType());
            }
            if (StringUtils.isNotBlank((CharSequence)imageNumber)) {
                ArrayList<ExpenseCoverDTO> coverList = new ArrayList<ExpenseCoverDTO>(1);
                ExpenseCoverDTO expenseCoverDTO = new ExpenseCoverDTO();
                coverList.add(expenseCoverDTO);
                expenseCoverDTO.setCoverNo(imageNumber);
                expenseCoverDTO.setBase64("");
                expenseCoverDTO.setFileType(Integer.valueOf(1));
                dto.setCoverDTOList(coverList);
            }
            InvoiceImageNotifyService.imageNotify((ExpenseDTO)dto);
            ApiResult results = this.successResult();
            JSONObject obj = new JSONObject();
            obj.put("coveNo", (Object)((ExpenseCoverDTO)dto.getCoverDTOList().get(0)).getCoverNo());
            results.setData((Object)obj.toJSONString());
            return results;
        }
        return null;
    }
}

