/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.collect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InvoiceSaveConstant;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.utils.BigDecimalUtil;

public class InvoiceClassSelectMBFormPlugin
extends AbstractMobFormPlugin {
    private static Log logger = LogFactory.getLog(InvoiceClassSelectMBFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"lbl_edit", "lbl_del", "lbl_done", "vt_add", "flex_add", "item_cancel", "item_ok"});
        this.addClickListeners(this.getVtDelList().toArray(new String[0]));
        this.addItemClickListeners(new String[]{"tool_items"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long currentUser = this.getCurrentUser();
        InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getDefaultClassList(currentUser), this.getDefaultCheckList(), "2");
        InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCustomClassList(currentUser), this.getCustomCheckList(), "3");
        InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCommonClassList(currentUser), this.getCommonCheckList(), "1");
        this.initCheckId();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean bool;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.getAllCheckList().contains(key) && (bool = ((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue())) {
            long startTime = System.currentTimeMillis();
            List<String> checkedKeys = this.getCheckedKeys();
            checkedKeys.remove(key);
            this.getModel().beginInit();
            this.getModel().endInit();
            for (String checkedKey : checkedKeys) {
                this.getView().updateView(checkedKey);
            }
            logger.info("{}\u8017\u65f6\uff1a{}", (Object)key, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"vt_add") || StringUtils.equals((CharSequence)key, (CharSequence)"flex_add")) {
            JSONArray customClassList = InvoiceClassService.getInstance().getCustomClassList(this.getCurrentUser());
            if (customClassList.size() >= 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u6dfb\u52a010\u4e2a\u81ea\u5b9a\u4e49\u6807\u7b7e\u3002", (String)"InvoiceClassSelectMBFormPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            InvoiceClassService.getInstance().openEditView("", Long.valueOf(0L), "class_add", this.getCurrentUser() + "", (AbstractFormPlugin)this);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_edit")) {
            List<Long> checkedClassIds = this.getCheckedClassIds();
            if (checkedClassIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6807\u7b7e\u3002", (String)"InvoiceClassSelectMBFormPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Long singleClassId = checkedClassIds.get(0);
            JSONObject classInfoJson = InvoiceClassService.getInstance().getClassInfoJson(singleClassId);
            String isEdit = classInfoJson.getString("class_isedit");
            if (StringUtils.equals((CharSequence)isEdit, (CharSequence)"0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u6807\u7b7e\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"InvoiceClassSelectMBFormPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Long id = classInfoJson.getLong("class_id");
            String name = classInfoJson.getString("class_name");
            InvoiceClassService.getInstance().openEditView(name, id, "class_edit", this.getCurrentUser() + "", (AbstractFormPlugin)this);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_del")) {
            this.getModel().setValue("check_del", (Object)true);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_done")) {
            this.getModel().setValue("check_del", (Object)false);
        } else if (StringUtils.contains((CharSequence)key, (CharSequence)"vt_custom_")) {
            String checkKey = key.replace("vt_custom_", "check_custom_");
            List<Long> checkedClassIds = this.getCheckedClassIds(Lists.newArrayList((Object[])new String[]{checkKey}));
            if (checkedClassIds.isEmpty()) {
                logger.info("\u6709\u95ee\u9898\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u3002checkedClassIds:{}", checkedClassIds);
                return;
            }
            Long singleClassId = checkedClassIds.get(0);
            JSONObject classInfoJson = InvoiceClassService.getInstance().getClassInfoJson(singleClassId);
            String className = classInfoJson.getString("class_name");
            HashMap btnName = Maps.newHashMapWithExpectedSize((int)2);
            btnName.put(6, ResManager.loadKDString((String)"\u5220\u9664", (String)"InvoiceClassSelectMBFormPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnName.put(2, ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvoiceClassSelectMBFormPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            JSONObject otherClassInfo = InvoiceClassService.getInstance().getClassInfoJson(Long.valueOf(10L));
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u201c%1$s\u201d\u6807\u7b7e\uff0c\u53d1\u7968\u6807\u7b7e\u5c06\u66f4\u6362\u4e3a\u201c%2$s\u201d", (String)"InvoiceClassSelectMBFormPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), className, otherClassInfo.get((Object)"class_name")), "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("del_custom", (IFormPlugin)this), (Map)btnName);
            this.getPageCache().put("need_delete_id_cache_key", singleClassId + "");
        } else if (StringUtils.equals((CharSequence)"item_ok", (CharSequence)key)) {
            JSONObject returnData = new JSONObject();
            List<Long> classIds = this.getCheckedClassIds();
            if (classIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6807\u7b7e\u3002", (String)"InvoiceClassSelectMBFormPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            returnData.put("classId", (Object)JSONArray.toJSONString(classIds));
            returnData.put("classUser", (Object)this.getCurrentUser());
            this.getView().returnDataToParent((Object)returnData.toJSONString());
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"del_custom")) {
            if (StringUtils.equals((CharSequence)evt.getResultValue(), (CharSequence)"Yes")) {
                try {
                    String singleClassId = this.getPageCache().get("need_delete_id_cache_key");
                    if (StringUtils.isNotBlank((CharSequence)singleClassId)) {
                        Long currentUser = this.getCurrentUser();
                        long delId = Long.parseLong(singleClassId);
                        InvoiceClassService.getInstance().delInvoiceClass(Long.valueOf(delId), currentUser);
                        List<Long> checkedClassIds = this.getCheckedClassIds();
                        InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCustomClassList(currentUser), this.getCustomCheckList(), "3");
                        InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCommonClassList(currentUser), this.getCommonCheckList(), "1");
                        List<String> checkKeys = this.getCheckKey(checkedClassIds.stream().map(v -> v + "").collect(Collectors.toList()));
                        if (checkKeys.isEmpty()) {
                            checkKeys = this.getCheckKey(Lists.newArrayList((Object[])new String[]{Long.toString(10L)}));
                        }
                        for (String checkKey : checkKeys) {
                            this.getModel().setValue(checkKey, (Object)true);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u5220\u9664\u62a5\u9519\uff1a", (Throwable)e);
                    throw new KDException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u62a5\u9519\u3002%1$s", (String)"InvoiceClassSelectMBFormPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
            this.getPageCache().remove("need_delete_id_cache_key");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String action = evt.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"class_add") || StringUtils.equals((CharSequence)action, (CharSequence)"class_edit")) {
            String str = (String)evt.getReturnData();
            if (StringUtils.isEmpty((CharSequence)str)) {
                return;
            }
            JSONObject returnData = JSONObject.parseObject((String)str);
            String name = returnData.getString("className");
            Long currentUser = this.getCurrentUser();
            Long id = returnData.getLong("classId");
            if (StringUtils.equals((CharSequence)action, (CharSequence)"class_add")) {
                InvoiceClassService.getInstance().addInvoiceClass(name, currentUser);
            } else if (StringUtils.equals((CharSequence)action, (CharSequence)"class_edit")) {
                InvoiceClassService.getInstance().updateInvoiceClass(name, id, currentUser);
            }
            InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCommonClassList(currentUser), this.getCommonCheckList(), "1");
            InvoiceClassService.getInstance().initCheck((AbstractFormPlugin)this, InvoiceClassService.getInstance().getCustomClassList(currentUser), this.getCustomCheckList(), "3");
        }
    }

    private void initCheckId() {
        String classId = (String)this.getView().getFormShowParameter().getCustomParam("classId");
        List classIds = JSONObject.parseArray((String)classId, String.class);
        if (classIds == null) {
            return;
        }
        List checkKeys = this.getModel().getEntryEntity("entity").stream().filter(v -> classIds.contains(Long.toString(v.getLong("classid"))) && (StringUtils.equals((CharSequence)v.getString("classtype"), (CharSequence)"2") || StringUtils.equals((CharSequence)v.getString("classtype"), (CharSequence)"3"))).map(v -> v.getString("check_key")).collect(Collectors.toList());
        for (String checkKey : checkKeys) {
            this.getModel().setValue(checkKey, (Object)true);
        }
    }

    private List<Long> getCheckedClassIds() {
        return this.getModel().getEntryEntity("entity").stream().filter(v -> (Boolean)this.getModel().getValue(v.getString("check_key"))).map(v -> v.getLong("classid")).collect(Collectors.toList());
    }

    private List<Long> getCheckedClassIds(List<String> checkKeyLists) {
        return this.getModel().getEntryEntity("entity").stream().filter(v -> checkKeyLists.contains(v.getString("check_key"))).map(v -> v.getLong("classid")).collect(Collectors.toList());
    }

    private List<String> getCheckedKeys() {
        return this.getModel().getEntryEntity("entity").stream().map(v -> v.getString("check_key")).collect(Collectors.toList());
    }

    private List<String> getCheckKey(List<String> classIds) {
        return this.getModel().getEntryEntity("entity").stream().filter(v -> classIds.contains(Long.toString(v.getLong("classid")))).map(v -> v.getString("check_key")).collect(Collectors.toList());
    }

    private Long getCurrentUser() {
        Long rim_user = BigDecimalUtil.transDecimal((Object)this.getView().getFormShowParameter().getCustomParam("rim_user")).longValue();
        Long opoer_user = BigDecimalUtil.transDecimal((Object)this.getView().getFormShowParameter().getCustomParam(InvoiceSaveConstant.OPERATE_USER_ID)).longValue();
        if (rim_user > 0L) {
            return rim_user;
        }
        if (opoer_user > 0L) {
            return opoer_user;
        }
        return Long.valueOf(RequestContext.get().getUserId());
    }

    private List<String> getAllCheckList() {
        return this.getModel().getEntryEntity("entity").stream().map(v -> v.getString("check_key")).collect(Collectors.toList());
    }

    private List<String> getCustomCheckList() {
        return InvoiceClassService.getInstance().getCheckList((AbstractFormPlugin)this, "custom");
    }

    private List<String> getCommonCheckList() {
        return InvoiceClassService.getInstance().getCheckList((AbstractFormPlugin)this, "common");
    }

    private List<String> getDefaultCheckList() {
        return InvoiceClassService.getInstance().getCheckList((AbstractFormPlugin)this, "default");
    }

    protected List<String> getVtDelList() {
        ArrayList vtDelList = Lists.newArrayList();
        ArrayList flexKeyList = Lists.newArrayList((Object[])new String[]{"common", "default", "custom"});
        for (String flexKey : flexKeyList) {
            vtDelList.addAll(InvoiceClassService.getInstance().getFieldKeyList((AbstractFormPlugin)this, flexKey, "vt_", v -> v instanceof Vector && v.getKey() != null));
        }
        return vtDelList;
    }
}

