/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.home.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.CollectTypeEnum;
import kd.imc.rim.common.constant.ErrorCodeConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.collector.InvoiceCollectService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.utils.AwsFpyService;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.InvoiceConvertUtils;
import kd.imc.rim.common.utils.MD5;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.lang.StringUtils;

public class ScanOperateService
extends AbstractOperateService {
    private static String[] VAT_TYPE = new String[]{"10", "04", "01", "31", "20", "32", "33", "34"};
    private static Log LOGGER = LogFactory.getLog(ScanOperateService.class);
    private InvoiceCollectService invoiceCollectService = new InvoiceCollectService();

    public ScanOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        boolean isLqcheck = this.getCheckType();
        if (isLqcheck) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u626b\u7801\u91c7\u96c6\u4e0d\u652f\u6301\u4f7f\u7528\u4e50\u4f01\u901a\u9053", (String)"InvoiceCollectEnterPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        LOGGER.info("\u79fb\u52a8\u7aef\u626b\u7801\u91c7\u96c6");
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>(2);
        args.put("needResult", 1);
        map.put("args", args);
        this.plugin.getView().executeClientCommand("callYZJApi", new Object[]{map});
        this.plugin.getPageCache().put("scanQRCodeType", "invoice");
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        JSONObject invoiceInfo;
        String value = e.getEventArgs();
        LOGGER.info("\u79fb\u52a8\u7aef\u626b\u7801\u7ed3\u679c\uff1a" + value);
        JSONObject qrcodeInfo = JSON.parseObject((String)value);
        String infoStr = qrcodeInfo.getString("qrcode_str");
        String[] invoice = infoStr.split(",");
        JSONObject checkResultJson = new JSONObject();
        if (invoice.length == 1 && invoice[0].startsWith("https")) {
            try {
                checkResultJson = this.isBlockChain(invoice);
            }
            catch (IOException ioException) {
                LOGGER.error("\u533a\u5757\u94fe\u53d1\u7968\u63a5\u53e3\u83b7\u53d6userKey\u5f02\u5e38\uff1a" + ioException.getMessage());
            }
        } else {
            boolean isAllow = this.checkInvoice(invoice);
            if (isAllow) {
                checkResultJson = this.notBlockChain(invoice);
            } else {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u975e\u589e\u503c\u7a0e\u53d1\u7968\u7684\u626b\u7801", (String)"ScanOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (checkResultJson == null) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u9a8c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a", (String)"ScanOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("0000".equals(checkResultJson.getString("errcode"))) {
            invoiceInfo = checkResultJson.getJSONObject("data");
            Long mainId = checkResultJson.getLong("mainId");
            invoiceInfo.put("mainId", (Object)mainId);
            String serialNo = invoiceInfo.getString("serialNo");
            QFilter filter = new QFilter("serial_no", "=", (Object)serialNo);
            DynamicObject object = QueryServiceHelper.queryOne((String)"rim_invoice_file", (String)"snapshot_url", (QFilter[])new QFilter[]{filter});
            invoiceInfo.put("snapshotUrl", null);
            if (!ObjectUtils.isEmpty((Object)object)) {
                invoiceInfo.put("snapshotUrl", object.get("snapshot_url"));
            }
        } else {
            String desc = checkResultJson.getString("description");
            if (StringUtils.isBlank((String)desc) || desc.contains(ResManager.loadKDString((String)"\u7f16\u8f91\u6309\u94ae", (String)"ScanOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]))) {
                desc = ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u89c4\u8303\uff0c\u67e5\u9a8c\u5931\u8d25", (String)"ScanOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            this.plugin.getView().showErrorNotification(desc);
            return;
        }
        this.plugin.getView().getPageCache().put("mobileCheckInvoiceInfo", invoiceInfo.toJSONString());
        Map<String, Object> customParams = this.getCustomParams();
        customParams.put("invoice_info", invoiceInfo);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("rim_mobile_check_info");
        FpzsAnonymousUserService.addEventCode(customParams, (String)this.plugin.getView().getPageId());
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "mobile_min"));
        this.plugin.getView().showForm((FormShowParameter)showParameter);
    }

    private JSONObject notBlockChain(String[] invoice) {
        try {
            String invoiceCode = this.getValue(invoice, 2);
            String invoiceNo = this.getValue(invoice, 3);
            String invoiceAmountStr = this.getValue(invoice, 4);
            String invoiceDateStr = this.getValue(invoice, 5);
            String checkCodeStr = this.getValue(invoice, 6);
            String invoiceType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCode, (String)invoiceNo);
            Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
            if (checkCodeStr != null && checkCodeStr.length() > 5) {
                checkCodeStr = checkCodeStr.substring(checkCodeStr.length() - 6);
            }
            JSONObject checkResultJson = new JSONObject();
            Map<String, Object> indexInfo = this.getCustomParams();
            JSONObject businessParam = FpzsMainService.getBusinessParam(indexInfo, (String)CollectTypeEnum.H5_SCAN.getCode());
            businessParam.put("resource", (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u626b\u7801\u91c7\u96c6", (String)"ScanOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            checkResultJson = StringUtils.isEmpty((String)checkCodeStr) ? this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDateStr, BigDecimalUtil.transDecimal((Object)invoiceAmountStr), null, businessParam) : (StringUtils.isEmpty((String)invoiceAmountStr) ? this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDateStr, null, checkCodeStr, businessParam) : this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDateStr, BigDecimalUtil.transDecimal((Object)invoiceAmountStr), checkCodeStr, businessParam));
            LOGGER.info("\u79fb\u52a8\u7aef\u626b\u7801\u91c7\u96c6\u53d1\u7968\u67e5\u9a8c\u7ed3\u679c\uff1a" + checkResultJson);
            return checkResultJson;
        }
        catch (Exception e) {
            LOGGER.error("\u626b\u63cf\u4e8c\u7ef4\u7801\u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff1a" + e);
            JSONObject checkResultJson = new JSONObject();
            checkResultJson.put("errcode", (Object)ErrorCodeConstant.PARAM_FORMAT_ERROR);
            checkResultJson.put("description", (Object)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7968\u7684\u4e8c\u7ef4\u7801\u626b\u63cf\u4e0a\u4f20", (String)"ScanOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return checkResultJson;
        }
    }

    private String getValue(String[] invoice, int index) {
        if (invoice != null && invoice.length > index) {
            return invoice[index];
        }
        return null;
    }

    private JSONObject isBlockChain(String[] invoice) throws IOException {
        String path = invoice[0];
        String pathValue = path.split("\\?")[1];
        String[] keyValueStr = pathValue.split("&");
        HashMap map = Maps.newHashMap();
        for (String keyValue : keyValueStr) {
            String key = keyValue.split("=")[0];
            String value = keyValue.split("=")[1];
            if (StringUtils.equals((String)key, (String)"hash")) {
                map.put("txHash", value);
                continue;
            }
            if (StringUtils.equals((String)key, (String)"bill_num")) {
                map.put("invoiceNo", value);
                continue;
            }
            if (!StringUtils.equals((String)key, (String)"total_amount")) continue;
            map.put("totalAmount", value);
        }
        JSONObject checkResultJson = new JSONObject();
        JSONObject userKeyResult = this.getUserKey();
        if (userKeyResult != null && "0000".equals(userKeyResult.getString("errcode"))) {
            String userKey = userKeyResult.getJSONObject("data").getString("userKey");
            map.put("userKey", userKey);
            JSONObject resData = AwsFpyService.newInstance().postAppJson("block_chain_check", Long.valueOf(RequestContext.get().getOrgId()), (Map)map);
            LOGGER.info("\u79fb\u52a8\u7aef\u533a\u5757\u94fe\u53d1\u7968-\u53d1\u7968\u4e91\u8fd4\u56de\u7ed3\u679c\uff1a" + resData);
            if (resData != null && "0000".equals(resData.getString("errcode"))) {
                Map<String, Object> indexInfo = this.getCustomParams();
                JSONObject businessParam = FpzsMainService.getBusinessParam(indexInfo, (String)CollectTypeEnum.H5_SCAN.getCode());
                businessParam.put("resource", (Object)ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u626b\u7801\u91c7\u96c6", (String)"ScanOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                JSONObject invoiceDataJson = resData.getJSONObject("data");
                String invoiceCode = invoiceDataJson.getString("invoiceCode");
                String invoiceNo = invoiceDataJson.getString("invoiceNo");
                String invoiceDate = invoiceDataJson.getString("invoiceDate");
                String invoiceAmount = invoiceDataJson.getString("amount");
                String checkCode = invoiceDataJson.getString("checkCode");
                String invoiceType = InvoiceConvertUtils.checkInvoiceType((String)invoiceCode, (String)invoiceNo);
                Long invoice_type = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)invoiceType);
                checkResultJson = this.invoiceCollectService.checkInvoice(invoiceCode, invoiceNo, invoice_type, invoiceDate, BigDecimalUtil.transDecimal((Object)invoiceAmount), checkCode, businessParam);
            }
        } else {
            return userKeyResult;
        }
        return checkResultJson;
    }

    private JSONObject getUserKey() throws IOException {
        RequestContext request;
        Long orgId;
        String linkKey = this.plugin.getView().getPageId();
        linkKey = MD5.md5Hex((String)linkKey);
        AwsFpyService service = AwsFpyService.newInstance();
        JSONObject config = service.getAwsConfig(orgId = Long.valueOf((request = RequestContext.get()).getOrgId()));
        if (ObjectUtils.isEmpty((Object)config)) {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"AwsConfig\u4e3a\u7a7a", (String)"ScanOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return null;
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5Hex((String)(config.getString("client_id") + config.getString("client_secret") + timestamp));
        JSONObject map = new JSONObject();
        map.put("tin", (Object)TenantUtils.getTaxNoByOrgId((Long)orgId));
        map.put("eid", (Object)Long.parseLong(request.getUserId()));
        map.put("client_id", (Object)config.getString("client_id"));
        map.put("sign", (Object)sign);
        map.put("timestamp", (Object)timestamp);
        map.put("linkKey", (Object)linkKey);
        map.put("random", (Object)System.currentTimeMillis());
        map.put("billNumber", (Object)linkKey);
        map.put("bxd_key", (Object)linkKey);
        map.put("ticketParam", (Object)"00000");
        String url = service.getUrl("get_user_key");
        JSONObject userKeyResult = service.postAppJson(url, map.toJSONString());
        LOGGER.info("\u79fb\u52a8\u7aef\u626b\u7801\u533a\u5757\u94fe\u53d1\u7968userKey\uff1a" + userKeyResult);
        return userKeyResult;
    }

    private boolean checkInvoice(String[] invoice) {
        boolean flag = true;
        if (invoice.length < 3) {
            flag = false;
        } else {
            String invoiceType = this.getValue(invoice, 1);
            if (!Arrays.asList(VAT_TYPE).contains(invoiceType)) {
                flag = false;
            }
        }
        return flag;
    }
}

