/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.mailcollect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import org.apache.commons.lang.StringUtils;

public class MailFailTaskPlugin
extends AbstractFormPlugin {
    public static final String ENTRYENTITY = "failentry";
    public static final String CONTROL_LABEL = "control_label";
    public static final String CLOSE_BUTTON = "close_button";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLOSE_BUTTON});
        Label controlLabel = (Label)this.getControl(CONTROL_LABEL);
        controlLabel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private void init() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        Object failTaskStr = parentCustomParams.get("failTask");
        String openId = (String)parentCustomParams.get("openId");
        this.getView().getPageCache().put("failTaskOpenId", openId);
        JSONArray failArray = JSON.parseArray((String)(failTaskStr + ""));
        if (ObjectUtils.isEmpty((Object)failArray)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        for (int i = 0; i < failArray.size(); ++i) {
            JSONObject failInfo = failArray.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("taskid", (Object)failInfo.getString("taskId"), row);
            this.getModel().setValue("mail_user", (Object)failInfo.getString("mailUser"), row);
            this.getModel().setValue("send_date", (Object)failInfo.getString("sendDate"), row);
            this.getModel().setValue("mail_subject", (Object)failInfo.getString("mailSubject"), row);
            this.getModel().setValue("fail_reason", (Object)failInfo.getString("failReason"), row);
        }
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Control control = (Control)eventObject.getSource();
        String openId = this.getView().getPageCache().get("failTaskOpenId");
        if (StringUtils.equals((String)control.getKey(), (String)CLOSE_BUTTON)) {
            this.getView().close();
        } else if (StringUtils.equals((String)control.getKey(), (String)CONTROL_LABEL)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
            String taskId = entryRowEntity.getString("taskid");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("clientType", (Object)"2");
            jsonObject.put("openId", (Object)openId);
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("index", (Object)index);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            HashMap customParams = Maps.newHashMap();
            customParams.put("taskInfo", jsonObject);
            showParameter.setFormId("rim_mobile_failtask_label");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParams((Map)customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "controlCallback");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)callBackData)) {
            return;
        }
        String index = (String)callBackData.get("index");
        this.getModel().deleteEntryRow(ENTRYENTITY, Integer.parseInt(index));
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
    }
}

