/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.mobile.mailcollect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.utils.AwsFpyService;
import org.apache.commons.lang.StringUtils;

public class MyMailListPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(MyMailListPlugin.class);
    public static final String ADD_MORE = "add_more";
    public static final String ENTRYENTITY = "entryentity";
    public static final String UNBAND_BUTTON = "unbound_button";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADD_MORE, UNBAND_BUTTON});
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    private void init() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        Object mailListStr = parentCustomParams.get("mailList");
        String openId = (String)parentCustomParams.get("openId");
        this.getView().getPageCache().put("mailListOpenId", openId);
        JSONArray mailList = JSON.parseArray((String)(mailListStr + ""));
        if (!ObjectUtils.isEmpty((Object)mailList)) {
            for (int i = 0; i < mailList.size(); ++i) {
                JSONObject mailInfo = mailList.getJSONObject(i);
                int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue("mail_address", (Object)mailInfo.getString("mailUser"), row);
            }
        }
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Control control = (Control)eventObject.getSource();
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        String openId = (String)parentCustomParams.get("openId");
        if (StringUtils.equals((String)control.getKey(), (String)ADD_MORE)) {
            HashMap customParams = Maps.newHashMap();
            customParams.put("openId", openId);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("rim_mobile_bind_mail");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setCustomParams((Map)customParams);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "freshList");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((String)control.getKey(), (String)UNBAND_BUTTON)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
            String mailUser = dynamicObject.getString("mail_address");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u89e3\u7ed1\u8be5\u90ae\u7bb1\u5417?%1$s", (String)"MyMailListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), mailUser), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener(UNBAND_BUTTON), null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        String openId = this.getView().getPageCache().get("mailListOpenId");
        JSONObject awsConfig = AwsFpyService.newInstance().getAwsConfig(Long.valueOf(RequestContext.get().getOrgId()));
        String clientId = awsConfig.getString("client_id");
        if (StringUtils.equals((String)actionId, (String)"freshList")) {
            JSONObject param = new JSONObject();
            param.put("openId", (Object)openId);
            param.put("clientId", (Object)clientId);
            param.put("clientType", (Object)"2");
            JSONObject resData = AwsFpyService.newInstance().postAppJson("mymail_list", Long.valueOf(RequestContext.get().getOrgId()), (Map)param);
            LOGGER.info("\u6211\u7684\u90ae\u7bb1\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:" + resData);
            if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
                this.getModel().deleteEntryData(ENTRYENTITY);
                JSONArray mailList = resData.getJSONArray("data");
                mailList.stream().forEach(f -> {
                    JSONObject mailInfo = (JSONObject)f;
                    int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("mail_address", (Object)mailInfo.getString("mailUser"), row);
                });
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        JSONObject awsConfig = AwsFpyService.newInstance().getAwsConfig(Long.valueOf(RequestContext.get().getOrgId()));
        String clientId = awsConfig.getString("client_id");
        if (UNBAND_BUTTON.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
            String mailUser = dynamicObject.getString("mail_address");
            String openId = this.getView().getPageCache().get("mailListOpenId");
            JSONObject unbandParam = new JSONObject();
            unbandParam.put("mailUser", (Object)mailUser);
            unbandParam.put("openId", (Object)openId);
            unbandParam.put("clientId", (Object)clientId);
            unbandParam.put("clientType", (Object)"2");
            JSONObject resData = AwsFpyService.newInstance().postAppJson("unbind_mail", Long.valueOf(RequestContext.get().getOrgId()), (Map)unbandParam);
            LOGGER.info("\u90ae\u7bb1\u53d6\u7968-\u89e3\u7ed1\u90ae\u7bb1\uff0c\u53d1\u7968\u4e91\u8fd4\u56de\u7ed3\u679c\uff1a" + resData);
            if (ResultContant.isSuccess((JSONObject)resData).booleanValue()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u7ed1\u6210\u529f", (String)"MyMailListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getModel().deleteEntryRow(ENTRYENTITY, index);
                this.getView().close();
                return;
            }
            this.getView().showErrorNotification(resData.getString("description"));
        }
    }
}

