/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class AddExpensePlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(AddExpensePlugin.class);
    private static final String EXPENSE_NUM_CACHE = "expense_num";
    private static final String UPDATE_FLAG = "update_flag";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnok_add"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String expenseId = (String)formShowParameter.getCustomParam("expenseId");
        if (StringUtils.isNotEmpty((CharSequence)expenseId)) {
            QFilter filter = new QFilter("expense_id", "=", (Object)expenseId);
            DynamicObject expenseInfo = QueryServiceHelper.queryOne((String)"rim_expense", (String)"expense_id,expense_num,creator_name,expense_time,remark", (QFilter[])filter.toArray());
            if (expenseInfo != null) {
                String expenseNum = expenseInfo.getString(EXPENSE_NUM_CACHE);
                this.getPageCache().put(EXPENSE_NUM_CACHE, expenseNum);
                this.getModel().setValue(EXPENSE_NUM_CACHE, (Object)expenseNum);
                this.getModel().setValue("expense_id", (Object)expenseId);
                this.getModel().setValue("creator_name", (Object)expenseInfo.getString("creator_name"));
                this.getModel().setValue("remark", (Object)expenseInfo.getString("remark"));
                Date expenseTime = expenseInfo.getDate("expense_time");
                this.getModel().setValue("create_time", (Object)expenseTime);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u9500\u5355\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a", (String)"AddExpensePlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey()) || "btnok_add".equals(control.getKey())) {
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            String expense_num = (String)this.getModel().getValue(EXPENSE_NUM_CACHE);
            if (StringUtils.isEmpty((CharSequence)expense_num)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u9500\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddExpensePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            String oldExpenseId = (String)this.getModel().getValue("expense_id");
            String oldExpenseNum = this.getPageCache().get(EXPENSE_NUM_CACHE);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String serials = (String)formShowParameter.getCustomParam("serials");
            String expenseId = StringUtils.isNotEmpty((CharSequence)oldExpenseNum) && StringUtils.isNotEmpty((CharSequence)oldExpenseId) && oldExpenseNum.equals(expense_num) ? oldExpenseId : "rim_invoice" + UUID.randomUUIDZero();
            data.put("creator_name", (String)this.getModel().getValue("creator_name"));
            data.put("serials", serials);
            data.put(EXPENSE_NUM_CACHE, (String)this.getModel().getValue(EXPENSE_NUM_CACHE));
            data.put("remark", (String)this.getModel().getValue("remark"));
            data.put("create_time", this.getModel().getValue("create_time"));
            data.put("expense_id", expenseId);
            data.put("old_expense_id", oldExpenseId);
            data.put("old_expense_num", oldExpenseNum);
            data.put("form_id", "rim_add_expense");
            if ("btnok_add".equals(control.getKey())) {
                try {
                    ExpenseRelationService expenseRelationService = new ExpenseRelationService();
                    expenseRelationService.updateEnterExpense(data, serials);
                }
                catch (MsgException e) {
                    this.getView().showErrorNotification(e.getErrorMsg());
                    return;
                }
                this.getPageCache().put(UPDATE_FLAG, "1");
                this.getModel().setValue("expense_id", null);
                this.getModel().setValue(EXPENSE_NUM_CACHE, null);
                this.getModel().setValue("creator_name", null);
                this.getModel().setValue("creator_name", null);
                this.getModel().setValue("create_time", (Object)new Date());
                this.getModel().setValue("remark", null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AddExpensePlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0\u62a5\u9500\u4fe1\u606f", (String)"AddExpensePlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                this.getView().updateView();
                return;
            }
            this.getView().returnDataToParent(data);
            this.getView().close();
        } else if ("btncancel".equals(control.getKey())) {
            if ("1".equals(this.getPageCache().get(UPDATE_FLAG))) {
                HashMap<String, String> data = new HashMap<String, String>(8);
                data.put("updateBillList", "1");
                this.getView().returnDataToParent(data);
            }
            this.getView().close();
        }
    }
}

