/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.formplugin.query.OpenVoucherDetailService;
import org.apache.commons.lang3.StringUtils;

public class AddVouchPlugin
extends AbstractFormPlugin {
    private static final String VOUCH_NO_CACHE = "vouch_no";
    private static final String DELETE_FLAG = "delete_flag";
    private static final String UPDATE_FLAG = "update_flag";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnok_add"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String openInvoice = (String)customParams.get("openInvoice");
        String vouchid = (String)customParams.get("vouchid");
        String vouchNo = (String)customParams.get(VOUCH_NO_CACHE);
        if (StringUtils.isNotEmpty((CharSequence)vouchid)) {
            this.getModel().setValue("vouchid", (Object)vouchid);
            this.getModel().setValue(VOUCH_NO_CACHE, (Object)vouchNo);
            this.getPageCache().put(VOUCH_NO_CACHE, vouchNo);
            this.getModel().setValue("account_date", (Object)this.getDate((String)customParams.get("account_date")));
            this.getModel().setValue("account_time", (Object)this.getDate((String)customParams.get("account_time")));
            if (StringUtils.isNotEmpty((CharSequence)openInvoice)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnok", "btnok_add"});
            }
        }
    }

    private Date getDate(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new Date();
        }
        return DateUtils.stringToDate((String)str);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey()) || "btnok_add".equals(control.getKey())) {
            Date first;
            Date accountDate = (Date)this.getModel().getValue("account_date");
            if (accountDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddVouchPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            String vouchNo = (String)this.getModel().getValue(VOUCH_NO_CACHE);
            if (StringUtils.isEmpty((CharSequence)vouchNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"AddVouchPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Date account_time = (Date)this.getModel().getValue("account_time");
            if (account_time == null && (first = DateUtils.getFirstDateOfMonth((Date)new Date())).compareTo(accountDate) <= 0) {
                account_time = new Date();
            }
            data.put("account_date", accountDate);
            data.put("account_time", account_time);
            data.put(VOUCH_NO_CACHE, vouchNo);
            String oldVouchNo = this.getPageCache().get(VOUCH_NO_CACHE);
            String oldVouchid = (String)this.getModel().getValue("vouchid");
            String vouchid = StringUtils.isNotEmpty((CharSequence)oldVouchNo) && StringUtils.isNotEmpty((CharSequence)oldVouchid) && oldVouchNo.equals(vouchNo) ? oldVouchid : "rim_invoice" + UUID.randomUUIDZero();
            data.put("vouchid", vouchid);
            data.put("old_vouchid", oldVouchid);
            data.put("form_id", "rim_add_vouch");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            data.put("serials", customParams.get("serials"));
            String isVouchSerials = (String)customParams.get("isVouchSerials");
            String deleteFlag = this.getPageCache().get(DELETE_FLAG);
            if ("btnok_add".equals(control.getKey())) {
                try {
                    if (!"0".equals(deleteFlag) && StringUtils.isNotEmpty((CharSequence)isVouchSerials)) {
                        OpenVoucherDetailService.deleteVouch(isVouchSerials.split(","));
                    }
                    this.getPageCache().put(DELETE_FLAG, "0");
                    this.getPageCache().put(UPDATE_FLAG, "1");
                    OpenVoucherDetailService.updateVouch(data);
                }
                catch (MsgException e) {
                    this.getView().showErrorNotification(e.getErrorMsg());
                    return;
                }
                this.getModel().setValue("vouchid", null);
                this.getModel().setValue(VOUCH_NO_CACHE, null);
                this.getModel().setValue("account_date", (Object)new Date());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AddVouchPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u7ef4\u62a4\u5165\u8d26\u4fe1\u606f", (String)"AddVouchPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0])));
                this.getView().updateView();
                return;
            }
            if (!"0".equals(deleteFlag)) {
                data.put("isVouchSerials", isVouchSerials);
            }
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            if ("1".equals(this.getPageCache().get(UPDATE_FLAG))) {
                HashMap<String, String> data = new HashMap<String, String>(8);
                data.put("updateBillList", "1");
                this.getView().returnDataToParent(data);
            }
            this.getView().close();
        }
    }
}

