/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.query.AttachQueryService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.formplugin.fpzs.FpzsAttachService;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AttachSelectedMobilePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener {
    private static Log LOGGER = LogFactory.getLog(AttachSelectedMobilePlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    private final String[] buttons = new String[]{"operation"};
    private static final String DELETE_RECORD = "deleteRecord";
    private static final String KEY_LEAVE_DAYS = "attach_detail";

    public void registerListener(EventObject event) {
        this.addClickListeners(this.buttons);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)customParams)) {
            return;
        }
        List ids = (List)customParams.get("data");
        LOGGER.info("\u5165\u53c2\u6570\u636e\uff0c[{}]", (Object)customParams);
        this.getPageCache().put("attachIds", JSON.toJSONString((Object)ids));
        this.queryAttach();
    }

    private void queryAttach() {
        this.fillAttachEntryEntity();
    }

    private List<Long> getIdsFromPageCache() {
        List ids = Lists.newArrayList();
        String cacheValue = this.getPageCache().get("attachIds");
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            ids = (List)JSON.parseObject((String)cacheValue, List.class);
        }
        return ids;
    }

    private void fillAttachEntryEntity() {
        this.clearListData(ENTRYENTITY);
        List<Long> ids = this.getIdsFromPageCache();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        AttachQueryService attachQueryService = new AttachQueryService();
        QFilter attachQFilters = new QFilter("id", "in", ids);
        DynamicObject[] invoiceObjects = attachQueryService.loadByFilterOrderBy(attachQFilters, "create_time desc");
        List resultList = Arrays.stream(invoiceObjects).map(attach -> {
            LinkedHashMap temMap = Maps.newLinkedHashMap();
            temMap.put("id", attach.getLong("id"));
            temMap.put("attach_name", attach.getString("attach_name"));
            temMap.put("create_time", DateUtils.format((Date)attach.getDate("create_time"), (String)"yyyy-MM-dd HH:mm:ss"));
            temMap.put("remark", attach.getString("remark"));
            temMap.put("attach_url", FpzsAttachService.getPreviewIconFullUrl(attach));
            return temMap;
        }).collect(Collectors.toList());
        this.getModel().beginInit();
        resultList.stream().forEach(map -> {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            map.entrySet().stream().forEach(modelEntry -> this.getModel().setValue((String)modelEntry.getKey(), modelEntry.getValue(), row));
        });
        this.getModel().endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void clearListData(String var1) {
        this.getModel().deleteEntryData(var1);
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "operation": {
                CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
                if (ArrayUtils.isEmpty((int[])cardEntry.getSelectRows())) {
                    return;
                }
                DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRYENTITY);
                if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                    return;
                }
                HashMap<String, Object> value = new HashMap<String, Object>(3);
                DynamicObject attach = (DynamicObject)dynamicObjectCollection.get(cardEntry.getSelectRows()[0]);
                value.put("id", attach.getLong("id"));
                value.put("operation", new String[]{"delete"});
                value.put("tips", ResManager.loadKDString((String)"\u9644\u4ef6", (String)"AttachSelectedMobilePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("rim_bill_operation_mobile");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DELETE_RECORD));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParams(value);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        String result;
        if (StringUtils.equals((CharSequence)DELETE_RECORD, (CharSequence)closedCallBackEvent.getActionId()) && null != closedCallBackEvent.getReturnData() && StringUtils.equals((CharSequence)"Yes", (CharSequence)(result = (String)(returnData = (HashMap)closedCallBackEvent.getReturnData()).get("result")))) {
            List[] ids = new List[]{this.getIdsFromPageCache()};
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
            LinkedList attachIds = Lists.newLinkedList();
            Arrays.stream(cardEntry.getSelectRows()).forEach(c -> {
                if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                    return;
                }
                DynamicObject object = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(c);
                Long id = object.getLong("id");
                attachIds.add(object.getLong("id"));
                ids[0] = ids[0].stream().filter(b -> id.longValue() != b.longValue()).collect(Collectors.toList());
            });
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String indexPageId = (String)customParams.get("indexPageId");
            AbstractOperateService.deleteSelected(indexPageId, null, attachIds);
            this.getPageCache().remove("attachIds");
            this.getPageCache().put("attachIds", JSON.toJSONString((Object)ids[0]));
            this.getModel().deleteEntryRows(ENTRYENTITY, cardEntry.getSelectRows());
            this.getView().updateView();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)("AttachSelectedRowClick" + RequestContext.get().getUserId())))) {
            return;
        }
        CacheHelper.put((String)("AttachSelectedRowClick" + RequestContext.get().getUserId()), (String)"1", (int)3);
        int currentRow = evt.getRow();
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        value.put("row", currentRow);
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currentRow);
        value.put("id", dynamicObject.getLong("id"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String indexPageId = (String)customParams.get("indexPageId");
        boolean freshAttachNum = true;
        value.put("freshAttachNum", freshAttachNum);
        value.put(ENTRYENTITY, ENTRYENTITY);
        value.put("attach_name", "attach_name");
        value.put("attach_remark", "remark");
        value.put("indexPageId", indexPageId);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("rim_h5_attach_detail");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_LEAVE_DAYS));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
        H5PluginService.setCommonParam(value, (Map)this.getView().getFormShowParameter().getCustomParams());
        showParameter.setCustomParams(value);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        this.queryAttach();
    }
}

