/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.deduction.ReadyDeductSelectSerive;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.UUID;
import org.apache.commons.compress.utils.Lists;

public class DeductionReadySelectPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"submit"});
    }

    public void afterCreateNewData(EventObject e) {
        String queryType;
        JSONObject param;
        this.getView().setVisible(Boolean.FALSE, new String[]{"not_deductible_type"});
        Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
        if (parentCustomParams != null && (param = (JSONObject)parentCustomParams.get("param")) != null && "undeduction".equals(queryType = param.getString("querytype"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"not_deductible_type"});
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("submit".equals(control.getKey())) {
            Object taxPeriod = this.getModel().getValue("tax_period");
            if (taxPeriod == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u63a7\u6240\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"HistoryDeductStatisticsPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Date taxPeriodDate = (Date)taxPeriod;
            Map parentCustomParams = this.getView().getFormShowParameter().getCustomParams();
            if (parentCustomParams != null) {
                JSONObject param = (JSONObject)parentCustomParams.get("param");
                String queryType = param.getString("querytype");
                JSONArray primaryKeyValues = param.getJSONArray("invoiceIds");
                DynamicObject[] mainObject = BusinessDataServiceHelper.load((String)"rim_invoice", (String)MetadataUtil.getFields((String)"rim_invoice"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                ArrayList failList = Lists.newArrayList();
                if (mainObject.length > 0) {
                    ReadyDeductSelectSerive selectSerive = new ReadyDeductSelectSerive();
                    String batchNo = UUID.getBatchNo((String)"READY");
                    JSONArray taxDeductInvoiceArray = new JSONArray();
                    ArrayList transportDeductSerialNos = Lists.newArrayList();
                    for (DynamicObject main : mainObject) {
                        String taxPeriodDateStr;
                        SimpleDateFormat sdf;
                        String invoiceDateStr;
                        int result;
                        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)main.get("invoice_type"));
                        Date invoiceDate = main.getDate("invoice_date");
                        if (invoiceDate != null && (result = (invoiceDateStr = (sdf = new SimpleDateFormat("yyyy-MM")).format(invoiceDate)).compareTo(taxPeriodDateStr = sdf.format(taxPeriodDate))) > 0) {
                            String invoiceCode = main.getString("invoice_code");
                            String invoiceNo = main.getString("invoice_no");
                            String invoiceInfo = StringUtils.isEmpty((CharSequence)invoiceCode) ? invoiceNo : invoiceCode + "-" + invoiceNo;
                            failList.add(invoiceInfo);
                            continue;
                        }
                        if ("undeduction".equals(queryType) || "deduction".equals(queryType) || "drawback".equals(queryType)) {
                            String notDeductibleType = (String)this.getModel().getValue("not_deductible_type");
                            if (StringUtils.isEmpty((CharSequence)notDeductibleType) && "undeduction".equals(queryType)) {
                                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u62b5\u6263\u52fe\u9009\u987b\u586b\u5199\u4e0d\u62b5\u6263\u539f\u56e0", (String)"SelectInvoiceExcelService_64", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                return;
                            }
                            taxDeductInvoiceArray.add((Object)this.addTaxDeductInvoiceArray(main, invoiceType, taxPeriodDate, queryType, notDeductibleType));
                            continue;
                        }
                        transportDeductSerialNos.add(main.getString("serial_no"));
                    }
                    selectSerive.readyDeductSelect(taxDeductInvoiceArray, "4", taxPeriodDate, batchNo);
                    selectSerive.readyDeductTransport((List)transportDeductSerialNos, "2", taxPeriodDate, batchNo);
                    if (failList.isEmpty()) {
                        this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u63d0\u4ea4\u9884\u52fe\u9009\u6210\u529f", (String)"ReadyDudectSelectPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    } else if (failList.size() == mainObject.length) {
                        this.getView().returnDataToParent((Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u9884\u52fe\u9009\u5931\u8d25\uff1a%s \u5f00\u7968\u65e5\u671f\u4e0d\u5f97\u5c0f\u4e8e\u7a0e\u6b3e\u6240\u5c5e\u671f", (String)"ReadyDudectSelectPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]), failList));
                    } else {
                        this.getView().returnDataToParent((Object)String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u9884\u52fe\u9009\u6210\u529f,\u90e8\u5206\u53d1\u7968\u6570\u636e\u63d0\u4ea4\u5931\u8d25\uff1a%s \u5f00\u7968\u65e5\u671f\u4e0d\u5f97\u5c0f\u4e8e\u7a0e\u6b3e\u6240\u5c5e\u671f", (String)"ReadyDudectSelectPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0]), failList));
                    }
                    this.getView().close();
                    return;
                }
            }
            this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ReadyDudectSelectConfirmPlugin_48", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    private JSONObject addTaxDeductInvoiceArray(DynamicObject main, Long invoiceType, Date taxPeriodDate, String queryType, String notDeductibleType) {
        JSONObject example = new JSONObject();
        example.put("serial_no", (Object)main.getString("serial_no"));
        example.put("invoice_type", (Object)invoiceType);
        String deductionPurpose = "1";
        if ("undeduction".equals(queryType)) {
            deductionPurpose = "2";
            example.put("not_deductible_type", (Object)notDeductibleType);
        } else if ("drawback".equals(queryType)) {
            deductionPurpose = "3";
        }
        example.put("deduction_purpose", (Object)deductionPurpose);
        if (!InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType) && !InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType)) {
            example.put("invoice_code", (Object)main.getString("invoice_code"));
        }
        example.put("invoice_no", (Object)main.getString("invoice_no"));
        example.put("effective_tax_amount", main.get("effective_tax_amount"));
        example.put("tax_period", (Object)DateUtils.format((Date)taxPeriodDate, (String)"yyyyMM"));
        example.put("authenticate_flag", (Object)"4");
        return example;
    }
}

