/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.utils.RimConfigUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseDetailPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ExpenseDetailPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BillShowParameter showParameter = new BillShowParameter();
        String entityid = (String)customParams.get("entityid");
        showParameter.setPkId(customParams.get("pkId"));
        showParameter.setFormId(entityid);
        showParameter.setCaption("");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setStatus(OperationStatus.VIEW);
        String appId = this.getAppId(entityid);
        logger.info("\u6253\u5f00\u62a5\u9500\u5355\u8be6\u60c5{},{},{}", new Object[]{entityid, appId, customParams.get("pkId")});
        showParameter.setAppId(appId);
        showParameter.getOpenStyle().setTargetKey("flexpanelap");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "detail");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getView().close();
    }

    private String getAppId(String formId) {
        try {
            MainEntityType mainEntityType;
            AppInfo app;
            boolean isAllUserApp;
            String apptype = RimConfigUtils.getConfig((String)"expense_app");
            if (StringUtils.isEmpty((CharSequence)apptype) || "esc".equals(apptype)) {
                if ("er_dailyreimbursebill".equals(formId) || "er_publicreimbursebill".equals(formId)) {
                    return "exp";
                }
                if ("er_tripreimbursebill".equals(formId)) {
                    return "tra";
                }
            }
            if (isAllUserApp = (app = AppMetadataCache.getAppInfo((String)(mainEntityType = EntityMetadataCache.getDataEntityType((String)formId)).getAppId())).isAllUserApp()) {
                return app.getAppId();
            }
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            boolean isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)app.getId());
            if (isPermission) {
                return app.getAppId();
            }
            List pubApps = mainEntityType.getPermissionControlType().getPublishApps();
            if (pubApps != null && !pubApps.isEmpty()) {
                for (String appId : pubApps) {
                    app = AppMetadataCache.getAppInfo((String)appId);
                    isAllUserApp = app.isAllUserApp();
                    if (isAllUserApp) {
                        return app.getAppId();
                    }
                    isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)appId);
                    if (!isPermission) continue;
                    return AppMetadataCache.getAppNumberById((String)appId);
                }
            }
            if ("er_dailyreimbursebill".equals(formId) || "er_publicreimbursebill".equals(formId)) {
                return "exp";
            }
            if ("er_tripreimbursebill".equals(formId)) {
                return "tra";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

