/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.fpzs.FpzsMainService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.service.WechatCardService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MobileIndexMinUtils;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.collections.MapUtils;

public class InvoiceCheckListMobPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(InvoiceCheckListMobPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    public static final String CACHE_SELECTED_INVOICE = "cache_selected_invoice";
    public static final String CACHE_SELECTED_ATTACH = "cache_selected_attach";
    public static final String CACHE_SELECTED_CURRENCY = "cache_selected_currency";
    private static int timeOut = 7200;

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"bar_push"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)customParams)) {
            return;
        }
        String ids = (String)customParams.get("data");
        String backdata = (String)customParams.get("backdata");
        String cardData = (String)customParams.get("cardData");
        String access_token = (String)customParams.get("access_token");
        customParams.remove("data");
        customParams.remove("backdata");
        customParams.remove("cardData");
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)ids)) {
            logger.info("\u5165\u53c2\u6570\u636e\uff0c[{}]", (Object)customParams);
            this.setIdsToPageCache(ids);
            this.fillEntryEntity();
        } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)backdata)) {
            logger.info("\u5165\u53c2\u6570\u636e\uff0c[{}]", (Object)customParams);
            String mainPageId = (String)customParams.get("indexPageId");
            JSONObject invoiceList = new JSONObject();
            try {
                invoiceList = WechatCardService.getInstance().getInvoiceJSON(backdata, mainPageId, access_token, customParams);
            }
            catch (Exception exception) {
                logger.error("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)exception);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5fae\u4fe1\u7968\u5939\u6570\u636e\u5931\u8d25\uff1a%1$s", (String)"InvoiceCheckListMobPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), exception.getMessage()));
                return;
            }
            this.checkWechatInvoice(invoiceList, mainPageId);
        } else if (org.apache.commons.lang.StringUtils.isNotBlank((String)cardData)) {
            String indexPageId = (String)customParams.get("indexPageId");
            JSONArray item_list = JSONArray.parseArray((String)cardData);
            JSONObject invoiceList = WechatCardService.getInstance().convertCheckInfoBatch(item_list, indexPageId, customParams);
            this.checkWechatInvoice(invoiceList, indexPageId);
        }
    }

    private void checkWechatInvoice(JSONObject invoiceList, String mainPageId) {
        JSONArray success = invoiceList.getJSONArray("success");
        JSONArray fail = invoiceList.getJSONArray("fail");
        if ((success == null || success.isEmpty()) && (fail == null || fail.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u5931\u8d25", (String)"InvoiceCheckListMobPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)"cancel");
            this.getView().close();
            return;
        }
        if (success != null && !success.isEmpty()) {
            String newIds = success.toJavaList(JSONObject.class).stream().map(v -> v.getLong("mainId").toString()).collect(Collectors.joining(","));
            logger.info("\u67e5\u9a8c\u901a\u8fc7\u7684\u53d1\u7968id\uff0c[{}]", (Object)newIds);
            this.setIdsToPageCache(newIds);
            this.fillEntryEntity();
        }
        if (fail != null && !fail.isEmpty()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            logger.info("\u67e5\u9a8c\u672a\u901a\u8fc7\u53d1\u7968\u4fe1\u606f\uff0c[{}]", (Object)fail.toJSONString());
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fail.size());
            for (int i = 0; i < fail.size(); ++i) {
                JSONObject failJSON = fail.getJSONObject(i);
                String errorInfo = "[" + failJSON.getString("errcode") + "]" + failJSON.getString("description");
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)errorInfo) && errorInfo.length() > 25) {
                    errorInfo = errorInfo.substring(0, 25) + "...";
                }
                this.getModel().setValue("error_info", (Object)errorInfo, rows[i]);
                Date invoice_date = DateUtils.stringToDate((String)failJSON.getString("invoice_date"), (String)"yyyyMMdd");
                this.getModel().setValue("invoice_date", (Object)format.format(invoice_date), rows[i]);
                this.getModel().setValue("buyer_name", failJSON.get((Object)"buyer_name"), rows[i]);
                this.getModel().setValue("saler_name", failJSON.get((Object)"saler_name"), rows[i]);
                this.getModel().setValue("total_amount", failJSON.get((Object)"total_amount"), rows[i]);
                CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
                cardEntry.setChildVisible(true, rows[i], new String[]{"error_tips_flex", "error_tips_flex1"});
                cardEntry.setChildVisible(false, rows[i], new String[]{"cardentryflexpanelap21", "payer_party_name", "place", "exit", "remark", "tax_authority_name", "cardentryflexpanelap3"});
                failJSON.put("row", (Object)rows[i]);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (org.apache.commons.lang.StringUtils.equals((String)"bar_push", (String)key)) {
            List<Long> invoiceIdsList;
            ArrayList attachIds = Lists.newArrayList();
            String pageId = (String)this.getView().getFormShowParameter().getCustomParams().get("indexPageId");
            String attachCacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_ATTACH));
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)attachCacheStr)) {
                JSONArray attachObj = JSONArray.parseArray((String)attachCacheStr);
                attachIds.addAll(attachObj.toJavaList(Long.class));
            }
            if ((invoiceIdsList = this.getIdsFromPageCache()).isEmpty() && attachIds.isEmpty()) {
                this.getView().returnDataToParent((Object)"cancel");
                this.getView().close();
                return;
            }
            Map<Long, BigDecimal> invoiceIds = this.getInvoiceMapByMainId(invoiceIdsList);
            Map<Long, Long> currencyIds = this.getCurrencyMapByMainId(invoiceIdsList);
            String minpageId = MobileIndexMinUtils.mobileIndex((IFormView)this.getView());
            if (minpageId != null) {
                Map params = FpzsMainService.getCustomParam((String)this.getView().getPageId());
                String indexPageId = (String)params.get("indexPageId");
                InvoiceCheckListMobPlugin.addSelected(indexPageId, invoiceIds, attachIds, currencyIds);
                AbstractOperateService operate = AbstractOperateService.newInstance("push_pc", this);
                operate.operate();
                CacheHelper.remove((String)(indexPageId + CACHE_SELECTED_INVOICE));
                CacheHelper.remove((String)(indexPageId + CACHE_SELECTED_ATTACH));
                CacheHelper.remove((String)(indexPageId + CACHE_SELECTED_CURRENCY));
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                customParams.put("invoiceIds", invoiceIds);
                customParams.put("attachIds", attachIds);
                customParams.put("currencyIds", currencyIds);
                this.getView().returnDataToParent(customParams);
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("import".equals(closedCallBackEvent.getReturnData()) || "cancel".equals(closedCallBackEvent.getReturnData())) {
            this.getView().returnDataToParent(closedCallBackEvent.getReturnData());
            this.getView().close();
        }
    }

    public Map<String, Object> getCustomParams() {
        String pageId = this.getView().getPageId();
        Map<String, Object> params = new HashMap(8);
        params = FpzsMainService.getCustomParam((String)pageId);
        params.put("org_id", params.get("orgId"));
        return params;
    }

    public static void addSelected(String pageId, Map<Long, BigDecimal> invoiceIds, List<Long> attachIds, Map<Long, Long> currencyIds) {
        logger.info("\u6dfb\u52a0\u5df2\u9009\u53d1\u7968{},{},{},{}", new Object[]{pageId, invoiceIds, attachIds, currencyIds});
        if (!CollectionUtils.isEmpty(currencyIds)) {
            String cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_CURRENCY));
            JSONObject array = new JSONObject();
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)cacheStr)) {
                array = JSONObject.parseObject((String)cacheStr);
            }
            for (Map.Entry<Long, Long> entry : currencyIds.entrySet()) {
                array.put(entry.getKey().toString(), (Object)entry.getValue());
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_CURRENCY), (String)array.toJSONString(), (int)timeOut);
        }
        InvoiceCheckListMobPlugin.addSelected(pageId, invoiceIds, attachIds);
    }

    public static void addSelected(String pageId, Map<Long, BigDecimal> invoiceIds, List<Long> attachIds) {
        String cacheStr;
        logger.info("\u6dfb\u52a0\u5df2\u9009\u53d1\u7968{},{},{}", new Object[]{pageId, invoiceIds, attachIds});
        Boolean refresh = Boolean.FALSE;
        if (!CollectionUtils.isEmpty(invoiceIds)) {
            cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_INVOICE));
            JSONObject array = new JSONObject(true);
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)cacheStr)) {
                array = JSONObject.parseObject((String)cacheStr, (Feature[])new Feature[]{Feature.OrderedField});
            }
            for (Map.Entry<Long, BigDecimal> entry : invoiceIds.entrySet()) {
                array.put(entry.getKey().toString(), (Object)entry.getValue());
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_INVOICE), (String)array.toJSONString(), (int)7200);
            logger.info("\u5df2\u9009\u53d1\u7968\u7f13\u5b58\u7ed3\u679c\uff1a{}", (Object)array);
            refresh = Boolean.TRUE;
        }
        if (!CollectionUtils.isEmpty(attachIds)) {
            cacheStr = CacheHelper.get((String)(pageId + CACHE_SELECTED_ATTACH));
            LinkedHashSet<Long> attachSet = new LinkedHashSet<Long>(attachIds);
            if (!org.apache.commons.lang.StringUtils.isEmpty((String)cacheStr)) {
                JSONArray array = JSONArray.parseArray((String)cacheStr);
                for (int i = 0; i < array.size(); ++i) {
                    attachSet.add(array.getLong(i));
                }
            }
            CacheHelper.put((String)(pageId + CACHE_SELECTED_ATTACH), (String)SerializationUtils.toJsonString(attachSet), (int)timeOut);
            refresh = Boolean.TRUE;
        }
        if (refresh.booleanValue()) {
            String pushType = CacheHelper.get((String)(pageId + "pushType"));
            CacheHelper.put((String)(pageId + "refresh"), (String)"1", (int)timeOut);
            if (!"poll".equals(pushType)) {
                MsgSendFactory.getSender().send("mob" + pageId, "refresh");
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int currentRow = evt.getRow();
        String errorStr = (String)this.getModel().getValue("error_info", currentRow);
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)errorStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fae\u4fe1\u5361\u5305\u83b7\u53d6\u7684\u67e5\u9a8c\u4e0d\u901a\u8fc7\u53d1\u7968\uff0c\u65e0\u6cd5\u67e5\u770b\u8be6\u60c5\u9875\u9762", (String)"InvoiceCheckListMobPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)CacheHelper.get((String)("InvoiceSelectedRowClick" + RequestContext.get().getUserId())))) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
            return;
        }
        CacheHelper.put((String)("InvoiceSelectedRowClick" + RequestContext.get().getUserId()), (String)"1", (int)3);
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        value.put("row", currentRow);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currentRow);
        value.put("mainIds", dynamicObject.getString("id"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String indexPageId = (String)customParams.get("indexPageId");
        List attachIds = (List)customParams.get("attachIds");
        if (attachIds == null) {
            attachIds = Lists.newArrayList();
        }
        value.put("indexPageId", indexPageId);
        value.put("attachIds", attachIds);
        boolean freshAttachNum = true;
        value.put("freshAttachNum", freshAttachNum);
        value.put("inv_attach_cnt", "inv_attach_cnt");
        value.put("attach_ids", "attach_ids");
        boolean allowEdit = false;
        boolean addAttach = true;
        value.put("allowEdit", allowEdit);
        value.put("allowDel", allowEdit);
        value.put("addAttach", addAttach);
        value.put("relationType", "3");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("rim_h5_inv_update");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "wx_check_detail"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        H5PluginService.setCommonParam(value, (Map)this.getView().getFormShowParameter().getCustomParams());
        FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
        showParameter.setCustomParams(value);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void fillEntryEntity() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        List<Long> ids = this.getIdsFromPageCache();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        String pageId = (String)this.getView().getFormShowParameter().getCustomParams().get("indexPageId");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        QFilter idsFilter = new QFilter("delete", "=", (Object)"1").and("id", "in", ids);
        filterList.add(idsFilter);
        H5InvoiceListService h5InvoiceListService = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
        h5InvoiceListService.loadList(filterList, null);
        int successRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < successRowCount; ++i) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
            cardEntry.setChildVisible(false, i, new String[]{"error_tips_flex", "error_tips_flex1"});
            Object attachIds = this.getModel().getValue("attach_ids", i);
            if (ObjectUtils.isEmpty((Object)attachIds)) continue;
            String attachIdsStr = String.valueOf(attachIds);
            List<Long> attachIdList = Arrays.stream(StringUtils.split((String)attachIdsStr, (String)",")).map(invAttachId -> Long.valueOf(invAttachId)).collect(Collectors.toList());
            AbstractOperateService.addSelected(pageId, null, attachIdList);
        }
    }

    private List<Long> getIdsFromPageCache() {
        List<Object> ids = Lists.newArrayList();
        String cacheValue = this.getPageCache().get("invoiceIds");
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)cacheValue)) {
            ids = Arrays.stream(cacheValue.split(",")).filter(v -> org.apache.commons.lang.StringUtils.isNotBlank((String)v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
        }
        return ids;
    }

    private void setIdsToPageCache(String newIds) {
        List newIdList = Arrays.stream(newIds.split(",")).filter(v -> org.apache.commons.lang.StringUtils.isNotBlank((String)v)).map(v -> Long.parseLong(v)).collect(Collectors.toList());
        List<Long> ids = this.getIdsFromPageCache();
        ids.addAll(newIdList);
        String idList = ids.stream().map(v -> v.toString()).collect(Collectors.joining(","));
        this.getPageCache().put("invoiceIds", idList);
    }

    private Map<Long, BigDecimal> getInvoiceMapByMainId(List<Long> mainIds) {
        LinkedHashMap<Long, BigDecimal> invoiceMap = new LinkedHashMap<Long, BigDecimal>(16);
        if (CollectionUtils.isEmpty(mainIds)) {
            return invoiceMap;
        }
        for (Long id : mainIds) {
            QFilter idFilter;
            DynamicObject mainObject;
            if (id == null || id < 0L || ObjectUtils.isEmpty((Object)(mainObject = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id,total_amount", (QFilter[])(idFilter = new QFilter("id", "=", (Object)id)).toArray())))) continue;
            Long mainId = mainObject.getLong("id");
            BigDecimal totalAmount = mainObject.getBigDecimal("total_amount");
            invoiceMap.put(mainId, totalAmount);
        }
        return invoiceMap;
    }

    private Map<Long, Long> getCurrencyMapByMainId(List<Long> mainIds) {
        HashMap<Long, Long> currencyMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty(mainIds)) {
            return currencyMap;
        }
        QFilter idFilter = new QFilter("id", "in", mainIds);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,currencyid", (QFilter[])idFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return currencyMap;
        }
        for (DynamicObject mainObject : collection) {
            Long mainId = mainObject.getLong("id");
            long currencyId = DynamicObjectUtil.getDynamicObjectLongValue((Object)mainObject.get("currencyid"));
            currencyMap.put(mainId, currencyId);
        }
        return currencyMap;
    }
}

