/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.formplugin.query.OpenInvoiceDetailService;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceDetailListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final InputInvoiceTypeEnum[] RATEINCLOUD = new InputInvoiceTypeEnum[]{InputInvoiceTypeEnum.ORDINARY_ELECTRON, InputInvoiceTypeEnum.SPECIAL_ELECTRON, InputInvoiceTypeEnum.ORDINARY_PAPER, InputInvoiceTypeEnum.SPECIAL_PAPER, InputInvoiceTypeEnum.ORDINARY_ROLL, InputInvoiceTypeEnum.TOLL_ELECTRON, InputInvoiceTypeEnum.HGJKS};
    private static final Log LOGGER = LogFactory.getLog(InvoiceDetailListPlugin.class);
    private String orgField = "org";
    private static final String BAR_EXIT = "tblclose";
    private String taxOrgField = "tax_org";

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_EXIT});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field.startsWith("org") || field.startsWith("tax_org")) {
            HasPermOrgResult result;
            if (field.contains("tax")) {
                if (TenantUtils.useNewTaxOrg().booleanValue()) {
                    args.addCustomParam("orgFuncId", (Object)"40");
                } else {
                    args.addCustomParam("orgFuncId", (Object)"10");
                }
            }
            if ((result = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_query_detail", (String)"47150e89000000ac")) == null || result.hasAllOrgPerm()) {
                return;
            }
            QFilter idsFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            args.addCustomQFilter(idsFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        this.loadOrgCombo(commonFilterColumns, this.orgField);
        this.loadOrgCombo(commonFilterColumns, this.taxOrgField);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void packageData(PackageDataEvent e) {
        Object[] formatValue;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String key = columnDesc.getKey();
        if ("tax_rate".equals(key) && (formatValue = (Object[])e.getFormatValue())[1] != null) {
            BigDecimal percent = new BigDecimal(100);
            BigDecimal value = (BigDecimal)formatValue[1];
            BigDecimal multiply = value.multiply(percent).setScale(2, 4);
            e.setFormatValue((Object)multiply);
        }
    }

    public void beforeBindData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParam("invoicetype") != null) {
            BillList list;
            long invoiceCode = (Long)this.getView().getFormShowParameter().getCustomParam("invoicetype");
            InputInvoiceTypeEnum invoiceType = InputInvoiceTypeEnum.getInvoiceType((Long)invoiceCode);
            if (invoiceType == InputInvoiceTypeEnum.ORDINARY_ROLL) {
                list = (BillList)this.getControl("billlistap");
                list.getView().setVisible(Boolean.FALSE, new String[]{"deduction_flag", "transport_deduction", "proxy_mark", "proxy_saler_name", "proxy_saler_tax_no"});
            }
            if (invoiceType == InputInvoiceTypeEnum.ORDINARY_PAPER) {
                list = (BillList)this.getControl("billlistap");
                list.getView().setVisible(Boolean.FALSE, new String[]{"deduction_flag", "transport_deduction"});
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("invoice_no".equals(args.getFieldName()) || "custom_declaration_no".equals(args.getFieldName())) {
            Object focusRowPkId;
            BillList list = (BillList)this.getControl("billlistap");
            String billFormId = list.getBillFormId();
            DynamicObject invoiceObj = QueryServiceHelper.queryOne((String)billFormId, (String)"serial_no", (QFilter[])new QFilter("id", "=", focusRowPkId = this.getFocusRowPkId()).toArray());
            if (invoiceObj != null) {
                DynamicObject mainObj = QueryServiceHelper.queryOne((String)"rim_invoice", (String)"id", (QFilter[])new QFilter("serial_no", "=", (Object)invoiceObj.getString("serial_no")).toArray());
                if (mainObj != null) {
                    OpenInvoiceDetailService.openEditViewByMainId((AbstractFormPlugin)this, mainObj.getLong("id"));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"InvoiceDetailListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0d\u5b58\u5728", (String)"InvoiceDetailListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            args.setCancel(true);
        }
    }

    private void loadOrgCombo(List<FilterColumn> filterColumnList, String type) {
        CommonFilterColumn orgColumn;
        if (type != null && (orgColumn = this.getOrgFilterColumn(filterColumnList, type)) != null) {
            Pair<String, List<ComboItem>> orgList = this.getOrgComboItem(type);
            String serialDetail = (String)this.getView().getFormShowParameter().getCustomParam("serialDetail");
            Boolean isSerialDetail = !StringUtils.isEmpty((CharSequence)serialDetail) && "true".equals(serialDetail);
            if (orgList != null && orgList.getLeft() != null) {
                if (!"tax_org".equals(type)) {
                    orgColumn.setDefaultValue((String)orgList.getLeft());
                }
                if ("org".equals(type) && isSerialDetail.booleanValue()) {
                    orgColumn.setDefaultValue(null);
                }
                orgColumn.setType("enum");
                orgColumn.setComboItems((List)orgList.getRight());
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        if (CollectionUtils.isEmpty((Collection)filters)) {
            return;
        }
        for (QFilter filter : filters) {
            if (!filter.getProperty().contains("tax_rate")) continue;
            BigDecimal value = new BigDecimal(filter.getValue().toString());
            filter.__setValue((Object)value.divide(BigDecimal.valueOf(100L), 4, 4));
            break;
        }
    }

    private CommonFilterColumn getOrgFilterColumn(List<FilterColumn> filterColumnList, String orgType) {
        if (orgType == null) {
            return null;
        }
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(orgType + ".") || !(filterColumn instanceof CommonFilterColumn)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return null;
    }

    private Pair<String, List<ComboItem>> getOrgComboItem(String field) {
        if (field != null && (this.taxOrgField != null || this.orgField != null)) {
            String orgListCache = "orgListCache";
            String orgListCacheString = this.getPageCache().get(orgListCache);
            if ("hasAllOrgPerm".equals(orgListCacheString)) {
                return null;
            }
            String orgCacheKey = field + "orgList";
            String orgCacheString = this.getPageCache().get(orgCacheKey);
            List orgList = new ArrayList();
            if (orgCacheString == null) {
                HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_query_detail", (String)"47150e89000000ac");
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    ORM orm = ORM.create();
                    QFilter idQFilter = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                    if (this.taxOrgField != null && field.startsWith(this.taxOrgField)) {
                        idQFilter = TenantUtils.useNewTaxOrg().booleanValue() ? idQFilter.and(new QFilter("view.number", "=", (Object)"40")) : idQFilter.and(new QFilter("view.number", "=", (Object)"10_taxc"));
                    } else if (this.orgField != null && field.startsWith(this.orgField)) {
                        idQFilter = idQFilter.and(new QFilter("view.number", "=", (Object)"10"));
                    }
                    DynamicObjectCollection col = orm.query("bos_org_structure", "org.id as id,org.name as name,parent.id", new QFilter[]{idQFilter}, "org.number");
                    for (DynamicObject org : col) {
                        if (org == null) continue;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("id", String.valueOf(org.getPkValue()));
                        hashMap.put("name", org.getString("name"));
                        orgList.add(hashMap);
                    }
                } else {
                    this.getPageCache().put(orgListCache, "hasAllOrgPerm");
                    return null;
                }
                this.getPageCache().put(orgCacheKey, SerializationUtils.toJsonString(orgList));
            } else {
                orgList = (List)SerializationUtils.fromJsonString((String)orgCacheString, orgList.getClass());
            }
            String orgID = String.valueOf(RequestContext.get().getOrgId());
            String defOrg = null;
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(orgList.size());
            int orgIndex = -1;
            int index = -1;
            for (Map map : orgList) {
                ++index;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString((String)map.get("name")));
                item.setValue((String)map.get("id"));
                combos.add(item);
                if (defOrg == null) {
                    defOrg = item.getValue();
                }
                if (!orgID.equals(item.getValue())) continue;
                defOrg = orgID;
                orgIndex = index;
            }
            if (orgIndex > 0) {
                Collections.swap(combos, 0, orgIndex);
            }
            return Pair.of(defOrg, combos);
        }
        return null;
    }
}

