/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.lang3.StringUtils;

public class InvoiceQueryConfigPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long id = BigDecimalUtil.transDecimal((Object)this.getModel().getValue("id")).longValue();
        if (id <= 0L) {
            String configtype = (String)this.getModel().getValue("configtype");
            String querytype = (String)this.getModel().getValue("querytype");
            String invoicetype = (String)this.getModel().getValue("invoicetype");
            this.loadDefault(configtype, querytype, invoicetype);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("configtype".equals(name) || "querytype".equals(name) || "invoicetype".equals(name)) {
            ChangeData[] changeDatas = e.getChangeSet();
            String newValue = changeDatas[0].getNewValue().toString();
            String configtype = this.getValue(newValue, name, "configtype");
            String querytype = this.getValue(newValue, name, "querytype");
            String invoicetype = this.getValue(newValue, name, "invoicetype");
            if ("1".equals(configtype) && !"invoicetype".equals(name)) {
                this.loadDefault(configtype, querytype, invoicetype);
            } else {
                configtype = (String)this.getModel().getValue("configtype");
            }
        }
    }

    private void loadDefault(String configtype, String querytype, String invoicetype) {
        if ("1".equals(configtype)) {
            this.getModel().deleteEntryData("entryentity");
            List<String> list = InvoiceOperateService.getToolItems(querytype, invoicetype);
            this.getModel().deleteEntryData("entryentity");
            for (String itemKey : list) {
                int index = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("itemkey", (Object)itemKey, index);
                this.getModel().setValue("show", (Object)true, index);
                this.getModel().setValue("itemname", (Object)InvoiceOperateService.getItemName(itemKey), index);
            }
        }
    }

    private String getValue(String newValue, String changeProperty, String field) {
        if (field.equals(changeProperty)) {
            return newValue;
        }
        return (String)this.getModel().getValue(field);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save) {
            String billNo;
            DynamicObject obj;
            if ("1".equals(this.getModel().getValue("configtype"))) {
                this.getModel().setValue("invoicetype", (Object)"");
            }
            if ((obj = QueryServiceHelper.queryOne((String)"rim_query_config", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)(billNo = this.getBillNo())).toArray())) != null && !obj.get("id").equals(this.getModel().getValue("id"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u91cd\u590d%1$s", (String)"InvoiceQueryConfigPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), billNo), Integer.valueOf(5000));
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("billno", (Object)billNo);
        }
    }

    private String getBillNo() {
        return StringUtils.trimToEmpty((String)((String)this.getModel().getValue("configtype"))) + StringUtils.trimToEmpty((String)((String)this.getModel().getValue("querytype"))) + StringUtils.trimToEmpty((String)((String)this.getModel().getValue("invoicetype")));
    }
}

