/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.PermissionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;

public class InvoiceQueryDetailPlugin
extends AbstractListPlugin
implements TreeNodeClickListener {
    private static final String KEY_TYPE_TREE = "typetree";
    private static final String KEY_DATA_FLEX = "data_flex";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        InputInvoiceTypeEnum[] invoiceTypes;
        String serialNoMapStr = (String)this.getView().getFormShowParameter().getCustomParam("serialNoMapStr");
        Map typeSerialNoMap = null;
        if (serialNoMapStr != null && !"".equals(serialNoMapStr)) {
            typeSerialNoMap = (Map)SerializationUtils.fromJsonString((String)serialNoMapStr, Map.class);
        }
        TreeView tree = (TreeView)this.getView().getControl(KEY_TYPE_TREE);
        if (typeSerialNoMap != null && typeSerialNoMap.size() > 0) {
            ArrayList<InputInvoiceTypeEnum> invoiceTypeList = new ArrayList<InputInvoiceTypeEnum>(typeSerialNoMap.size());
            for (String invoiceTypeStr : typeSerialNoMap.keySet()) {
                if (ObjectUtils.isEmpty((Object)invoiceTypeStr)) continue;
                Long invoiceType = Long.parseLong(invoiceTypeStr);
                invoiceTypeList.add(InputInvoiceTypeEnum.getInvoiceType((Long)invoiceType));
            }
            invoiceTypes = invoiceTypeList.toArray(new InputInvoiceTypeEnum[0]);
        } else {
            invoiceTypes = InputInvoiceTypeEnum.getDetialType();
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(8);
        for (InputInvoiceTypeEnum type : invoiceTypes) {
            TreeNode node = new TreeNode();
            node.setId(type.getCode() + "");
            node.setText(type.getName());
            list.add(node);
        }
        tree.addNodes(list);
        tree.focusNode((TreeNode)list.get(0));
        tree.treeNodeClick(null, ((TreeNode)list.get(0)).getId());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map typeSerialNoMap;
        List serialNos;
        ArrayList filters = Lists.newArrayList();
        Long nodeId = Long.parseLong((String)evt.getNodeId());
        String invoiceType = InputInvoiceTypeEnum.getInvoiceType((Long)nodeId).getName();
        String entity = InputInvoiceTypeEnum.getEntity((Long)nodeId);
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId(entity);
        showParameter.setShowTitle(true);
        QFilter qFilter = null;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_invoice_query_detail", (String)"47150e89000000ac");
        boolean isAdmin = hasPermOrgResult.hasAllOrgPerm();
        if (!isAdmin) {
            QFilter orgFilter;
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            if (!CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                orgFilter = new QFilter("org", "in", (Object)hasPermOrgs);
                filters.add(orgFilter);
            } else {
                orgFilter = new QFilter("org", "=", (Object)-100);
                filters.add(orgFilter);
            }
        }
        String typeSerialNoMapStr = (String)this.getView().getFormShowParameter().getCustomParam("serialNoMapStr");
        QFilter serialNoFilter = null;
        Boolean serialDetail = Boolean.FALSE;
        if (StringUtils.isNotBlank((String)typeSerialNoMapStr) && !CollectionUtils.isEmpty((Collection)(serialNos = (List)(typeSerialNoMap = (Map)SerializationUtils.fromJsonString((String)typeSerialNoMapStr, Map.class)).get(nodeId.toString())))) {
            serialNoFilter = new QFilter("serial_no", "in", (Object)serialNos);
            serialDetail = Boolean.TRUE;
        }
        qFilter = new QFilter("invoice_type", "=", (Object)nodeId);
        filters.add(qFilter);
        QFilter delFilter = new QFilter("delete", "=", (Object)"1");
        filters.add(delFilter);
        if (serialNoFilter != null) {
            filters.add(serialNoFilter);
        }
        listFilterParameter.setQFilters((List)filters);
        showParameter.setCaption(invoiceType);
        showParameter.setCustomParam("invoicetype", (Object)nodeId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALL_BACK"));
        showParameter.getOpenStyle().setTargetKey(KEY_DATA_FLEX);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCustomParam("serialDetail", (Object)serialDetail.toString());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        this.getView().close();
    }
}

