/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.rim.common.h5.H5InvoiceListService;
import kd.imc.rim.common.h5.H5PluginService;
import kd.imc.rim.common.invoice.fpzs.InvoiceClassService;
import kd.imc.rim.common.license.service.FpzsAnonymousUserService;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.formplugin.mobile.home.operate.AbstractOperateService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class InvoiceSelectedMobilePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
PullRefreshListener,
EntryGridBindDataListener,
ProgresssListener {
    private static Log LOGGER = LogFactory.getLog(InvoiceSelectedMobilePlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    private final String[] buttons = new String[]{"operation"};
    private static final String DELETE_RECORD = "deleteRecord";
    private static final String KEY_LEAVE_DAYS = "inv_detail";

    public void registerListener(EventObject event) {
        this.addClickListeners(this.buttons);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addDataBindListener((EntryGridBindDataListener)this);
        cardEntry.addPullRefreshlisteners((PullRefreshListener)this);
        ProgressBar pb = (ProgressBar)this.getControl("probarupdateclass");
        if (pb != null) {
            pb.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isEmpty((Map)customParams)) {
            return;
        }
        List ids = (List)customParams.get("data");
        LOGGER.info("\u5165\u53c2\u6570\u636e\uff0c[{}]", (Object)customParams);
        this.getPageCache().put("invoiceIds", JSON.toJSONString((Object)ids));
        this.fillEntryEntity();
    }

    private List<Long> getIdsFromPageCache() {
        List ids = Lists.newArrayList();
        String cacheValue = this.getPageCache().get("invoiceIds");
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            ids = (List)JSON.parseObject((String)cacheValue, List.class);
        }
        return ids;
    }

    private void fillEntryEntity() {
        this.clearListData(ENTRYENTITY);
        List<Long> ids = this.getIdsFromPageCache();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        QFilter invQFilters = new QFilter("delete", "=", (Object)"1");
        invQFilters.and(new QFilter("id", "in", ids));
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        filters.add(invQFilters);
        H5InvoiceListService h5InvoiceListService = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
        h5InvoiceListService.queryData(filters, null);
        if (!CollectionUtils.isEmpty(ids)) {
            ArrayList<String> idsStr = new ArrayList<String>(ids.size());
            for (Long id : ids) {
                if (id == null) continue;
                idsStr.add(((Object)id).toString());
            }
            h5InvoiceListService.orderListByFields(new ArrayList(idsStr), "id");
        }
        h5InvoiceListService.fillEntryEntity();
    }

    private void clearListData(String var1) {
        this.getModel().deleteEntryData(var1);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getRows().stream().forEach(row -> {
            int index = row.getRowIndex();
            DynamicObject dynamicObject = row.getDataEntity();
            H5InvoiceListService h5InvoiceListSevice = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
            String invoiceInfoStr = dynamicObject.getString("invoice_info");
            JSONObject invoiceInfoJson = JSONObject.parseObject((String)invoiceInfoStr);
            Map invoice = invoiceInfoJson.getInnerMap();
            h5InvoiceListSevice.setTag(invoice, index);
        });
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "operation": {
                CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
                if (ArrayUtils.isEmpty((int[])cardEntry.getSelectRows())) {
                    return;
                }
                if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                    return;
                }
                HashMap<String, Object> value = new HashMap<String, Object>(3);
                DynamicObject invoice = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(cardEntry.getSelectRows()[0]);
                value.put("id", invoice.getLong("id"));
                value.put("operation", new String[]{"delete"});
                value.put("tips", ResManager.loadKDString((String)"\u53d1\u7968", (String)"InvoiceSelectedMobilePlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("rim_bill_operation_mobile");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DELETE_RECORD));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
                showParameter.setCustomParams(value);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        String result;
        if (StringUtils.equals((CharSequence)DELETE_RECORD, (CharSequence)closedCallBackEvent.getActionId()) && null != closedCallBackEvent.getReturnData() && StringUtils.equals((CharSequence)"Yes", (CharSequence)(result = (String)(returnData = (HashMap)closedCallBackEvent.getReturnData()).get("result")))) {
            List[] ids = new List[]{this.getIdsFromPageCache()};
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
            LinkedHashMap invoiceIds = Maps.newLinkedHashMap();
            HashMap currencyIds = Maps.newHashMap();
            Arrays.stream(cardEntry.getSelectRows()).forEach(c -> {
                if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                    return;
                }
                DynamicObject invoice = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(c);
                Long id = invoice.getLong("id");
                invoiceIds.put(id, invoice.getBigDecimal("total_amount"));
                currencyIds.put(id, DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("currencyid")));
                ids[0] = ids[0].stream().filter(b -> id.longValue() != b.longValue()).collect(Collectors.toList());
            });
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String indexPageId = (String)customParams.get("indexPageId");
            AbstractOperateService.deleteSelected(indexPageId, invoiceIds, this.getAttachIds(cardEntry.getSelectRows()), currencyIds);
            this.getPageCache().remove("invoiceIds");
            this.getPageCache().put("invoiceIds", JSON.toJSONString((Object)ids[0]));
            this.getModel().deleteEntryRows(ENTRYENTITY, cardEntry.getSelectRows());
            this.getView().updateView();
            for (int i = 0; i < cardEntry.getEntryData().getDataEntitys().length; ++i) {
                DynamicObject dynamicObject = cardEntry.getEntryData().getDataEntitys()[i];
                H5InvoiceListService h5InvoiceListSevice = new H5InvoiceListService((AbstractFormPlugin)this, ENTRYENTITY, "");
                String invoiceInfoStr = dynamicObject.getString("invoice_info");
                JSONObject invoiceInfoJson = JSONObject.parseObject((String)invoiceInfoStr);
                Map invoice = invoiceInfoJson.getInnerMap();
                h5InvoiceListSevice.setTag(invoice, i);
            }
        }
    }

    private List<Long> getAttachIds(int[] selectRows) {
        LinkedList invAttachIds = Lists.newLinkedList();
        Arrays.stream(selectRows).forEach(c -> {
            if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(c);
            String attachIds = dynamicObject.getString("attach_ids");
            if (StringUtils.isBlank((CharSequence)attachIds)) {
                return;
            }
            List invAttachIdsTemp = Arrays.stream(StringUtils.split((String)attachIds, (String)",")).map(invAttachId -> Long.valueOf(invAttachId)).collect(Collectors.toList());
            invAttachIds.addAll(invAttachIdsTemp);
        });
        return invAttachIds;
    }

    public void entryRowClick(RowClickEvent evt) {
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)("InvoiceSelectedRowClick" + RequestContext.get().getUserId())))) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity(ENTRYENTITY))) {
            return;
        }
        CacheHelper.put((String)("InvoiceSelectedRowClick" + RequestContext.get().getUserId()), (String)"1", (int)3);
        int currentRow = evt.getRow();
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        value.put("row", currentRow);
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currentRow);
        value.put("mainIds", dynamicObject.getString("id"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String indexPageId = (String)customParams.get("indexPageId");
        String showAttach = (String)customParams.get("showAttach");
        List attachIds = (List)customParams.get("attachIds");
        value.put("indexPageId", indexPageId);
        value.put("attachIds", attachIds);
        boolean freshAttachNum = true;
        value.put("freshAttachNum", freshAttachNum);
        value.put("inv_attach_cnt", "inv_attach_cnt");
        value.put("attach_ids", "attach_ids");
        boolean allowEdit = false;
        boolean addAttach = true;
        value.put("allowEdit", allowEdit);
        value.put("allowDel", allowEdit);
        value.put("addAttach", addAttach);
        value.put("relationType", "3");
        value.put("showAttach", showAttach);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("rim_h5_inv_update");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_LEAVE_DAYS));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        H5PluginService.setCommonParam(value, (Map)this.getView().getFormShowParameter().getCustomParams());
        FpzsAnonymousUserService.addEventCode(value, (String)this.getView().getPageId());
        showParameter.setCustomParams(value);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void pullRefesh(PullRefreshEvent pullRefreshEvent) {
        this.fillEntryEntity();
    }

    public void onProgress(ProgressEvent progressEvent) {
        InvoiceClassService.getInstance().refreshListRow((AbstractFormPlugin)this, "invoice_class", "invoice_class_show", "id");
    }
}

