/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.ViewUtil;

public class OpenExpenseDetalService {
    public static void showExpenseDetail(AbstractFormPlugin plugin, Map<String, Object> returnData, String type) {
        if (returnData != null) {
            String resource;
            if ("1".equals(returnData.get("updateBillList"))) {
                OpenExpenseDetalService.refresh(plugin);
                return;
            }
            if ("rim_add_expense".equals(returnData.get("form_id"))) {
                OpenExpenseDetalService.updateEnterExpense(plugin, returnData);
                return;
            }
            String expenseid = (String)returnData.get("reimbursingId");
            String entityid = (String)returnData.get("entityid");
            String expenseType = (String)returnData.get("expenseType");
            if (ExpenseConstant.isEnterExpense((String)expenseType, (String)(resource = (String)returnData.get("resource")))) {
                String serialNo = plugin.getPageCache().get("expense_serialno");
                serialNo = Optional.ofNullable(serialNo).orElseGet(() -> (String)returnData.get("serials"));
                String expenseId = (String)returnData.get("expenseId");
                OpenExpenseDetalService.showEnterExpenseDetail(plugin, expenseId, serialNo, type);
                return;
            }
            OpenExpenseDetalService.showDetail(plugin, expenseid, entityid, type);
        } else {
            OpenExpenseDetalService.refresh(plugin);
        }
    }

    public static void refresh(AbstractFormPlugin plugin) {
        BillList billlist = (BillList)plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }

    private static void updateEnterExpense(AbstractFormPlugin plugin, Map<String, Object> returnData) {
        if (returnData == null) {
            return;
        }
        String serialNo = plugin.getPageCache().get("expense_serialno");
        try {
            ExpenseRelationService expenseRelationService = new ExpenseRelationService();
            expenseRelationService.updateEnterExpense(returnData, serialNo);
            OpenExpenseDetalService.refresh(plugin);
        }
        catch (MsgException e) {
            plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%1$s", (String)"ExpenseDetailHyperLinkService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static void showEnterExpenseDetail(AbstractFormPlugin plugin, String expenseId, String serialNo, String type) {
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("expenseId", expenseId);
        customParams.put("serials", serialNo);
        ViewUtil.openDialog((AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u67e5\u770b\u62a5\u9500\u5355\u4fe1\u606f", (String)"ExpenseDetailHyperLinkService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), customParams, (String)"rim_add_expense", (String)type);
    }

    public static void showDetail(AbstractFormPlugin plugin, String expenseid, String entityid, String type) {
        Long pkId = BigDecimalUtil.transDecimal((Object)expenseid).longValue();
        if (pkId < 1L || StringUtils.isEmpty((CharSequence)entityid)) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u62a5\u9500\u5355\u8be6\u60c5", (String)"ExpenseDetailHyperLinkService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)pkId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityid, (String)"id", (QFilter[])new QFilter[]{filter});
        if (obj == null) {
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"id:%1$s\u5355\u636e\u4e0d\u5b58\u5728", (String)"ExpenseDetailHyperLinkService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), expenseid), Integer.valueOf(2000));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        FormShowParameter showParameter = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("entityid", entityid);
        customParams.put("pkId", pkId);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_expense_detail");
        if (mainEntityType.getDisplayName() != null) {
            showParameter.setCaption(mainEntityType.getDisplayName().getLocaleValue());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, type);
        showParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(showParameter);
    }
}

