/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.query.config.ColumnConfig;
import kd.imc.rim.common.invoice.query.config.ListConfig;
import kd.imc.rim.common.invoice.query.config.ListConfigUtil;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import org.apache.commons.lang3.StringUtils;

public class QueryExportConfigPlugin
extends AbstractFormPlugin
implements CellClickListener {
    public void initialize() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"btnok", "reset"});
    }

    public void afterCreateNewData(EventObject e) {
        this.iniView();
    }

    private void iniView() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add("rim_invoice");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.get("invoicetype");
        String queryType = String.valueOf(customParams.get("querytype"));
        String invoiceType = "";
        if (type != null) {
            invoiceType = type.toString();
        }
        InputInvoiceTypeEnum eum = InputInvoiceTypeEnum.getInvoiceType((String)invoiceType);
        String bodyEntity = null;
        if (eum != null && eum.getCode() > 0L) {
            bodyEntity = InputInvoiceTypeEnum.getEntity((Long)eum.getCode());
            list.add(bodyEntity);
        }
        Map<String, Map<String, Object>> configMap = this.queryConfig(queryType, invoiceType, bodyEntity);
        ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>(32);
        int seq = 0;
        for (String entity : list) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                Map<String, Object> config;
                LocaleString display;
                if (property instanceof EntryProp || (display = property.getDisplayName()) == null) continue;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
                map.put("field_key", property.getName());
                map.put("field_name", display.getLocaleValue());
                map.put("entity_key", entity);
                map.put("entity_name", mainEntityType.getDisplayName().getLocaleValue());
                JSONObject propjson = new JSONObject();
                if (property instanceof BasedataProp) {
                    map.put("field_type", "BasedataProp");
                    BasedataProp base = (BasedataProp)property;
                    IDataEntityType baseEntityType = base.getComplexType();
                    DataEntityPropertyCollection collect = baseEntityType.getProperties();
                    for (IDataEntityProperty subPro : collect) {
                        if (subPro.getDisplayName() == null) continue;
                        propjson.put(subPro.getName(), (Object)subPro.getDisplayName().getLocaleValue());
                    }
                    map.put("propjson", propjson.toJSONString());
                }
                if ((config = configMap.get(entity + property.getName())) != null) {
                    map.put("field_name", (String)config.get("field_name"));
                    map.put("seq", config.get("seq"));
                    map.put("exportpropname", config.get("exportpropname"));
                    String exportpropkey = (String)config.get("exportpropkey");
                    if (!StringUtils.isEmpty((CharSequence)exportpropkey)) {
                        JSONObject propJson = JSONObject.parseObject((String)exportpropkey);
                        StringBuilder sbName = new StringBuilder();
                        StringBuilder sbKey = new StringBuilder();
                        for (Map.Entry entry : propJson.entrySet()) {
                            String name = propjson.getString((String)entry.getKey());
                            if (sbName.length() > 0) {
                                sbName.append(',');
                            }
                            sbName.append(name);
                            if (sbKey.length() > 0) {
                                sbKey.append(',');
                            }
                            sbKey.append((String)entry.getKey());
                        }
                        map.put("exportpropname", sbName.toString());
                        map.put("exportpropkey", sbKey.toString());
                    }
                    map.put("colwidth", config.get("colwidth"));
                    map.put("isexport", Boolean.TRUE);
                } else {
                    map.put("seq", 100 + seq++);
                    map.put("isexport", Boolean.FALSE);
                    map.put("colwidth", 100);
                }
                fieldList.add(map);
            }
        }
        Collections.sort(fieldList, (o1, o2) -> {
            Long uploadSeq1 = BigDecimalUtil.transDecimal(o1.get("seq")).longValue();
            Long uploadSeq2 = BigDecimalUtil.transDecimal(o2.get("seq")).longValue();
            return uploadSeq1.compareTo(uploadSeq2);
        });
        this.iniFieldEntry(fieldList);
    }

    private void iniFieldEntry(List<Map<String, Object>> fieldList) {
        this.getModel().deleteEntryData("entryentity");
        for (Map<String, Object> map : fieldList) {
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("field_name", map.get("field_name"), index);
            this.getModel().setValue("entity_key", map.get("entity_key"), index);
            this.getModel().setValue("entity_name", map.get("entity_name"), index);
            this.getModel().setValue("field_key", map.get("field_key"), index);
            this.getModel().setValue("colwidth", map.get("colwidth"), index);
            this.getModel().setValue("isexport", map.get("isexport"), index);
            if (!"BasedataProp".equals(map.get("field_type"))) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"exportpropname"});
                continue;
            }
            String propjson = (String)map.get("propjson");
            if (StringUtils.isEmpty((CharSequence)propjson)) continue;
            String exportpropkey = (String)map.get("exportpropkey");
            if (StringUtils.isEmpty((CharSequence)exportpropkey)) {
                JSONObject propObject = JSONObject.parseObject((String)propjson);
                String name = propObject.getString("name");
                if (name != null) {
                    this.getModel().setValue("exportpropname", (Object)name, index);
                    this.getModel().setValue("exportpropkey", (Object)"name", index);
                } else {
                    name = propObject.getString("number");
                    if (name != null) {
                        this.getModel().setValue("exportpropname", (Object)name, index);
                        this.getModel().setValue("exportpropkey", (Object)"number", index);
                    }
                }
            } else {
                this.getModel().setValue("exportpropname", (Object)((String)map.get("exportpropname")), index);
                this.getModel().setValue("exportpropkey", (Object)((String)map.get("exportpropkey")), index);
            }
            this.getModel().setValue("propjson", map.get("propjson"), index);
        }
    }

    private Map<String, Map<String, Object>> queryConfig(String queryType, String invoiceType, String bodyEntity) {
        QFilter filter1 = new QFilter("query_type", "=", (Object)queryType);
        QFilter filter2 = new QFilter("invoice_type", "=", (Object)invoiceType);
        RequestContext context = RequestContext.get();
        QFilter filter3 = new QFilter("creater", "=", (Object)Long.valueOf(context.getUserId()));
        DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_export_config", (String)"item.entity_key as entity_key,item.field_key as field_key,item.field_name as field_name,item.colwidth as colwidth,item.exportpropkey as exportpropkey", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        if (collect != null && !collect.isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> configMap = new LinkedHashMap<String, Map<String, Object>>(collect.size());
            int seq = 0;
            for (DynamicObject object : collect) {
                Map map = DynamicObjectUtil.dynamicObject2Map((DynamicObject)object);
                map.put("seq", seq++);
                configMap.put((String)map.get("entity_key") + map.get("field_key"), map);
            }
            return configMap;
        }
        ListConfig listConfig = ListConfigUtil.getListDefConfig((String)(queryType + "_export"), (String)invoiceType);
        if (listConfig != null) {
            List columnList = listConfig.getListColumn();
            LinkedHashMap<String, Map<String, Object>> configMap = new LinkedHashMap<String, Map<String, Object>>(columnList.size());
            int seq = 0;
            HashMap<String, JSONObject> exportpropkey = new HashMap<String, JSONObject>(4);
            for (ColumnConfig columnConfig : columnList) {
                if (columnConfig.getVisible() < 1) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                String fieldKey = null;
                columnConfig.getFieldKey();
                String entity = null;
                if (!StringUtils.isEmpty((CharSequence)columnConfig.getRefField())) {
                    entity = bodyEntity;
                    fieldKey = columnConfig.getRefField();
                } else {
                    entity = "rim_invoice";
                    fieldKey = columnConfig.getFieldKey();
                }
                if (fieldKey.indexOf(46) > 0) {
                    String[] str = fieldKey.split("\\.");
                    fieldKey = str[0];
                    JSONObject property = (JSONObject)exportpropkey.get(entity + fieldKey);
                    if (property == null) {
                        property = new JSONObject();
                    }
                    property.put(str[1], (Object)str[1]);
                    exportpropkey.put(entity + fieldKey, property);
                }
                map.put("entity_key", entity);
                map.put("field_key", fieldKey);
                map.put("field_name", columnConfig.getName());
                int width = 100;
                if (columnConfig.getWidth() != null) {
                    width = BigDecimalUtil.transDecimal((Object)columnConfig.getWidth().replace("px", "")).intValue();
                }
                if (width < 1) {
                    width = 100;
                }
                map.put("colwidth", width);
                map.put("seq", seq++);
                configMap.put(entity + fieldKey, map);
            }
            for (Map.Entry entry : exportpropkey.entrySet()) {
                Map config = (Map)configMap.get(entry.getKey());
                config.put("exportpropkey", ((JSONObject)entry.getValue()).toJSONString());
            }
            return configMap;
        }
        return new LinkedHashMap<String, Map<String, Object>>(1);
    }

    public void cellClick(CellClickEvent paramCellClickEvent) {
        String fieldKey = paramCellClickEvent.getFieldKey();
        if ("exportpropname".equals(fieldKey)) {
            int row = paramCellClickEvent.getRow();
            IDataModel model = this.getModel();
            String propjson = (String)model.getValue("propjson", row);
            if (!StringUtils.isEmpty((CharSequence)propjson)) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("rim_popcombo");
                showParameter.getCustomParams().put("items", model.getValue("propjson", row));
                showParameter.getCustomParams().put("values", model.getValue("exportpropkey", row));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey + row));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] data;
        String newValue;
        if ("exportpropname".equals(e.getProperty().getName()) && StringUtils.isEmpty((CharSequence)(newValue = (String)(data = e.getChangeSet())[0].getNewValue()))) {
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("exportpropkey", (Object)"", row);
        }
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        int row;
        IDataModel model;
        String propjson;
        List list = (List)closedCallBackEvent.getReturnData();
        if (list != null && !list.isEmpty() && !StringUtils.isEmpty((CharSequence)(propjson = (String)(model = this.getModel()).getValue("propjson", row = model.getEntryCurrentRowIndex("entryentity"))))) {
            JSONObject json = JSONObject.parseObject((String)propjson);
            StringBuilder sb = new StringBuilder();
            for (String value : list) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(json.get((Object)value));
            }
            model.setValue("exportpropname", (Object)sb.toString(), row);
            model.setValue("exportpropkey", (Object)String.join((CharSequence)",", list), row);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            int count = 0;
            for (int i = 0; i < rowCount; ++i) {
                Boolean isexport = (Boolean)this.getModel().getValue("isexport", i);
                if (!isexport.booleanValue()) continue;
                ++count;
                break;
            }
            if (count < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5", (String)"QueryExportConfigPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"QueryExportConfigPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"QueryExportConfigPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u5bfc\u51fa\u5c06\u8986\u76d6\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"QueryExportConfigPlugin_19", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(control.getKey()), btnNameMaps);
        } else if ("reset".equals(control.getKey())) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"QueryExportConfigPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"QueryExportConfigPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u4f7f\u7528\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e\uff1f", (String)"QueryExportConfigPlugin_20", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(control.getKey()), btnNameMaps);
        }
    }

    private void reset() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String invoiceType = "";
        Object type = customParams.get("invoicetype");
        if (type != null) {
            invoiceType = type.toString();
        }
        String queryType = (String)customParams.get("querytype");
        QFilter filter1 = new QFilter("query_type", "=", (Object)queryType);
        QFilter filter2 = new QFilter("invoice_type", "=", (Object)invoiceType);
        RequestContext context = RequestContext.get();
        QFilter filter3 = new QFilter("creater", "=", (Object)Long.valueOf(context.getUserId()));
        DeleteServiceHelper.delete((String)"rim_export_config", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        this.iniView();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"QueryExportConfigPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        this.getView().close();
    }

    private void submit() {
        String queryType;
        IDataModel model = this.getModel();
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String invoiceType = "";
        Object type = customParams.get("invoicetype");
        if (type != null) {
            invoiceType = type.toString();
        }
        if (!StringUtils.isEmpty((CharSequence)(queryType = (String)customParams.get("querytype")))) {
            QFilter filter1 = new QFilter("query_type", "=", (Object)queryType);
            QFilter filter2 = new QFilter("invoice_type", "=", (Object)invoiceType);
            RequestContext context = RequestContext.get();
            QFilter filter3 = new QFilter("creater", "=", (Object)Long.valueOf(context.getUserId()));
            DynamicObject object = QueryServiceHelper.queryOne((String)"rim_export_config", (String)"id", (QFilter[])new QFilter[]{filter1, filter2, filter3});
            if (object != null) {
                object = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"rim_export_config");
            } else {
                object = BusinessDataServiceHelper.newDynamicObject((String)"rim_export_config");
                object.set("query_type", (Object)queryType);
                object.set("invoice_type", (Object)invoiceType);
                object.set("creater", (Object)Long.valueOf(context.getUserId()));
            }
            DynamicObjectCollection itemCollection = object.getDynamicObjectCollection("item");
            itemCollection.clear();
            int seq = 0;
            for (int i = 0; i < rowCount; ++i) {
                Boolean isexport = (Boolean)model.getValue("isexport", i);
                if (!isexport.booleanValue()) continue;
                String field_name = (String)model.getValue("field_name", i);
                String propjson = (String)model.getValue("propjson", i);
                String exportpropkey = (String)model.getValue("exportpropkey", i);
                if (!StringUtils.isEmpty((CharSequence)propjson) && StringUtils.isEmpty((CharSequence)exportpropkey)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bf7\u9009\u62e9\u5bfc\u51fa\u5c5e\u6027", (String)"QueryExportConfigPlugin_15", (String)"imc-rim-formplugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
                    return;
                }
                DynamicObject item = itemCollection.addNew();
                if (!StringUtils.isEmpty((CharSequence)propjson) && !StringUtils.isEmpty((CharSequence)exportpropkey)) {
                    JSONObject json = JSONObject.parseObject((String)propjson);
                    String[] str = exportpropkey.split(",");
                    JSONObject propJson = new JSONObject(true);
                    for (String kk : str) {
                        propJson.put(kk, (Object)(field_name + '.' + json.get((Object)kk)));
                    }
                    item.set("exportpropkey", (Object)propJson.toJSONString());
                }
                item.set("entity_key", model.getValue("entity_key", i));
                item.set("field_key", model.getValue("field_key", i));
                item.set("field_name", model.getValue("field_name", i));
                item.set("colwidth", model.getValue("colwidth", i));
                item.set("seq", (Object)seq++);
            }
            if (seq < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5", (String)"QueryExportConfigPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"QueryExportConfigPlugin_21", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if ("btnok".equals(callBackId)) {
                this.submit();
            } else if ("reset".equals(callBackId)) {
                this.reset();
            }
        }
    }
}

