/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.hyperlink;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.aws.ofd.util.pdf.StringUtil;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class ClassInvoiceHyperLinkService
extends InvoiceOperateService {
    public ClassInvoiceHyperLinkService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate(ListSelectedRow listSelectedRow) {
        Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
        this.plugin.getPageCache().put("selectedValue", primaryKeyValue + "");
        DynamicObject invoices = BusinessDataServiceHelper.loadSingle((String)"rim_invoice", (String)"id, mul_class, ext_info", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (invoices == null) {
            return;
        }
        DynamicObjectCollection mulClass = invoices.getDynamicObjectCollection("mul_class");
        if (CollectionUtils.isEmpty((Collection)mulClass)) {
            return;
        }
        ArrayList ids = Lists.newArrayList();
        for (DynamicObject obj : mulClass) {
            DynamicObject sysOrg = obj.getDynamicObject("fbasedataid");
            ids.add(sysOrg.getPkValue() + "");
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("ids", (Object)ids);
        param.setFormId("rim_chose_invoice_class");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
        param.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(param);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Set classIds;
        String postResult = this.plugin.getPageCache().get("selectedValue");
        if (StringUtil.isEmpty((Object)postResult)) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof HashMap) {
            classIds = (Set)((Map)returnData).get("choseIds");
        } else {
            ListSelectedRowCollection classList = (ListSelectedRowCollection)returnData;
            if (classList == null) {
                BillList billlist = (BillList)this.plugin.getControl("billlistap");
                billlist.clearSelection();
                billlist.refresh();
                return;
            }
            classIds = (Set)((Object)Arrays.asList(classList.getPrimaryKeyValues()));
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"rim_invoice", (String)"id, mul_class, ext_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(postResult))});
        boolean tipsFlag = false;
        StringBuilder sysClassName = new StringBuilder(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u7cfb\u7edf\u81ea\u52a8\u5224\u65ad\u6807\u7b7e", (String)"ClassInvoiceHyperLinkService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        if (invoices != null) {
            try (TXHandle tx = TX.required();){
                try {
                    for (DynamicObject invoice : invoices) {
                        DynamicObjectCollection mul_class = invoice.getDynamicObjectCollection("mul_class");
                        mul_class.clear();
                        String extInfo = invoice.getString("ext_info");
                        if (StringUtils.isNotEmpty((CharSequence)extInfo)) {
                            try {
                                JSONObject extInfoObj = JSONObject.parseObject((String)extInfo);
                                String sysMulClass = extInfoObj.getString("sys_mulclass");
                                if (StringUtils.isNotEmpty((CharSequence)sysMulClass)) {
                                    DynamicObject[] invoiceClasses;
                                    List<String> sysIds = Arrays.asList(sysMulClass.split(","));
                                    int[] ids = sysIds.stream().mapToInt(Integer::valueOf).toArray();
                                    for (DynamicObject obj : invoiceClasses = BusinessDataServiceHelper.load((String)"rim_invoice_class", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)})) {
                                        if (classIds.contains(obj.getString("id"))) continue;
                                        sysClassName.append("[").append(obj.getString("name")).append("]");
                                        tipsFlag = true;
                                    }
                                    sysClassName.append(ResManager.loadKDString((String)"\u4e0d\u53ef\u53d6\u6d88", (String)"ClassInvoiceHyperLinkService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                                    classIds.addAll(sysIds);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        for (Object classid : classIds) {
                            if (StringUtils.isEmpty((CharSequence)classid.toString())) continue;
                            DynamicObject classInfo = mul_class.addNew();
                            classInfo.set("fbasedataid_id", classid);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                }
            }
        }
        this.plugin.getPageCache().remove("selectedValue");
        if (tipsFlag) {
            this.plugin.getView().showSuccessNotification(sysClassName.toString(), Integer.valueOf(3000));
        } else {
            this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClassInvoiceHyperLinkService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        BillList billlist = (BillList)this.plugin.getControl("billlistap");
        billlist.clearSelection();
        billlist.refresh();
    }
}

