/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.hyperlink;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.rim.common.constant.ExpenseConstant;
import kd.imc.rim.common.expense.service.ExpenseService;
import kd.imc.rim.common.invoice.fpzs.ExpenseRelationService;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.OpenExpenseDetalService;

public class ExpenseListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(ExpenseListPlugin.class);
    private static final String UPDATE_FLAG = "update_flag";
    private static final String CALL_BACK_KEY = "expense_list";

    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String openInvoice = (String)customParams.get("openInvoice");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object str = pkEvent.getRowData().get("json");
            JSONObject jsonObject = JSONObject.parseObject((String)str.toString());
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String opKey = operationColItem.getOperationKey();
                    if (StringUtils.isEmpty((Object)openInvoice) && jsonObject != null && ExpenseConstant.isEnterExpense((String)jsonObject.getString("expense_type"), (String)jsonObject.getString("resource"))) {
                        if ("delete".equalsIgnoreCase(opKey) || "edit".equalsIgnoreCase(opKey)) {
                            operationColItem.setVisible(true);
                            operationColItem.setLocked(false);
                            continue;
                        }
                        operationColItem.setVisible(false);
                        operationColItem.setLocked(true);
                        continue;
                    }
                    if ("delete".equalsIgnoreCase(opKey) || "edit".equalsIgnoreCase(opKey) || jsonObject == null) {
                        operationColItem.setVisible(false);
                        operationColItem.setLocked(true);
                        continue;
                    }
                    operationColItem.setVisible(true);
                    operationColItem.setLocked(false);
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List expenseList = (List)customParams.get("expense");
        this.viewList(expenseList);
    }

    private void viewList(List<Map<String, Object>> expenseList) {
        this.getModel().deleteEntryData("entryentity");
        if (CollectionUtils.isEmpty(expenseList)) {
            return;
        }
        DynamicObjectCollection coll = BaseDataServiceHelper.queryBaseData((String)"rim_expense_type", null, null, (String)"id,number,name");
        HashMap<String, String> typeMap = new HashMap<String, String>(8);
        if (!CollectionUtils.isEmpty((Collection)coll)) {
            for (DynamicObject dy : coll) {
                typeMap.put(dy.getString("number"), dy.getString("name"));
            }
        }
        Object[] expenseIds = expenseList.stream().map(s -> s.get("expense_id")).toArray();
        QFilter qFilter = new QFilter("expense_id", "in", (Object)expenseIds);
        HashMap<String, Date> expenseTimeMap = new HashMap<String, Date>(8);
        DynamicObjectCollection expenses = QueryServiceHelper.query((String)"rim_expense", (String)"expense_id,expense_time", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)expenses)) {
            for (DynamicObject ex : expenses) {
                expenseTimeMap.put(ex.getString("expense_id"), ex.getDate("expense_time"));
            }
        }
        for (Map<String, Object> map : expenseList) {
            int index = this.getModel().createNewEntryRow("entryentity");
            String expenseId = (String)map.get("expense_id");
            Object createTime = expenseTimeMap.get(expenseId);
            if (createTime == null) {
                createTime = map.get("create_time");
            }
            this.getModel().setValue("expense_num", map.get("expense_num"), index);
            String expenseType = (String)map.get("expense_type");
            String resource = (String)map.get("resource");
            this.getModel().setValue("expense_type", typeMap.get(map.get("expense_type")), index);
            this.getModel().setValue("create_time", createTime, index);
            String entityid = (String)map.get("entityid");
            if (!MetadataUtil.exists((String)(entityid = ExpenseConstant.getExpenseEntityId((String)expenseId, (String)entityid))).booleanValue() && !ExpenseConstant.isEnterExpense((String)expenseType, (String)resource)) continue;
            if (ExpenseConstant.isEnterExpense((String)expenseType, (String)resource)) {
                map.put("expenseType", expenseType);
                map.put("expenseId", expenseId);
                map.put("resource", resource);
            }
            map.put("serialNo", (String)map.get("serial_no"));
            map.put("entityid", entityid);
            map.put("reimbursingId", ExpenseConstant.getExpenseReimbursingid((String)expenseId, (String)entityid));
            this.getModel().setValue("json", (Object)SerializationUtils.toJsonString(map), index);
            this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"ExpenseListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), index);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }

    public void hyperLinkClick(HyperLinkClickEvent rowClickEvent) {
        int index = rowClickEvent.getRowIndex();
        this.viewDetail(index);
    }

    private void viewDetail(int index) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String openInvoice = (String)customParams.get("openInvoice");
        String json = (String)this.getModel().getValue("json", index);
        logger.info("\u67e5\u770b\u5355\u636e\u8be6\u60c5{},{}", (Object)index, (Object)json);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (StringUtils.isEmpty((Object)openInvoice)) {
            String reimbursingId = jsonObject.getString("reimbursingId");
            String entityid = jsonObject.getString("entityid");
            HashMap<String, Object> returnData = new HashMap<String, Object>(4);
            returnData.put("reimbursingId", reimbursingId);
            returnData.put("entityid", entityid);
            returnData.put("expenseType", jsonObject.getString("expenseType"));
            returnData.put("expenseId", jsonObject.getString("expenseId"));
            returnData.put("resource", jsonObject.getString("resource"));
            returnData.put("serials", customParams.get("serials"));
            OpenExpenseDetalService.showExpenseDetail(this, returnData, CALL_BACK_KEY);
        } else {
            String expenseType = jsonObject.getString("expense_type");
            String expenseId = jsonObject.getString("expense_id");
            QFilter qFilters = new QFilter("expense_id", "=", (Object)expenseId);
            ExpenseRelationService expenseRelationService = new ExpenseRelationService();
            DynamicObjectCollection relCollection = expenseRelationService.findByFilter("serial_no", qFilters);
            List<String> serialNos = relCollection.stream().map(c -> c.getString("serial_no")).collect(Collectors.toList());
            this.openInvoceList(expenseType, expenseId, serialNos);
        }
    }

    private void openInvoceList(String expenseType, String expenseId, List<String> serialList) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billType", expenseType);
        customParams.put("expenseId", expenseId);
        customParams.put("resource", ResManager.loadKDString((String)"\u53d1\u7968\u52a9\u624b4", (String)"ExpenseListPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        customParams.put("serialList", serialList);
        ViewUtil.openDialog((AbstractFormPlugin)this, customParams, (String)"rim_view_invoice", (String)"rim_view_invoice");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if ("rim_view_invoice".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        } else if (CALL_BACK_KEY.equals(closedCallBackEvent.getActionId()) && callBackData != null) {
            String serials = (String)callBackData.get("serials");
            List serialNos = CommonUtils.getMultiValues((String)serials);
            if ("1".equals(callBackData.get("updateBillList"))) {
                this.refeshList(serialNos);
                return;
            }
            try {
                ExpenseRelationService expenseRelationService = new ExpenseRelationService();
                expenseRelationService.saveExpenseInfo(callBackData, serials);
                this.refeshList(serialNos);
            }
            catch (MsgException e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%1$s", (String)"ExpenseListPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void refeshList(List<String> serialNos) {
        this.getPageCache().put(UPDATE_FLAG, "1");
        QFilter serialNofilter = new QFilter("serial_no", "in", serialNos);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"rim_expense_relation", (String)"resource,view_page,entityid,expense_id,expense_num,expense_type,create_time,reimbursingid,serial_no", (QFilter[])new QFilter[]{serialNofilter});
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.viewList(null);
            return;
        }
        List expenseist = DynamicObjectUtil.dynamicObjectColletction2ListMap((DynamicObjectCollection)list);
        this.viewList(expenseist);
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (ObjectUtils.isEmpty((Object)selectRows)) {
            return;
        }
        if ("viewdetail".equals(operateKey) || "edit".equals(operateKey)) {
            this.viewDetail(selectRows[0]);
        } else if ("delete".equals(operateKey)) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"ExpenseListPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"ExpenseListPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u8be5\u5355\u636e\u5417\uff1f", (String)"ExpenseListPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("deleteCallBack"), btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        if ("deleteCallBack".equals(callBackId)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (ObjectUtils.isEmpty((Object)selectRows)) {
                return;
            }
            int index = selectRows[0];
            String json = (String)this.getModel().getValue("json", index);
            JSONObject jsonObject = JSONObject.parseObject((String)json);
            String expenseId = jsonObject.getString("expenseId");
            String expenseNum = jsonObject.getString("expense_num");
            String serialNo = jsonObject.getString("serialNo");
            this.getModel().deleteEntryRow("entryentity", index);
            ExpenseRelationService expenseRelationService = new ExpenseRelationService();
            ArrayList<String> serialNos = new ArrayList<String>(1);
            serialNos.add(serialNo);
            ArrayList<String> expenseIdList = new ArrayList<String>(2);
            expenseIdList.add(expenseId);
            expenseRelationService.deleteBySerialNoAndExpenseId(serialNos, expenseIdList);
            ExpenseService expenseService = new ExpenseService();
            expenseService.updateInvoiceMain(serialNos, null);
            expenseRelationService.syncAwsExpense(expenseId, expenseNum, "1", serialNo);
            this.getPageCache().put(UPDATE_FLAG, "1");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ExpenseListPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btncancel".equals(control.getKey())) {
            if ("1".equals(this.getPageCache().get(UPDATE_FLAG))) {
                HashMap<String, String> data = new HashMap<String, String>(8);
                data.put("updateBillList", "1");
                this.getView().returnDataToParent(data);
            }
            this.getView().close();
        } else if ("btnok".equals(control.getKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap customParamsNew = new HashMap(1);
            customParamsNew.put("serials", customParams.get("serials"));
            ViewUtil.openDialog((AbstractFormPlugin)this, customParamsNew, (String)"rim_add_expense", (String)CALL_BACK_KEY);
        }
    }
}

