/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.invoice.deduction.AgricInvoiceHandleService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class AgricHandleConfirmOperateService
extends InvoiceOperateService {
    public AgricHandleConfirmOperateService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"AgricHandleConfirmOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            Map parentCustomParams = listPlugin.getView().getFormShowParameter().getCustomParams();
            Object queryType = parentCustomParams.get("querytype");
            QFilter filte = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,serial_no,invoice_type,invoice_code,invoice_no,invoice_date,invoice_amount,total_tax_amount,total_amount,authenticate_flag,effective_tax_amount,buyer_tax_no,org,isvoucher,invoice_status,deduction_flag,deduction_purpose,not_deductible_type,saler_name,saler_tax_no,output_type,remark,electronic_no,createtime,purchase_ticket,agric_handle_status,invoice_risk_level", (QFilter[])new QFilter[]{filte});
            StringBuilder message = new StringBuilder();
            JSONArray invoices = new JSONArray();
            for (DynamicObject object : invoiceCollection) {
                String authenticateFlag;
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)object.getString("invoice_code"), (String)object.getString("invoice_no"));
                String agricHandleStatus = object.getString("agric_handle_status");
                if ("3".equals(agricHandleStatus) || "2".equals(agricHandleStatus)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u519c\u4ea7\u54c1\u5904\u7406\u72b6\u6001\u4e3a\u201c\u65e0\u9700\u5904\u7406\u201d\u6216\u201c\u5904\u7406\u4e2d\u201d\uff0c\u8bf7\u9009\u62e9\u201c\u672a\u5904\u7406\u201d\u6216\u201c\u5df2\u5904\u7406\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"AgricHandleConfirmOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                if ("1".equals(authenticateFlag = object.getString("authenticate_flag")) || "2".equals(authenticateFlag) || "3".equals(authenticateFlag) || "5".equals(authenticateFlag)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u52fe\u9009\u72b6\u6001\u4e3a\u201c\u5df2\u52fe\u9009\u8ba4\u8bc1\u201d\u6216\u201c\u5904\u7406\u4e2d\u201d\uff0c\u8bf7\u9009\u62e9\u201c\u672a\u52fe\u9009\u201d\u72b6\u6001\u7684\u53d1\u7968\u3002", (String)"AgricHandleConfirmOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                }
                Map invoiceMap = DynamicObjectUtil.dynamicObjectToMap((DynamicObject)object);
                invoices.add((Object)invoiceMap);
            }
            String title = ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u4e0a\u4f20\u786e\u8ba4", (String)"AgricHandleConfirmOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            String strMsg = message.toString();
            if (StringUtils.isNotBlank((CharSequence)strMsg)) {
                ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)title, (String)strMsg, (int)0, (int)invoiceCollection.size());
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            parentCustomParams.put("deductName", title);
            parentCustomParams.put("invoices", invoices);
            parentCustomParams.put("operatetype", this.type);
            parentCustomParams.put("querytype", queryType);
            showParameter.setCustomParams(parentCustomParams);
            showParameter.setFormId("rim_agric_handle_edit");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u7f16\u8f91", (String)"AgricHandleConfirmOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), title));
            this.plugin.getView().showForm(showParameter);
        } else {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53d1\u7968\u4e3b\u8868\u201d\u7684\u201c\u519c\u4ea7\u54c1\u4e0a\u4f20\u786e\u8ba4\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AgricHandleConfirmOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)this.type, (CharSequence)actionId)) {
            JSONObject paramJson = (JSONObject)closedCallBackEvent.getReturnData();
            this.handle(paramJson);
        }
    }

    private void handle(JSONObject paramJson) {
        if (paramJson != null) {
            if (StringUtils.isBlank((Object)paramJson)) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef", (String)"AgricHandleConfirmOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONArray invoices = paramJson.getJSONArray("invoices");
            if (CollectionUtils.isEmpty((Collection)invoices)) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u5904\u7406\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"AgricHandleConfirmOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)paramJson.getString("taskNo"))) {
                paramJson.put("taskNo", (Object)UUID.randomUUID());
            }
            paramJson.put("notDateSplit", (Object)"1");
            List list = JSONArray.parseArray((String)invoices.toJSONString(), JSONObject.class);
            Map<String, List<JSONObject>> invoiceGroupMap = list.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("buyerTaxNo"))).collect(Collectors.groupingBy(s -> s.getString("buyerTaxNo") + s.getString("agricPrehandleType")));
            if (ObjectUtils.isEmpty(invoiceGroupMap)) {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u5904\u7406\u6570\u636e\u6ca1\u6709\u4f20\u5165\u8d2d\u65b9\u7a0e\u53f7", (String)"AgricHandleConfirmOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            int successNum = 0;
            int failNum = 0;
            StringBuilder message = new StringBuilder();
            Set<Map.Entry<String, List<JSONObject>>> entrySet = invoiceGroupMap.entrySet();
            for (Map.Entry<String, List<JSONObject>> entry : entrySet) {
                Long orgId = null;
                List<JSONObject> invoiceList = entry.getValue();
                String taxNo = invoiceList.get(0).getString("buyerTaxNo");
                if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
                    failNum += invoiceList.size();
                    for (JSONObject jSONObject : invoiceList) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s \u4f01\u4e1a\u6027\u8d28\u4e3a\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u652f\u6301\u519c\u4ea7\u54c1\u5904\u7406\uff0c\u53ef\u6839\u636e\u4f01\u4e1a\u5728\u7a0e\u5c40\u7684\u4fe1\u606f\uff0c\u5728\u661f\u701a\u53d1\u7968\u4e91\u4f01\u4e1a\u57fa\u7840\u8d44\u6599\u4fee\u6539\u3002", (String)"AgricHandleConfirmOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)jSONObject.getString("invoiceCode"), (String)jSONObject.getString("invoiceNo")))).append(ViewUtil.LINE_SEPARATOR);
                    }
                    continue;
                }
                paramJson.put("taxNo", (Object)taxNo);
                paramJson.put("deductibleMode", (Object)invoiceList.get(0).getString("agricPrehandleType"));
                for (JSONObject jSONObject : invoiceList) {
                    jSONObject.remove((Object)"buyerTaxNo");
                    if (ObjectUtils.isEmpty(orgId)) {
                        orgId = jSONObject.getLong("orgId");
                    }
                    jSONObject.remove((Object)"orgId");
                }
                paramJson.put("orgId", orgId);
                paramJson.put("invoices", invoiceList);
                String dktype = DeductionConstant.getDkType((String)taxNo);
                AgricInvoiceHandleService service = DeductServiceFactory.newInstanceForAgricInvoiceHandle((String)dktype);
                if (service == null) {
                    failNum += invoiceList.size();
                    for (JSONObject invoice2 : invoiceList) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s %2$s\u3002", (String)"AgricHandleConfirmOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), CommonUtils.getInvoiceCodeNoGroup((String)invoice2.getString("invoiceCode"), (String)invoice2.getString("invoiceNo")), ErrorType.AGRIC_HANDLE_NONSUPPORT.getName())).append(ViewUtil.LINE_SEPARATOR);
                    }
                    continue;
                }
                JSONObject jSONObject = service.batchSelectInvoices(paramJson);
                successNum += jSONObject.getInteger("successNum").intValue();
                failNum += jSONObject.getInteger("failNum").intValue();
                message.append(jSONObject.get((Object)"message"));
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                this.plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\uff0c\u519c\u4ea7\u54c1\u4e0a\u4f20\u786e\u8ba4\u63d0\u4ea4\u6210\u529f%2$s\u6761\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\u3002\u63d0\u4ea4\u5931\u8d25%3$s\u6761", (String)"AgricHandleConfirmOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoices.size(), successNum, invoices.size() - successNum), message.toString(), MessageTypes.Default);
            } else {
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u4e0a\u4f20\u786e\u8ba4\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u201c\u8fdb\u9879\u62b5\u6263-\u7a0e\u5c40\u7528\u7968\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868\u201d\u67e5\u770b\u72b6\u6001\uff0c\u6216\u7a0d\u540e\u5237\u65b0\u8be5\u9875\u9762\u67e5\u770b\u7ed3\u679c\u3002", (String)"AgricHandleConfirmOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        }
    }
}

