/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.invoice.download.RpaFileDownApplyService;
import kd.imc.rim.common.utils.AllEleAuthUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;

public class DownTaxFileOperateService
extends InvoiceOperateService {
    public DownTaxFileOperateService(String type, AbstractFormPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DownTaxFileOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            int maxSizeDownEleFile = InvoiceDownloadConstant.getPageSizeFromConfig((int)5000, (String)"max_size_down_ele_file");
            if (selectCollection.size() > maxSizeDownEleFile) {
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6700\u5927\u5141\u8bb8\u4e0b\u8f7d\u53d1\u7968\u6587\u4ef6\u7684\u6570\u91cf\u4e3a%1$s", (String)"DownTaxFileOperateService_13", (String)"imc-rim-formplugin", (Object[])new Object[0]), maxSizeDownEleFile);
                this.plugin.getView().showTipNotification(msg, Integer.valueOf(2000));
                return;
            }
            QFilter idFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"id,invoice_code,invoice_no,invoice_date,buyer_tax_no,invoice_type,serial_no,buyer_name,saler_tax_no,saler_name,total_amount", (QFilter[])new QFilter[]{idFilter});
            Object[] serialNos = collection.stream().map(s -> s.getString("serial_no")).toArray();
            Set downloadedTaxFileNos = InvoiceDownHelper.getDownloadedTaxFileNos((Object[])serialNos);
            HashMap<String, JSONArray> applyFiles = new HashMap<String, JSONArray>(8);
            StringBuilder message = new StringBuilder();
            int successNum = 0;
            String lqTaxNoStr = ImcConfigUtil.getValue((String)"rim_deduction", (String)"leqi_taxno_down_ele_file");
            Date minInvoiceDate = null;
            Date maxInvoiceDate = null;
            for (DynamicObject invoice : collection) {
                String allEaccount;
                boolean isLqTaxno;
                String msg;
                Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("invoice_type"));
                String invoiceCode = invoice.getString("invoice_code");
                String invoiceNo = invoice.getString("invoice_no");
                String buyerTaxNo = invoice.getString("buyer_tax_no");
                String serialNo = invoice.getString("serial_no");
                Date invoiceDate = invoice.getDate("invoice_date");
                String buyerName = invoice.getString("buyer_name");
                String salerTaxNo = invoice.getString("saler_tax_no");
                String salerName = invoice.getString("saler_name");
                String totalAmount = DynamicObjectUtil.fieldToString((Object)invoice.get("total_amount"));
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                if (downloadedTaxFileNos.contains(serialNo)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5df2\u7ecf\u4e0b\u8f7d\u4e86\u7a0e\u5c40\u6587\u4ef6\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"DownTaxFileOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if (!InputInvoiceTypeEnum.isEleInvoice((Long)invoiceType).booleanValue()) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u975e\u6570\u7535\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u4e0b\u8f7d\u7a0e\u5c40\u6587\u4ef6\u3002", (String)"DownTaxFileOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if (invoiceDate == null || DateUtils.isTimeZero((Date)invoiceDate)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u5f00\u7968\u65e5\u671f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u4ece\u7a0e\u5c40\u540c\u6b65\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"DownTaxFileOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)buyerTaxNo)) {
                    msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u91cd\u65b0\u91c7\u96c6\u53d1\u7968\u540e\u91cd\u8bd5\u3002", (String)"DownTaxFileOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                    message.append(msg);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                String dkType = DeductionConstant.getDkType((String)buyerTaxNo);
                boolean bl = isLqTaxno = "5".equals(dkType) || StringUtils.isNotBlank((CharSequence)lqTaxNoStr) && lqTaxNoStr.contains(buyerTaxNo);
                if (!"4".equals(dkType) && !isLqTaxno) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u8d2d\u65b9\u7a0e\u53f7%2$s\u7684\u6536\u7968\u901a\u9053\u975e\u3010\u65b0\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0\u3011\u6216\u3010\u4e50\u4f01\u5e73\u53f0\u3011\uff0c\u8bf7\u5148\u5230\u201c\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u4f01\u4e1a\u4fe1\u606f\u201d\u914d\u7f6e\u6536\u7968\u901a\u9053\u3002", (String)"DownTaxFileOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup, buyerTaxNo);
                    message.append(msg2);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                String taxCity = AllEleAuthUtil.getTaxCity((String)buyerTaxNo);
                if (isLqTaxno && StringUtils.isEmpty((CharSequence)taxCity)) {
                    String msg3 = String.format(ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u4e3a\u3010\u4e50\u4f01\u5e73\u53f0\u3011,\u53d1\u7968\uff1a%1$s\u8d2d\u65b9\u7a0e\u53f7%2$s\uff0c\u5fc5\u987b\u5728\u53d1\u7968\u4e91\u4f01\u4e1a\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u4f01\u4e1a\u6240\u5c5e\u7a0e\u5c40\u5730\u533a\u7f16\u7801\u624d\u80fd\u4e0b\u8f7d\u6570\u7535\u7248\u5f0f\u2f42\u4ef6\u3002", (String)"DownTaxFileOperateService_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup, buyerTaxNo);
                    message.append(msg3);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if ("4".equals(dkType) && StringUtils.isEmpty((CharSequence)(allEaccount = AllEleAuthUtil.getAllEaccount((String)buyerTaxNo)))) {
                    String msg4 = String.format(ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u4e3a\u3010\u65b0\u7535\u5b50\u53d1\u7968\u670d\u52a1\u5e73\u53f0\u3011,\u53d1\u7968\uff1a%1$s\u8d2d\u65b9\u7a0e\u53f7%2$s\u672a\u914d\u7f6e\u6570\u7535\u8d26\u53f7\uff0c\u8bf7\u5148\u5230\u201c\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406-\u6570\u7535\u914d\u7f6e\u201d\u914d\u7f6e\u6536\u7968\u8d26\u53f7\u3002", (String)"DownTaxFileOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup, buyerTaxNo);
                    message.append(msg4);
                    message.append(ViewUtil.LINE_SEPARATOR);
                    continue;
                }
                if (minInvoiceDate == null) {
                    minInvoiceDate = invoiceDate;
                } else if (minInvoiceDate.compareTo(invoiceDate) > 0) {
                    minInvoiceDate = invoiceDate;
                }
                if (maxInvoiceDate == null) {
                    maxInvoiceDate = invoiceDate;
                } else if (maxInvoiceDate.compareTo(invoiceDate) < 0) {
                    maxInvoiceDate = invoiceDate;
                }
                JSONArray invoices = applyFiles.getOrDefault(buyerTaxNo, new JSONArray());
                JSONObject json = new JSONObject();
                json.put("invoiceNo", (Object)invoiceNo);
                json.put("invoiceType", (Object)InputInvoiceTypeEnum.getAwsType((Object)invoiceType));
                HashSet<Integer> fileTypeSet = new HashSet<Integer>(1);
                fileTypeSet.add(-1);
                json.put("fileTypes", fileTypeSet);
                json.put("invoiceDate", (Object)DateUtils.format((Date)invoiceDate, (String)"yyyy-MM-dd HH:mm:ss"));
                json.put("buyerTaxNo", (Object)buyerTaxNo);
                json.put("buyerName", (Object)buyerName);
                json.put("salerTaxNo", (Object)salerTaxNo);
                json.put("salerName", (Object)salerName);
                json.put("totalAmount", (Object)totalAmount);
                json.put("cityCode", (Object)taxCity);
                invoices.add((Object)json);
                applyFiles.put(buyerTaxNo, invoices);
                ++successNum;
            }
            String msg = message.toString();
            if (!ObjectUtils.isEmpty(applyFiles)) {
                RpaFileDownApplyService rpaFileDownApplyService = new RpaFileDownApplyService();
                JSONObject rtn = rpaFileDownApplyService.applyTaxFile(applyFiles, minInvoiceDate, maxInvoiceDate, 0);
                if (!ResultContant.isSuccess((JSONObject)rtn).booleanValue()) {
                    this.plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%1$s", (String)"DownTaxFileOperateService_10", (String)"imc-rim-formplugin", (Object[])new Object[0]), rtn.getString("description")));
                    return;
                }
                int successNumResult = rtn.getIntValue("successNum");
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.plugin.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\uff0c\u4e0b\u8f7d\u7a0e\u5c40\u6e90\u6587\u4ef6\u7533\u8bf7\u6210\u529f%2$s\u6761\uff0c\u4e0b\u8f7d\u8bb0\u5f55\u8bf7\u5230\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u6570\u636e\u540c\u6b65\u65e5\u5fd7\u67e5\u8be2\u201d\u5217\u8868\u4e2d\u67e5\u770b\u3002\u7533\u8bf7\u5931\u8d25%3$s\u6761", (String)"DownTaxFileOperateService_12", (String)"imc-rim-formplugin", (Object[])new Object[0]), collection.size(), successNumResult, collection.size() - successNumResult), message.toString(), MessageTypes.Default);
                } else {
                    this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u4e0b\u8f7d\u8bb0\u5f55\u8bf7\u5230\u201c\u53d1\u7968\u5f52\u96c6\u7ba1\u7406-\u6570\u636e\u540c\u6b65\u65e5\u5fd7\u67e5\u8be2\u201d\u5217\u8868\u4e2d\u67e5\u770b", (String)"DownTaxFileOperateService_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
            } else {
                ViewUtil.showMessage((AbstractFormPlugin)this.plugin, (String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u5c40\u6e90\u6587\u4ef6", (String)"DownTaxFileOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), (String)msg, (int)0, (int)collection.size());
            }
        } else {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53d1\u7968\u4e3b\u8868\u201d\u7684\u201c\u4e0b\u8f7d\u7a0e\u5c40\u6e90\u6587\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DownTaxFileOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }
}

