/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;
import kd.imc.rim.formplugin.query.operate.DownloadOperateService;
import org.apache.commons.collections.CollectionUtils;

public class DownloadElectricOperateService
extends DownloadOperateService {
    private static Log LOGGER = LogFactory.getLog(DownloadElectricOperateService.class);

    public DownloadElectricOperateService(String type, AbstractFormPlugin plugin) {
        super(type, plugin);
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DownloadElectricOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            int size = selectCollection.size();
            if (size > 2000) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8d85\u8fc72000", (String)"DownloadElectricOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "in", (Object)selectCollection.getPrimaryKeyValues());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice", (String)"invoice_code,billno,invoice_no,invoice_type", (QFilter[])new QFilter[]{qFilter});
            StringBuilder message = new StringBuilder();
            for (DynamicObject invoice : collection) {
                long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("invoice_type"));
                String invoiceCode = invoice.getString("invoice_code");
                String invoiceNo = invoice.getString("invoice_no");
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                if (InputInvoiceTypeEnum.isEleInvoice((Long)invoiceType).booleanValue()) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u975e\u6570\u7535\u53d1\u7968\uff0c\u53ea\u652f\u6301\u5bfc\u51fa\u6570\u7535\u53d1\u7968\u6587\u4ef6\u3002", (String)"DownloadElectricOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup);
                message.append(msg);
                message.append(ViewUtil.LINE_SEPARATOR);
            }
            if (StringUtils.isNotEmpty((CharSequence)message.toString())) {
                this.plugin.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u7a0e\u5c40\u6570\u7535\u6e90\u6587\u4ef6\u5931\u8d25", (String)"DownloadElectricOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), message.toString(), MessageTypes.Default);
                return;
            }
            ViewUtil.openDialog((AbstractFormPlugin)this.plugin, null, (String)"rim_filetype_selected", (String)this.type);
        } else {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53d1\u7968\u4e3b\u8868\u201d\u7684\u201c\u5bfc\u51fa\u7a0e\u5c40\u6570\u7535\u7968\u6e90\u6587\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DownloadOperateService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (this.type.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map data = (Map)closedCallBackEvent.getReturnData();
            String downOriginalTypes = (String)data.get("downOriginalTypes");
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            InvoiceFileDownloadService.downloadFile(this.plugin, this.type, selectCollection.getPrimaryKeyValues(), downOriginalTypes, "");
        }
    }
}

