/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;
import kd.imc.rim.formplugin.query.operate.DownloadOperateService;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DownloadInvoiceAttachOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(DownloadOperateService.class);

    public DownloadInvoiceAttachOperateService() {
    }

    public DownloadInvoiceAttachOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        block10: {
            if (this.checkPermission()) {
                int size;
                AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
                ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                    this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DownloadOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                int MAX = BigDecimalUtil.transDecimal((Object)RimConfigUtils.getConfig((String)"downFileSize")).intValue();
                if (MAX < 1 || MAX > 5000) {
                    MAX = 100;
                }
                if ((size = selectCollection.size()) > MAX) {
                    this.plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u8bb0\u5f55\u8d85\u8fc7%1$s", (String)"DownloadInvoiceAttachOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), MAX), Integer.valueOf(3000));
                    return;
                }
                try {
                    if (size > 10) {
                        InvoiceFileDownloadService.downloadFile(this.plugin, this.type, selectCollection.getPrimaryKeyValues(), "", "");
                        break block10;
                    }
                    String url = "";
                    url = this.getInvoiceAndAttachList(selectCollection.getPrimaryKeyValues(), null);
                    if (StringUtils.isEmpty((CharSequence)url)) {
                        this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6", (String)"InvoiceFileDownloadService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        return;
                    }
                    this.plugin.getView().openUrl(url);
                }
                catch (Exception e) {
                    if (e instanceof MsgException) {
                        this.plugin.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
                        return;
                    }
                    LOGGER.info("DownloadInvoiceAttachOperateService", (Object)e);
                }
            } else {
                this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53d1\u7968\u4e3b\u8868\u201d\u7684\u201c\u5bfc\u51fa\u53d1\u7968\u53ca\u5173\u8054\u9644\u4ef6\u6587\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DownloadOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("bdm_download_center_v1");
            showParameter.setFormId("bos_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.plugin.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public String getInvoiceAndAttachList(Object[] pkList, String name) {
        ByteArrayOutputStream baos;
        block54: {
            InvoiceFileDownloadService downloadService = new InvoiceFileDownloadService();
            String nowinvoicenamerule = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"nowinvoicenamerule");
            String invoicenameseparator = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"invoicenameseparator");
            if (StringUtils.isEmpty((CharSequence)invoicenameseparator)) {
                invoicenameseparator = "_";
            }
            if (nowinvoicenamerule == null) {
                nowinvoicenamerule = "invoice_no,invoice_code";
            }
            String selectfields = "id,serial_no," + nowinvoicenamerule;
            if (StringUtils.isEmpty((CharSequence)nowinvoicenamerule)) {
                selectfields = "id,serial_no";
            }
            QFilter filter = new QFilter("id", "in", (Object)pkList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)selectfields, (QFilter[])new QFilter[]{filter});
            HashMap<String, DynamicObjectCollection> attachCollect = new HashMap<String, DynamicObjectCollection>(collect.size());
            HashMap<String, Object> fileNameMap = new HashMap<String, Object>(collect.size());
            ArrayList<String> serialNoList = new ArrayList<String>(collect.size());
            for (DynamicObject invoice : collect) {
                serialNoList.add(invoice.getString("serial_no"));
            }
            QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
            QFilter attachRelationFilter = new QFilter("relation_id", "in", serialNoList);
            DynamicObjectCollection attachRelationCollect = QueryServiceHelper.query((String)"rim_attach_relation", (String)"attach_id,relation_id", (QFilter[])new QFilter[]{attachRelationFilter});
            DynamicObjectCollection obtainFileName = QueryServiceHelper.query((String)"rim_invoice_file", (String)"serial_no,original_filename,pdf_url,ofd_url,image_url,xml_url,tax_pdf_url,tax_ofd_url,tax_xml_url", (QFilter[])new QFilter[]{serialFilter});
            for (Object fileNameAndUrl : obtainFileName) {
                String string = fileNameAndUrl.getString("serial_no");
                if (fileNameAndUrl == null) continue;
                fileNameMap.put(string, fileNameAndUrl);
            }
            HashMap<String, List> attachidMap = new HashMap<String, List>(8);
            for (DynamicObject dynamicObject : attachRelationCollect) {
                attachidMap.computeIfAbsent(dynamicObject.getString("relation_id"), k -> new ArrayList()).add(Long.parseLong(dynamicObject.getString("attach_id")));
            }
            for (Map.Entry entry : attachidMap.entrySet()) {
                QFilter attachidFilter;
                DynamicObjectCollection attachObj;
                String relationid = (String)entry.getKey();
                List attachids = (List)entry.getValue();
                if (attachids.size() <= 0 || (attachObj = QueryServiceHelper.query((String)"rim_attach", (String)"attach_url,original_name,file_extension,attach_type", (QFilter[])new QFilter[]{attachidFilter = new QFilter("id", "in", (Object)attachids)})) == null) continue;
                attachCollect.put(relationid, attachObj);
            }
            HashMap<String, Integer> fileNameIndexMap = new HashMap<String, Integer>(collect.size());
            String[] stringArray = nowinvoicenamerule.split(",");
            ArrayList<String> itemList = new ArrayList<String>(Arrays.asList(stringArray));
            boolean isAllEmpty = true;
            baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (DynamicObject invoice : collect) {
                    DynamicObjectCollection attachs;
                    String fileName;
                    Integer index;
                    Serializable decimalFormat;
                    Object fieldvalue;
                    String serialNo = invoice.getString("serial_no");
                    for (String field : itemList) {
                        if (itemList.size() == 1 && StringUtils.isEmpty((CharSequence)field)) {
                            isAllEmpty = true;
                            break;
                        }
                        if (StringUtils.isEmpty((CharSequence)invoice.getString(field))) continue;
                        isAllEmpty = false;
                        break;
                    }
                    StringBuilder fileNameSb = new StringBuilder();
                    if (!isAllEmpty) {
                        for (int i = 0; i < itemList.size(); ++i) {
                            Object val = invoice.get((String)itemList.get(i));
                            fieldvalue = "";
                            if (val instanceof Date) {
                                fieldvalue = DateUtils.format((Date)((Date)val));
                            } else if (val instanceof BigDecimal) {
                                decimalFormat = new DecimalFormat("#.00");
                                fieldvalue = decimalFormat.format(val);
                            } else if (val != null) {
                                fieldvalue = val.toString();
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)fieldvalue)) continue;
                            if (fileNameSb.length() > 0) {
                                fileNameSb.append(invoicenameseparator);
                            }
                            fileNameSb.append((String)fieldvalue);
                        }
                    } else {
                        String orginalname;
                        DynamicObject fileNameAndUrl = (DynamicObject)fileNameMap.get(serialNo);
                        if (fileNameAndUrl != null && StringUtils.isNotEmpty((CharSequence)(orginalname = fileNameAndUrl.getString("original_filename")))) {
                            fileNameSb.append(FilenameUtils.removeExtension((String)orginalname));
                        }
                    }
                    if (fileNameSb.length() < 1) {
                        fileNameSb.append(serialNo);
                    }
                    if ((index = (Integer)fileNameIndexMap.get(fileName = fileNameSb.toString())) == null) {
                        index = 1;
                    } else {
                        fieldvalue = index;
                        index = index + 1;
                        decimalFormat = index;
                        fileNameSb.append(invoicenameseparator).append(index);
                    }
                    fileNameIndexMap.put(fileName, index);
                    String finalName = fileNameSb.toString();
                    InputStream downloadStream = downloadService.downloadInvoiceFileInputStream(serialNo, finalName, attachs = (DynamicObjectCollection)attachCollect.get(serialNo), (DynamicObject)fileNameMap.get(serialNo));
                    if (downloadStream == null) continue;
                    downloadService.addZipEntry(zos, finalName + ".zip", downloadStream);
                }
            }
            catch (Exception e) {
                LOGGER.error("downloadAllFile IOException:", (Throwable)e);
                if (!(e instanceof MsgException)) break block54;
                throw new MsgException(e.getMessage());
            }
        }
        String url = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            Object invoiceType = this.plugin.getView().getFormShowParameter().getCustomParam("invoicetype");
            name = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType))).getName();
            String format = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            try (ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());){
                url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + format + ".zip", (InputStream)in, 5000);
            }
            catch (Exception e) {
                LOGGER.info("downloadAllFile-download exception:{}", (Object)e);
            }
        } else {
            InvoiceFileDownloadService invoiceFileDownloadService = new InvoiceFileDownloadService();
            url = invoiceFileDownloadService.upload(name + ".zip", baos.toByteArray());
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            return url;
        }
        return "";
    }
}

