/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.message.exception.MsgException;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.FileUtils;
import kd.imc.rim.common.utils.SysParamUtil;
import kd.imc.rim.formplugin.downloadcenter.InvoiceFileDownloadService;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DownloadOperateService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(DownloadOperateService.class);

    public DownloadOperateService() {
    }

    public DownloadOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"DownloadOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            int size = selectCollection.size();
            if (size > 2000) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u8d85\u8fc72000", (String)"DownloadOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setShowTitle(true);
            showParameter.setFormId("rim_get_filetype");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, this.type);
            showParameter.setCloseCallBack(closeCallBack);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("350");
            styleCss.setHeight("150");
            showParameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.plugin.getView().showForm(showParameter);
        } else {
            this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u53d1\u7968\u4e3b\u8868\u201d\u7684\u201c\u5bfc\u51fa\u53d1\u7968\u6587\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DownloadOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("bdm_download_center_v1");
            showParameter.setFormId("bos_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.plugin.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData;
        String actionId = closedCallBackEvent.getActionId();
        AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
        ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
        int size = selectCollection.size();
        if ("download_invoice".equals(actionId) && StringUtils.isNotEmpty((CharSequence)(returnData = (String)closedCallBackEvent.getReturnData()))) {
            String[] types = returnData.split(",");
            types = (String[])Arrays.stream(types).filter(s -> !s.isEmpty()).toArray(String[]::new);
            try {
                if (size > 10) {
                    InvoiceFileDownloadService.downloadFile(this.plugin, this.type, selectCollection.getPrimaryKeyValues(), "", returnData);
                } else {
                    String url = "";
                    url = this.getAllTypeInvoice(selectCollection.getPrimaryKeyValues(), null, types);
                    if (StringUtils.isEmpty((CharSequence)url)) {
                        this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u6587\u4ef6", (String)"InvoiceFileDownloadService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        return;
                    }
                    int count = this.getZipFileCountFromUrl(url);
                    this.plugin.getView().openUrl(url);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(1);
                    btnNameMaps.put(MessageBoxResult.OK.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"DownloadCenterHelper_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    this.plugin.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u51fa\u53d1\u7968[%1$s]\u4efd\uff0c\u672a\u5bfc\u51fa\u53d1\u7968[%2$s]\u4efd\uff0c\u8bf7\u68c0\u67e5\u672a\u5bfc\u51fa\u7684\u53d1\u7968\u662f\u5426\u4e0d\u5b58\u5728\u6240\u9009\u7c7b\u578b\u7684\u6587\u4ef6\u3002", (String)"DownloadCenterHelper_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), count, size - count), "", MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(this.type), btnNameMaps);
                }
            }
            catch (Exception e) {
                if (e instanceof MsgException) {
                    this.plugin.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
                    return;
                }
                LOGGER.info("DownloadInvoiceAttachOperateService", (Object)e);
            }
        }
    }

    public int getZipFileCountFromUrl(String zipUrl) throws Exception {
        int count = 0;
        InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(zipUrl);
        try (ZipInputStream zipIn = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    ++count;
                }
                zipIn.closeEntry();
            }
        }
        return count;
    }

    private String getfield(String[] types) {
        StringBuilder sb = new StringBuilder("serial_no,original_filename");
        String[] stringArray = types;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String type;
            switch (type = stringArray[i]) {
                case "pdf_url": {
                    sb.append(",pdf_url,tax_pdf_url");
                    continue block12;
                }
                case "ofd_url": {
                    sb.append(",ofd_url,tax_ofd_url");
                    continue block12;
                }
                case "image_url": {
                    sb.append(",image_url");
                    continue block12;
                }
                case "xml_url": {
                    sb.append(",xml_url,tax_xml_url");
                }
            }
        }
        return sb.toString();
    }

    public static int getInvoiceFileCount(String[] types, DynamicObject invoice) {
        int count = 0;
        String[] stringArray = types;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String type;
            switch (type = stringArray[i]) {
                case "pdf_url": {
                    String pdfUrl = invoice.getString("pdf_url");
                    String taxPdfUrl = invoice.getString("tax_pdf_url");
                    if (!StringUtils.isNotEmpty((CharSequence)pdfUrl) && !StringUtils.isNotEmpty((CharSequence)taxPdfUrl)) continue block12;
                    ++count;
                    continue block12;
                }
                case "ofd_url": {
                    String ofdUrl = invoice.getString("ofd_url");
                    String taxOfdUrl = invoice.getString("tax_ofd_url");
                    if (!StringUtils.isNotEmpty((CharSequence)ofdUrl) && !StringUtils.isNotEmpty((CharSequence)taxOfdUrl)) continue block12;
                    ++count;
                    continue block12;
                }
                case "image_url": {
                    String imageUrl = invoice.getString("image_url");
                    if (!StringUtils.isNotEmpty((CharSequence)imageUrl)) continue block12;
                    ++count;
                    continue block12;
                }
                case "xml_url": {
                    String xmlUrl = invoice.getString("xml_url");
                    String taxXmlUrl = invoice.getString("tax_xml_url");
                    if (!StringUtils.isNotEmpty((CharSequence)xmlUrl) && !StringUtils.isNotEmpty((CharSequence)taxXmlUrl)) continue block12;
                    ++count;
                }
            }
        }
        return count;
    }

    public String getAllTypeInvoice(Object[] pkList, String name, String[] types) {
        ByteArrayOutputStream baos;
        block56: {
            boolean oneFileFlag = true;
            boolean oneTypeFlag = false;
            if (types != null && types.length > 0) {
                oneTypeFlag = types.length <= 1;
            }
            InvoiceFileDownloadService downloadService = new InvoiceFileDownloadService();
            String nowinvoicenamerule = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"nowinvoicenamerule");
            String invoicenameseparator = (String)SysParamUtil.getParamValue((Long)RequestContext.get().getOrgId(), (String)"invoicenameseparator");
            if (StringUtils.isEmpty((CharSequence)invoicenameseparator)) {
                invoicenameseparator = "_";
            }
            if (nowinvoicenamerule == null) {
                nowinvoicenamerule = "invoice_no,invoice_code";
            }
            String selectfields = "id,serial_no," + nowinvoicenamerule;
            if (StringUtils.isEmpty((CharSequence)nowinvoicenamerule)) {
                selectfields = "id,serial_no";
            }
            QFilter filter = new QFilter("id", "in", (Object)pkList);
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"rim_invoice", (String)selectfields, (QFilter[])new QFilter[]{filter});
            HashMap<String, DynamicObject> fileNameMap = new HashMap<String, DynamicObject>(collect.size());
            ArrayList<String> serialNoList = new ArrayList<String>(collect.size());
            for (DynamicObject invoice : collect) {
                serialNoList.add(invoice.getString("serial_no"));
            }
            QFilter serialFilter = new QFilter("serial_no", "in", serialNoList);
            String selectField = "serial_no,original_filename,pdf_url,ofd_url,image_url,xml_url,tax_pdf_url,tax_ofd_url,tax_xml_url";
            if (types != null && types.length > 0) {
                selectField = this.getfield(types);
            }
            DynamicObjectCollection obtainFileName = QueryServiceHelper.query((String)"rim_invoice_file", (String)selectField, (QFilter[])new QFilter[]{serialFilter});
            for (DynamicObject fileNameAndUrl : obtainFileName) {
                String serialNo = fileNameAndUrl.getString("serial_no");
                int invoiceFileCount = DownloadOperateService.getInvoiceFileCount(types, fileNameAndUrl);
                if (invoiceFileCount > 1) {
                    oneFileFlag = false;
                }
                if (fileNameAndUrl == null) continue;
                fileNameMap.put(serialNo, fileNameAndUrl);
            }
            boolean noZipFlag = oneFileFlag || oneTypeFlag;
            HashMap<String, Integer> fileNameIndexMap = new HashMap<String, Integer>(collect.size());
            String[] items = nowinvoicenamerule.split(",");
            ArrayList<String> itemList = new ArrayList<String>(Arrays.asList(items));
            boolean isAllEmpty = true;
            baos = new ByteArrayOutputStream();
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (DynamicObject invoice : collect) {
                    String fileName;
                    Integer index;
                    Serializable decimalFormat;
                    Object fieldvalue;
                    String serialNo = invoice.getString("serial_no");
                    for (String field : itemList) {
                        if (itemList.size() == 1 && StringUtils.isEmpty((CharSequence)field)) {
                            isAllEmpty = true;
                            break;
                        }
                        if (StringUtils.isEmpty((CharSequence)invoice.getString(field))) continue;
                        isAllEmpty = false;
                        break;
                    }
                    StringBuilder fileNameSb = new StringBuilder();
                    if (!isAllEmpty) {
                        for (int i = 0; i < itemList.size(); ++i) {
                            Object val = invoice.get((String)itemList.get(i));
                            fieldvalue = "";
                            if (val instanceof Date) {
                                fieldvalue = DateUtils.format((Date)((Date)val));
                            } else if (val instanceof BigDecimal) {
                                decimalFormat = new DecimalFormat("#.00");
                                fieldvalue = decimalFormat.format(val);
                            } else if (val != null) {
                                fieldvalue = val.toString();
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)fieldvalue)) continue;
                            if (fileNameSb.length() > 0) {
                                fileNameSb.append(invoicenameseparator);
                            }
                            fileNameSb.append((String)fieldvalue);
                        }
                    } else {
                        String orginalname;
                        DynamicObject fileNameAndUrl = (DynamicObject)fileNameMap.get(serialNo);
                        if (fileNameAndUrl != null && StringUtils.isNotEmpty((CharSequence)(orginalname = fileNameAndUrl.getString("original_filename")))) {
                            fileNameSb.append(FilenameUtils.removeExtension((String)orginalname));
                        }
                    }
                    if (fileNameSb.length() < 1) {
                        fileNameSb.append(serialNo);
                    }
                    if ((index = (Integer)fileNameIndexMap.get(fileName = fileNameSb.toString())) == null) {
                        index = 1;
                    } else {
                        fieldvalue = index;
                        index = index + 1;
                        decimalFormat = index;
                        fileNameSb.append(invoicenameseparator).append(index);
                    }
                    fileNameIndexMap.put(fileName, index);
                    String finalName = fileNameSb.toString();
                    InputStream downloadStream = downloadService.downloadAllTypeInvoiceInputStream(serialNo, finalName, (DynamicObject)fileNameMap.get(serialNo), noZipFlag);
                    if (downloadStream == null) continue;
                    if (noZipFlag) {
                        Map fileMap = DynamicObjectUtil.dynamicObject2Map((DynamicObject)((DynamicObject)fileNameMap.get(serialNo)));
                        String suffix = this.getFileType(fileMap);
                        LOGGER.info("{}\u6587\u4ef6\u540e\u7f00\u4e3a\uff1a{}", (Object)serialNo, (Object)suffix);
                        downloadService.addZipEntry(zos, fileName + "." + suffix, downloadStream);
                        continue;
                    }
                    downloadService.addZipEntry(zos, finalName + ".zip", downloadStream);
                }
            }
            catch (Exception e) {
                LOGGER.error("downloadAllFile IOException:", (Throwable)e);
                if (!(e instanceof MsgException)) break block56;
                throw new MsgException(e.getMessage());
            }
        }
        String url = null;
        if (StringUtils.isBlank((CharSequence)name)) {
            Object invoiceType = this.plugin.getView().getFormShowParameter().getCustomParam("invoicetype");
            name = InputInvoiceTypeEnum.getInvoiceType((Long)Long.parseLong(String.valueOf(invoiceType))).getName();
            String format = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            try (ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());){
                url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + format + ".zip", (InputStream)in, 5000);
            }
            catch (Exception e) {
                LOGGER.info("downloadAllFile-download exception:{}", (Object)e);
            }
        } else {
            InvoiceFileDownloadService invoiceFileDownloadService = new InvoiceFileDownloadService();
            url = invoiceFileDownloadService.upload(name + ".zip", baos.toByteArray());
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            return url;
        }
        return "";
    }

    private String getFileType(Map<String, Object> fileMap) {
        String pdfurl = (String)CommonUtils.getJsonValue(fileMap, String.class, (String[])new String[]{"pdf_url", "tax_pdf_url"});
        String orfurl = (String)CommonUtils.getJsonValue(fileMap, String.class, (String[])new String[]{"ofd_url", "tax_ofd_url"});
        String imageurl = (String)CommonUtils.getJsonValue(fileMap, String.class, (String[])new String[]{"image_url"});
        String xmleurl = (String)CommonUtils.getJsonValue(fileMap, String.class, (String[])new String[]{"xml_url", "tax_xml_url"});
        Optional<String> firstNonEmpty = Arrays.asList(pdfurl, orfurl, imageurl, xmleurl).stream().filter(s -> s != null && !s.isEmpty()).findFirst();
        if (firstNonEmpty.isPresent()) {
            String trueUrl = firstNonEmpty.get();
            Pair fileContent = FileUtils.getFileContent((String)trueUrl);
            return (String)fileContent.getLeft();
        }
        return null;
    }
}

