/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;

public class SignOperateService
extends InvoiceOperateService {
    public SignOperateService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        if (this.checkPermission()) {
            DynamicObject[] invoices;
            JSONArray signArray = new JSONArray();
            JSONObject signJsons = new JSONObject();
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                selectCollection = ((IListView)listPlugin.getView()).getCurrentListAllRowCollection();
            }
            String status = "invoice_sign".equals(this.type) ? "1" : "0";
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((Object[])selectCollection.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"))) {
                String invoiceType = invoice.getString("invoice_type.id");
                String serialNo = invoice.getString("serial_no");
                if (!StringUtils.isNotEmpty((String)serialNo) || status.equals(invoice.getString("original_state"))) continue;
                JSONObject sign = new JSONObject();
                StringJoiner serialNos = new StringJoiner(",");
                serialNos.add(serialNo);
                int invoiceCount = 1;
                BigDecimal invoiceTotalAmount = BigDecimalUtil.transDecimal((Object)invoice.getString("total_amount")).setScale(2, 4);
                sign.put("invoiceType", (Object)invoiceType);
                sign.put("invoiceTypeName", (Object)InputInvoiceTypeEnum.getInvoiceType((Long)invoice.getLong("invoice_type.id")).getName());
                if (null != signJsons.get((Object)invoiceType)) {
                    sign = (JSONObject)signJsons.get((Object)invoiceType);
                    invoiceTotalAmount = invoiceTotalAmount.add(sign.getBigDecimal("invoiceTotalAmount")).setScale(2, 4);
                    invoiceCount += sign.getInteger("invoiceCount").intValue();
                    serialNos.add(sign.getString("serialNos"));
                }
                sign.put("invoiceTotalAmount", (Object)invoiceTotalAmount);
                sign.put("invoiceCount", (Object)invoiceCount);
                sign.put("serialNos", (Object)serialNos.toString());
                signJsons.put(invoiceType, (Object)sign);
            }
            for (String invoiceType : signJsons.keySet()) {
                JSONObject signJson = signJsons.getJSONObject(invoiceType);
                signArray.add((Object)signJson);
            }
            if (CollectionUtils.isEmpty((Collection)signArray)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53d1\u7968\u53ef\u7b7e\u6536!", (String)"SignOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            HashMap<String, Object> customParams = new HashMap<String, Object>(1);
            customParams.put("signArray", signArray.toJSONString());
            customParams.put("status", status);
            FormShowParameter showParameter = this.newPage("rim_inv_collect_sign", customParams, this.type);
            if (!"invoice_sign".equals(this.type)) {
                showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u53cd\u7b7e\u6536", (String)"SignOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            this.plugin.getView().showForm(showParameter);
        }
    }

    private FormShowParameter newPage(String formId, Map<String, Object> customParams, String callBackId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((String)callBackId)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, callBackId);
            showParameter.setCloseCallBack(closeCallBack);
        }
        return showParameter;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map callBackData = (Map)closedCallBackEvent.getReturnData();
        if (null != callBackData && null != callBackData.get("serialNos")) {
            if ("invoice_sign".equals(this.type)) {
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"SignOperateService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7b7e\u6536\u6210\u529f", (String)"SignOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        }
    }
}

