/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.multitenant.service.AbstractFpzsService;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.formplugin.query.operate.InvoiceOperateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateVouchService
extends InvoiceOperateService {
    private static Log LOGGER = LogFactory.getLog(UpdateVouchService.class);

    public UpdateVouchService(String type, AbstractFormPlugin plugin) {
        this.plugin = plugin;
        this.type = type;
    }

    @Override
    public void operate() {
        super.operate();
        if (!UpdateVouchService.checkPermission(this.type)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u66f4\u65b0\u51ed\u8bc1\u4fe1\u606f\u6743\u9650", (String)"UpdateVouchService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        if ("update_vouch".equals(this.type)) {
            AbstractListPlugin listPlugin = (AbstractListPlugin)this.plugin;
            ListSelectedRowCollection selectCollection = ((IListView)listPlugin.getView()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectCollection)) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d1\u7968", (String)"RelayInvoiceService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            Set vouchBill = null;
            try {
                vouchBill = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getCanBuildVoucherBillNames", (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOGGER.info("DapQueryDataService getCanBuildVoucherBillNames error:", (Object)e);
            }
            LOGGER.info("\u67e5\u8be2\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u7c7b\u578b\u96c6\u5408\u4e3a:{}", (Object)vouchBill);
            if (vouchBill == null) {
                this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u5b9e\u4f53\u5355\u636e\u96c6\u5408", (String)"UpdateVouchService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            HashMap<String, String> invoiceBillsMap = new HashMap<String, String>(8);
            Object[] primaryKeyValues = selectCollection.getPrimaryKeyValues();
            DynamicObject[] mainInvoices = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_invoice"));
            HashMap targetMaps = Maps.newHashMap();
            HashSet<String> tips = new HashSet<String>(8);
            for (DynamicObject mainInvoice : mainInvoices) {
                String expenseNo = mainInvoice.getString("expense_num");
                String vouchNo = mainInvoice.getString("vouch_no");
                if (StringUtils.isEmpty((CharSequence)expenseNo) || StringUtils.isEmpty((CharSequence)vouchNo)) {
                    tips.add(mainInvoice.getString("invoice_no"));
                    continue;
                }
                targetMaps.put(mainInvoice.getString("serial_no"), expenseNo);
                invoiceBillsMap.put(mainInvoice.getString("invoice_no"), expenseNo);
            }
            if (!tips.isEmpty()) {
                this.plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e2d\u6709\u672a\u5173\u8054\u5355\u636e\u6216\u51ed\u8bc1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff1a %1$s", (String)"UpdateVouchService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), ((Object)tips).toString()), Integer.valueOf(2000));
                return;
            }
            Pair<JSONArray, Boolean> validateResult = this.validateBill(targetMaps, vouchBill);
            if (!((Boolean)validateResult.getRight()).booleanValue()) {
                this.plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e2d\u6709\u5916\u90e8\u5355\u636e\u6216\u5916\u90e8\u51ed\u8bc1\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", (String)"UpdateVouchService_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), ((Object)tips).toString()), Integer.valueOf(2000));
                return;
            }
            this.updateVouch((JSONArray)validateResult.getLeft(), invoiceBillsMap, true);
            BillList billlist = (BillList)this.plugin.getControl("billlistap");
            billlist.clearSelection();
            billlist.refresh();
        }
    }

    public void updateVouch(JSONArray billInfos, Map<String, String> invoiceBillsMap, boolean isPlugin) {
        HashSet<String> failBillNos = new HashSet<String>(8);
        Map entityExpenseMap = billInfos.stream().map(JSONObject.class::cast).flatMap(jsonObject -> jsonObject.keySet().stream().map(key -> new AbstractMap.SimpleEntry<String, String>((String)key, jsonObject.getString(key)))).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, Collectors.mapping(AbstractMap.SimpleEntry::getValue, Collectors.toSet())));
        HashSet<String> emptyResultBills = new HashSet<String>(8);
        for (Map.Entry map : entityExpenseMap.entrySet()) {
            try {
                Set billIds = map.getValue();
                try {
                    billIds = billIds.stream().map(str -> str.startsWith((String)map.getKey() + "_") ? str.substring(((String)map.getKey()).length() + 1) : str).collect(Collectors.toSet());
                }
                catch (Exception e) {
                    LOGGER.info("\u5b58\u5728\u5355\u636eid\u52a0\u4e86entity\u524d\u7f00\u7684\uff0c\u53bb\u6389\u524d\u7f00 error\uff1a{}", (Object)e);
                }
                Set queryFilter = billIds.stream().map(Long::valueOf).collect(Collectors.toSet());
                LOGGER.info("\u8c03\u7528\u603b\u8d26\u5fae\u670d\u52a1\u83b7\u53d6\u51ed\u8bc1\u63a5\u53e3\u53c2\u6570\uff1a{}, {}", (Object)map.getKey(), queryFilter);
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getVoucherInfofromBill", (Object[])new Object[]{map.getKey(), queryFilter});
                LOGGER.info("\u8c03\u7528\u603b\u8d26\u5fae\u670d\u52a1\u83b7\u53d6\u51ed\u8bc1\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)result);
                if (result == null || result.isEmpty()) {
                    emptyResultBills.addAll(billIds);
                    continue;
                }
                for (Map.Entry voucherBill : result.entrySet()) {
                    if (!queryFilter.contains(voucherBill.getKey())) {
                        emptyResultBills.add(voucherBill.getKey() + "");
                    }
                    Set value = (Set)voucherBill.getValue();
                    QFilter idFilter = new QFilter("id", "in", (Object)value);
                    DynamicObjectCollection aiBizvouchers = QueryServiceHelper.query((String)"gl_voucher", (String)MetadataUtil.getFields((String)"gl_voucher"), (QFilter[])new QFilter[]{idFilter});
                    for (DynamicObject voucher : aiBizvouchers) {
                        boolean successFlag = this.saveVoucher(voucher, (Long)voucherBill.getKey());
                        if (successFlag) continue;
                        failBillNos.add(this.getBillNo((Long)voucherBill.getKey()));
                    }
                }
            }
            catch (Exception e) {
                if (isPlugin) {
                    this.plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25", (String)"H5InvoiceUploadPlugin_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                LOGGER.info("\u83b7\u53d6\u51ed\u8bc1\u63a5\u53e3\u51fa\u9519:", (Object)e);
                return;
            }
        }
        LOGGER.info("\u5355\u636e\u672a\u5728\u603b\u8d26\u67e5\u8be2\u5230\u51ed\u8bc1\u4fe1\u606f\uff1a{}", emptyResultBills);
        if (isPlugin) {
            String invoiceTips;
            if (!emptyResultBills.isEmpty() && !StringUtils.isEmpty((CharSequence)(invoiceTips = this.getInvoiceTips(emptyResultBills, invoiceBillsMap)))) {
                this.plugin.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a %1$s\uff0c\u672a\u67e5\u8be2\u5230\u5355\u636e\u5173\u8054\u7684\u51ed\u8bc1\u4fe1\u606f", (String)"UpdateVouchService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), invoiceTips, 3000));
                return;
            }
            if (failBillNos.isEmpty()) {
                LOGGER.info("\u64cd\u4f5c\u6210\u529f");
                this.plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"ClassInvoiceService_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            this.plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u51ed\u8bc1\u66f4\u65b0\u5931\u8d25\u5355\u636e\uff1a %1$s", (String)"UpdateVouchService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]), ((Object)failBillNos).toString()), Integer.valueOf(2000));
        }
    }

    private String getInvoiceTips(Set<String> emptyResultBills, Map<String, String> invoiceBillsMap) {
        LOGGER.info("\u53d1\u7968\u53f7\u7801-\u5355\u636e\u7f16\u53f7\u7ec4\u5408\uff1a{}", invoiceBillsMap);
        DynamicObjectCollection emptyBillNos = QueryServiceHelper.query((String)"rim_expense", (String)"expense_num", (QFilter[])new QFilter[]{new QFilter("expense_id", "in", emptyResultBills)});
        if (CollectionUtils.isEmpty((Collection)emptyBillNos)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List emptyBills = emptyBillNos.stream().map(s -> s.getString("expense_num")).collect(Collectors.toList());
        for (Map.Entry<String, String> entry : invoiceBillsMap.entrySet()) {
            String invoiceNo = entry.getKey();
            String expenseNo = entry.getValue();
            if (expenseNo.contains(",")) {
                String[] expenseNos = expenseNo.split(",");
                if (!emptyBills.containsAll(Arrays.asList(expenseNos))) continue;
                sb.append(invoiceNo).append(",");
                continue;
            }
            if (!emptyBills.contains(expenseNo)) continue;
            sb.append(invoiceNo).append(",");
        }
        if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    private String getBillNo(Long key) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"rim_expense", (String)"expense_no", (QFilter[])new QFilter[]{new QFilter("expense_id", "=", (Object)(key + ""))});
        if (object != null) {
            return object.getString("expense_no");
        }
        return "";
    }

    private boolean saveVoucher(DynamicObject row, Long billId) {
        Object vouchId = row.get("id");
        Object vouchNo = row.get("billno");
        Object businessDate = row.get("bizdate");
        Object accountDate = row.get("bookeddate");
        JSONObject vouchInfo = new JSONObject();
        vouchInfo.put("vouchId", vouchId);
        vouchInfo.put("vouchNo", vouchNo);
        vouchInfo.put("resource", (Object)"4");
        vouchInfo.put("businessDate", businessDate);
        vouchInfo.put("accountDate", accountDate);
        JSONArray expenseIdArray = new JSONArray();
        expenseIdArray.add((Object)billId);
        HashMap param = Maps.newHashMap();
        param.put("expenseIdArray", expenseIdArray);
        param.put("voucherInfo", vouchInfo);
        AbstractFpzsService service = AbstractFpzsService.newInstance();
        Map result = service.saveVoucher((Map)param);
        return result != null && "0000".equals(result.get("errcode"));
    }

    private Pair<JSONArray, Boolean> validateBill(Map<String, String> targetMaps, Set<String> vouchBill) {
        if (targetMaps.isEmpty()) {
            return Pair.of(null, (Object)false);
        }
        JSONArray result = new JSONArray();
        for (Map.Entry<String, String> entry : targetMaps.entrySet()) {
            QFilter filter;
            String expenseNo = entry.getValue();
            int size = 1;
            if (expenseNo.contains(",")) {
                String[] expenseNos = expenseNo.split(",");
                filter = new QFilter("expense_num", "in", Arrays.asList(expenseNos));
                size = expenseNos.length;
            } else {
                filter = new QFilter("expense_num", "=", (Object)expenseNo);
            }
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)entry.getKey());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"rim_expense_relation", (String)MetadataUtil.getFields((String)"rim_expense_relation"), (QFilter[])new QFilter[]{filter, serialFilter});
            int falseNum = 0;
            for (DynamicObject obj : query) {
                JSONObject billInfo = new JSONObject();
                String entityId = obj.getString("entityid");
                if (size == 1 && !vouchBill.contains(entityId)) {
                    return Pair.of(null, (Object)false);
                }
                if (size > 1 && !vouchBill.contains(entityId)) {
                    ++falseNum;
                    continue;
                }
                billInfo.put(obj.getString("entityid"), (Object)obj.getString("expense_id"));
                result.add((Object)billInfo);
            }
            if (falseNum != size) continue;
            return Pair.of(null, (Object)false);
        }
        return Pair.of((Object)result, (Object)true);
    }
}

