/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.deduction.DeductSelectService;
import kd.imc.rim.common.invoice.deduction.DeductServiceFactory;
import kd.imc.rim.common.utils.DeductionUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.DeductionLoginOperateService;

public class DeductSelectLoginOperateService
extends DeductionLoginOperateService {
    public DeductSelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    public DeductSelectLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        super(type, currentOrgId, plugin, consumer);
    }

    @Override
    public boolean beforeLoginDoOperation(String dkType, String taxNo, JSONObject configObj) {
        if (TenantUtils.isSmallScaleTaxpayer((String)taxNo)) {
            JSONArray invoices = configObj.getJSONArray("invoices");
            this.setCacheTip(taxNo, invoices, ErrorType.SMALL_SCALE_TAXPAYER_DEDUCT.getName());
            return true;
        }
        return false;
    }

    @Override
    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
        String deductibleMode;
        String notSelectLoginFail = RimConfigUtils.getConfig((String)"not_select_login_fail");
        String rpaSelectSyn = configObj.getString("rpa_select_syn");
        JSONArray invoices = configObj.getJSONArray("invoices");
        if (StringUtils.isBlank((CharSequence)rpaSelectSyn)) {
            rpaSelectSyn = DeductSelectLoginOperateService.isSyncDown(taxNo) ? "1" : "0";
            configObj.put("rpa_select_syn", (Object)rpaSelectSyn);
        }
        if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
            configObj.put("errcode", (Object)ErrorType.ALl_E_LOGIN_FAIL.getCode());
            configObj.put("description", (Object)failMsg);
            if ("1".equals(rpaSelectSyn) || "1".equals(notSelectLoginFail)) {
                JSONObject resultParam = ResultContant.createSuccessJSONObject();
                StringBuilder resultMessage = new StringBuilder();
                resultMessage.append(taxNo).append("\uff1a").append(failMsg).append(ViewUtil.LINE_SEPARATOR);
                resultParam.put("message", (Object)resultMessage.toString());
                resultParam.put("successNum", (Object)0);
                resultParam.put("failNum", (Object)invoices.size());
                this.setOperationResult2Cache(resultParam);
                return;
            }
        }
        if (!"2".equals(deductibleMode = configObj.getString("deductibleMode")) && !"-2".equals(deductibleMode) && DeductionUtils.checkStatisticsStatus((String)taxNo, (Long)this.currentOrgId)) {
            this.setCacheTip(taxNo, invoices, ErrorType.STATISTICS_STATUS_LOCKED.getName());
            return;
        }
        DeductSelectService service = DeductServiceFactory.newInstanceForDeductSelect((String)dkType);
        String queryType = configObj.getString("queryType");
        JSONArray isselect = invoices.stream().filter(f -> "1".equals(((JSONObject)f).getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
        JSONArray noselect = invoices.stream().filter(f -> "0".equals(((JSONObject)f).getString("isselect"))).collect(Collectors.toCollection(JSONArray::new));
        if (isselect.size() == 0 && noselect.size() == 0) {
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
            return;
        }
        if (isselect.size() > 0) {
            if ("undeduction".equals(queryType)) {
                configObj.put("deductibleMode", (Object)"4");
            } else if ("deduction".equals(queryType)) {
                configObj.put("deductibleMode", (Object)"1");
            }
            configObj.put("invoices", (Object)isselect);
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
        }
        if (noselect.size() > 0) {
            configObj.put("cancelSelectType", (Object)"1");
            for (int i = 0; i < noselect.size(); ++i) {
                if ("undeduction".equals(queryType)) {
                    configObj.put("deductibleMode", (Object)"-4");
                    continue;
                }
                if (!"deduction".equals(queryType)) continue;
                configObj.put("deductibleMode", (Object)"-1");
            }
            configObj.put("invoices", (Object)noselect);
            JSONObject selectRtn = service.batchSelectInvoices(configObj);
            this.setOperationResult2Cache(selectRtn);
        }
    }
}

