/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.DeductionLoginOperateService;

public class DownInvoiceLoginOperateService
extends DeductionLoginOperateService {
    public DownInvoiceLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    @Override
    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
        JSONArray batchNoList = configObj.getJSONArray("data");
        JSONObject resultInfo = ResultContant.createSuccessJSONObject();
        StringBuilder message = new StringBuilder();
        boolean isLogin = StringUtils.isEmpty((CharSequence)failMsg);
        String async = RimConfigUtils.getConfig((String)"rim_deduction", (String)"batch_down_invoice_sync");
        if ("1".equals(async)) {
            ThreadPools.executeOnceIncludeRequestContext((String)"DownLogPlugin.downSync", () -> this.downSync(taxNo, batchNoList, async, isLogin));
            resultInfo.put("successNum", (Object)batchNoList.size());
            resultInfo.put("failNum", (Object)0);
            resultInfo.put("message", (Object)message.toString());
            this.setOperationResult2Cache(resultInfo);
        } else {
            this.downSync(taxNo, batchNoList, async, isLogin);
        }
    }

    private void downSync(String taxNo, JSONArray batchNoList, String async, boolean isLogin) {
        if (batchNoList == null) {
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(batchNoList.size());
        for (int i = 0; i < batchNoList.size(); ++i) {
            JSONObject logConfig = batchNoList.getJSONObject(i);
            idList.add(logConfig.getLong("id"));
        }
        CacheHelper.remove((String)("e_down_login_" + taxNo));
        DynamicObject[] downLogDynamicObject = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rim_down_log"));
        int successNum = 0;
        int failNum = 0;
        JSONObject resultInfo = ResultContant.createSuccessJSONObject();
        StringBuilder message = new StringBuilder();
        HashSet<String> succBatchNos = new HashSet<String>(idList.size());
        for (DynamicObject dynamicObject : downLogDynamicObject) {
            String batchNo = dynamicObject.getString("batch_no");
            JSONObject downResult = InvoiceDownHelper.downInvoice((DynamicObject)dynamicObject, null, (RequestContext)RequestContext.get(), (boolean)isLogin);
            if (downResult == null) {
                return;
            }
            if (ResultContant.isSuccess((JSONObject)downResult).booleanValue()) {
                succBatchNos.add(batchNo);
                ++successNum;
                continue;
            }
            ++failNum;
            message.append(batchNo).append('\uff1a').append(downResult.getString("description")).append(ViewUtil.LINE_SEPARATOR);
        }
        resultInfo.put("message", (Object)message.toString());
        resultInfo.put("successNum", (Object)successNum);
        resultInfo.put("failNum", (Object)failNum);
        if ("1".equals(async)) {
            InvoiceDownHelper.dealInvoice(succBatchNos);
        } else {
            this.setOperationResult2Cache(resultInfo);
            if (!CollectionUtils.isEmpty(succBatchNos)) {
                ThreadPools.executeOnceIncludeRequestContext((String)"DownLogPlugin.dealInvice", () -> InvoiceDownHelper.dealInvoice((Set)succBatchNos));
            }
        }
    }
}

