/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.query.operate.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.ErrorType;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.collector.InvoiceHeaderDownService;
import kd.imc.rim.common.invoice.deduction.impl.NewEtaxDeductService;
import kd.imc.rim.common.invoice.download.RpaFileDownApplyService;
import kd.imc.rim.common.invoice.download.impl.NewEtaxInputOutInvoiceApplyServiceImpl;
import kd.imc.rim.common.invoice.download.impl.NewEtaxTaxperiodInvoiceDownServiceImpl;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.ListUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.UUID;
import kd.imc.rim.common.utils.ViewUtil;
import kd.imc.rim.formplugin.query.operate.DeductionLoginOperateService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class ReapplyDownLoginOperateService
extends DeductionLoginOperateService {
    private static Log LOGGER = LogFactory.getLog(ReapplyDownLoginOperateService.class);

    public ReapplyDownLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin) {
        super(type, currentOrgId, plugin);
    }

    public ReapplyDownLoginOperateService(String type, Long currentOrgId, AbstractFormPlugin plugin, Consumer<String> consumer) {
        super(type, currentOrgId, plugin, consumer);
    }

    @Override
    public void operate() {
        String cache = this.plugin.getPageCache().get("deduct_tax_no");
        String title = this.plugin.getPageCache().get("deduct_title");
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject cacheJson = JSONObject.parseObject((String)cache);
        if (ObjectUtils.isEmpty((Object)cacheJson)) {
            this.plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef,\u7f13\u5b58\u4e3a\u7a7a", (String)"DeductionLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            return;
        }
        String notLoginReapply = ImcConfigUtil.getValue((String)"rim_download", (String)"not_login_reapply");
        ArrayList<String> list = new ArrayList<String>(cacheJson.size());
        LOGGER.info("\u767b\u5f55\u68c0\u6d4b\u7a0e\u53f7:{}", (Object)cacheJson.keySet());
        for (Map.Entry entry : cacheJson.entrySet()) {
            JSONArray jsonArray;
            String taxNo = (String)entry.getKey();
            JSONObject configObj = cacheJson.getJSONObject(taxNo);
            if (StringUtils.isBlank((CharSequence)taxNo)) {
                list.add(taxNo);
                JSONArray jsonArray2 = configObj.getJSONArray("data");
                this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u7a0e\u53f7\u4e3a\u7a7a", (String)"DownLogListPlugin_14", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray2, 0);
                continue;
            }
            String dkType = DeductionConstant.getDkType((String)taxNo);
            LOGGER.info("{}\u6536\u7968\u901a\u9053:{}", (Object)taxNo, (Object)dkType);
            if (StringUtils.isBlank((CharSequence)dkType)) {
                list.add(taxNo);
                jsonArray = configObj.getJSONArray("data");
                this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u4e3a\u7a7a", (String)"DownLogListPlugin_17", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
                continue;
            }
            if ("4".equals(dkType)) {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)notLoginReapply)) {
                    this.afterLoginDoOperation(dkType, taxNo, configObj, null);
                    list.add(taxNo);
                    continue;
                }
                boolean isBreak = this.loginEleClient(cacheJson, list, taxNo, configObj, dkType);
                if (!isBreak) continue;
                return;
            }
            if ("select_reapply_login".equals(this.type) && "5".equals(dkType)) {
                this.afterLoginDoOperation(dkType, taxNo, configObj, null);
                list.add(taxNo);
                continue;
            }
            list.add(taxNo);
            jsonArray = configObj.getJSONArray("data");
            this.setCacheTip(taxNo, ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"DownLogListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]), jsonArray, 0);
        }
        for (String tt : list) {
            cacheJson.remove((Object)tt);
        }
        if (cacheJson.isEmpty()) {
            this.showResult.accept(title);
        }
    }

    @Override
    public boolean loginEleClient(JSONObject cacheJson, List<String> list, String taxNo, JSONObject configObj, String dkType) {
        NewEtaxDeductService service = new NewEtaxDeductService(Long.valueOf(0L));
        JSONObject loginResult = service.login(taxNo);
        JSONObject data = loginResult.getJSONObject("data");
        if (ResultContant.isSuccess((JSONObject)loginResult).booleanValue()) {
            if (service.needOpenLoginPage(data)) {
                data.put("taxNo", (Object)taxNo);
                service.showLoginPage(data, this.plugin, this.type);
                this.plugin.getPageCache().put("loginTaxNo", taxNo);
                for (String tt : list) {
                    cacheJson.remove((Object)tt);
                }
                this.plugin.getPageCache().put("deduct_tax_no", cacheJson.toJSONString());
                return true;
            }
            this.afterLoginDoOperation(dkType, taxNo, configObj, null);
            list.add(taxNo);
        } else {
            if (loginResult == null) {
                loginResult = new JSONObject();
                loginResult.put("errcode", (Object)ErrorType.ALl_E_LOGIN_FAIL.getCode());
                loginResult.put("description", (Object)ErrorType.ALl_E_LOGIN_FAIL.getName());
            }
            list.add(taxNo);
            StringBuilder resultMessage = new StringBuilder();
            JSONArray downLogArr = configObj.getJSONArray("data");
            this.setCacheTip(taxNo, loginResult.getString("description"), downLogArr, 0);
        }
        return false;
    }

    @Override
    public void afterLoginDoOperation(String dkType, String taxNo, JSONObject configObj, String failMsg) {
        JSONArray donwLogArr = configObj.getJSONArray("data");
        String notSelectLoginFail = RimConfigUtils.getConfig((String)"not_reapply_down_fail");
        if (StringUtils.isNotEmpty((CharSequence)failMsg) && "1".equals(notSelectLoginFail)) {
            this.setCacheTip(taxNo, failMsg, donwLogArr, 0);
            return;
        }
        this.reapply(taxNo, donwLogArr);
    }

    public void setCacheTip(String taxNo, String messageParam, JSONArray downLogArr, int successNum) {
        JSONObject resultParam = ResultContant.createSuccessJSONObject();
        StringBuilder message = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)messageParam)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)downLogArr)) {
                for (int i = 0; i < downLogArr.size(); ++i) {
                    JSONObject downLog = downLogArr.getJSONObject(i);
                    String batchNo = downLog.getString("batch_no");
                    message.append(String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7\uff1a%1$s\uff0c\u7a0e\u53f7\uff1a%2$s\uff0c%3$s", (String)"ReapplyDownLoginOperateService_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), batchNo, taxNo, messageParam)).append(ViewUtil.LINE_SEPARATOR);
                }
            } else {
                message.append(messageParam).append(ViewUtil.LINE_SEPARATOR);
            }
            resultParam.put("message", (Object)message.toString());
        }
        resultParam.put("successNum", (Object)successNum);
        resultParam.put("failNum", (Object)(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)downLogArr) ? downLogArr.size() : 0));
        this.setOperationResult2Cache(resultParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapply(String taxNo, JSONArray donwLogArr) {
        if (CollectionUtils.isEmpty((Collection)donwLogArr)) {
            LOGGER.info("\u540c\u6b65\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a");
        }
        Set idSet = donwLogArr.toJavaList(JSONObject.class).stream().map(t -> t.get((Object)"id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection logList = QueryServiceHelper.query((String)"rim_down_log", (String)"id,gov_status,tax_no,inout,taskno,batch_no,invoice_type,sync_type,org.id as org,requestid,invoice_startdate,invoice_enddate,aws_invoice_type,json_tag", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : logList) {
            String govStatus = dynamicObject.getString("gov_status");
            String batchNo = dynamicObject.getString("batch_no");
            String inout = dynamicObject.getString("inout");
            String dkType = DeductionConstant.getDkType((String)taxNo);
            long id = dynamicObject.getLong("id");
            String key = "rim.ReapplyDownLoginOperateService-" + batchNo;
            DLock lock = DLock.create((String)key, (String)"ReapplyDownLoginOperateService.lock");
            Throwable throwable = null;
            try {
                if (!lock.tryLock()) continue;
                try {
                    JSONObject result;
                    if ("1".equals(inout) || "2".equals(inout)) {
                        NewEtaxInputOutInvoiceApplyServiceImpl applyService = new NewEtaxInputOutInvoiceApplyServiceImpl();
                        JSONObject result2 = applyService.reapply(Long.valueOf(id));
                        this.dealData(dynamicObject, taxNo, result2);
                        continue;
                    }
                    if ("3".equals(inout)) {
                        result = this.reapplyHeadDown(dynamicObject);
                        this.dealData(dynamicObject, taxNo, result);
                        continue;
                    }
                    if ("7".equals(inout)) {
                        result = this.reapplyEleFile(dynamicObject);
                        this.dealData(dynamicObject, taxNo, result);
                        continue;
                    }
                    if ("9".equals(inout)) {
                        result = this.reapplyAgricInvoice(dynamicObject);
                        this.dealData(dynamicObject, taxNo, result);
                        continue;
                    }
                    LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u4e0b\u8f7d\u7c7b\u578b\u4e0d\u652f\u6301: {}", new Object[]{taxNo, id, inout});
                    result = ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u8fdb\u3001\u9500\u9879\u5168\u91cf\uff1b\u8fdb\u9879\u8981\u7d20\u3001\u6570\u7535\u6587\u4ef6\u548c\u519c\u4ea7\u54c1\u4e0b\u8f7d", (String)"DownLogListPlugin_18", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    this.dealData(dynamicObject, taxNo, result);
                }
                catch (Exception e) {
                    LOGGER.error("\u540c\u6b65\u65e5\u5fd7\u91cd\u8bd5\u5931\u8d25:" + batchNo, (Throwable)e);
                    JSONArray jsonArray = new JSONArray(1);
                    jsonArray.add((Object)DynamicObjectUtil.dynamicObject2Map((DynamicObject)dynamicObject));
                    this.setCacheTip(taxNo, e.getMessage(), jsonArray, 0);
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
    }

    private void dealData(DynamicObject dynamicObject, String taxNo, JSONObject result) {
        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
            this.setCacheTip(taxNo, "", null, 1);
        } else {
            JSONArray jsonArray = new JSONArray(1);
            jsonArray.add((Object)DynamicObjectUtil.dynamicObject2Map((DynamicObject)dynamicObject));
            String description = "";
            if (result != null) {
                description = result.getString("description");
            }
            this.setCacheTip(taxNo, description, jsonArray, 0);
        }
    }

    private JSONObject reapplyHeadDown(DynamicObject dynamicObject) {
        JSONObject success = ResultContant.createSuccessJSONObject();
        String taxNo = dynamicObject.getString("tax_no");
        Date invoiceStartdate = dynamicObject.getDate("invoice_startdate");
        Date invoiceEnddate = dynamicObject.getDate("invoice_enddate");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type"));
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("org"));
        String jsonTag = dynamicObject.getString("json_tag");
        String syncType = dynamicObject.getString("sync_type");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        long id = dynamicObject.getLong("id");
        boolean synFlg = true;
        JSONObject jsonParam = null;
        try {
            jsonParam = JSON.parseObject((String)jsonTag);
            if (jsonParam != null) {
                synFlg = !StringUtils.equals((CharSequence)"1", (CharSequence)jsonParam.getString("rpadownAsyn"));
            }
        }
        catch (Exception e) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u8868\u5934\u4e0b\u8f7d\uff0cjson\u89e3\u6790\u5931\u8d25, {}", new Object[]{taxNo, id, jsonTag});
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u8fdb\u9879\u8981\u7d20\u91cd\u8bd5\uff0c\u89e3\u6790\u6570\u636e\u5f02\u5e38", (String)"ReapplyDownLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (synFlg) {
            DynamicObject dynamicObjectDB = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_down_log");
            if (dynamicObjectDB != null) {
                dynamicObjectDB.set("gov_status", (Object)"6");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectDB});
            }
            return success;
        }
        if (jsonParam == null) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u8868\u5934\u4e0b\u8f7d\uff0cjson\u89e3\u6790\u5931\u8d25, {}", new Object[]{taxNo, id, jsonTag});
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u8fdb\u9879\u8981\u7d20\u91cd\u8bd5\uff0c\u89e3\u6790\u6570\u636e\u5f02\u5e38", (String)"ReapplyDownLoginOperateService_1", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        NewEtaxTaxperiodInvoiceDownServiceImpl service = new NewEtaxTaxperiodInvoiceDownServiceImpl();
        NewEtaxDeductService newEtaxDeductService = new NewEtaxDeductService(orgId);
        JSONObject resultObject = newEtaxDeductService.downInvoiceHeadApply(jsonParam);
        if (resultObject != null && ResultContant.isSuccess((JSONObject)resultObject).booleanValue()) {
            InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
            JSONObject logParam = new JSONObject();
            logParam.put("searchOpt", (Object)jsonParam.getJSONObject("searchOpt"));
            logParam.put("rpadownAsyn", (Object)jsonParam.getString("rpadownAsyn"));
            logParam.put("billType", (Object)jsonParam.getString("billType"));
            logParam.put("taxNo", (Object)taxNo);
            logParam.put("taskNo", (Object)UUID.getBatchNo((String)"DOWN"));
            logParam.put("syncType", (Object)syncType);
            invoiceHeaderDownService.insertDownLog(logParam, resultObject);
        } else {
            LOGGER.info("rpa\u91cd\u65b0\u7533\u8bf7-\u5df2\u52fe\u9009\u6216\u5df2\u62b5\u6263\u5f02\u6b65\u8868\u5934\u4e0b\u8f7d\u7533\u8bf7\u5931\u8d25, \u7a0e\u53f7-{}, id-{}, \u8fd4\u56de\u503c-{}", new Object[]{taxNo, id, resultObject});
        }
        return resultObject;
    }

    private JSONObject reapplyAgricInvoice(DynamicObject dynamicObject) {
        String batchNo = dynamicObject.getString("batch_no");
        String taxNo = dynamicObject.getString("tax_no");
        Date invoiceStartdate = dynamicObject.getDate("invoice_startdate");
        Date invoiceEnddate = dynamicObject.getDate("invoice_enddate");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type"));
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("org"));
        String jsonTag = dynamicObject.getString("json_tag");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        long id = dynamicObject.getLong("id");
        if (!"4".equals(dkType)) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u519c\u4ea7\u54c1\u4e0b\u8f7d\u53ea\u6709\u65b0\u7535\u5b50\u7a0e\u52a1\u901a\u9053\u652f\u6301", (Object)taxNo, (Object)id);
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"DownLogListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        JSONObject object = null;
        try {
            object = JSON.parseObject((String)jsonTag);
        }
        catch (Exception e) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u519c\u4ea7\u54c1\u4e0b\u8f7d\uff0cjson\u89e3\u6790\u5931\u8d25, {}", new Object[]{taxNo, id, jsonTag});
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u4e0b\u8f7d\u91cd\u8bd5\uff0c\u89e3\u6790\u6570\u636e\u5f02\u5e38", (String)"ReapplyDownLoginOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (object == null) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u519c\u4ea7\u54c1\u4e0b\u8f7d\uff0cjsonTag\u6570\u636e\u6709\u8bef, {}", new Object[]{taxNo, id, jsonTag});
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u519c\u4ea7\u54c1\u4e0b\u8f7d\u91cd\u8bd5\uff0c\u89e3\u6790\u6570\u636e\u5f02\u5e38", (String)"ReapplyDownLoginOperateService_9", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        String farmProductType = object.getString("farmProductType");
        String invoiceStatus = object.getString("invoiceStatus");
        String processingStatusOld = object.getString("processingStatus");
        JSONObject param = new JSONObject();
        param.put("taxNo", (Object)taxNo);
        param.put("farmProductType", (Object)farmProductType);
        param.put("invoiceStatus", (Object)invoiceStatus);
        param.put("processingStatus", (Object)processingStatusOld);
        param.put("startDate", (Object)DateUtils.format((Date)invoiceStartdate));
        param.put("endDate", (Object)DateUtils.format((Date)invoiceEnddate));
        InvoiceHeaderDownService invoiceHeaderDownService = new InvoiceHeaderDownService(orgId);
        JSONObject result = invoiceHeaderDownService.downAgricInvoice(taxNo, orgId, param);
        return result;
    }

    private JSONObject reapplyEleFile(DynamicObject dynamicObject) {
        String taxNo = dynamicObject.getString("tax_no");
        String batchNo = dynamicObject.getString("batch_no");
        String inout = dynamicObject.getString("inout");
        Date invoiceStartdate = dynamicObject.getDate("invoice_startdate");
        Date invoiceEnddate = dynamicObject.getDate("invoice_enddate");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("invoice_type"));
        String awsInvoiceType = dynamicObject.getString("aws_invoice_type");
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("org"));
        long id = dynamicObject.getLong("id");
        String dkType = DeductionConstant.getDkType((String)taxNo);
        if (!"4".equals(dkType)) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u8fdb\u9879\u53d1\u7968\u4e0b\u8f7d\u6587\u4ef6\u53ea\u6709\u65b0\u7535\u5b50\u7a0e\u52a1\u901a\u9053\u652f\u6301: {}", new Object[]{taxNo, id, inout});
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u6536\u7968\u901a\u9053\u975e\u65b0\u7535\u5b50\u5e73\u53f0\uff0c\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u64cd\u4f5c", (String)"DownLogListPlugin_16", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        QFilter batchNoFilter = new QFilter("batch_no", "=", (Object)batchNo);
        QFilter invoiceTypeFilter = null;
        if (invoiceType > 0L) {
            invoiceTypeFilter = new QFilter("invoice_type", "=", (Object)invoiceType);
        }
        QFilter dataTypeFilter = new QFilter("data_type_tb", "=", (Object)"7");
        DynamicObjectCollection downAccountCollection = QueryServiceHelper.query((String)"rim_down_account", (String)"id, batch_no, invoice_no, serial_no", (QFilter[])new QFilter[]{batchNoFilter, dataTypeFilter, invoiceTypeFilter});
        List<Object> invoiceNoList = new ArrayList(16);
        if (CollectionUtils.isEmpty((Collection)downAccountCollection)) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u8fdb\u9879\u53d1\u7968\u4e0b\u8f7d\u6587\u4ef6-\u4e0d\u5b58\u5728\u53f0\u8d26: {}", new Object[]{taxNo, id, inout});
            if (invoiceStartdate == null || invoiceEnddate == null) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u53f0\u8d26\u4e3a\u7a7a\u4e14\u4e0d\u5b58\u5728\u8d77\u6b62\u65e5\u671f\uff0c\u4e0d\u8fdb\u884c\u4e0b\u8f7d: {}", new Object[]{taxNo, id, inout});
                return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u53f0\u8d26\u4e3a\u7a7a\u4e14\u4e0d\u5b58\u5728\u8d77\u6b62\u65e5\u671f", (String)"ReapplyDownLoginOperateService_3", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            if (invoiceType > 0L && !InputInvoiceTypeEnum.isEleInvoice((Long)invoiceType).booleanValue()) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u7968\u79cd\u4e0d\u652f\u6301\u4e0b\u8f7d\u6570\u7535\u6587\u4ef6", (Object)taxNo, (Object)id);
                return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u8be5\u7968\u79cd\u4e0d\u652f\u6301\u4e0b\u8f7d\u6570\u7535\u6587\u4ef6", (String)"ReapplyDownLoginOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            ArrayList filters = Lists.newArrayList();
            filters.add(new QFilter("buyer_tax_no", "=", (Object)taxNo));
            if (invoiceType > 0L) {
                if (!InputInvoiceTypeEnum.isEleInvoice((Long)invoiceType).booleanValue()) {
                    LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u7968\u79cd\u4e0d\u652f\u6301\u4e0b\u8f7d\u6570\u7535\u6587\u4ef6", (Object)taxNo, (Object)id);
                    return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u8be5\u7968\u79cd\u4e0d\u652f\u6301\u4e0b\u8f7d\u6570\u7535\u6587\u4ef6", (String)"ReapplyDownLoginOperateService_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                }
                filters.add(new QFilter("invoice_type", "=", (Object)invoiceType));
            } else {
                List awsTypeList;
                HashSet<Long> invoiceTypeSet = new HashSet<Long>(1);
                if (StringUtils.isNotBlank((CharSequence)awsInvoiceType) && !CollectionUtils.isEmpty((Collection)(awsTypeList = CommonUtils.getMultiValues((String)awsInvoiceType)))) {
                    for (String awsType : awsTypeList) {
                        Long invoiceTypeByAwsType = InputInvoiceTypeEnum.getInvoiceTypeByAwsType((String)awsType);
                        if (!InputInvoiceTypeEnum.isEleInvoice((Long)invoiceTypeByAwsType).booleanValue()) continue;
                        invoiceTypeSet.add(invoiceTypeByAwsType);
                    }
                }
                filters.add(new QFilter("invoice_type", "in", (Object)(!CollectionUtils.isEmpty(invoiceTypeSet) ? invoiceTypeSet.toArray() : InputInvoiceTypeEnum.getEleInvoice())));
            }
            filters.add(new QFilter("invoice_date", ">=", (Object)invoiceStartdate));
            if (invoiceEnddate != null) {
                filters.add(new QFilter("invoice_date", "<", (Object)DateUtils.trunc((Date)DateUtils.addDay((Date)invoiceEnddate, (int)1))));
            }
            filters.add(new QFilter("delete", "=", (Object)"1"));
            int maxNum = InvoiceDownloadConstant.getPageSizeFromConfig((int)500, (String)"reapply_max_num_down_file");
            DynamicObjectCollection eleInvoiceCollection = this.getInvoiceData(filters, null, maxNum);
            if (CollectionUtils.isEmpty((Collection)eleInvoiceCollection)) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u53d1\u7968\u4e3b\u8868\u65e0\u6570\u636e", (Object)taxNo, (Object)id);
                return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u5168\u7968\u6c60\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u7968\u6570\u636e", (String)"ReapplyDownLoginOperateService_6", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            RpaFileDownApplyService rpaFileDownApplyService = new RpaFileDownApplyService();
            int i = 0;
            int maxCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)20, (String)"reapply_max_num_down_file");
            while (!CollectionUtils.isEmpty((Collection)eleInvoiceCollection)) {
                invoiceNoList.addAll(eleInvoiceCollection.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("invoice_no"))).map(t -> t.getString("invoice_no")).collect(Collectors.toList()));
                if (++i > maxCount) {
                    LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u8fbe\u5230\u6700\u5927\u5faa\u73af\u6b21\u657020\u6b21", (Object)taxNo, (Object)id);
                    break;
                }
                if (eleInvoiceCollection.size() != maxNum || ((DynamicObject)eleInvoiceCollection.get(eleInvoiceCollection.size() - 1)).getDate("createtime") == null) break;
                eleInvoiceCollection = this.getInvoiceData(filters, ((DynamicObject)eleInvoiceCollection.get(eleInvoiceCollection.size() - 1)).getDate("createtime"), maxNum);
            }
            if (CollectionUtils.isEmpty(invoiceNoList)) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (Object)taxNo, (Object)id);
                return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (String)"ReapplyDownLoginOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            }
            JSONObject result = null;
            if (!CollectionUtils.isEmpty(invoiceNoList)) {
                LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (Object)taxNo, (Object)id);
                int maxApplySize = InvoiceDownloadConstant.getPageSizeFromConfig((int)1000, (String)"max_size_down_ele_file");
                if (invoiceNoList.size() > maxApplySize) {
                    List lists = ListUtils.splitList(invoiceNoList, (int)maxApplySize);
                    for (List list : lists) {
                        Map applyFiles = rpaFileDownApplyService.replenishApplyData(taxNo, list, invoiceType);
                        if (MapUtils.isNotEmpty((Map)applyFiles)) {
                            JSONObject resultParam;
                            result = resultParam = rpaFileDownApplyService.applyTaxFile(applyFiles, invoiceStartdate, invoiceEnddate, 0);
                            continue;
                        }
                        LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u7533\u8bf7", (Object)taxNo, (Object)id);
                        if (ResultContant.isSuccess((JSONObject)result).booleanValue()) continue;
                        result = ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u6570\u7535\u6587\u4ef6\u5df2\u4e0b\u8f7d\u6216\u4e1a\u52a1\u903b\u8f91\u6821\u9a8c\u5931\u8d25", (String)"ReapplyDownLoginOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    Map applyFiles = rpaFileDownApplyService.replenishApplyData(taxNo, invoiceNoList, invoiceType);
                    if (MapUtils.isNotEmpty((Map)applyFiles)) {
                        JSONObject resultParam;
                        result = resultParam = rpaFileDownApplyService.applyTaxFile(applyFiles, invoiceStartdate, invoiceEnddate, 0);
                    } else {
                        LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u7533\u8bf7", (Object)taxNo, (Object)id);
                        if (!ResultContant.isSuccess(result).booleanValue()) {
                            result = ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u6570\u7535\u6587\u4ef6\u5df2\u4e0b\u8f7d\u6216\u4e1a\u52a1\u903b\u8f91\u6821\u9a8c\u5931\u8d25", (String)"ReapplyDownLoginOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
            return result;
        }
        invoiceNoList = downAccountCollection.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getString("invoice_no"))).map(t -> t.getString("invoice_no")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(invoiceNoList)) {
            LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {}, \u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (Object)taxNo, (Object)id);
            return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a", (String)"ReapplyDownLoginOperateService_7", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        RpaFileDownApplyService rpaFileDownApplyService = new RpaFileDownApplyService();
        Map applyFiles = rpaFileDownApplyService.replenishApplyData(taxNo, invoiceNoList, invoiceType);
        if (MapUtils.isNotEmpty((Map)applyFiles)) {
            JSONObject result = rpaFileDownApplyService.applyTaxFile(applyFiles, invoiceStartdate, invoiceEnddate, 0);
            return result;
        }
        LOGGER.info("\u7a0e\u53f7\uff1a{}\uff0cid: {},\u91cd\u65b0\u7533\u8bf7\u6587\u4ef6\u4e0b\u8f7d\uff0c\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u7533\u8bf7", (Object)taxNo, (Object)id);
        return ResultContant.createJSONObject((String)"0201", (String)ResManager.loadKDString((String)"\u6570\u7535\u6587\u4ef6\u5df2\u4e0b\u8f7d\u6216\u4e1a\u52a1\u903b\u8f91\u6821\u9a8c\u5931\u8d25", (String)"ReapplyDownLoginOperateService_8", (String)"imc-rim-formplugin", (Object[])new Object[0]));
    }

    private DynamicObjectCollection getInvoiceData(List<QFilter> filters, Date createTime, int maxNum) {
        if (CollectionUtils.isEmpty(filters)) {
            return new DynamicObjectCollection();
        }
        ArrayList<QFilter> newfilters = new ArrayList<QFilter>(filters.size());
        newfilters.addAll(filters);
        if (createTime != null) {
            newfilters.add(new QFilter("createtime", ">", (Object)createTime));
        }
        LOGGER.info("rpa\u6587\u4ef6\u4e0b\u8f7d\u91cd\u8bd5, \u67e5\u8be2\u6761\u4ef6\uff1a" + ((Object)newfilters).toString());
        DynamicObjectCollection eleInvoiceCollection = QueryServiceHelper.query((String)"rim_invoice", (String)"id, invoice_no, serial_no, createtime", (QFilter[])newfilters.toArray(new QFilter[newfilters.size()]), (String)"createtime asc", (int)maxNum);
        return eleInvoiceCollection;
    }
}

