/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.imc.rim.common.utils.PermissionUtils;
import kd.imc.rim.common.utils.TenantUtils;
import kd.imc.rim.common.utils.UUID;

public class AutoRecordedTaskEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CACHE_KEY = "AutoRecordedTaskEditNumber";
    private static final String DYM_ACCOUNTINGORG = "taxpayer_org";
    private static final Collection<String> MULDROP;

    public void registerListener(EventObject e) {
        BasedataEdit accountingorg = (BasedataEdit)this.getControl(DYM_ACCOUNTINGORG);
        accountingorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNnmber();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initMulti();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initNnmber();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.isMulDropDown(key) != null) {
            String mulDropKey = this.isMulDropDown(key);
            String value = key.replace(mulDropKey, "");
            this.refreshMultiOfDropDown(key, mulDropKey, value);
        } else if (StringUtils.equals((CharSequence)DYM_ACCOUNTINGORG, (CharSequence)key)) {
            ChangeData changeDatum = e.getChangeSet()[0];
            int rowIndex = changeDatum.getRowIndex();
            DynamicObject org = (DynamicObject)changeDatum.getNewValue();
            if (org != null) {
                this.setOrgTaxNo(org, rowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)DYM_ACCOUNTINGORG)) {
            QFilter filter;
            long userId;
            long orgId = RequestContext.get().getOrgId();
            if (this.getModel().getValue("createorg") != null) {
                orgId = (Long)((DynamicObject)this.getModel().getValue("createorg")).getPkValue();
            }
            if (PermissionServiceHelper.isSuperUser((long)(userId = Long.parseLong(RequestContext.get().getUserId()))) || PermissionServiceHelper.isAdminUser((long)userId)) {
                filter = new QFilter("1", "=", (Object)1);
            } else {
                HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
                filter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            }
            event.getCustomQFilters().add(filter);
        }
    }

    private void initNnmber() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String numberPre = "FPY" + sdf.format(new Date());
        String number = UUID.getNumber((String)numberPre, (String)CACHE_KEY, (String)this.getView().getEntityId());
        this.getModel().setValue("number", (Object)number);
    }

    private void refreshMultiOfDropDown(String optionKey, String key, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String selectedDropDown = (String)this.getModel().getValue(key);
        if (selectedDropDown == null) {
            selectedDropDown = "";
        }
        HashSet selectedSet = Sets.newHashSet((Object[])selectedDropDown.split(","));
        boolean isSelected = (Boolean)this.getModel().getValue(optionKey);
        selectedSet.remove("-1");
        selectedSet.remove("");
        boolean isUnlimited = StringUtils.equals((CharSequence)value, (CharSequence)"000");
        if (isSelected && isUnlimited) {
            this.getModel().setValue(key, (Object)"-1");
            this.getModel().beginInit();
            for (String select : selectedSet) {
                this.getModel().setValue(key + select, (Object)Boolean.FALSE);
            }
            this.initMulti(key);
            this.getModel().endInit();
            for (String select : selectedSet) {
                this.getView().updateView(key + select);
            }
            return;
        }
        if (isSelected) {
            selectedSet.add(value);
        } else {
            selectedSet.remove(value);
        }
        selectedSet.remove("000");
        this.getModel().beginInit();
        if (selectedSet.size() > 0) {
            this.getModel().setValue(key + "000", (Object)Boolean.FALSE);
        } else {
            selectedSet.add("-1");
            this.getModel().setValue(key + "000", (Object)Boolean.TRUE);
        }
        this.getModel().endInit();
        this.getView().updateView(key + "000");
        String newValue = selectedSet.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.joining(","));
        this.getModel().setValue(key, (Object)newValue);
    }

    private void initMulti() {
        for (String key : MULDROP) {
            if (this.getModel().getDataEntity(true).getDynamicObjectType().getProperty(key) == null) continue;
            this.initMulti(key);
        }
    }

    private void initMulti(String key) {
        String value = (String)this.getModel().getValue(key);
        if (value != null) {
            String[] selectedArr;
            for (String selected : selectedArr = value.split(",")) {
                if (StringUtils.equals((CharSequence)selected, (CharSequence)"-1")) {
                    selected = "000";
                }
                if (!StringUtils.isNotBlank((CharSequence)selected)) continue;
                this.getModel().setValue(key + selected, (Object)Boolean.TRUE);
            }
        }
    }

    private String isMulDropDown(String key) {
        String regex = "[0-9]+$";
        if (MULDROP.contains(key = key.replaceAll(regex, ""))) {
            return key;
        }
        return null;
    }

    private void setOrgTaxNo(DynamicObject org, int rowIndex) {
        long orgId = org.getLong("id");
        Map companyNameAndTaxNo = TenantUtils.getCompanyNameAndTaxNoByOrgId((Long)orgId);
        if (companyNameAndTaxNo != null && !StringUtils.isEmpty((CharSequence)((CharSequence)companyNameAndTaxNo.get("taxNo")))) {
            this.getModel().setValue("taxpayer_name", companyNameAndTaxNo.get("name"), rowIndex);
            this.getModel().setValue("taxpayer_tax_no", companyNameAndTaxNo.get("taxNo"), rowIndex);
        } else {
            this.getModel().setValue("taxpayer_name", null, rowIndex);
            this.getModel().setValue("taxpayer_tax_no", null, rowIndex);
        }
    }

    static {
        ArrayList muldrop = Lists.newArrayListWithExpectedSize((int)8);
        muldrop.add("invoiceresouce");
        muldrop.add("invoicetype");
        muldrop.add("receipttype");
        muldrop.add("authenticate_flag");
        muldrop.add("invovicestatus");
        muldrop.add("check_status");
        muldrop.add("deduction_flag");
        muldrop.add("preiod");
        MULDROP = Collections.unmodifiableCollection(muldrop);
    }
}

