/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.recorded;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.rim.common.constant.RecordedConstant;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class TaxRecordedCommitPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TaxRecordedCommitPlugin.class);
    private static final String ENTRY_GRID = "entryentity";
    public static final String INVOICES = "invoices";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel", "batchupdate"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray invoiceList = JSONObject.parseArray((String)SerializationUtils.toJsonString(customParams.get(INVOICES)));
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return;
        }
        Object operateType = customParams.get("operateType");
        boolean isUpdate = "recorded_update".equals(operateType);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_GRID);
        List fieldEdits = entryGrid.getFieldEdits();
        Date now = new Date();
        for (int i = 0; i < invoiceList.size(); ++i) {
            JSONObject object = invoiceList.getJSONObject(i);
            int row = this.getModel().createNewEntryRow(ENTRY_GRID);
            this.getModel().setValue("id", (Object)object.getString("id"), row);
            this.getModel().setValue("invoice_code", (Object)object.getString("invoice_code"), row);
            this.getModel().setValue("invoice_no", (Object)object.getString("invoice_no"), row);
            this.getModel().setValue("electronic_no", (Object)object.getString("electronic_no"), row);
            this.getModel().setValue("serial_no", (Object)object.getString("serial_no"), row);
            Long itemInvoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"invoice_type"));
            this.getModel().setValue("invoice_type", (Object)itemInvoiceType, row);
            this.getModel().setValue("invoice_date", (Object)object.getString("invoice_date"), row);
            this.getModel().setValue("saler_name", (Object)object.getString("saler_name"), row);
            this.getModel().setValue("saler_tax_no", (Object)object.getString("saler_tax_no"), row);
            this.getModel().setValue("invoice_amount", (Object)object.getString("invoice_amount"), row);
            this.getModel().setValue("total_tax_amount", (Object)object.getString("total_tax_amount"), row);
            this.getModel().setValue("buyer_tax_no", (Object)object.getString("buyer_tax_no"), row);
            this.getModel().setValue("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)object.get((Object)"org")), row);
            this.getModel().setValue("invoice_risk_level", (Object)object.getString("invoice_risk_level"), row);
            this.getModel().setValue("invoice_status", (Object)object.getString("invoice_status"), row);
            this.getModel().setValue("tax_recorded_status", (Object)object.getString("tax_recorded_status"), row);
            String taxRecordedPurpose = object.getString("tax_recorded_purpose");
            if (StringUtils.isBlank((CharSequence)taxRecordedPurpose)) {
                taxRecordedPurpose = "02";
            }
            this.getModel().setValue("tax_recorded_purpose", (Object)taxRecordedPurpose, row);
            Date taxRecordedTime = object.getDate("tax_recorded_time");
            Date taxRecordedPeriod = object.getDate("tax_recorded_period");
            if (!(isUpdate || taxRecordedTime != null && taxRecordedPeriod != null)) {
                Date accountTime = object.getDate("account_time");
                Date accountDate = object.getDate("account_date");
                if (taxRecordedTime == null) {
                    if (accountTime != null) {
                        taxRecordedTime = DateUtils.trunc((Date)accountTime);
                        if (null != object.get((Object)"invoice_date") && DateUtils.compare((Date)taxRecordedTime, (Date)DateUtils.trunc((Date)object.getDate("invoice_date"))) < 0) {
                            taxRecordedTime = DateUtils.trunc((Date)now);
                        }
                    } else {
                        taxRecordedTime = DateUtils.trunc((Date)now);
                    }
                }
                if (taxRecordedPeriod == null) {
                    if (accountDate != null) {
                        taxRecordedPeriod = DateUtils.getFirstDateOfMonth((Date)accountDate);
                        if (null != object.get((Object)"invoice_date") && DateUtils.compare((Date)taxRecordedPeriod, (Date)DateUtils.getFirstDateOfMonth((Date)object.getDate("invoice_date"))) < 0) {
                            taxRecordedPeriod = DateUtils.getFirstDateOfMonth((Date)now);
                        }
                    } else {
                        taxRecordedPeriod = DateUtils.getFirstDateOfMonth((Date)now);
                    }
                }
            }
            this.getModel().setValue("tax_recorded_time", (Object)taxRecordedTime, row);
            this.getModel().setValue("tax_recorded_period", (Object)taxRecordedPeriod, row);
            if (!isUpdate || !"02".equals(object.getString("tax_recorded_status")) && !"03".equals(object.getString("tax_recorded_status"))) continue;
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"tax_recorded_time", "tax_recorded_period"});
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_GRID);
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                logger.info("\u6ca1\u6709\u9700\u8981\u63d0\u4ea4\u5165\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u52fe\u9009\u6570\u636e");
                control.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u63d0\u4ea4\u5165\u8d26\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u52fe\u9009\u6570\u636e", (String)"TaxRecordedCommitPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                return;
            }
            Date now = new Date();
            ArrayList<Long> ids = new ArrayList<Long>(1);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String operateType = (String)customParams.get("operateType");
            boolean isUpdate = "recorded_update".equals(operateType);
            DynamicObjectCollection updateEntryEntity = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : entryEntity) {
                String invoiceCode = dynamicObject.getString("invoice_code");
                String invoiceNo = dynamicObject.getString("invoice_no");
                String codeGroup = CommonUtils.getInvoiceCodeNoGroup((String)invoiceCode, (String)invoiceNo);
                if (null != dynamicObject.getDate("tax_recorded_time")) {
                    Date taxRecordedTime = DateUtils.trunc((Date)dynamicObject.getDate("tax_recorded_time"));
                    if (taxRecordedTime.compareTo(DateUtils.trunc((Date)now)) > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                    if (null != dynamicObject.get("invoice_date") && DateUtils.compare((Date)taxRecordedTime, (Date)DateUtils.trunc((Date)dynamicObject.getDate("invoice_date"))) < 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u53d1\u7968\u7684\u5f00\u7968\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                }
                if (null != dynamicObject.getDate("tax_recorded_period")) {
                    Date taxRecordedPeriod = DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("tax_recorded_period"));
                    if (taxRecordedPeriod.compareTo(DateUtils.getFirstDateOfMonth((Date)now)) > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u5927\u4e8e\u5f53\u524d\u6708\u4efd", (String)"TaxRecordedCommitPlugin_7", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                    if (null != dynamicObject.get("invoice_date") && DateUtils.compare((Date)taxRecordedPeriod, (Date)DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("invoice_date"))) < 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u5c0f\u4e8e\u53d1\u7968\uff1a%1$s\u7684\u5f00\u7968\u6708\u4efd", (String)"TaxRecordedCommitPlugin_8", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                        return;
                    }
                }
                String taxRecordedStatus = dynamicObject.getString("tax_recorded_status");
                if (isUpdate) {
                    boolean recordedPurposeChange;
                    boolean bl = recordedPurposeChange = StringUtils.compare((String)dynamicObject.getString("tax_recorded_purpose"), (String)taxRecordedStatus) != 0;
                    if ("02".equals(taxRecordedStatus) || "03".equals(taxRecordedStatus)) {
                        if (recordedPurposeChange) {
                            updateEntryEntity.add((Object)dynamicObject);
                        }
                    } else if ("06".equals(taxRecordedStatus)) {
                        boolean timeChange;
                        boolean bl2 = timeChange = dynamicObject.getDate("tax_recorded_time") != null || dynamicObject.getDate("tax_recorded_period") != null;
                        if (recordedPurposeChange && timeChange) {
                            updateEntryEntity.add((Object)dynamicObject);
                        } else {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s \u5165\u8d26\u65f6\u95f4\u3001\u5165\u8d26\u5c5e\u671f\u4e0d\u80fd\u90fd\u4e3a\u7a7a", (String)"TaxRecordedCommitPlugin_23", (String)"imc-rim-formplugin", (Object[])new Object[0]), codeGroup), Integer.valueOf(2000));
                            return;
                        }
                    }
                }
                if (!StringUtils.isBlank((CharSequence)taxRecordedStatus)) continue;
                ids.add(dynamicObject.getLong("id"));
            }
            if (isUpdate && CollectionUtils.isEmpty((Collection)updateEntryEntity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u8fdb\u884c\u5165\u8d26\u53d8\u66f4\u7684\u53d1\u7968\u6570\u636e", (String)"TaxRecordedCommitPlugin_22", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if (CollectionUtils.isNotEmpty(ids) && !isUpdate) {
                RecordedConstant.batchUpateInvoiceMain(ids, null, null, null, (String)"01", (String)operateType);
            }
            JSONObject param = RecordedConstant.createRecordedParamNew((DynamicObjectCollection)(isUpdate ? updateEntryEntity : entryEntity), (String)operateType, (String)"1", null);
            this.getView().returnDataToParent((Object)param);
            this.getView().close();
        }
        if ("btncancel".equals(control.getKey())) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        Date now = new Date();
        if (("tax_recorded_purpose".equals(name) || "tax_recorded_time".equals(name) || "tax_recorded_period".equals(name)) && (changeSet = e.getChangeSet()).length > 0) {
            Date newValue;
            ChangeData changeData = changeSet[0];
            DynamicObject dataEntity = changeData.getDataEntity();
            Object id = dataEntity.get("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_invoice");
            if (null == dynamicObject) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u7968\u6570\u636e", (String)"TaxRecordedCommitPlugin_1", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                return;
            }
            if ("tax_recorded_time".equals(name) && (newValue = (Date)changeData.getNewValue()) != null) {
                if (DateUtils.trunc((Date)newValue).compareTo(DateUtils.trunc((Date)now)) > 0) {
                    this.getModel().setValue("tax_recorded_time", changeData.getOldValue(), changeData.getRowIndex());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"TaxRecordedEditPlugin_5", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (null != dynamicObject.get("invoice_date") && DateUtils.compare((Date)newValue, (Date)dynamicObject.getDate("invoice_date")) < 0) {
                    this.getModel().setValue("tax_recorded_time", changeData.getOldValue(), changeData.getRowIndex());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u7a0e\u5c40\u5165\u8d26\u65f6\u95f4\u5c0f\u4e8e\u53d1\u7968\u7684\u5f00\u7968\u65f6\u95f4", (String)"TaxRecordedCommitPlugin_2", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
            }
            if ("tax_recorded_period".equals(name) && (newValue = (Date)changeData.getNewValue()) != null) {
                if (DateUtils.getFirstDateOfMonth((Date)newValue).compareTo(DateUtils.getFirstDateOfMonth((Date)now)) > 0) {
                    this.getModel().setValue("tax_recorded_period", changeData.getOldValue(), changeData.getRowIndex());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u6708\u4efd", (String)"TaxRecordedEditPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
                if (null != dynamicObject.get("invoice_date") && DateUtils.getFirstDateOfMonth((Date)newValue).compareTo(DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("invoice_date"))) < 0) {
                    this.getModel().setValue("tax_recorded_period", changeData.getOldValue(), changeData.getRowIndex());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bbe\u7f6e\u7684\u7a0e\u5c40\u5165\u8d26\u5c5e\u671f\u5c0f\u4e8e\u53d1\u7968\u7684\u5f00\u7968\u6708\u4efd", (String)"TaxRecordedCommitPlugin_6", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    return;
                }
            }
        }
    }
}

