/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.report.rptinput;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.report.rptinput.constant.RptInputConstant;

public class RptDetailListPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(RptDetailListPlugin.class);
    private static final String VATFields = "invoice_type, createtime, invoice_date, invoice_status, expense_status, authenticate_flag, original_state, deduction_purpose, effective_tax_amount, select_time,invoice_code, invoice_no, saler_name, saler_tax_no, buyer_name, buyer_tax_no, total_amount, org, tax_org, remark, goods_name, spec_model, unit_price, unit, num,detail_amount, tax_rate, tax_amount";
    private static final String mainFieldsStr = "serial_no,invoice_type,createtime,invoice_date,invoice_status,expense_status,authenticate_flag,original_state,deduction_purpose,effective_tax_amount,tax_period,select_time,invoice_code,invoice_no,saler_name,saler_tax_no,buyer_name,buyer_tax_no,total_amount,org,tax_org,remark,resource,transport_deduction";
    private static final String[] mainFileds = new String[]{"serial_no", "invoice_type", "createtime", "invoice_date", "invoice_status", "expense_status", "authenticate_flag", "original_state", "deduction_purpose", "effective_tax_amount", "select_time", "invoice_code", "invoice_no", "saler_name", "saler_tax_no", "buyer_name", "buyer_tax_no", "total_amount", "resource", "org", "tax_org", "remark"};
    private static final String detailFieldsStr = "serial_no, items.goods_name, items.spec_model, items.unit_price, items.unit, items.num, items.detail_amount, items.tax_rate, items.tax_amount";
    private static final String[] selectedFeilds = new String[]{"serial_no", "invoice_type", "createtime", "invoice_date", "invoice_status", "transport_deduction", "tax_period", "expense_status", "authenticate_flag", "original_state", "deduction_purpose", "effective_tax_amount", "select_time", "invoice_code", "invoice_no", "saler_name", "saler_tax_no", "buyer_name", "buyer_tax_no", "total_amount", "org", "tax_org", "remark", "items.goods_name as goods_name", "items.spec_model as spec_model", "items.unit_price as unit_price", "items.unit as unit", "items.num as num", "items.detail_amount as detail_amount", "items.tax_rate * 100 as tax_rate", "items.tax_amount as tax_amount"};
    private static final String[] trainFields = new String[]{"train_num", "sequence_no", "train_time", "station_get_on", "station_get_off", "passenger_name", "seat_grade"};
    private static final String[] airFields = new String[]{"eticket_no", "print_num", "place_of_departure", "destination", "customer_name", "customer_id_no", "seat_grade", "airport_construction_fee", "fuel_surcharge"};
    private static final String[] transportFields = new String[]{"station_get_on", "station_get_off", "passenger_name"};
    private static final String[] taxiFields = new String[]{"time_get_on", "time_get_off", "mileage"};
    private static final String[] generalFields = new String[]{"entrance", "exit", "time"};
    private static final String[] hgjksFields = new String[]{"custom_declaration_no", "dept_name", "declare_no", "contract_no", "trans_tool_no", "pay_limit_date", "get_office", "items.goods_name as goods_name", "items.num as num", "items.unit as unit", "items.unit_price as unit_price", "items.tax_rate * 100 as tax_rate", "items.tax_amount as tax_amount"};
    private static final String[] financialFields = new String[]{"invoicing_party_code", "invoicing_party_name", "payer_party_code", "payer_party_name"};
    private static final String[] electricFields = new String[]{"total_deduct", "main_goods_name"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        boolean containsUnit;
        boolean containsTaxCheck;
        boolean containsUnitPriceCheck;
        QFilter expenseTypeFilter;
        DynamicObject expenseTypeObj;
        boolean containsUnitPriceOrTax;
        boolean containsUnitPrice;
        boolean containsRemark;
        boolean containAuthFlag;
        boolean containOriginalState;
        boolean containStatus;
        Boolean containsTax;
        boolean containsInvoiceData;
        JSONObject invoiveTypeInfo;
        Long invoiceTypeParam;
        boolean containsBuyer;
        boolean containsSaler;
        JSONArray authListArray;
        Long nodeId = null;
        String pageId = RptInputConstant.getPageId((Object)this);
        String customParamStr = new PageCache(pageId).get("customParam");
        if (StringUtils.isEmpty((CharSequence)customParamStr)) {
            throw new KDException(new ErrorCode("0001", ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u81ea\u5b9a\u4e49\u53c2\u6570", (String)"RptDetailListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        logger.info("\u8fdb\u9879\u660e\u7ec6\u7edf\u8ba1-\u8bf7\u6c42\u53c2\u6570:{}", (Object)reportQueryParam);
        JSONObject customParam = JSONObject.parseObject((String)customParamStr);
        if (!CollectionUtils.isEmpty((Map)customParam)) {
            nodeId = (Long)customParam.get((Object)"nodeId");
        }
        List checkList = null;
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"checkSeqList"))) {
            checkList = (List)customParam.get((Object)"checkSeqList");
        }
        if (!ObjectUtils.isEmpty((Object)customParam)) {
            logger.info("RptDetailListPlugin-\u8bf7\u6c42\u53c2\u6570", (Object)JSON.toJSONString((Object)customParam));
        }
        Long[] vatInvoiceTypes = InputInvoiceTypeEnum.getVatTypes();
        JSONObject orgObj = (JSONObject)customParam.get((Object)"org_query");
        Long orgParam = null;
        if (!ObjectUtils.isEmpty((Object)orgObj)) {
            orgParam = orgObj.getLong("id");
        }
        JSONObject taxOrgObj = (JSONObject)customParam.get((Object)"tax_org_query");
        Long taxOrgParam = null;
        if (!ObjectUtils.isEmpty((Object)taxOrgObj)) {
            taxOrgParam = taxOrgObj.getLong("id");
        }
        JSONObject searchInvoiceTypeObj = (JSONObject)customParam.get((Object)"invoice_type");
        Long searchInvoiceType = null;
        if (!ObjectUtils.isEmpty((Object)searchInvoiceTypeObj)) {
            searchInvoiceType = searchInvoiceTypeObj.getLong("id");
        }
        Boolean isAdmin = null;
        Date collectTimeStart = null;
        Date collectTimeEnd = null;
        Date invoiceDateStartParam = null;
        Date invoiceDateEndParam = null;
        Date accountTimeStartParam = null;
        Date accountTimeEndParam = null;
        Date authenticateTimeStartParam = null;
        Date authenticateTimeEndParam = null;
        ArrayList<Long> authList = null;
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"create_time_startdate_query"))) {
            collectTimeStart = DateUtils.stringToDate((String)((String)customParam.get((Object)"create_time_startdate_query")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"create_time_enddate_query"))) {
            collectTimeEnd = DateUtils.stringToDate((String)((String)customParam.get((Object)"create_time_enddate_query")), (String)"yyyy-MM-dd HH:mm:ss");
            collectTimeEnd = DateUtils.getDayEndTime((Date)collectTimeEnd);
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"invoice_date_startdate_query"))) {
            invoiceDateStartParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"invoice_date_startdate_query")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"invoice_date_enddate_query"))) {
            invoiceDateEndParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"invoice_date_enddate_query")), (String)"yyyy-MM-dd HH:mm:ss");
            invoiceDateEndParam = DateUtils.getDayEndTime((Date)invoiceDateEndParam);
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"daterangefield_startdate_query"))) {
            accountTimeStartParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"daterangefield_startdate_query")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"daterangefield_enddate_query"))) {
            accountTimeEndParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"daterangefield_enddate_query")), (String)"yyyy-MM-dd HH:mm:ss");
            accountTimeEndParam = DateUtils.getDayEndTime((Date)accountTimeEndParam);
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"daterangefield1_startdate_query"))) {
            authenticateTimeStartParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"daterangefield1_startdate_query")), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"daterangefield1_enddate_query"))) {
            authenticateTimeEndParam = DateUtils.stringToDate((String)((String)customParam.get((Object)"daterangefield1_enddate_query")), (String)"yyyy-MM-dd HH:mm:ss");
            authenticateTimeEndParam = DateUtils.getDayEndTime((Date)authenticateTimeEndParam);
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"isAdmin"))) {
            isAdmin = (Boolean)customParam.get((Object)"isAdmin");
        }
        if (!ObjectUtils.isEmpty((Object)customParam.get((Object)"authList")) && !CollectionUtils.isEmpty((Collection)(authListArray = (JSONArray)customParam.get((Object)"authList")))) {
            for (int i = 0; i < authListArray.size(); ++i) {
                JSONArray detailAuthList = ((JSONObject)authListArray.get(i)).getJSONArray("value");
                if (CollectionUtils.isEmpty((Collection)detailAuthList)) continue;
                for (int j = 0; j < detailAuthList.size(); ++j) {
                    if (authList == null) {
                        authList = new ArrayList<Long>(16);
                    }
                    authList.add(Long.parseLong(detailAuthList.get(j).toString()));
                }
            }
        }
        String sellerNameParam = (String)customParam.get((Object)"saler_name");
        String sellerNameQueryParam = (String)customParam.get((Object)"saler_name_query");
        boolean bl = containsSaler = checkList != null && checkList.size() > 0 && checkList.contains("saler_check");
        if (containsSaler) {
            if (StringUtils.isEmpty((CharSequence)sellerNameParam)) {
                sellerNameParam = "";
            }
        } else if (StringUtils.isEmpty((CharSequence)sellerNameParam)) {
            sellerNameParam = null;
        }
        String buyerNameParam = (String)customParam.get((Object)"buyer_name");
        String buyerNameQueryParam = (String)customParam.get((Object)"buyer_name_query");
        boolean bl2 = containsBuyer = checkList != null && checkList.size() > 0 && checkList.contains("buyer_check");
        if (containsBuyer) {
            if (StringUtils.isEmpty((CharSequence)buyerNameParam)) {
                buyerNameParam = "";
            }
        } else if (StringUtils.isEmpty((CharSequence)buyerNameParam)) {
            buyerNameParam = null;
        }
        String goodsNameParam = (String)customParam.get((Object)"goods_name");
        String goodsNameQueryParam = (String)customParam.get((Object)"goods_name_query");
        if (StringUtils.isEmpty((CharSequence)goodsNameParam)) {
            goodsNameParam = null;
        }
        if ((invoiceTypeParam = Long.valueOf(Long.parseLong(customParam.get((Object)"invoice_type_id").toString()))) == 0L || ObjectUtils.isEmpty((Object)invoiceTypeParam)) {
            invoiceTypeParam = null;
        }
        if (invoiceTypeParam == null && !ObjectUtils.isEmpty((Object)customParam.get((Object)"invoice_type_query")) && ((invoiceTypeParam = (invoiveTypeInfo = (JSONObject)customParam.get((Object)"invoice_type_query")).getLong("id")) == 0L || ObjectUtils.isEmpty((Object)invoiceTypeParam))) {
            invoiceTypeParam = null;
        }
        String invoiceDateStr = (String)customParam.get((Object)"invoice_date");
        boolean bl3 = containsInvoiceData = checkList != null && checkList.size() > 0 && checkList.contains("invoicedate_check");
        if (containsInvoiceData) {
            if (ObjectUtils.isEmpty((Object)invoiceDateStr)) {
                invoiceDateStr = "";
            }
        } else if (ObjectUtils.isEmpty((Object)invoiceDateStr)) {
            invoiceDateStr = null;
        }
        Object taxRateObj = customParam.get((Object)"tax_rate");
        BigDecimal taxRateParam = null;
        if (taxRateObj != null) {
            taxRateParam = BigDecimalUtil.transDecimal((Object)customParam.get((Object)"tax_rate"));
        }
        if ((containsTax = Boolean.valueOf(checkList != null && checkList.size() > 0 && checkList.contains("tax_check"))).booleanValue()) {
            if (ObjectUtils.isEmpty((Object)taxRateParam)) {
                taxRateParam = BigDecimal.ZERO;
            }
        } else if (ObjectUtils.isEmpty((Object)taxRateParam)) {
            taxRateParam = null;
        }
        String expenseStatusParam = (String)customParam.get((Object)"expense_status");
        boolean bl4 = containStatus = checkList != null && checkList.size() > 0 && checkList.contains("status_check");
        if (containStatus) {
            if (ObjectUtils.isEmpty((Object)expenseStatusParam)) {
                expenseStatusParam = "";
            }
        } else if (ObjectUtils.isEmpty((Object)expenseStatusParam)) {
            expenseStatusParam = null;
        }
        String originalStateParam = (String)customParam.get((Object)"original_state");
        boolean bl5 = containOriginalState = checkList != null && checkList.size() > 0 && checkList.contains("original_check");
        if (containOriginalState) {
            if (ObjectUtils.isEmpty((Object)originalStateParam)) {
                originalStateParam = "";
            }
        } else if (ObjectUtils.isEmpty((Object)originalStateParam)) {
            originalStateParam = null;
        }
        String authFlagParam = (String)customParam.get((Object)"authenticate_flag");
        boolean bl6 = containAuthFlag = checkList != null && checkList.size() > 0 && checkList.contains("auth_check");
        if (containAuthFlag) {
            if (ObjectUtils.isEmpty((Object)authFlagParam)) {
                authFlagParam = "";
            }
        } else if (ObjectUtils.isEmpty((Object)authFlagParam)) {
            authFlagParam = null;
        }
        String billTypeParam = (String)customParam.get((Object)"expense_type");
        Boolean containsBill = checkList != null && checkList.size() > 0 && checkList.contains("bill_check");
        if (containsBill.booleanValue()) {
            if (ObjectUtils.isEmpty((Object)billTypeParam)) {
                billTypeParam = "";
            }
        } else if (ObjectUtils.isEmpty((Object)billTypeParam)) {
            billTypeParam = null;
        }
        String remarkParam = (String)customParam.get((Object)"remark");
        String remarkQueryParam = (String)customParam.get((Object)"remark_query");
        boolean bl7 = containsRemark = checkList != null && checkList.size() > 0 && checkList.contains("remark_check");
        if (containsRemark) {
            if (ObjectUtils.isEmpty((Object)remarkParam)) {
                remarkParam = "";
            }
        } else if (ObjectUtils.isEmpty((Object)remarkParam)) {
            remarkParam = null;
        }
        BigDecimal goodPriceParam = null;
        String unit = null;
        String specModel = null;
        boolean bl8 = containsUnitPrice = checkList != null && checkList.size() > 0 && checkList.contains("unitprice_check");
        if (containsUnitPrice) {
            Object itemUnitPriceObj = customParam.get((Object)"items.unit_price");
            if (itemUnitPriceObj != null) {
                goodPriceParam = BigDecimalUtil.transDecimal((Object)itemUnitPriceObj);
            }
            goodsNameParam = (String)customParam.get((Object)"items.goods_name");
            Object itemTaxRateObj = customParam.get((Object)"items.tax_rate");
            if (itemTaxRateObj != null) {
                taxRateParam = BigDecimalUtil.transDecimal((Object)itemTaxRateObj);
            }
            unit = (String)customParam.get((Object)"items.unit");
            specModel = (String)customParam.get((Object)"items.spec_model");
        } else {
            goodPriceParam = null;
        }
        boolean bl9 = containsUnitPriceOrTax = checkList != null && checkList.size() > 0 && (checkList.contains("unitprice_check") || checkList.contains("tax_check"));
        if (!containsUnitPriceOrTax) {
            taxRateParam = null;
        }
        QFilter mainFilter = null;
        QFilter detailFilter = null;
        QFilter sonTaxFilter = null;
        ArrayList<String> serialNos = new ArrayList<String>(16);
        if (InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "in", (Object)vatInvoiceTypes);
        } else if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.TRAIN_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.AIR_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.BOAT_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.TAXI_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.QUOTA_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.ROAD_BRIDGE.getCode());
        } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.HGJKS.getCode());
        } else if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.TAX_PROOF.getCode());
        } else if (InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.OTHER_INVOICE.getCode());
        } else if (InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "in", (Object)new Long[]{InputInvoiceTypeEnum.GENERAL_PAPER.getCode(), InputInvoiceTypeEnum.GENERAL_ELECTRON.getCode()});
        } else if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.TRAIN_REFUND.getCode());
        } else if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(nodeId)) {
            mainFilter = new QFilter("invoice_type", "=", (Object)InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode());
        }
        if (mainFilter == null) {
            mainFilter = new QFilter("invoice_type", "=", (Object)"-1");
            return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", (String)mainFieldsStr, (QFilter[])mainFilter.toArray(), null);
        }
        String isShowUncheck = RimConfigUtils.getConfig((String)"rim_config", (String)"show_uncheck");
        if (org.apache.commons.lang.StringUtils.isEmpty((String)isShowUncheck) || "0".equals(isShowUncheck)) {
            mainFilter.and("check_status", "=", (Object)"1");
        }
        mainFilter.and("delete", "=", (Object)"1");
        if (!ObjectUtils.isEmpty((Object)searchInvoiceType)) {
            mainFilter.and("invoice_type", "=", (Object)searchInvoiceType);
        }
        if (!ObjectUtils.isEmpty((Object)orgParam)) {
            mainFilter.and("org", "=", (Object)orgParam);
        }
        if (!ObjectUtils.isEmpty((Object)taxOrgParam)) {
            mainFilter.and("tax_org", "=", (Object)taxOrgParam);
        }
        if (isAdmin != null && !isAdmin.booleanValue()) {
            mainFilter.and("org", "in", authList);
        }
        if (!ObjectUtils.isEmpty((Object)collectTimeStart)) {
            mainFilter.and("createtime", ">=", (Object)collectTimeStart);
        }
        if (!ObjectUtils.isEmpty((Object)collectTimeEnd)) {
            mainFilter.and("createtime", "<=", (Object)collectTimeEnd);
        }
        if (!ObjectUtils.isEmpty((Object)invoiceDateStartParam)) {
            mainFilter.and("invoice_date", ">=", (Object)invoiceDateStartParam);
        }
        if (!ObjectUtils.isEmpty((Object)invoiceDateEndParam)) {
            mainFilter.and("invoice_date", "<=", (Object)invoiceDateEndParam);
        }
        if (!ObjectUtils.isEmpty((Object)accountTimeStartParam)) {
            mainFilter.and("account_time", ">=", (Object)accountTimeStartParam);
        }
        if (!ObjectUtils.isEmpty((Object)accountTimeEndParam)) {
            mainFilter.and("account_time", "<=", (Object)accountTimeEndParam);
        }
        if (!ObjectUtils.isEmpty((Object)authenticateTimeStartParam)) {
            mainFilter.and("authenticate_time", ">=", (Object)authenticateTimeStartParam);
        }
        if (!ObjectUtils.isEmpty((Object)authenticateTimeEndParam)) {
            mainFilter.and("authenticate_time", "<=", (Object)authenticateTimeEndParam);
        }
        if (sellerNameParam != null) {
            mainFilter.and("saler_name", "=", (Object)sellerNameParam);
        } else if (!StringUtils.isEmpty((CharSequence)sellerNameQueryParam)) {
            mainFilter.and("saler_name", "like", (Object)("%" + sellerNameQueryParam + "%"));
        }
        if (buyerNameParam != null) {
            mainFilter.and("buyer_name", "=", (Object)buyerNameParam);
        } else if (!StringUtils.isEmpty((CharSequence)buyerNameQueryParam)) {
            mainFilter.and("buyer_name", "like", (Object)("%" + buyerNameQueryParam + "%"));
        }
        if (invoiceTypeParam != null) {
            mainFilter = mainFilter.and("invoice_type", "=", (Object)invoiceTypeParam);
        }
        if (expenseStatusParam != null) {
            mainFilter = mainFilter.and("expense_status", "=", (Object)expenseStatusParam);
        }
        if (originalStateParam != null) {
            mainFilter = mainFilter.and("original_state", "=", (Object)originalStateParam);
        }
        if (authFlagParam != null) {
            mainFilter = mainFilter.and("authenticate_flag", "=", (Object)authFlagParam);
        }
        if (remarkParam != null) {
            mainFilter = mainFilter.and("remark", "=", (Object)remarkParam);
        } else if (!StringUtils.isEmpty((CharSequence)remarkQueryParam)) {
            mainFilter = mainFilter.and("remark", "like", (Object)("%" + remarkQueryParam + "%"));
        }
        if (invoiceDateStr != null) {
            Date invoiceDate = DateUtils.stringToDate((String)invoiceDateStr, (String)"yyyy-MM");
            Date invoiceDateStart = DateUtils.getFirstDateOfMonth((Date)invoiceDate);
            Date invoiceDateEnd = DateUtils.getLastDateOfMonth((Date)invoiceDate);
            mainFilter = mainFilter.and("invoice_date", ">=", (Object)invoiceDateStart).and("invoice_date", "<=", (Object)invoiceDateEnd);
        }
        if (billTypeParam != null && !ObjectUtils.isEmpty((Object)(expenseTypeObj = QueryServiceHelper.queryOne((String)"rim_expense_type", (String)"number", (QFilter[])(expenseTypeFilter = new QFilter("name", "=", (Object)billTypeParam)).toArray())))) {
            String expenseTypeNumber = expenseTypeObj.getString("number");
            QFilter expenseSerialNosFilter = new QFilter("expense_type", "=", (Object)expenseTypeNumber);
            DynamicObjectCollection serialNosCollection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"serial_no", (QFilter[])expenseSerialNosFilter.toArray());
            if (!serialNosCollection.isEmpty()) {
                for (DynamicObject serialNoObj : serialNosCollection) {
                    if (ObjectUtils.isEmpty((Object)serialNoObj)) continue;
                    serialNos.add(serialNoObj.getString("serial_no"));
                }
            }
            if (!CollectionUtils.isEmpty(serialNos)) {
                mainFilter.and("serial_no", "in", serialNos);
            }
        }
        DataSet mainInvoiceDataSet = null;
        if (mainFilter != null) {
            mainInvoiceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", (String)mainFieldsStr, (QFilter[])mainFilter.toArray(), null);
        }
        boolean bl10 = containsUnitPriceCheck = checkList != null && checkList.size() > 0 && checkList.contains("unitprice_check") && !InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(nodeId) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(nodeId);
        if (containsUnitPriceCheck) {
            DataSet nullReult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", (String)mainFieldsStr, (QFilter[])new QFilter[]{new QFilter("invoice_no", "=", (Object)"-1")}, null);
            return nullReult;
        }
        boolean bl11 = containsTaxCheck = checkList != null && checkList.size() > 0 && checkList.contains("tax_check") && !InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(nodeId) && !InputInvoiceTypeEnum.HGJKS.getCode().equals(nodeId) && !InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(nodeId) && !InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(nodeId) && !InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(nodeId) && !InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(nodeId);
        if (containsTaxCheck) {
            DataSet nullReult = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", (String)mainFieldsStr, (QFilter[])new QFilter[]{new QFilter("invoice_no", "=", (Object)"-1")}, null);
            return nullReult;
        }
        if (InputInvoiceTypeEnum.USEDCAR_INVOICE.getCode().equals(nodeId) || InputInvoiceTypeEnum.OTHER_INVOICE.getCode().equals(nodeId)) {
            mainInvoiceDataSet = this.getFilteredDataSet(mainInvoiceDataSet, reportQueryParam);
            return mainInvoiceDataSet;
        }
        if (InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(nodeId)) {
            DataSet trainDataSet = this.getFilteredDataSet(this.train(mainInvoiceDataSet, taxRateParam), reportQueryParam);
            return trainDataSet;
        }
        if (InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(nodeId)) {
            DataSet airDataSet = this.getFilteredDataSet(this.air(mainInvoiceDataSet, taxRateParam), reportQueryParam);
            return airDataSet;
        }
        if (InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(nodeId) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(nodeId)) {
            DataSet transportDataSet = this.getFilteredDataSet(this.transport(mainInvoiceDataSet, taxRateParam), reportQueryParam);
            return transportDataSet;
        }
        if (InputInvoiceTypeEnum.TAXI_INVOICE.getCode().equals(nodeId)) {
            DataSet taxiDataSet = this.getFilteredDataSet(this.taxi(mainInvoiceDataSet), reportQueryParam);
            return taxiDataSet;
        }
        if (InputInvoiceTypeEnum.QUOTA_INVOICE.getCode().equals(nodeId)) {
            DataSet quotaDataSet = this.getFilteredDataSet(this.quota(mainInvoiceDataSet), reportQueryParam);
            return quotaDataSet;
        }
        if (InputInvoiceTypeEnum.ROAD_BRIDGE.getCode().equals(nodeId) || InputInvoiceTypeEnum.GENERAL_PAPER.getCode().equals(nodeId)) {
            DataSet generalDataSet = this.getFilteredDataSet(this.general(mainInvoiceDataSet), reportQueryParam);
            return generalDataSet;
        }
        if (InputInvoiceTypeEnum.HGJKS.getCode().equals(nodeId)) {
            DataSet hgjksDataSet = this.getFilteredDataSet(this.hgjks(mainInvoiceDataSet, goodsNameParam, taxRateParam, goodPriceParam), reportQueryParam);
            return hgjksDataSet;
        }
        if (InputInvoiceTypeEnum.TAX_PROOF.getCode().equals(nodeId)) {
            DataSet taxProofDataSet = this.getFilteredDataSet(this.taxProof(mainInvoiceDataSet), reportQueryParam);
            return taxProofDataSet;
        }
        if (InputInvoiceTypeEnum.TRAIN_REFUND.getCode().equals(nodeId)) {
            DataSet trainRefundDataSet = this.getFilteredDataSet(this.trainRefund(mainInvoiceDataSet), reportQueryParam);
            return trainRefundDataSet;
        }
        if (InputInvoiceTypeEnum.FINANCIAL_INVOICE.getCode().equals(nodeId)) {
            DataSet financialInvoiceDataSet = this.getFilteredDataSet(this.financialInvoice(mainInvoiceDataSet), reportQueryParam);
            return financialInvoiceDataSet;
        }
        if (goodPriceParam != null) {
            detailFilter = new QFilter("items.unit_price", ">=", (Object)goodPriceParam.subtract(BigDecimal.valueOf(0.005))).and("items.unit_price", "<", (Object)goodPriceParam.add(BigDecimal.valueOf(0.005)));
        }
        if (goodsNameParam != null) {
            detailFilter = detailFilter == null ? new QFilter("items.goods_name", "=", (Object)goodsNameParam) : detailFilter.and("items.goods_name", "=", (Object)goodsNameParam);
        } else if (!StringUtils.isEmpty((CharSequence)goodsNameQueryParam)) {
            detailFilter = detailFilter == null ? new QFilter("items.goods_name", "like", (Object)("%" + goodsNameQueryParam + "%")) : detailFilter.and("items.goods_name", "like", (Object)("%" + goodsNameQueryParam + "%"));
        }
        if (taxRateParam != null) {
            BigDecimal subtract = taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5));
            BigDecimal add = taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5));
            detailFilter = detailFilter == null ? new QFilter("items.tax_rate", ">=", (Object)subtract).and("items.tax_rate", "<=", (Object)add) : detailFilter.and("items.tax_rate", ">=", (Object)subtract).and("items.tax_rate", "<=", (Object)add);
            if (!ObjectUtils.isEmpty((Object)taxRateParam)) {
                sonTaxFilter = new QFilter("tax_rate", ">=", (Object)subtract).and("tax_rate", "<=", (Object)add);
            }
        }
        if (unit != null) {
            detailFilter = detailFilter == null ? new QFilter("items.unit", "=", (Object)unit) : detailFilter.and("items.unit", "=", (Object)unit);
        }
        if (specModel != null) {
            detailFilter = detailFilter == null ? new QFilter("items.spec_model", "=", (Object)specModel) : detailFilter.and("items.spec_model", "=", (Object)specModel);
        }
        DataSet detailDataSet = null;
        DataSet ordinaryDataSet = null;
        DataSet specialDataSet = null;
        DataSet tollDataSet = null;
        DataSet sonDataSet = null;
        DataSet electricDataSet = null;
        if (detailFilter != null) {
            ordinaryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_ordinary", (String)detailFieldsStr, (QFilter[])detailFilter.toArray(), null);
            specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_special", (String)detailFieldsStr, (QFilter[])detailFilter.toArray(), null);
            tollDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_toll", (String)detailFieldsStr, (QFilter[])detailFilter.toArray(), null);
            electricDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_electric", (String)detailFieldsStr, (QFilter[])detailFilter.toArray(), null);
            detailDataSet = ordinaryDataSet.union(specialDataSet).union(tollDataSet).union(electricDataSet);
        } else {
            ordinaryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_ordinary", (String)detailFieldsStr, null, null);
            specialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_special", (String)detailFieldsStr, null, null);
            tollDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_toll", (String)detailFieldsStr, null, null);
            electricDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_electric", (String)detailFieldsStr, null, null);
            detailDataSet = ordinaryDataSet.union(specialDataSet).union(tollDataSet).union(electricDataSet);
        }
        boolean bl12 = containsUnit = checkList != null && checkList.size() > 0 && checkList.contains("unitprice_check");
        if (!containsUnit) {
            String motorFieldsStr;
            if (sonTaxFilter != null) {
                motorFieldsStr = "serial_no, '' as goods_name, '' as spec_model, invoice_amount as items.unit_price, '' as items.unit, 1 as items.num, invoice_amount as items.detail_amount, tax_rate as items.tax_rate, effective_tax_amount as items.tax_amount";
                sonDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_motor", (String)motorFieldsStr, (QFilter[])sonTaxFilter.toArray(), null);
                detailDataSet = detailDataSet == null ? sonDataSet : detailDataSet.union(sonDataSet);
            } else {
                motorFieldsStr = "serial_no, '' as goods_name, '' as spec_model, invoice_amount as items.unit_price, '' as items.unit, 0 as items.num, invoice_amount as items.detail_amount, tax_rate as items.tax_rate, effective_tax_amount as items.tax_amount";
                sonDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_motor", (String)motorFieldsStr, null, null);
                detailDataSet = detailDataSet == null ? sonDataSet : detailDataSet.union(sonDataSet);
            }
        }
        DataSet dataSet = null;
        if (goodsNameParam != null || taxRateParam != null || goodPriceParam != null) {
            if (mainInvoiceDataSet != null) {
                dataSet = mainInvoiceDataSet.join(detailDataSet, JoinType.INNER).on("serial_no", "serial_no").select(selectedFeilds).finish();
            }
        } else if (mainInvoiceDataSet != null) {
            dataSet = mainInvoiceDataSet.join(detailDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFeilds).finish();
        }
        dataSet = this.getFilteredDataSet(dataSet, reportQueryParam);
        ArrayList<String> orderBy = new ArrayList<String>(16);
        if (!StringUtils.isEmpty((CharSequence)reportQueryParam.getSortInfo())) {
            orderBy.add(reportQueryParam.getSortInfo());
        }
        if (!CollectionUtils.isEmpty(orderBy)) {
            dataSet = dataSet.orderBy(orderBy.toArray(new String[0]));
        }
        return dataSet;
    }

    private DataSet getFilteredDataSet(DataSet dataSet, ReportQueryParam reportQueryParam) {
        String whereCondition = "";
        List headfilters = reportQueryParam.getFilter().getHeadFilters();
        boolean countFilterNum = false;
        for (QFilter filter : headfilters) {
            String filterStr = "";
            if ("invoice_date".equals(filter.getProperty()) || "createtime".equals(filter.getProperty()) || "select_time".equals(filter.getProperty()) || "entry_date".equals(filter.getProperty()) || "tax_period".equals(filter.getProperty())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                Date startDate = null;
                Timestamp endDate = null;
                if ("=".equals(filter.getCP())) {
                    startDate = DateUtils.stringToDate((String)((String)filter.getValue()), (String)"yyyy-MM-dd");
                    if ("invoice_date".equals(filter.getProperty()) || "tax_period".equals(filter.getProperty()) || "select_time".equals(filter.getProperty())) {
                        startDate = DateUtils.addDay((Date)startDate, (int)-1);
                    }
                    endDate = DateUtils.getDayEndTime((Date)startDate);
                    String startDateStr = sdf.format(startDate);
                    String endDateStr = sdf.format(endDate);
                    filterStr = filterStr.concat(filter.getProperty().concat(" >= ").concat("to_date(").concat("'" + startDateStr + "'").concat(", 'yyyy-MM-dd HH:mm:ss') and ")).concat(filter.getProperty().concat(" <= ").concat("to_date(").concat("'" + endDateStr + "'").concat(", 'yyyy-MM-dd HH:mm:ss')"));
                } else if ("<".equals(filter.getCP())) {
                    date = (Date)filter.getValue();
                    date = DateUtils.getDayEndTime((Date)date);
                } else {
                    date = (Date)filter.getValue();
                }
                if (StringUtils.isEmpty((CharSequence)filterStr)) {
                    if ("invoice_date".equals(filter.getProperty()) || "tax_period".equals(filter.getProperty()) || "select_time".equals(filter.getProperty())) {
                        date = DateUtils.addDay((Date)date, (int)-1);
                    }
                    String dateStr = sdf.format(date);
                    filterStr = filter.getProperty().concat(" " + filter.getCP() + " ").concat("to_date(").concat("'" + dateStr + "'").concat(", 'yyyy-MM-dd HH:mm:ss')");
                    List nestFilters = filter.getNests(false);
                    if (!CollectionUtils.isEmpty((Collection)nestFilters)) {
                        for (QFilter.QFilterNest nestFilter : nestFilters) {
                            QFilter nest = nestFilter.getFilter();
                            if (ObjectUtils.isEmpty((Object)nest)) continue;
                            String nestStr = null;
                            Date nestDate = (Date)nest.getValue();
                            if ("invoice_date".equals(nest.getProperty()) || "tax_period".equals(nest.getProperty()) || "select_time".equals(nest.getProperty())) {
                                nestDate = DateUtils.addDay((Date)nestDate, (int)-1);
                            }
                            nestStr = "<".equals(nest.getCP()) ? sdf.format(DateUtils.getDayEndTime((Date)nestDate)) : sdf.format(nestDate);
                            filterStr = filterStr.concat(" and ").concat(nest.getProperty().concat(" " + nest.getCP() + " ").concat("to_date(").concat("'" + nestStr + "'").concat(", 'yyyy-MM-dd HH:mm:ss')"));
                        }
                    }
                }
            } else if ("invoice_type".equals(filter.getProperty())) {
                if ("is not null".equals(filter.getCP())) {
                    filterStr = "invoice_type <> null";
                } else if ("is null".equals(filter.getCP())) {
                    filterStr = "invoice_type = null";
                } else {
                    List<Long> invoiceType = this.filterdInvoiceType(filter.toCurrentString());
                    if (CollectionUtils.isEmpty(invoiceType)) {
                        filterStr = "invoice_type = -1";
                    } else {
                        String invoiceTypeStr = "(";
                        for (Long type : invoiceType) {
                            if (ObjectUtils.isEmpty((Object)type)) continue;
                            invoiceTypeStr = invoiceTypeStr.concat(type.toString() + ",");
                        }
                        invoiceTypeStr = invoiceTypeStr.substring(0, invoiceTypeStr.length() - 1).concat(")");
                        filterStr = "invoice_type in " + invoiceTypeStr;
                    }
                }
            } else if ("effective_tax_amount".equals(filter.getProperty()) || "total_amount".equals(filter.getProperty()) || "num".equals(filter.getProperty()) || "detail_amount".equals(filter.getProperty()) || "tax_rate".equals(filter.getProperty()) || "tax_amount".equals(filter.getProperty()) || "unit_price".equals(filter.getProperty()) || "mileage".equals(filter.getProperty()) || "fuel_surcharge".equals(filter.getProperty()) || "airport_construction_fee".equals(filter.getProperty())) {
                Double m = null;
                if (filter.getValue() instanceof BigDecimal) {
                    m = BigDecimalUtil.transDecimal((Object)filter.getValue()).doubleValue();
                } else if (filter.getValue() instanceof String) {
                    m = Double.valueOf((String)filter.getValue());
                }
                filterStr = filter.getProperty() + " " + filter.getCP() + " " + m;
            } else {
                filterStr = "is not null".equals(filter.getCP()) ? filter.getProperty() + " <> null and " + filter.getProperty() + "<> ''" : ("is null".equals(filter.getCP()) ? "(" + filter.getProperty() + " = null or " + filter.getProperty() + " = '')" : filter.toCurrentString());
            }
            if (StringUtils.isEmpty((CharSequence)filterStr)) continue;
            whereCondition = whereCondition.concat(filterStr).concat(" and ");
        }
        if (!StringUtils.isEmpty((CharSequence)whereCondition)) {
            dataSet = dataSet.where(whereCondition);
        }
        return dataSet;
    }

    private void showField(Long nodeId) {
    }

    private List<Long> filterdInvoiceType(String filterStr) {
        if (!StringUtils.isEmpty((CharSequence)filterStr)) {
            filterStr = filterStr.replaceFirst("invoice_type", "name");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_invoicetype", (String)"id, name", null, null);
            dataSet = dataSet.where(filterStr);
            ArrayList<Long> invoiceTypes = new ArrayList<Long>(16);
            while (dataSet.hasNext()) {
                Row typeRow = dataSet.next();
                if (ObjectUtils.isEmpty((Object)typeRow)) continue;
                invoiceTypes.add(typeRow.getLong("id"));
            }
            return invoiceTypes;
        }
        return null;
    }

    private DataSet train(DataSet mainInvoiceDataSet, BigDecimal taxRateParam) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])trainFields);
        QFilter trainFilter = null;
        if (!ObjectUtils.isEmpty((Object)taxRateParam)) {
            trainFilter = new QFilter("tax_rate", ">=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("tax_rate", "<=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5)));
        }
        DataSet trainDataSet = null;
        DataSet dataSet = null;
        if (trainFilter != null) {
            trainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_train", (String)"train_num,serial_no, sequence_no, train_time, station_get_on, station_get_off, passenger_name, seat_grade", (QFilter[])trainFilter.toArray(), null);
            dataSet = mainInvoiceDataSet.join(trainDataSet, JoinType.INNER).on("serial_no", "serial_no").select(selectedFields).finish();
        } else {
            trainDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_train", (String)"train_num,serial_no, sequence_no, train_time, station_get_on, station_get_off, passenger_name, seat_grade", null, null);
            dataSet = mainInvoiceDataSet.join(trainDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        }
        return dataSet;
    }

    private DataSet air(DataSet mainInvoiceDataSet, BigDecimal taxRateParam) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])airFields);
        QFilter airFilter = null;
        if (!ObjectUtils.isEmpty((Object)taxRateParam)) {
            airFilter = new QFilter("tax_rate", ">=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("tax_rate", "<=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5)));
        }
        DataSet airDataSet = null;
        DataSet resultDataSet = null;
        if (airFilter != null) {
            airDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_air", (String)"eticket_no,serial_no, print_num, place_of_departure, destination, customer_name, customer_id_no, seat_grade, airport_construction_fee,fuel_surcharge", (QFilter[])airFilter.toArray(), null);
            DataSet select = airDataSet.select("eticket_no,serial_no, print_num, place_of_departure, destination, customer_name, case when len(customer_id_no) = 18 then concat(substr(customer_id_no, 0, 6), '********', substr(customer_id_no, 14,17)) when len(customer_id_no) <> 18 and len(customer_id_no) > 2 then concat(substr(customer_id_no, 0, len(customer_id_no)-2), '**') else customer_id_no end as customer_id_no, seat_grade, airport_construction_fee,fuel_surcharge");
            resultDataSet = mainInvoiceDataSet.join(select, JoinType.INNER).on("serial_no", "serial_no").select(selectedFields).finish();
        } else {
            airDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_air", (String)"eticket_no,serial_no, print_num, place_of_departure, destination, customer_name, customer_id_no, seat_grade, airport_construction_fee,fuel_surcharge", null, null);
            DataSet select = airDataSet.select("eticket_no,serial_no, print_num, place_of_departure, destination, customer_name, case when len(customer_id_no) = 18 then concat(substr(customer_id_no, 0, 6), '********', substr(customer_id_no, 14,17)) when len(customer_id_no) <> 18 and len(customer_id_no) > 2 then concat(substr(customer_id_no, 0, len(customer_id_no)-2), '**') else customer_id_no end as customer_id_no, seat_grade, airport_construction_fee,fuel_surcharge");
            resultDataSet = mainInvoiceDataSet.join(select, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        }
        return resultDataSet;
    }

    private DataSet transport(DataSet mainInvoiceDataSet, BigDecimal taxRateParam) {
        DataSet resultDataSet;
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])transportFields);
        QFilter transportFilter = null;
        if (!ObjectUtils.isEmpty((Object)taxRateParam)) {
            transportFilter = new QFilter("tax_rate", ">=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("tax_rate", "<=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5)));
        }
        if (transportFilter != null) {
            DataSet transportDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_transport", (String)"station_get_on,serial_no, station_get_off, passenger_name, time", (QFilter[])transportFilter.toArray(), null);
            resultDataSet = mainInvoiceDataSet.join(transportDataSet, JoinType.INNER).on("serial_no", "serial_no").select(selectedFields).finish();
        } else {
            DataSet transportDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_transport", (String)"station_get_on,serial_no, station_get_off, passenger_name, time", null, null);
            resultDataSet = mainInvoiceDataSet.join(transportDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        }
        return resultDataSet;
    }

    private DataSet taxi(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])taxiFields);
        DataSet taxiDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_taxi", (String)"serial_no, time_get_on,time_get_off, mileage", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(taxiDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet quota(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        Object[] quotaFields = new String[]{"place"};
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])quotaFields);
        DataSet quotaDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_quota", (String)"serial_no, place", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(quotaDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet general(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])generalFields);
        DataSet generalDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_general", (String)"serial_no, entrance, exit, time", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(generalDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet hgjks(DataSet mainInvoiceDataSet, String goodsNameParam, BigDecimal taxRateParam, BigDecimal goodPriceParam) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])hgjksFields);
        QFilter hgjksFilter = null;
        if (!ObjectUtils.isEmpty((Object)goodsNameParam)) {
            hgjksFilter = new QFilter("items.goods_name", "=", (Object)goodsNameParam);
        }
        if (!ObjectUtils.isEmpty((Object)taxRateParam)) {
            hgjksFilter = hgjksFilter == null ? new QFilter("items.tax_rate", ">=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("items.tax_rate", "<=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).add(BigDecimal.valueOf(5.0E-5))) : hgjksFilter.and("items.tax_rate", ">=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L), 4, 2).subtract(BigDecimal.valueOf(5.0E-5))).and("items.tax_rate", "<=", (Object)taxRateParam.divide(BigDecimal.valueOf(100L).add(BigDecimal.valueOf(5.0E-5)), 4, 2));
        }
        if (!ObjectUtils.isEmpty((Object)goodPriceParam)) {
            hgjksFilter = hgjksFilter == null ? new QFilter("items.unit_price", ">=", (Object)goodPriceParam.subtract(BigDecimal.valueOf(0.005))).and("items.unit_price", "<", (Object)goodPriceParam.add(BigDecimal.valueOf(0.005))) : hgjksFilter.and("items.unit_price", ">=", (Object)goodPriceParam.subtract(BigDecimal.valueOf(0.005))).and("items.unit_price", "<", (Object)goodPriceParam.add(BigDecimal.valueOf(0.005)));
        }
        DataSet hgjksDataSet = null;
        DataSet dataSet = null;
        if (hgjksFilter == null) {
            hgjksDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_custom", (String)"serial_no, custom_declaration_no, dept_name,declare_no, contract_no,trans_tool_no,pay_limit_date,get_office,items.goods_name,items.num,items.unit,items.unit_price,items.tax_rate,items.tax_amount", null, null);
            dataSet = mainInvoiceDataSet.join(hgjksDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        } else {
            hgjksDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_custom", (String)"serial_no, custom_declaration_no, dept_name,declare_no, contract_no,trans_tool_no,pay_limit_date,get_office,items.goods_name,items.num,items.unit,items.unit_price,items.tax_rate,items.tax_amount", (QFilter[])hgjksFilter.toArray(), null);
            dataSet = mainInvoiceDataSet.join(hgjksDataSet, JoinType.INNER).on("serial_no", "serial_no").select(selectedFields).finish();
        }
        return dataSet;
    }

    private DataSet taxProof(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        Object[] taxProofFields = new String[]{"tax_paid_proof_no"};
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])taxProofFields);
        DataSet taxProofDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_tax_proof", (String)"serial_no, tax_paid_proof_no", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(taxProofDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet trainRefund(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        Object[] taxProofFields = new String[]{"number"};
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])taxProofFields);
        DataSet taxProofDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_train_refund", (String)"serial_no, number", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(taxProofDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet financialInvoice(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])financialFields);
        DataSet taxProofDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_financial", (String)"serial_no, invoicing_party_code, invoicing_party_name, payer_party_code, payer_party_name", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(taxProofDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }

    private DataSet electric(DataSet mainInvoiceDataSet) {
        Object[] mainFields = mainFieldsStr.split(",");
        String[] selectedFields = (String[])ArrayUtils.addAll((Object[])mainFields, (Object[])electricFields);
        DataSet electricDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_electric", (String)"serial_no, total_deduct, main_goods_name", null, null);
        DataSet dataSet = mainInvoiceDataSet.join(electricDataSet, JoinType.LEFT).on("serial_no", "serial_no").select(selectedFields).finish();
        return dataSet;
    }
}

