/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.report.rptinput;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.report.rptinput.constant.RptInputConstant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;

public class RptInputListPlugin
extends AbstractReportListDataPlugin {
    private static final String DBROUTE = "taxc";
    private static Log LOGGER = LogFactory.getLog(RptInputListPlugin.class);
    private static String[] mainInfoSelectedFields = new String[]{"serial_no", "saler_name", "buyer_name", "invoice_date", "invoice_type", "expense_status", "original_state", "authenticate_flag", "expense_type", "remark", "total_amount", "invoice_amount", "total_tax_amount", "entry_amount", "effective_tax_amount"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        DataSet result;
        ArrayList searchFilterList = Lists.newArrayList();
        LOGGER.info("\u8fdb\u9879\u7edf\u8ba1-\u8bf7\u6c42\u53c2\u6570:{}", (Object)reportQueryParam);
        String isShowUncheck = RimConfigUtils.getConfig((String)"rim_config", (String)"show_uncheck");
        if (StringUtils.isBlank((String)isShowUncheck) || "0".equals(isShowUncheck)) {
            QFilter checkFilter = new QFilter("check_status", "=", (Object)"1");
            searchFilterList.add(checkFilter);
        }
        QFilter deleteFilter = new QFilter("delete", "=", (Object)"1");
        searchFilterList.add(deleteFilter);
        List orgFilters = reportQueryParam.getFilter().getQFilters();
        if (CollectionUtils.isNotEmpty((Collection)orgFilters)) {
            searchFilterList.addAll(orgFilters);
        }
        List filterItems = reportQueryParam.getFilter().getFilterItems();
        String pageId = RptInputConstant.getPageId((Object)this);
        PageCache pageCache = new PageCache(pageId);
        String customParamStr = pageCache.get("customParam");
        JSONObject customParam = null;
        if (!StringUtils.isEmpty((String)customParamStr)) {
            customParam = JSONObject.parseObject((String)customParamStr);
        }
        List<Object> checkboxTrueList = Lists.newArrayList();
        if (customParam != null && customParam.size() > 0) {
            for (String key : customParam.keySet()) {
                for (FilterItemInfo f2 : filterItems) {
                    if (!StringUtils.equals((String)f2.getPropName(), (String)key)) continue;
                    checkboxTrueList.add(f2);
                }
            }
        } else {
            checkboxTrueList = filterItems.stream().filter(f -> f.getPropName().endsWith("_check") && Boolean.TRUE.equals(f.getValue())).collect(Collectors.toList());
        }
        LinkedHashMap<String, String> columnsMap = this.getColumnsMap((List<FilterItemInfo>)checkboxTrueList);
        Set<String> keySet = columnsMap.keySet();
        String[] selected_field = keySet.toArray(new String[columnsMap.size()]);
        int dimenisonNum = checkboxTrueList.size();
        String[] columnsArray = keySet.stream().limit(dimenisonNum).collect(Collectors.toList()).toArray(new String[dimenisonNum]);
        String tag_name = this.getTagName(checkboxTrueList);
        FilterInfo filter = reportQueryParam.getFilter();
        List filterItems1 = filter.getFilterItems();
        ArrayList qFilters = Lists.newArrayList();
        for (FilterItemInfo f3 : filterItems1) {
            QFilter qFilter;
            String propName = f3.getPropName();
            Object value = f3.getValue();
            if (value instanceof DynamicObject) {
                DynamicObject dynamicObject = (DynamicObject)value;
                long aLong = dynamicObject.getLong(0);
                QFilter qFilter2 = new QFilter(propName, "=", (Object)aLong);
                qFilters.add(qFilter2);
                continue;
            }
            if (value instanceof String && !StringUtils.isEmpty((String)((String)value))) {
                qFilter = new QFilter(propName, "like", (Object)("%" + value + "%"));
                qFilters.add(qFilter);
                continue;
            }
            if (!(value instanceof Date) || ObjectUtils.isEmpty((Object)value)) continue;
            if (StringUtils.equals((String)propName, (String)"create_time_startdate")) {
                qFilter = new QFilter("createtime", ">=", (Object)DateUtils.trunc((Date)((Date)value)));
                qFilters.add(qFilter);
            } else if (StringUtils.equals((String)propName, (String)"create_time_enddate")) {
                qFilter = new QFilter("createtime", "<=", (Object)DateUtils.getDayEndTime((Date)DateUtils.trunc((Date)((Date)value))));
                qFilters.add(qFilter);
            }
            if (StringUtils.equals((String)propName, (String)"invoice_date_startdate")) {
                qFilter = new QFilter("invoice_date", ">=", (Object)DateUtils.trunc((Date)((Date)value)));
                qFilters.add(qFilter);
            } else if (StringUtils.equals((String)propName, (String)"invoice_date_enddate")) {
                qFilter = new QFilter("invoice_date", "<=", (Object)DateUtils.getDayEndTime((Date)DateUtils.trunc((Date)((Date)value))));
                qFilters.add(qFilter);
            }
            if (StringUtils.equals((String)propName, (String)"daterangefield_startdate") || StringUtils.equals((String)propName, (String)"account_time_startdate")) {
                qFilter = new QFilter("account_time", ">=", (Object)DateUtils.trunc((Date)((Date)value)));
                qFilters.add(qFilter);
            } else if (StringUtils.equals((String)propName, (String)"daterangefield_enddate") || StringUtils.equals((String)propName, (String)"account_time_enddate")) {
                qFilter = new QFilter("account_time", "<=", (Object)DateUtils.getDayEndTime((Date)DateUtils.trunc((Date)((Date)value))));
                qFilters.add(qFilter);
            }
            if (StringUtils.equals((String)propName, (String)"daterangefield1_startdate") || StringUtils.equals((String)propName, (String)"authenticate_time_startdate")) {
                qFilter = new QFilter("authenticate_time", ">=", (Object)DateUtils.trunc((Date)((Date)value)));
                qFilters.add(qFilter);
                continue;
            }
            if (!StringUtils.equals((String)propName, (String)"daterangefield1_enddate") && !StringUtils.equals((String)propName, (String)"authenticate_time_enddate")) continue;
            qFilter = new QFilter("authenticate_time", "<=", (Object)DateUtils.getDayEndTime((Date)DateUtils.trunc((Date)((Date)value))));
            qFilters.add(qFilter);
        }
        searchFilterList.addAll(qFilters);
        ArrayList<QFilter> mainFilters = new ArrayList();
        CollectionUtils.addAll(mainFilters, (Object[])new Object[searchFilterList.size()]);
        Collections.copy(mainFilters, searchFilterList);
        mainFilters = mainFilters.stream().filter(f -> !StringUtils.equals((String)f.getProperty(), (String)"goods_name")).collect(Collectors.toList());
        ArrayList<QFilter> itemFilters = new ArrayList<QFilter>();
        searchFilterList.stream().filter(f -> StringUtils.equals((String)f.getProperty(), (String)"goods_name")).forEach(i -> {
            String property = "items." + i.getProperty();
            QFilter qfilter = new QFilter(property, "like", i.getValue());
            itemFilters.add(qfilter);
        });
        String sortInfo = reportQueryParam.getSortInfo();
        ArrayList<String> orderBy = new ArrayList<String>(16);
        if (!StringUtils.isEmpty((String)sortInfo)) {
            sortInfo = sortInfo.replace("items_", "items.");
            orderBy.add(sortInfo);
        }
        if (checkboxTrueList.size() == 1) {
            String propName;
            switch (propName = ((FilterItemInfo)checkboxTrueList.get(0)).getPropName()) {
                case "tax_check": {
                    result = this.checkTaxQuery(columnsArray, mainFilters, itemFilters);
                    break;
                }
                case "bill_check": {
                    result = this.checkBillQuery(mainFilters);
                    break;
                }
                case "unitprice_check": {
                    result = this.checkUnitPriceQuery(selected_field, columnsArray, mainFilters, itemFilters);
                    break;
                }
                default: {
                    result = this.checkOneNormalQuery(selected_field, columnsArray, tag_name, searchFilterList, reportQueryParam);
                }
            }
            if (result == null) {
                return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_invoice", null, (QFilter[])new QFilter[]{new QFilter("invoice_no", "=", (Object)"@")}, null);
            }
            return result.where(this.appendWhereExper(reportQueryParam, columnsArray, keySet)).orderBy(orderBy.toArray(new String[0]));
        }
        result = this.checkMultiQuery(selected_field, columnsArray, tag_name, mainFilters, itemFilters, reportQueryParam);
        if (result == null) {
            return this.getDetailEmptyDataSet();
        }
        return result.where(this.appendWhereExper(reportQueryParam, columnsArray, keySet)).orderBy(orderBy.toArray(new String[0]));
    }

    private String appendWhereExper(ReportQueryParam reportQueryParam, String[] columnsArray, Set<String> keySet) {
        String whereExprStr;
        List headFilters = reportQueryParam.getFilter().getHeadFilters();
        StringBuilder whereExpr = new StringBuilder();
        Arrays.asList(columnsArray).stream().forEach(f -> {
            if (!StringUtils.equals((String)f, (String)"invoice_type") && !StringUtils.equals((String)f, (String)"tax_rate")) {
                whereExpr.append((String)f).append(" != '' and ").append((String)f).append(" is not null and ");
            } else {
                whereExpr.append((String)f).append(" is not null and ");
            }
        });
        if (!CollectionUtils.isEmpty((Collection)headFilters)) {
            for (QFilter q : headFilters) {
                String headFilterStr;
                String property = q.getProperty().replace("items_", "items.");
                if (!keySet.contains(property) && !StringUtils.equals((String)property, (String)"count")) continue;
                if (property.contains("rate") || property.contains("amount") || property.contains("price") || StringUtils.equals((String)property, (String)"count")) {
                    headFilterStr = property + " " + q.getCP() + " " + q.getValue();
                } else if ("invoice_type".equals(property)) {
                    String value = q.getValue().toString();
                    if (q.getCP().equals("is not null")) continue;
                    List<Long> matchInvoiceTypes = this.getMatchInvoiceTypes(value);
                    String invoiceTypes = StringUtil.stripChar((String)StringUtil.stripChar((String)matchInvoiceTypes.toString(), (char)'['), (char)']');
                    if (StringUtils.isEmpty((String)invoiceTypes)) {
                        invoiceTypes = "-1";
                    }
                    headFilterStr = StringUtils.equals((String)q.getCP(), (String)"not like") || StringUtils.equals((String)q.getCP(), (String)"!=") ? property + " not in (" + invoiceTypes + ")" : property + " in (" + invoiceTypes + ")";
                } else if (keySet.contains(property) && q.getCP().equals("is null")) {
                    headFilterStr = "1 = 2";
                } else {
                    if (keySet.contains(property) && q.getCP().equals("is not null")) continue;
                    headFilterStr = property + " " + q.getCP() + " '" + q.getValue() + "'";
                }
                whereExpr.append(headFilterStr).append(" and ");
            }
        }
        if (!StringUtils.isEmpty((String)(whereExprStr = whereExpr.toString()))) {
            whereExprStr = whereExprStr.substring(0, whereExprStr.length() - 4);
        }
        return whereExprStr;
    }

    private List<Long> getMatchInvoiceTypes(String enumName) {
        ArrayList matchInvoiceTypes = Lists.newArrayList();
        DynamicObjectCollection invoiceTypeCollection = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id, name", null);
        invoiceTypeCollection.stream().forEach(f -> {
            String invoiceTypeName = f.getString("name");
            Long invoiceTypeId = f.getLong("id");
            if (enumName.startsWith("%") && enumName.endsWith("%")) {
                if (invoiceTypeName.contains(enumName.replace("%", ""))) {
                    matchInvoiceTypes.add(invoiceTypeId);
                }
            } else if (enumName.startsWith("%") && !enumName.endsWith("%")) {
                if (invoiceTypeName.endsWith(enumName.replace("%", ""))) {
                    matchInvoiceTypes.add(invoiceTypeId);
                }
            } else if (!enumName.startsWith("%") && enumName.endsWith("%")) {
                if (invoiceTypeName.startsWith(enumName.replace("%", ""))) {
                    matchInvoiceTypes.add(invoiceTypeId);
                }
            } else if (StringUtils.equals((String)invoiceTypeName, (String)enumName)) {
                matchInvoiceTypes.add(invoiceTypeId);
            }
        });
        return matchInvoiceTypes;
    }

    private DataSet checkUnitPriceQuery(String[] selected_field, String[] columnsArray, List<QFilter> mainFilters, List<QFilter> itemsList) {
        ORM orm = ORM.create();
        DataSet mainSerial = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_invoice", "serial_no", mainFilters.toArray(new QFilter[0]));
        String selectedField = StringUtil.stripChar((String)StringUtil.stripChar((String)Arrays.asList(selected_field).toString(), (char)'['), (char)']');
        selectedField = selectedField.replace("items.unit_price", "round(items.unit_price,2) as items.unit_price").replace("items.tax_rate", "round(items.tax_rate,4) * 100 as items.tax_rate");
        DataSet rim_inv_ordinary = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_ordinary", "serial_no," + selectedField, itemsList.toArray(new QFilter[0]));
        DataSet rim_inv_custom = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_custom", "serial_no, items.goods_name, '' as items.spec_model, '' as saler_name, '' as buyer_name, round(items.unit_price,2) as items.unit_price, items.unit, round(items.tax_rate,4) * 100 as items.tax_rate", itemsList.toArray(new QFilter[0]));
        DataSet rim_inv_toll = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_toll", "serial_no," + selectedField, itemsList.toArray(new QFilter[0]));
        DataSet rim_inv_special = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_special", "serial_no," + selectedField, itemsList.toArray(new QFilter[0]));
        DataSet rim_inv_electric = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_electric", "serial_no," + selectedField, itemsList.toArray(new QFilter[0]));
        DataSet union = rim_inv_ordinary.union(rim_inv_custom).union(rim_inv_toll).union(rim_inv_special).union(rim_inv_electric);
        DataSet finshBySerialNo = mainSerial.join(union, JoinType.INNER).on("serial_no", "serial_no").select(selected_field).finish();
        DataSet count = finshBySerialNo.groupBy(selected_field).count("count").finish();
        return count.orderBy(columnsArray);
    }

    private DataSet checkMultiQuery(String[] selected_field, String[] columnsArray, String tag_name, List<QFilter> mainFilters, List<QFilter> itemFilters, ReportQueryParam reportQueryParam) {
        ORM orm = ORM.create();
        List<String> tagNameList = Arrays.asList(tag_name.split(","));
        HashSet<String> tagNameSet = new HashSet<String>(tagNameList);
        if (tagNameSet.size() == 1) {
            String tagName = (String)tagNameSet.iterator().next();
            String selects = StringUtil.stripChar((String)StringUtil.stripChar((String)Arrays.asList(selected_field).toString(), (char)'['), (char)']');
            selects = this.convertByDBType(selects);
            DataSet rows = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), tagName, selects, mainFilters.toArray(new QFilter[0]));
            GroupbyDataSet groupbyDataSet = rows.groupBy(columnsArray);
            List<String> sunColumnsList = Arrays.asList(selected_field).subList(columnsArray.length, Arrays.asList(selected_field).size());
            sunColumnsList.stream().forEach(f -> {
                if (f.contains("amount")) {
                    groupbyDataSet.sum(f);
                }
            });
            return groupbyDataSet.count("count").finish();
        }
        DataSet mainInfo = null;
        if (tagNameSet.contains("rim_expense_relation")) {
            mainInfo = this.getMainInfoByExp(orm, mainFilters);
        }
        if (!tagNameSet.contains("rim_expense_relation") && tagNameSet.contains("rim_invoice")) {
            String selectedField = "serial_no, saler_name, buyer_name, invoice_date, invoice_type, expense_status, original_state, authenticate_flag, remark, total_amount, invoice_amount, total_tax_amount, entry_amount, effective_tax_amount";
            selectedField = this.convertByDBType(selectedField);
            mainInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_invoice", selectedField, mainFilters.toArray(new QFilter[0]));
        }
        if (tagNameSet.contains("taxmulti")) {
            DataSet finishInfo = this.getTaxFinishInfo(orm, selected_field, columnsArray, mainInfo, mainFilters, itemFilters);
            return finishInfo;
        }
        DataSet finishInfo = mainInfo;
        if (finishInfo == null) {
            return null;
        }
        GroupbyDataSet groupbyDataSet = finishInfo.groupBy(selected_field).finish().groupBy(columnsArray);
        List<String> sunColumnsList = Arrays.asList(selected_field).subList(columnsArray.length, Arrays.asList(selected_field).size());
        sunColumnsList.stream().forEach(f -> {
            if (f.contains("amount")) {
                groupbyDataSet.sum(f);
            }
        });
        return groupbyDataSet.count("count").finish();
    }

    private String convertByDBType(String selects) {
        DBType dbType = DB.getDBType((DBRoute)DBRoute.of((String)DBROUTE));
        int value = dbType.getValue();
        selects = value == 5 ? selects.replace("invoice_date", "substring(to_char(invoice_date,'yyyy-MM-dd'),0,8) as invoice_date") : selects.replace("invoice_date", "substring(to_char(invoice_date,'yyyy-MM-dd'),0,7) as invoice_date");
        return selects;
    }

    private DataSet getMainInfoByExp(ORM orm, List<QFilter> mainFilters) {
        DataSet mainInfo = null;
        DataSet expInvoice = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_expense_relation", "expense_type, serial_no", null);
        DataSet expTypeInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_expense_type", "number, name", null);
        DataSet finish = expInvoice.join(expTypeInfo, JoinType.LEFT).on("expense_type", "number").select(new String[]{"name as expense_type", "serial_no"}).finish();
        DataSet expInvoiceCopy = finish.copy();
        Iterator iterator = expInvoiceCopy.iterator();
        ArrayList serialNoList = Lists.newArrayList();
        while (iterator.hasNext()) {
            Row info = (Row)iterator.next();
            String serialNo = info.getString("serial_no");
            serialNoList.add(serialNo);
        }
        if (serialNoList.size() > 0) {
            QFilter qFilter = new QFilter("serial_no", "in", (Object)serialNoList);
            mainFilters.add(qFilter);
            String selectColumns = "serial_no, saler_name, buyer_name, invoice_date, invoice_type, expense_status, original_state, authenticate_flag,  remark, total_amount,invoice_amount, total_tax_amount, entry_amount, effective_tax_amount";
            String selectColumnsConvert = this.convertByDBType(selectColumns);
            DataSet result = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_invoice", selectColumnsConvert, mainFilters.toArray(new QFilter[0]));
            mainInfo = finish.join(result, JoinType.RIGHT).on("serial_no", "serial_no").select(mainInfoSelectedFields).finish().groupBy(mainInfoSelectedFields).finish();
        }
        return mainInfo;
    }

    private DataSet getTaxFinishInfo(ORM orm, String[] selected_field, String[] columnsArray, DataSet mainInfo, List<QFilter> mainFilters, List<QFilter> itemFilters) {
        List<QFilter> transportFilters;
        ArrayList allFilter = Lists.newArrayList();
        allFilter.addAll(mainFilters.stream().filter(f -> !StringUtils.equals((String)f.getProperty(), (String)"delete")).collect(Collectors.toList()));
        allFilter.addAll(itemFilters);
        boolean queryTransportFlag = this.getTransportFlag(allFilter);
        boolean queryCustomFlag = this.getCustomFlag(allFilter);
        boolean queryMotorFlag = this.getMotorFlag(allFilter);
        List<QFilter> vatFilters = allFilter.stream().filter(f -> StringUtils.equals((String)f.getProperty(), (String)"goods_name") || StringUtils.equals((String)f.getProperty(), (String)"unit_price")).collect(Collectors.toList());
        DataSet ordinaryItem = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_ordinary", "serial_no, round(items.tax_rate,4) * 100 as tax_rate", vatFilters.toArray(new QFilter[0]));
        DataSet specialItem = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_special", "serial_no, round(items.tax_rate,4) * 100 as tax_rate", vatFilters.toArray(new QFilter[0]));
        DataSet tollItem = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_toll", "serial_no, round(items.tax_rate,4) * 100 as tax_rate", vatFilters.toArray(new QFilter[0]));
        DataSet electricItem = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_electric", "serial_no, round(items.tax_rate,4) * 100 as tax_rate", vatFilters.toArray(new QFilter[0]));
        DataSet ordFinish = mainInfo.copy().join(ordinaryItem, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
        DataSet specFinish = mainInfo.copy().join(specialItem, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
        DataSet tollFinish = mainInfo.copy().join(tollItem, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
        DataSet electricFinish = mainInfo.copy().join(electricItem, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
        DataSet finishInfo = ordFinish.union(specFinish).union(tollFinish).union(electricFinish);
        if (queryTransportFlag) {
            transportFilters = allFilter.stream().filter(f -> StringUtils.equals((String)f.getProperty(), (String)"invoice_type") || StringUtils.equals((String)f.getProperty(), (String)"org") || StringUtils.equals((String)f.getProperty(), (String)"tax_org") || StringUtils.equals((String)f.getProperty(), (String)"create_time")).collect(Collectors.toList());
            DataSet airInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_air", "serial_no, round(tax_rate,4) * 100 as tax_rate", transportFilters.toArray(new QFilter[0]));
            DataSet trainInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_train", "serial_no, round(tax_rate,4) * 100 as tax_rate", transportFilters.toArray(new QFilter[0]));
            DataSet transportInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_transport", "serial_no, round(tax_rate,4) * 100 as tax_rate", transportFilters.toArray(new QFilter[0]));
            DataSet airFinish = mainInfo.copy().join(airInfo, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
            DataSet trainFinish = mainInfo.copy().join(trainInfo, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
            DataSet transportFinish = mainInfo.copy().join(transportInfo, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
            finishInfo = finishInfo.union(airFinish).union(trainFinish).union(transportFinish);
        }
        if (queryCustomFlag) {
            List<QFilter> coustomFilter = allFilter.stream().filter(f -> StringUtils.equals((String)f.getProperty(), (String)"invoice_type") || StringUtils.equals((String)f.getProperty(), (String)"org") || StringUtils.equals((String)f.getProperty(), (String)"tax_org") || StringUtils.equals((String)f.getProperty(), (String)"create_time") || StringUtils.equals((String)f.getProperty(), (String)"items.goods_name")).collect(Collectors.toList());
            DataSet customItem = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_custom", "serial_no, round(items.tax_rate,4) * 100 as tax_rate", coustomFilter.toArray(new QFilter[0]));
            DataSet customFinish = mainInfo.copy().join(customItem, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
            finishInfo = finishInfo.union(customFinish);
        }
        if (queryMotorFlag) {
            transportFilters = allFilter.stream().filter(f -> StringUtils.equals((String)f.getProperty(), (String)"org") || StringUtils.equals((String)f.getProperty(), (String)"create_time") || StringUtils.equals((String)f.getProperty(), (String)"remark") || StringUtils.equals((String)f.getProperty(), (String)"daterangefield1_startdate") || StringUtils.equals((String)f.getProperty(), (String)"daterangefield1_enddate")).collect(Collectors.toList());
            DataSet motorInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_inv_motor", "serial_no, round(tax_rate,4) * 100 as tax_rate", transportFilters.toArray(new QFilter[0]));
            DataSet motorFinish = mainInfo.copy().join(motorInfo, JoinType.RIGHT).on("serial_no", "serial_no").select(selected_field).finish();
            finishInfo = finishInfo.union(motorFinish);
        }
        GroupbyDataSet groupbyDataSet = finishInfo.groupBy(columnsArray);
        List<String> sunColumnsList = Arrays.asList(selected_field).subList(columnsArray.length, Arrays.asList(selected_field).size());
        sunColumnsList.stream().forEach(f -> {
            if (f.contains("amount")) {
                groupbyDataSet.sum(f);
            }
        });
        return groupbyDataSet.count("count").finish();
    }

    private boolean getMotorFlag(List<QFilter> allFilter) {
        for (QFilter qFilter : allFilter) {
            if (!StringUtils.equals((String)qFilter.getProperty(), (String)"items.goods_name")) continue;
            return false;
        }
        return true;
    }

    private boolean getCustomFlag(List<QFilter> allFilter) {
        for (QFilter qFilter : allFilter) {
            if (!StringUtils.equals((String)qFilter.getProperty(), (String)"saler_name") && !StringUtils.equals((String)qFilter.getProperty(), (String)"buyer_name")) continue;
            return false;
        }
        return true;
    }

    private boolean getTransportFlag(List<QFilter> allFilter) {
        for (QFilter qFilter : allFilter) {
            if (!StringUtils.equals((String)qFilter.getProperty(), (String)"saler_name") && !StringUtils.equals((String)qFilter.getProperty(), (String)"items.goods_name") && !StringUtils.equals((String)qFilter.getProperty(), (String)"remark") && !StringUtils.equals((String)qFilter.getProperty(), (String)"buyer_name")) continue;
            return false;
        }
        return true;
    }

    private DataSet checkBillQuery(List<QFilter> searchFilterList) {
        ORM orm = ORM.create();
        DataSet expInvoice = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_expense_relation", "expense_type, serial_no", null);
        DataSet expInvoiceCopy = expInvoice.copy();
        Iterator iterator = expInvoice.iterator();
        HashSet<String> serialNoList = new HashSet<String>(16);
        while (iterator.hasNext()) {
            Row info = (Row)iterator.next();
            String serialNo = info.getString("serial_no");
            serialNoList.add(serialNo);
        }
        QFilter qFilter = new QFilter("serial_no", "in", serialNoList);
        searchFilterList.add(qFilter);
        DataSet result = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_invoice", "serial_no, total_amount, invoice_amount, total_tax_amount, entry_amount, effective_tax_amount", searchFilterList.toArray(new QFilter[0]));
        DataSet finish = expInvoiceCopy.join(result, JoinType.RIGHT).on("serial_no", "serial_no").select(new String[]{"serial_no", "expense_type", "total_amount", "invoice_amount", "total_tax_amount", "entry_amount", "effective_tax_amount"}).finish().groupBy(new String[]{"serial_no", "expense_type", "total_amount", "invoice_amount", "total_tax_amount", "entry_amount", "effective_tax_amount"}).finish();
        result = finish.copy().groupBy(new String[]{"expense_type"}).sum("total_amount").sum("invoice_amount").sum("total_tax_amount").sum("entry_amount").sum("effective_tax_amount").count("count").finish();
        DataSet expTypeInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_expense_type", "number, name", null);
        result = result.join(expTypeInfo, JoinType.LEFT).on("expense_type", "number").select(new String[]{"name as expense_type", "total_amount", "invoice_amount", "total_tax_amount", "entry_amount", "effective_tax_amount", "count"}).finish();
        return result.orderBy(new String[]{"expense_type"});
    }

    private DataSet checkTaxQuery(String[] columnsArray, List<QFilter> mainFilters, List<QFilter> itemFilters) {
        ORM orm = ORM.create();
        long starttime1 = System.currentTimeMillis();
        DataSet rimInvoice = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "rim_invoice", "invoice_type, serial_no", mainFilters.toArray(new QFilter[0])).groupBy(new String[]{"invoice_type", "serial_no"}).finish();
        LOGGER.info("\u7a0e\u7387\u7ef4\u5ea6\u7edf\u8ba1\u67e5\u8be2\u4e3b\u8868\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - starttime1));
        Iterator iterator = rimInvoice.iterator();
        HashMap serialTypeMap = Maps.newHashMap();
        long starttime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Row info = (Row)iterator.next();
            Long invoiceType = info.getLong("invoice_type");
            StringBuilder serialNo = new StringBuilder(info.getString("serial_no"));
            StringBuilder savedValue = (StringBuilder)serialTypeMap.get(invoiceType);
            if (savedValue != null) {
                serialTypeMap.put(invoiceType, savedValue.append(',').append((CharSequence)serialNo));
                continue;
            }
            serialTypeMap.put(invoiceType, serialNo);
        }
        long endtime = System.currentTimeMillis();
        LOGGER.info("\u7a0e\u7387\u7ef4\u5ea6\u7edf\u8ba1\u7ec4\u5408serialNo\u65f6\u95f4\uff1a" + (endtime - starttime));
        long starttime2 = System.currentTimeMillis();
        DataSet result = this.queryInvoiceTaxBySerialMap(serialTypeMap, itemFilters);
        LOGGER.info("\u7a0e\u7387\u7ef4\u5ea6\u7edf\u8ba1\u67e5\u8be2\u660e\u7ec6\u8868\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - starttime2));
        if (result != null) {
            result = result.groupBy(columnsArray).sum("invoice_amount").sum("total_tax_amount").count("count").finish().orderBy(columnsArray);
        }
        return result;
    }

    private DataSet queryInvoiceTaxBySerialMap(Map<Long, StringBuilder> serialTypeMap, List<QFilter> itemFilters) {
        ArrayList resultFilter = Lists.newArrayList();
        DataSet entityInfo = null;
        int i = 0;
        DataSet result = null;
        for (Map.Entry<Long, StringBuilder> entry : serialTypeMap.entrySet()) {
            resultFilter.clear();
            Long invoiceType = entry.getKey();
            String searchFileds = "";
            String entityName = InputInvoiceTypeEnum.getEntity((Long)invoiceType);
            if ((InputInvoiceTypeEnum.TRAIN_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.BOAT_INVOICE.getCode().equals(invoiceType) || InputInvoiceTypeEnum.AIR_INVOICE.getCode().equals(invoiceType)) && CollectionUtils.isEmpty(itemFilters)) {
                searchFileds = "id, -1 as eid, round(tax_rate,4) * 100 as tax_rate, total_amount as invoice_amount, total_tax_amount as total_tax_amount";
            } else if (this.checkVatItem(invoiceType)) {
                searchFileds = "id, items.id as eid, round(items.tax_rate,4) * 100 as tax_rate, items.detail_amount as invoice_amount, items.tax_amount as total_tax_amount";
            } else if (InputInvoiceTypeEnum.MOTOR_INVOICE.getCode().equals(invoiceType)) {
                searchFileds = "id, -1 as eid, round(tax_rate,4) * 100 as tax_rate, invoice_amount as invoice_amount, total_tax_amount as total_tax_amount";
            } else if (InputInvoiceTypeEnum.HGJKS.getCode().equals(invoiceType)) {
                searchFileds = "id, -1 as eid, round(items.tax_rate,4) * 100 as tax_rate, items.unit_price as invoice_amount, items.tax_amount as total_tax_amount";
            }
            if (!StringUtils.isEmpty((String)searchFileds) && !StringUtils.isEmpty((String)entityName)) {
                List<String> serialNoList = Arrays.asList(entry.getValue().toString().split(","));
                QFilter qFilter = new QFilter("serial_no", "in", serialNoList);
                resultFilter.add(qFilter);
                resultFilter.addAll(itemFilters);
                entityInfo = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)searchFileds, (QFilter[])resultFilter.toArray(new QFilter[0]), null);
            }
            if (i == 0) {
                result = entityInfo;
            } else if (entityInfo != null && result != null) {
                result = result.union(entityInfo);
            }
            if (entityInfo == null) continue;
            ++i;
        }
        if (result != null) {
            result = result.groupBy(new String[]{"id", "eid", "tax_rate", "invoice_amount", "total_tax_amount"}).finish();
        }
        return result;
    }

    private DataSet getEntityInfo(String entityName, String searchFileds, QFilter[] toArray) {
        ORM orm = ORM.create();
        return orm.queryDataSet(((Object)((Object)this)).getClass().getName(), entityName, searchFileds, toArray);
    }

    private DataSet getDetailEmptyDataSet() {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"rim_inv_custom", (String)"round(items.tax_rate,4) * 100 as tax_rate, items.unit_price as invoice_amount, items.tax_amount as total_tax_amount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)-1)}, null);
    }

    private boolean checkVatItem(Long invoiceType) {
        return InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.TOLL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode().equals(invoiceType) || InputInvoiceTypeEnum.SPECIAL_PAPER.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ORDINARY_ROLL.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode().equals(invoiceType) || InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode().equals(invoiceType);
    }

    private DataSet checkOneNormalQuery(String[] selected_field, String[] columnsArray, String tag_name, List<QFilter> searchFilterList, ReportQueryParam reportQueryParam) {
        ORM orm = ORM.create();
        String selectedField = StringUtil.stripChar((String)StringUtil.stripChar((String)Arrays.asList(selected_field).toString(), (char)'['), (char)']');
        selectedField = this.convertByDBType(selectedField);
        DataSet rowsInfo = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), tag_name, selectedField, searchFilterList.toArray(new QFilter[0]));
        GroupbyDataSet groupInfo = rowsInfo.groupBy(columnsArray);
        List<String> sunColumnsList = Arrays.asList(selected_field).subList(columnsArray.length, Arrays.asList(selected_field).size());
        sunColumnsList.stream().forEach(f -> {
            if (f.contains("amount")) {
                groupInfo.sum(f);
            }
        });
        return groupInfo.count("count").finish().orderBy(columnsArray);
    }

    private String getTagName(List<FilterItemInfo> checkboxTrueList) {
        StringBuilder tagName = new StringBuilder();
        for (FilterItemInfo f : checkboxTrueList) {
            if ("unitprice_check".equals(f.getPropName())) {
                tagName.append("rim_inv_ordinary,");
                continue;
            }
            if ("bill_check".equals(f.getPropName())) {
                tagName.append("rim_expense_relation,");
                continue;
            }
            if ("tax_check".equals(f.getPropName())) {
                tagName.append("taxmulti,");
                continue;
            }
            tagName.append("rim_invoice,");
        }
        String result = tagName.toString();
        if (!StringUtils.isEmpty((String)result)) {
            result = result.substring(0, tagName.length() - 1);
        }
        return result;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        List filterItems = this.getQueryParam().getFilter().getFilterItems();
        String pageId = RptInputConstant.getPageId((Object)this);
        PageCache pageCache = new PageCache(pageId);
        String customParamStr = pageCache.get("customParam");
        JSONObject customParam = null;
        if (!StringUtils.isEmpty((String)customParamStr)) {
            customParam = JSONObject.parseObject((String)customParamStr);
        }
        List<Object> checkboxTrueList = Lists.newArrayList();
        if (customParam != null && customParam.size() > 0) {
            for (String key : customParam.keySet()) {
                for (FilterItemInfo f2 : filterItems) {
                    if (!StringUtils.equals((String)f2.getPropName(), (String)key)) continue;
                    checkboxTrueList.add(f2);
                }
            }
        } else {
            checkboxTrueList = filterItems.stream().filter(f -> f.getPropName().endsWith("_check") && Boolean.TRUE.equals(f.getValue())).collect(Collectors.toList());
        }
        LinkedHashMap<String, String> columnsMap = this.getColumnsMap((List<FilterItemInfo>)checkboxTrueList);
        String[] selected_field = columnsMap.keySet().toArray(new String[columnsMap.size()]);
        for (String selectedField : Arrays.asList(selected_field)) {
            if (StringUtils.equals((String)selectedField, (String)"expense_status")) {
                this.addComboReportColumn(cols, selectedField, columnsMap, this.expenseStatusCombo());
                continue;
            }
            if (StringUtils.equals((String)selectedField, (String)"original_state")) {
                this.addComboReportColumn(cols, selectedField, columnsMap, this.originalStatusCombo());
                continue;
            }
            if (StringUtils.equals((String)selectedField, (String)"authenticate_flag")) {
                this.addComboReportColumn(cols, selectedField, columnsMap, this.authStatusCombo());
                continue;
            }
            ReportColumn totalRpt = new ReportColumn();
            totalRpt.setCaption(new LocaleString(ResManager.loadKDString((String)columnsMap.get(selectedField), (String)"RptInputListPlugin_1", (String)"RptInputListPlugin_0", (Object[])new Object[0])));
            totalRpt.setWidth(new LocaleString("250px"));
            totalRpt.setFieldKey(selectedField);
            if (selectedField.contains("price") || selectedField.contains("amount")) {
                totalRpt.setFieldType("amount");
                totalRpt.setScale(2);
                totalRpt.setZeroShow(true);
            } else if (selectedField.contains("rate")) {
                totalRpt.setFieldType("decimal");
                totalRpt.setScale(2);
                totalRpt.setZeroShow(true);
            } else {
                totalRpt.setFieldType("text");
            }
            cols.add(totalRpt);
        }
        cols.add(this.addCountColumns());
        return cols;
    }

    private void addComboReportColumn(List<AbstractReportColumn> cols, String selectedField, LinkedHashMap<String, String> columnsMap, List<ValueMapItem> comboItems) {
        ComboReportColumn comboReportColumn = new ComboReportColumn();
        comboReportColumn.setComboItems(comboItems);
        comboReportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)columnsMap.get(selectedField), (String)"RptInputListPlugin_1", (String)"RptInputListPlugin_0", (Object[])new Object[0])));
        comboReportColumn.setWidth(new LocaleString("250px"));
        comboReportColumn.setFieldKey(selectedField);
        comboReportColumn.setFieldType("combofield");
        cols.add((AbstractReportColumn)comboReportColumn);
    }

    private List<ValueMapItem> expenseStatusCombo() {
        ArrayList comboItems = Lists.newArrayList();
        ValueMapItem valueMapItem = new ValueMapItem();
        valueMapItem.setValue("1");
        valueMapItem.setName(new LocaleString(ResManager.loadKDString((String)"\u672a\u7528", (String)"RptInputListPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem2 = new ValueMapItem();
        valueMapItem2.setValue("30");
        valueMapItem2.setName(new LocaleString(ResManager.loadKDString((String)"\u5728\u7528", (String)"RptInputListPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem3 = new ValueMapItem();
        valueMapItem3.setValue("60");
        valueMapItem3.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7528", (String)"RptInputListPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem4 = new ValueMapItem();
        valueMapItem4.setValue("65");
        valueMapItem4.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5165\u8d26", (String)"RptInputListPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem5 = new ValueMapItem();
        valueMapItem5.setValue("2");
        valueMapItem5.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u6253\u5305", (String)"RptInputListPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        comboItems.add(valueMapItem);
        comboItems.add(valueMapItem2);
        comboItems.add(valueMapItem3);
        comboItems.add(valueMapItem4);
        comboItems.add(valueMapItem5);
        return comboItems;
    }

    private List<ValueMapItem> originalStatusCombo() {
        ArrayList comboItems = Lists.newArrayList();
        ValueMapItem valueMapItem = new ValueMapItem();
        valueMapItem.setValue("0");
        valueMapItem.setName(new LocaleString(ResManager.loadKDString((String)"\u672a\u7b7e\u6536", (String)"RptInputListPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem2 = new ValueMapItem();
        valueMapItem2.setValue("1");
        valueMapItem2.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u7b7e\u6536", (String)"RptInputListPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        comboItems.add(valueMapItem);
        comboItems.add(valueMapItem2);
        return comboItems;
    }

    private List<ValueMapItem> authStatusCombo() {
        ArrayList comboItems = Lists.newArrayList();
        ValueMapItem valueMapItem = new ValueMapItem();
        valueMapItem.setValue("0");
        valueMapItem.setName(new LocaleString(ResManager.loadKDString((String)"\u672a\u52fe\u9009", (String)"RptInputListPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem1 = new ValueMapItem();
        valueMapItem1.setValue("1");
        valueMapItem1.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u52fe\u9009", (String)"RptInputListPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem2 = new ValueMapItem();
        valueMapItem2.setValue("2");
        valueMapItem2.setName(new LocaleString(ResManager.loadKDString((String)"\u5df2\u8ba4\u8bc1", (String)"RptInputListPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem3 = new ValueMapItem();
        valueMapItem3.setValue("3");
        valueMapItem3.setName(new LocaleString(ResManager.loadKDString((String)"\u626b\u63cf\u8ba4\u8bc1", (String)"RptInputListPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem4 = new ValueMapItem();
        valueMapItem4.setValue("4");
        valueMapItem4.setName(new LocaleString(ResManager.loadKDString((String)"\u9884\u52fe\u9009", (String)"RptInputListPlugin_36", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        ValueMapItem valueMapItem5 = new ValueMapItem();
        valueMapItem5.setValue("5");
        valueMapItem5.setName(new LocaleString(ResManager.loadKDString((String)"\u52fe\u9009\u4e2d", (String)"RptInputListPlugin_37", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        comboItems.add(valueMapItem);
        comboItems.add(valueMapItem1);
        comboItems.add(valueMapItem2);
        comboItems.add(valueMapItem3);
        comboItems.add(valueMapItem4);
        comboItems.add(valueMapItem5);
        return comboItems;
    }

    private LinkedHashMap<String, String> getColumnsMap(List<FilterItemInfo> checkboxTrueList) {
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        boolean taxNormalFlag = false;
        for (FilterItemInfo itemInfo : checkboxTrueList) {
            if ("saler_check".equals(itemInfo.getPropName())) {
                resultMap.put("saler_name", ResManager.loadKDString((String)"\u9500\u65b9\u540d\u79f0", (String)"RptInputListPlugin_38", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("buyer_check".equals(itemInfo.getPropName())) {
                resultMap.put("buyer_name", ResManager.loadKDString((String)"\u8d2d\u65b9\u540d\u79f0", (String)"RptInputListPlugin_39", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("unitprice_check".equals(itemInfo.getPropName())) {
                resultMap.putAll(RptInputConstant.unitPriceColumnsMap);
                return resultMap;
            }
            if ("bill_check".equals(itemInfo.getPropName())) {
                resultMap.put("expense_type", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u7c7b\u578b", (String)"RptInputListPlugin_40", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("invoicedate_check".equals(itemInfo.getPropName())) {
                resultMap.put("invoice_date", ResManager.loadKDString((String)"\u6708\u4efd(\u5f00\u7968\u6708\u4efd)", (String)"RptInputListPlugin_41", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("invoicetype_check".equals(itemInfo.getPropName())) {
                resultMap.put("invoice_type", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"RptInputListPlugin_42", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("tax_check".equals(itemInfo.getPropName())) {
                resultMap.put("tax_rate", ResManager.loadKDString((String)"\u7a0e\u7387(%)", (String)"RptInputListPlugin_43", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                taxNormalFlag = true;
                continue;
            }
            if ("status_check".equals(itemInfo.getPropName())) {
                resultMap.put("expense_status", ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"RptInputListPlugin_44", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("remark_check".equals(itemInfo.getPropName())) {
                resultMap.put("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"RptInputListPlugin_45", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if ("original_check".equals(itemInfo.getPropName())) {
                resultMap.put("original_state", ResManager.loadKDString((String)"\u7b7e\u6536\u72b6\u6001", (String)"RptInputListPlugin_46", (String)"imc-rim-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"auth_check".equals(itemInfo.getPropName())) continue;
            resultMap.put("authenticate_flag", ResManager.loadKDString((String)"\u8ba4\u8bc1\u72b6\u6001", (String)"RptInputListPlugin_47", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        if (taxNormalFlag) {
            resultMap.putAll(RptInputConstant.taxNormalColumnsMap);
        } else {
            resultMap.putAll(RptInputConstant.normalColumnsMap);
        }
        return resultMap;
    }

    private ReportColumn addCountColumns() {
        ReportColumn totalRpt = new ReportColumn();
        totalRpt.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7968\u636e\u4efd\u6570", (String)"RptInputListPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0])));
        totalRpt.setWidth(new LocaleString("250px"));
        totalRpt.setFieldKey("count");
        totalRpt.setFieldType("integer");
        totalRpt.setHyperlink(true);
        totalRpt.setScale(0);
        return totalRpt;
    }
}

